/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.ISourceBlock;
import net.minecraft.core.Position;
import net.minecraft.core.SourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;

public class BlockDispenser
extends BlockTileEntity {
    public static final BlockStateDirection a = BlockDirectional.a;
    public static final BlockStateBoolean b = BlockProperties.A;
    public static final Map<Item, IDispenseBehavior> c = (Map)SystemUtils.a(new Object2ObjectOpenHashMap(), (T object2objectopenhashmap) -> object2objectopenhashmap.defaultReturnValue((Object)new DispenseBehaviorItem()));
    private static final int d = 4;
    public static boolean eventFired = false;

    public static void a(IMaterial provider, IDispenseBehavior behavior) {
        c.put(provider.k(), behavior);
    }

    protected BlockDispenser(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.C.b().a(a, EnumDirection.c)).a(b, false));
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (world.B) {
            return EnumInteractionResult.a;
        }
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityDispenser) {
            player.a((TileEntityDispenser)tileentity);
            if (tileentity instanceof TileEntityDropper) {
                player.a(StatisticList.ac);
            } else {
                player.a(StatisticList.ae);
            }
        }
        return EnumInteractionResult.b;
    }

    public void a(WorldServer world, BlockPosition pos) {
        SourceBlock sourceblock = new SourceBlock(world, pos);
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)sourceblock.f();
        int i2 = tileentitydispenser.a(world.z);
        if (i2 < 0) {
            if (CraftEventFactory.handleBlockFailedDispenseEvent(world, pos)) {
                world.c(1001, pos, 0);
                world.a(GameEvent.a, pos, GameEvent.a.a(tileentitydispenser.q()));
            }
        } else {
            ItemStack itemstack = tileentitydispenser.a(i2);
            IDispenseBehavior idispensebehavior = this.a(itemstack);
            if (idispensebehavior != IDispenseBehavior.b) {
                if (!CraftEventFactory.handleBlockPreDispenseEvent(world, pos, itemstack, i2)) {
                    return;
                }
                eventFired = false;
                tileentitydispenser.a(i2, idispensebehavior.dispense(sourceblock, itemstack));
            }
        }
    }

    protected IDispenseBehavior a(ItemStack stack) {
        return c.get(stack.d());
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        boolean flag1 = world.B(pos) || world.B(pos.c());
        boolean flag2 = state.c(b);
        if (flag1 && !flag2) {
            world.a(pos, (Block)this, 4);
            world.a(pos, (IBlockData)state.a(b, true), 4);
        } else if (!flag1 && flag2) {
            world.a(pos, (IBlockData)state.a(b, false), 4);
        }
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        this.a(world, pos);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityDispenser(pos, state);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.n().a(a, ctx.d().g());
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        TileEntity tileentity;
        if (itemStack.A() && (tileentity = world.c_(pos)) instanceof TileEntityDispenser) {
            ((TileEntityDispenser)tileentity).a(itemStack.y());
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            TileEntity tileentity = world.c_(pos);
            if (tileentity instanceof TileEntityDispenser) {
                InventoryUtils.a(world, pos, (IInventory)((TileEntityDispenser)tileentity));
                world.c(pos, this);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    public static IPosition a(ISourceBlock pointer) {
        EnumDirection enumdirection = pointer.e().c(a);
        double d0 = pointer.a() + 0.7 * (double)enumdirection.j();
        double d1 = pointer.b() + 0.7 * (double)enumdirection.k();
        double d2 = pointer.c() + 0.7 * (double)enumdirection.l();
        return new Position(d0, d1, d2);
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        return Container.a(world.c_(pos));
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(a, rotation.a(state.c(a)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(a)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b);
    }
}

