/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockShulkerBox
extends BlockTileEntity {
    private static final float c = 1.0f;
    private static final VoxelShape d = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape e = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape f = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape g = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape h = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape i = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> j = SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (T map) -> {
        map.put(EnumDirection.c, h);
        map.put(EnumDirection.f, g);
        map.put(EnumDirection.d, i);
        map.put(EnumDirection.e, f);
        map.put(EnumDirection.b, d);
        map.put(EnumDirection.a, e);
    });
    public static final BlockStateEnum<EnumDirection> a = BlockDirectional.a;
    public static final MinecraftKey b = new MinecraftKey("contents");
    @Nullable
    public final EnumColor k;

    public BlockShulkerBox(@Nullable EnumColor color, BlockBase.Info settings) {
        super(settings);
        this.k = color;
        this.k((IBlockData)this.C.b().a(a, EnumDirection.b));
    }

    @Override
    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityShulkerBox(this.k, pos, state);
    }

    @Override
    @Nullable
    @Override
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return BlockShulkerBox.a(type, TileEntityTypes.x, TileEntityShulkerBox::a);
    }

    @Override
    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.b;
    }

    @Override
    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (world.B) {
            return EnumInteractionResult.a;
        }
        if (player.G_()) {
            return EnumInteractionResult.b;
        }
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            if (BlockShulkerBox.a(state, world, pos, shulkerBoxBlockEntity)) {
                player.a(shulkerBoxBlockEntity);
                player.a(StatisticList.aq);
                PiglinAI.a(player, true);
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.d;
    }

    private static boolean a(IBlockData state, World world, BlockPosition pos, TileEntityShulkerBox entity) {
        if (entity.i() != TileEntityShulkerBox.AnimationPhase.a) {
            return true;
        }
        AxisAlignedBB aABB = EntityShulker.a(state.c(a), 0.0f, 0.5f).a(pos).h(1.0E-6);
        return world.b(aABB);
    }

    @Override
    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.n().a(a, ctx.k());
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{a});
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            if (!world.B && player.f() && !shulkerBoxBlockEntity.ab_()) {
                ItemStack itemStack = BlockShulkerBox.b(this.a());
                blockEntity.e(itemStack);
                if (shulkerBoxBlockEntity.aa()) {
                    itemStack.a(shulkerBoxBlockEntity.ab());
                }
                EntityItem itemEntity = new EntityItem(world, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, itemStack);
                itemEntity.o();
                world.b(itemEntity);
            } else {
                shulkerBoxBlockEntity.e(player);
            }
        }
        super.a(world, pos, state, player);
    }

    @Override
    @Override
    public List<ItemStack> a(IBlockData state, LootParams.a builder) {
        TileEntity blockEntity = builder.b(LootContextParameters.h);
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            builder = builder.a(b, (Consumer<ItemStack> lootConsumer) -> {
                for (int i2 = 0; i2 < shulkerBoxBlockEntity.b(); ++i2) {
                    lootConsumer.accept(shulkerBoxBlockEntity.a(i2));
                }
            });
        }
        return super.a(state, builder);
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        TileEntity blockEntity;
        if (itemStack.A() && (blockEntity = world.c_(pos)) instanceof TileEntityShulkerBox) {
            ((TileEntityShulkerBox)blockEntity).a(itemStack.y());
        }
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (state.a(newState.b())) {
            return;
        }
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityShulkerBox) {
            world.c(pos, state.b());
        }
        super.a(state, world, pos, newState, moved);
    }

    @Override
    @Override
    public void a(ItemStack stack, @Nullable IBlockAccess world, List<IChatBaseComponent> tooltip, TooltipFlag options) {
        super.a(stack, world, tooltip, options);
        NBTTagCompound compoundTag = ItemBlock.a(stack);
        if (compoundTag != null) {
            if (compoundTag.b("LootTable", 8)) {
                tooltip.add(IChatBaseComponent.b("???????"));
            }
            if (compoundTag.b("Items", 9)) {
                NonNullList<ItemStack> nonNullList = NonNullList.a(27, ItemStack.b);
                ContainerUtil.b(compoundTag, nonNullList);
                int i2 = 0;
                int j2 = 0;
                for (ItemStack itemStack : nonNullList) {
                    if (itemStack.b()) continue;
                    ++j2;
                    if (i2 > 4) continue;
                    ++i2;
                    IChatMutableComponent mutableComponent = itemStack.y().e();
                    mutableComponent.f(" x").f(String.valueOf(itemStack.L()));
                    tooltip.add(mutableComponent);
                }
                if (j2 - i2 > 0) {
                    tooltip.add(IChatBaseComponent.a("container.shulkerBox.more", j2 - i2).a(EnumChatFormat.u));
                }
            }
        }
    }

    @Override
    @Override
    public VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        TileEntityShulkerBox shulkerBoxBlockEntity;
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityShulkerBox && !(shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity).v()) {
            return j.get(state.c(a).g());
        }
        return VoxelShapes.b();
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityShulkerBox) {
            return VoxelShapes.a(((TileEntityShulkerBox)blockEntity).a(state));
        }
        return VoxelShapes.b();
    }

    @Override
    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        return Container.b((IInventory)((Object)world.c_(pos)));
    }

    @Override
    @Override
    public ItemStack a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        ItemStack itemStack = super.a(world, pos, state);
        world.a(pos, TileEntityTypes.x).ifPresent(blockEntity -> blockEntity.e(itemStack));
        return itemStack;
    }

    @Nullable
    public static EnumColor b(Item item) {
        return BlockShulkerBox.a(Block.a(item));
    }

    @Nullable
    public static EnumColor a(Block block) {
        if (block instanceof BlockShulkerBox) {
            return ((BlockShulkerBox)block).a();
        }
        return null;
    }

    public static Block a(@Nullable EnumColor dyeColor) {
        if (dyeColor == null) {
            return Blocks.kP;
        }
        switch (dyeColor) {
            case a: {
                return Blocks.kQ;
            }
            case b: {
                return Blocks.kR;
            }
            case c: {
                return Blocks.kS;
            }
            case d: {
                return Blocks.kT;
            }
            case e: {
                return Blocks.kU;
            }
            case f: {
                return Blocks.kV;
            }
            case g: {
                return Blocks.kW;
            }
            case h: {
                return Blocks.kX;
            }
            case i: {
                return Blocks.kY;
            }
            case j: {
                return Blocks.kZ;
            }
            default: {
                return Blocks.la;
            }
            case l: {
                return Blocks.lb;
            }
            case m: {
                return Blocks.lc;
            }
            case n: {
                return Blocks.ld;
            }
            case o: {
                return Blocks.le;
            }
            case p: 
        }
        return Blocks.lf;
    }

    @Nullable
    public EnumColor a() {
        return this.k;
    }

    public static ItemStack b(@Nullable EnumColor color) {
        return new ItemStack(BlockShulkerBox.a(color));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(a, rotation.a(state.c(a)));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(a)));
    }
}

