/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class WallHangingSignBlock
extends BlockSign {
    public static final BlockStateDirection a = BlockFacingHorizontal.aC;
    public static final VoxelShape b = Block.a(0.0, 14.0, 6.0, 16.0, 16.0, 10.0);
    public static final VoxelShape c = Block.a(6.0, 14.0, 0.0, 10.0, 16.0, 16.0);
    public static final VoxelShape d = VoxelShapes.a(b, Block.a(1.0, 0.0, 7.0, 15.0, 10.0, 9.0));
    public static final VoxelShape h = VoxelShapes.a(c, Block.a(7.0, 0.0, 1.0, 9.0, 10.0, 15.0));
    private static final Map<EnumDirection, VoxelShape> i = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, (Object)d, (Object)EnumDirection.d, (Object)d, (Object)EnumDirection.f, (Object)h, (Object)EnumDirection.e, (Object)h));

    public WallHangingSignBlock(BlockBase.Info settings, BlockPropertyWood type) {
        super(settings.a(type.e()), type);
        this.k((IBlockData)((IBlockData)this.C.b().a(a, EnumDirection.c)).a(BlockSign.e, false));
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        ItemStack itemStack0;
        TileEntitySign signBlockEntity;
        TileEntity itemStack = world.c_(pos);
        if (itemStack instanceof TileEntitySign && this.a(state, player, hit, signBlockEntity = (TileEntitySign)itemStack, itemStack0 = player.b(hand))) {
            return EnumInteractionResult.d;
        }
        return super.a(state, world, pos, player, hand, hit);
    }

    private boolean a(IBlockData state, EntityHuman player, MovingObjectPositionBlock hitResult, TileEntitySign sign, ItemStack stack) {
        return !sign.a(sign.a(player), player) && stack.d() instanceof HangingSignItem && !this.a(hitResult, state);
    }

    private boolean a(MovingObjectPositionBlock hitResult, IBlockData state) {
        return hitResult.b().o() == state.c(a).o();
    }

    @Override
    public String f() {
        return this.k().a();
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return i.get(state.c(a));
    }

    @Override
    public VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return this.a(state, world, pos, VoxelShapeCollision.a());
    }

    @Override
    public VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        switch (state.c(a)) {
            case f: 
            case e: {
                return c;
            }
        }
        return b;
    }

    public boolean b(IBlockData state, IWorldReader world, BlockPosition pos) {
        EnumDirection direction = state.c(a).h();
        EnumDirection direction2 = state.c(a).i();
        return this.a(world, state, pos.a(direction), direction2) || this.a(world, state, pos.a(direction2), direction);
    }

    public boolean a(IWorldReader world, IBlockData state, BlockPosition toPos, EnumDirection direction) {
        IBlockData blockState = world.a_(toPos);
        return blockState.a(TagsBlock.ax) ? blockState.c(a).o().a(state.c(a)) : blockState.a((IBlockAccess)world, toPos, direction, EnumBlockSupport.a);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        IBlockData blockState = this.n();
        Fluid fluidState = ctx.q().b_(ctx.a());
        World levelReader = ctx.q();
        BlockPosition blockPos = ctx.a();
        for (EnumDirection direction : ctx.f()) {
            EnumDirection direction2;
            if (!direction.o().d() || direction.o().a(ctx.k()) || !(blockState = (IBlockData)blockState.a(a, direction2 = direction.g())).a((IWorldReader)levelReader, blockPos) || !this.b(blockState, (IWorldReader)levelReader, blockPos)) continue;
            return (IBlockData)blockState.a(BlockSign.e, fluidState.a() == FluidTypes.c);
        }
        return null;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return direction.o() == state.c(a).h().o() && !state.a(world, pos) ? Blocks.a.n() : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public float g(IBlockData state) {
        return state.c(a).p();
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(a, rotation.a(state.c(a)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(a)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, BlockSign.e);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new HangingSignBlockEntity(pos, state);
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return null;
    }
}

