/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.block.LockableTileState;
import io.papermc.paper.event.block.BlockLockCheckEvent;
import io.papermc.paper.util.MCUtil;
import javax.annotation.Nullable;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ChestLock;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class TileEntityContainer
extends TileEntity
implements IInventory,
ITileInventory,
INamableTileEntity {
    public ChestLock c = ChestLock.a;
    @Nullable
    public IChatBaseComponent d;

    protected TileEntityContainer(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        super(type, pos, state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.c = ChestLock.b(nbt);
        if (nbt.b("CustomName", 8)) {
            this.d = MCUtil.getBaseComponentFromNbt("CustomName", nbt);
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.c.a(nbt);
        if (this.d != null) {
            nbt.a("CustomName", IChatBaseComponent.ChatSerializer.a(this.d));
        }
    }

    public void a(IChatBaseComponent customName) {
        this.d = customName;
    }

    @Override
    public IChatBaseComponent Z() {
        return this.d != null ? this.d : this.g();
    }

    @Override
    public IChatBaseComponent H_() {
        return this.Z();
    }

    @Override
    @Nullable
    public IChatBaseComponent ab() {
        return this.d;
    }

    protected abstract IChatBaseComponent g();

    public boolean d(EntityHuman player) {
        return TileEntityContainer.canUnlock(player, this.c, this.H_(), this);
    }

    @Deprecated
    @DoNotUse
    public static boolean a(EntityHuman player, ChestLock lock, IChatBaseComponent containerName) {
        return TileEntityContainer.canUnlock(player, lock, containerName, null);
    }

    public static boolean canUnlock(EntityHuman player, ChestLock lock, IChatBaseComponent containerName, @Nullable TileEntity blockEntity) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            if (blockEntity != null && blockEntity.k() != null && blockEntity.k().c_(blockEntity.p()) == blockEntity) {
                CraftBlock block = CraftBlock.at(blockEntity.k(), blockEntity.p());
                TranslatableComponent lockedMessage = Component.translatable((String)"container.isLocked", (ComponentLike[])new ComponentLike[]{PaperAdventure.asAdventure(containerName)});
                net.kyori.adventure.sound.Sound lockedSound = net.kyori.adventure.sound.Sound.sound((Sound.Type)Sound.BLOCK_CHEST_LOCKED, (Sound.Source)Sound.Source.BLOCK, (float)1.0f, (float)1.0f);
                BlockLockCheckEvent event = new BlockLockCheckEvent((Block)block, (LockableTileState)block.getState(), (Player)serverPlayer.getBukkitEntity(), (Component)lockedMessage, lockedSound);
                event.callEvent();
                if (event.getResult() == Event.Result.ALLOW) {
                    return true;
                }
                if (event.getResult() == Event.Result.DENY || !player.G_() && !lock.a(event.isUsingCustomKeyItemStack() ? CraftItemStack.asNMSCopy(event.getKeyItem()) : player.eO())) {
                    if (event.getLockedMessage() != null) {
                        event.getPlayer().sendActionBar(event.getLockedMessage());
                    }
                    if (event.getLockedSound() != null) {
                        event.getPlayer().playSound(event.getLockedSound());
                    }
                    return false;
                }
                return true;
            }
        }
        if (!player.G_() && !lock.a(player.eO())) {
            player.a(IChatBaseComponent.a("container.isLocked", containerName), true);
            player.a(SoundEffects.ei, SoundCategory.e, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Container createMenu(int syncId, PlayerInventory playerInventory, EntityHuman player) {
        return this.d(player) ? this.a(syncId, playerInventory) : null;
    }

    protected abstract Container a(int var1, PlayerInventory var2);

    @Override
    public Location getLocation() {
        if (this.o == null) {
            return null;
        }
        return new Location((World)this.o.getWorld(), (double)this.p.u(), (double)this.p.v(), (double)this.p.w());
    }
}

