/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.Clearable;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class TileEntityJukeBox
extends TileEntity
implements Clearable,
ContainerSingleItem {
    private static final int c = 20;
    private final NonNullList<ItemStack> d;
    private int e;
    public long f;
    public long g;
    public boolean h;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    public boolean opened;

    @Override
    public List<ItemStack> getContents() {
        return this.d;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        if (this.o == null) {
            return null;
        }
        return new Location((org.bukkit.World)this.o.getWorld(), (double)this.p.u(), (double)this.p.v(), (double)this.p.w());
    }

    public TileEntityJukeBox(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.e, pos, state);
        this.d = NonNullList.a(this.b(), ItemStack.b);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("RecordItem", 10)) {
            this.d.set(0, ItemStack.a(nbt.p("RecordItem")));
        }
        this.h = nbt.q("IsPlaying");
        this.g = nbt.i("RecordStartTick");
        this.f = nbt.i("TickCount");
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (!this.ar_().b()) {
            nbt.a("RecordItem", this.ar_().b(new NBTTagCompound()));
        }
        nbt.a("IsPlaying", this.h);
        nbt.a("RecordStartTick", this.g);
        nbt.a("TickCount", this.f);
    }

    public boolean f() {
        return !this.ar_().b() && this.h;
    }

    private void a(@Nullable Entity entity, boolean hasRecord) {
        if (this.o.a_(this.p()) == this.q()) {
            this.o.a(this.p(), (IBlockData)this.q().a(BlockJukeBox.a, hasRecord), 2);
            this.o.a(GameEvent.c, this.p(), GameEvent.a.a(entity, this.q()));
        }
    }

    @VisibleForTesting
    public void g() {
        this.g = this.f;
        this.h = true;
        this.o.a(this.p(), this.q().b());
        this.o.a((EntityHuman)null, 1010, this.p(), Item.a(this.ar_().d()));
        this.e();
    }

    private void v() {
        this.h = false;
        this.o.a(GameEvent.G, this.p(), GameEvent.a.a(this.q()));
        this.o.a(this.p(), this.q().b());
        this.o.c(1011, this.p(), 0);
        this.e();
    }

    private void b(World world, BlockPosition pos, IBlockData state) {
        Item item;
        ++this.e;
        if (this.f() && (item = this.ar_().d()) instanceof ItemRecord) {
            ItemRecord itemrecord = (ItemRecord)item;
            if (this.a(itemrecord)) {
                this.v();
            } else if (this.w()) {
                this.e = 0;
                world.a(GameEvent.F, pos, GameEvent.a.a(state));
                this.a(world, pos);
            }
        }
        ++this.f;
    }

    private boolean a(ItemRecord musicDisc) {
        return this.f >= this.g + (long)musicDisc.y() + 20L;
    }

    private boolean w() {
        return this.e >= 20;
    }

    @Override
    public ItemStack a(int slot) {
        return this.d.get(slot);
    }

    @Override
    public ItemStack a(int slot, int amount) {
        ItemStack itemstack = Objects.requireNonNullElse(this.d.get(slot), ItemStack.b);
        this.d.set(slot, ItemStack.b);
        if (!itemstack.b()) {
            this.a((Entity)null, false);
            this.v();
        }
        return itemstack;
    }

    @Override
    public void a(int slot, ItemStack stack) {
        if (stack.b()) {
            this.a(slot, 0);
            return;
        }
        if (stack.a(TagsItem.aq) && this.o != null) {
            this.d.set(slot, stack);
            this.a((Entity)null, true);
            this.g();
        }
    }

    @Override
    public int ac_() {
        return this.maxStack;
    }

    @Override
    public boolean a(EntityHuman player) {
        return IInventory.a(this, player);
    }

    @Override
    public boolean b(int slot, ItemStack stack) {
        return stack.a(TagsItem.aq) && this.a(slot).b();
    }

    @Override
    public boolean a(IInventory hopperInventory, int slot, ItemStack stack) {
        return hopperInventory.a_(ItemStack::b);
    }

    private void a(World world, BlockPosition pos) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Vec3D vec3d = Vec3D.c(pos).b(0.0, 1.2f, 0.0);
            float f2 = (float)world.y_().a(4) / 24.0f;
            worldserver.a(Particles.V, vec3d.a(), vec3d.b(), vec3d.c(), 0, (double)f2, 0.0, 0.0, 1.0);
        }
    }

    public void i() {
        if (this.o != null && !this.o.B) {
            BlockPosition blockposition = this.p();
            ItemStack itemstack = this.ar_();
            if (!itemstack.b()) {
                this.j();
                Vec3D vec3d = Vec3D.a(blockposition, 0.5, 1.01, 0.5).a(this.o.z, 0.7f);
                ItemStack itemstack1 = itemstack.p();
                EntityItem entityitem = new EntityItem(this.o, vec3d.a(), vec3d.b(), vec3d.c(), itemstack1);
                entityitem.o();
                this.o.b(entityitem);
            }
        }
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityJukeBox blockEntity) {
        blockEntity.b(world, pos, state);
    }

    @VisibleForTesting
    public void a(ItemStack stack) {
        this.d.set(0, stack);
        if (this.o != null) {
            this.o.a(this.p(), this.q().b());
        }
        this.e();
    }
}

