/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class ShapeDetector {
    private final Predicate<ShapeDetectorBlock>[][][] a;
    private final int b;
    private final int c;
    private final int d;

    public ShapeDetector(Predicate<ShapeDetectorBlock>[][][] pattern) {
        this.a = pattern;
        this.b = pattern.length;
        if (this.b > 0) {
            this.c = pattern[0].length;
            this.d = this.c > 0 ? pattern[0][0].length : 0;
        } else {
            this.c = 0;
            this.d = 0;
        }
    }

    public int a() {
        return this.b;
    }

    public int b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    @VisibleForTesting
    public Predicate<ShapeDetectorBlock>[][][] d() {
        return this.a;
    }

    @Nullable
    @VisibleForTesting
    public ShapeDetectorCollection a(IWorldReader world, BlockPosition frontTopLeft, EnumDirection forwards, EnumDirection up) {
        LoadingCache<BlockPosition, ShapeDetectorBlock> loadingCache = ShapeDetector.a(world, false);
        return this.a(frontTopLeft, forwards, up, loadingCache);
    }

    @Nullable
    private ShapeDetectorCollection a(BlockPosition frontTopLeft, EnumDirection forwards, EnumDirection up, LoadingCache<BlockPosition, ShapeDetectorBlock> cache) {
        for (int i2 = 0; i2 < this.d; ++i2) {
            for (int j2 = 0; j2 < this.c; ++j2) {
                for (int k2 = 0; k2 < this.b; ++k2) {
                    if (this.a[k2][j2][i2].test((ShapeDetectorBlock)cache.getUnchecked((Object)ShapeDetector.a(frontTopLeft, forwards, up, i2, j2, k2)))) continue;
                    return null;
                }
            }
        }
        return new ShapeDetectorCollection(frontTopLeft, forwards, up, cache, this.d, this.c, this.b);
    }

    @Nullable
    public ShapeDetectorCollection a(IWorldReader world, BlockPosition pos) {
        LoadingCache<BlockPosition, ShapeDetectorBlock> loadingCache = ShapeDetector.a(world, false);
        int i2 = Math.max(Math.max(this.d, this.c), this.b);
        for (BlockPosition blockPos : BlockPosition.a(pos, pos.b(i2 - 1, i2 - 1, i2 - 1))) {
            for (EnumDirection direction : EnumDirection.values()) {
                for (EnumDirection direction2 : EnumDirection.values()) {
                    ShapeDetectorCollection blockPatternMatch;
                    if (direction2 == direction || direction2 == direction.g() || (blockPatternMatch = this.a(blockPos, direction, direction2, loadingCache)) == null) continue;
                    return blockPatternMatch;
                }
            }
        }
        return null;
    }

    public static LoadingCache<BlockPosition, ShapeDetectorBlock> a(IWorldReader world, boolean forceLoad) {
        return CacheBuilder.newBuilder().build((CacheLoader)new BlockLoader(world, forceLoad));
    }

    protected static BlockPosition a(BlockPosition pos, EnumDirection forwards, EnumDirection up, int offsetLeft, int offsetDown, int offsetForwards) {
        if (forwards == up || forwards == up.g()) {
            throw new IllegalArgumentException("Invalid forwards & up combination");
        }
        BaseBlockPosition vec3i = new BaseBlockPosition(forwards.j(), forwards.k(), forwards.l());
        BaseBlockPosition vec3i2 = new BaseBlockPosition(up.j(), up.k(), up.l());
        BaseBlockPosition vec3i3 = vec3i.d(vec3i2);
        return pos.b(vec3i2.u() * -offsetDown + vec3i3.u() * offsetLeft + vec3i.u() * offsetForwards, vec3i2.v() * -offsetDown + vec3i3.v() * offsetLeft + vec3i.v() * offsetForwards, vec3i2.w() * -offsetDown + vec3i3.w() * offsetLeft + vec3i.w() * offsetForwards);
    }

    public static class ShapeDetectorCollection {
        private final BlockPosition a;
        private final EnumDirection b;
        private final EnumDirection c;
        private final LoadingCache<BlockPosition, ShapeDetectorBlock> d;
        private final int e;
        private final int f;
        private final int g;

        public ShapeDetectorCollection(BlockPosition frontTopLeft, EnumDirection forwards, EnumDirection up, LoadingCache<BlockPosition, ShapeDetectorBlock> cache, int width, int height, int depth) {
            this.a = frontTopLeft;
            this.b = forwards;
            this.c = up;
            this.d = cache;
            this.e = width;
            this.f = height;
            this.g = depth;
        }

        public BlockPosition a() {
            return this.a;
        }

        public EnumDirection b() {
            return this.b;
        }

        public EnumDirection c() {
            return this.c;
        }

        public int d() {
            return this.e;
        }

        public int e() {
            return this.f;
        }

        public int f() {
            return this.g;
        }

        public ShapeDetectorBlock a(int offsetLeft, int offsetDown, int offsetForwards) {
            return (ShapeDetectorBlock)this.d.getUnchecked((Object)ShapeDetector.a(this.a, this.b(), this.c(), offsetLeft, offsetDown, offsetForwards));
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.c).add("forwards", (Object)this.b).add("frontTopLeft", (Object)this.a).toString();
        }
    }

    static class BlockLoader
    extends CacheLoader<BlockPosition, ShapeDetectorBlock> {
        private final IWorldReader a;
        private final boolean b;

        public BlockLoader(IWorldReader world, boolean forceLoad) {
            this.a = world;
            this.b = forceLoad;
        }

        @Override
        public ShapeDetectorBlock a(BlockPosition blockPos) {
            return new ShapeDetectorBlock(this.a, blockPos, this.b);
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.a((BlockPosition)object);
        }
    }
}

