/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockStateEnum<T extends Enum<T>>
extends IBlockState<T> {
    private final ImmutableSet<T> a;
    private final Map<String, T> b = Maps.newHashMap();
    private int[] idLookupTable;

    @Override
    public final int getIdFor(T value) {
        return this.idLookupTable[((Enum)value).ordinal()];
    }

    protected BlockStateEnum(String name, Class<T> type, Collection<T> values) {
        super(name, type);
        this.a = ImmutableSet.copyOf(values);
        for (Enum enum_ : values) {
            String string = ((INamable)((Object)enum_)).c();
            if (this.b.containsKey(string)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + string + "'");
            }
            this.b.put(string, enum_);
        }
        int id = 0;
        this.idLookupTable = new int[((Enum[])type.getEnumConstants()).length];
        Arrays.fill(this.idLookupTable, -1);
        for (Enum value : this.a()) {
            this.idLookupTable[value.ordinal()] = id++;
        }
    }

    @Override
    public Collection<T> a() {
        return this.a;
    }

    @Override
    public Optional<T> b(String name) {
        return Optional.ofNullable((Enum)this.b.get(name));
    }

    @Override
    public String a(T value) {
        return ((INamable)value).c();
    }

    public boolean equals_unused(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BlockStateEnum && super.equals(object)) {
            BlockStateEnum enumProperty = (BlockStateEnum)object;
            return this.a.equals(enumProperty.a) && this.b.equals(enumProperty.b);
        }
        return false;
    }

    @Override
    public int b() {
        int i2 = super.b();
        i2 = 31 * i2 + this.a.hashCode();
        return 31 * i2 + this.b.hashCode();
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> type) {
        return BlockStateEnum.a(name, type, (T enum_) -> true);
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> type, Predicate<T> filter) {
        return BlockStateEnum.a(name, type, Arrays.stream((Enum[])type.getEnumConstants()).filter(filter).collect(Collectors.toList()));
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> type, T ... values) {
        return BlockStateEnum.a(name, type, Lists.newArrayList((Object[])values));
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> type, Collection<T> values) {
        return new BlockStateEnum<T>(name, type, values);
    }
}

