/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.dimension.DimensionManager;

public final class NoiseSettings
extends Record {
    private final int g;
    private final int h;
    private final int i;
    private final int j;
    public static final Codec<NoiseSettings> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)DimensionManager.e, (int)DimensionManager.d).fieldOf("min_y").forGetter(NoiseSettings::c), (App)Codec.intRange((int)0, (int)DimensionManager.c).fieldOf("height").forGetter(NoiseSettings::d), (App)Codec.intRange((int)1, (int)4).fieldOf("size_horizontal").forGetter(NoiseSettings::e), (App)Codec.intRange((int)1, (int)4).fieldOf("size_vertical").forGetter(NoiseSettings::f)).apply((Applicative)instance, NoiseSettings::new)).comapFlatMap(NoiseSettings::a, Function.identity());
    protected static final NoiseSettings b = NoiseSettings.a(-64, 384, 1, 2);
    protected static final NoiseSettings c = NoiseSettings.a(0, 128, 1, 2);
    protected static final NoiseSettings d = NoiseSettings.a(0, 128, 2, 1);
    protected static final NoiseSettings e = NoiseSettings.a(-64, 192, 1, 2);
    protected static final NoiseSettings f = NoiseSettings.a(0, 256, 2, 1);

    public NoiseSettings(int minimumY, int height, int i2, int j2) {
        this.g = minimumY;
        this.h = height;
        this.i = i2;
        this.j = j2;
    }

    private static DataResult<NoiseSettings> a(NoiseSettings config) {
        if (config.c() + config.d() > DimensionManager.d + 1) {
            return DataResult.error(() -> "min_y + height cannot be higher than: " + (DimensionManager.d + 1));
        }
        if (config.d() % 16 != 0) {
            return DataResult.error(() -> "height has to be a multiple of 16");
        }
        if (config.c() % 16 != 0) {
            return DataResult.error(() -> "min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)config);
    }

    public static NoiseSettings a(int minimumY, int height, int horizontalSize, int verticalSize) {
        NoiseSettings noiseSettings = new NoiseSettings(minimumY, height, horizontalSize, verticalSize);
        NoiseSettings.a(noiseSettings).error().ifPresent(result -> {
            throw new IllegalStateException(result.message());
        });
        return noiseSettings;
    }

    public int a() {
        return QuartPos.c(this.f());
    }

    public int b() {
        return QuartPos.c(this.e());
    }

    public NoiseSettings a(LevelHeightAccessor world) {
        int i2 = Math.max(this.g, world.C_());
        int j2 = Math.min(this.g + this.h, world.aj()) - i2;
        return new NoiseSettings(i2, j2, this.i, this.j);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSizeHorizontal;noiseSizeVertical", "g", "h", "i", "j"}, this, object);
    }

    public int c() {
        return this.g;
    }

    public int d() {
        return this.h;
    }

    public int e() {
        return this.i;
    }

    public int f() {
        return this.j;
    }
}

