/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.storage.WorldDataServer;

public record WorldDimensions(IRegistry<WorldDimension> b) {
    private final IRegistry<WorldDimension> b;
    public static final MapCodec<WorldDimensions> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.b(Registries.aI, Lifecycle.stable(), WorldDimension.a).fieldOf("dimensions").forGetter(WorldDimensions::d)).apply((Applicative)instance, instance.stable(WorldDimensions::new)));
    private static final Set<ResourceKey<WorldDimension>> c = ImmutableSet.of(WorldDimension.b, WorldDimension.c, WorldDimension.d);
    private static final int d = c.size();

    public WorldDimensions {
        WorldDimension levelStem = registry.a(WorldDimension.b);
        if (levelStem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    public static Stream<ResourceKey<WorldDimension>> a(Stream<ResourceKey<WorldDimension>> otherKeys) {
        return Stream.concat(c.stream(), otherKeys.filter(key -> !c.contains(key)));
    }

    public WorldDimensions a(IRegistryCustom dynamicRegistryManager, ChunkGenerator chunkGenerator) {
        IRegistry<DimensionManager> registry = dynamicRegistryManager.d(Registries.au);
        IRegistry<WorldDimension> registry2 = WorldDimensions.a(registry, this.b, chunkGenerator);
        return new WorldDimensions(registry2);
    }

    public static IRegistry<WorldDimension> a(IRegistry<DimensionManager> dynamicRegistry, IRegistry<WorldDimension> currentRegistry, ChunkGenerator chunkGenerator) {
        WorldDimension levelStem = currentRegistry.a(WorldDimension.b);
        Holder<DimensionManager> holder = levelStem == null ? dynamicRegistry.f(BuiltinDimensionTypes.a) : levelStem.a();
        return WorldDimensions.a(currentRegistry, holder, chunkGenerator);
    }

    public static IRegistry<WorldDimension> a(IRegistry<WorldDimension> currentRegistry, Holder<DimensionManager> overworldEntry, ChunkGenerator chunkGenerator) {
        RegistryMaterials<WorldDimension> writableRegistry = new RegistryMaterials<WorldDimension>(Registries.aI, Lifecycle.experimental());
        writableRegistry.a(WorldDimension.b, new WorldDimension(overworldEntry, chunkGenerator), Lifecycle.stable());
        for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> entry : currentRegistry.g()) {
            ResourceKey<WorldDimension> resourceKey = entry.getKey();
            if (resourceKey == WorldDimension.b) continue;
            writableRegistry.a(resourceKey, entry.getValue(), currentRegistry.e(entry.getValue()));
        }
        return writableRegistry.l();
    }

    public ChunkGenerator a() {
        WorldDimension levelStem = this.b.a(WorldDimension.b);
        if (levelStem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return levelStem.b();
    }

    public Optional<WorldDimension> a(ResourceKey<WorldDimension> key) {
        return this.b.d(key);
    }

    public ImmutableSet<ResourceKey<World>> b() {
        return (ImmutableSet)this.d().g().stream().map(Map.Entry::getKey).map(Registries::a).collect(ImmutableSet.toImmutableSet());
    }

    public boolean c() {
        return this.a() instanceof ChunkProviderDebug;
    }

    private static WorldDataServer.a b(IRegistry<WorldDimension> dimensionOptionsRegistry) {
        return dimensionOptionsRegistry.d(WorldDimension.b).map(overworldEntry -> {
            ChunkGenerator chunkGenerator = overworldEntry.b();
            if (chunkGenerator instanceof ChunkProviderDebug) {
                return WorldDataServer.a.c;
            }
            if (chunkGenerator instanceof ChunkProviderFlat) {
                return WorldDataServer.a.b;
            }
            return WorldDataServer.a.a;
        }).orElse(WorldDataServer.a.a);
    }

    static Lifecycle a(ResourceKey<WorldDimension> key, WorldDimension dimensionOptions) {
        return WorldDimensions.b(key, dimensionOptions) ? Lifecycle.stable() : Lifecycle.experimental();
    }

    private static boolean b(ResourceKey<WorldDimension> key, WorldDimension dimensionOptions) {
        if (key == WorldDimension.b) {
            return WorldDimensions.a(dimensionOptions);
        }
        if (key == WorldDimension.c) {
            return WorldDimensions.b(dimensionOptions);
        }
        if (key == WorldDimension.d) {
            return WorldDimensions.c(dimensionOptions);
        }
        return false;
    }

    private static boolean a(WorldDimension dimensionOptions) {
        WorldChunkManagerMultiNoise multiNoiseBiomeSource;
        Holder<DimensionManager> holder = dimensionOptions.a();
        if (!holder.a(BuiltinDimensionTypes.a) && !holder.a(BuiltinDimensionTypes.d)) {
            return false;
        }
        WorldChunkManager worldChunkManager = dimensionOptions.b().c();
        return !(worldChunkManager instanceof WorldChunkManagerMultiNoise) || (multiNoiseBiomeSource = (WorldChunkManagerMultiNoise)worldChunkManager).a(MultiNoiseBiomeSourceParameterLists.b);
    }

    private static boolean b(WorldDimension dimensionOptions) {
        WorldChunkManagerMultiNoise multiNoiseBiomeSource;
        ChunkGeneratorAbstract noiseBasedChunkGenerator;
        Object object;
        return dimensionOptions.a().a(BuiltinDimensionTypes.b) && (object = dimensionOptions.b()) instanceof ChunkGeneratorAbstract && (noiseBasedChunkGenerator = (ChunkGeneratorAbstract)object).a(GeneratorSettingBase.f) && (object = noiseBasedChunkGenerator.c()) instanceof WorldChunkManagerMultiNoise && (multiNoiseBiomeSource = (WorldChunkManagerMultiNoise)object).a(MultiNoiseBiomeSourceParameterLists.a);
    }

    private static boolean c(WorldDimension dimensionOptions) {
        ChunkGeneratorAbstract noiseBasedChunkGenerator;
        ChunkGenerator chunkGenerator;
        return dimensionOptions.a().a(BuiltinDimensionTypes.c) && (chunkGenerator = dimensionOptions.b()) instanceof ChunkGeneratorAbstract && (noiseBasedChunkGenerator = (ChunkGeneratorAbstract)chunkGenerator).a(GeneratorSettingBase.g) && noiseBasedChunkGenerator.c() instanceof WorldChunkManagerTheEnd;
    }

    public b a(IRegistry<WorldDimension> existingRegistry) {
        record A(ResourceKey<WorldDimension> a, WorldDimension b) {
            Lifecycle c() {
                return WorldDimensions.a(this.a, this.b);
            }

            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "key;value", "a", "b"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "key;value", "a", "b"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "key;value", "a", "b"}, this, object);
            }
        }
        Stream<ResourceKey<WorldDimension>> stream = Stream.concat(existingRegistry.f().stream(), this.b.f().stream()).distinct();
        ArrayList list = new ArrayList();
        WorldDimensions.a(stream).forEach(key -> existingRegistry.d((ResourceKey<WorldDimension>)key).or(() -> this.b.d((ResourceKey<WorldDimension>)key)).ifPresent(dimensionOptions -> list.add(new A((ResourceKey<WorldDimension>)key, (WorldDimension)dimensionOptions))));
        Lifecycle lifecycle = list.size() == d ? Lifecycle.stable() : Lifecycle.experimental();
        RegistryMaterials<WorldDimension> writableRegistry = new RegistryMaterials<WorldDimension>(Registries.aI, lifecycle);
        list.forEach(entry -> writableRegistry.a(entry.a, entry.b, entry.c()));
        IRegistry<WorldDimension> registry = writableRegistry.l();
        WorldDataServer.a specialWorldProperty = WorldDimensions.b(registry);
        return new b(registry.l(), specialWorldProperty);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this, object);
    }

    public IRegistry<WorldDimension> d() {
        return this.b;
    }

    public record b(IRegistry<WorldDimension> a, WorldDataServer.a b) {
        private final IRegistry<WorldDimension> a;
        private final WorldDataServer.a b;

        public Lifecycle a() {
            return this.a.d();
        }

        public IRegistryCustom.Dimension b() {
            return new IRegistryCustom.c(List.of(this.a)).c();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this, object);
        }

        public IRegistry<WorldDimension> c() {
            return this.a;
        }

        public WorldDataServer.a d() {
            return this.b;
        }
    }
}

