/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;

public class UnderwaterMagmaFeature
extends WorldGenerator<UnderwaterMagmaConfiguration> {
    public UnderwaterMagmaFeature(Codec<UnderwaterMagmaConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<UnderwaterMagmaConfiguration> context) {
        BaseBlockPosition vec3i;
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        UnderwaterMagmaConfiguration underwaterMagmaConfiguration = context.f();
        RandomSource randomSource = context.d();
        OptionalInt optionalInt = UnderwaterMagmaFeature.a(worldGenLevel, blockPos, underwaterMagmaConfiguration);
        if (!optionalInt.isPresent()) {
            return false;
        }
        BlockPosition blockPos2 = blockPos.h(optionalInt.getAsInt());
        AxisAlignedBB aABB = new AxisAlignedBB(blockPos2.b(vec3i = new BaseBlockPosition(underwaterMagmaConfiguration.c, underwaterMagmaConfiguration.c, underwaterMagmaConfiguration.c)), blockPos2.a(vec3i));
        return BlockPosition.a(aABB).filter(pos -> randomSource.i() < underwaterMagmaConfiguration.d).filter(pos -> this.b(worldGenLevel, (BlockPosition)pos)).mapToInt(pos -> {
            worldGenLevel.a((BlockPosition)pos, Blocks.kJ.n(), 2);
            return 1;
        }).sum() > 0;
    }

    private static OptionalInt a(GeneratorAccessSeed world, BlockPosition pos, UnderwaterMagmaConfiguration config) {
        Predicate<IBlockData> predicate = state -> state.a(Blocks.G);
        Predicate<IBlockData> predicate2 = state -> !state.a(Blocks.G);
        Optional<Column> optional = Column.a(world, pos, config.b, predicate, predicate2);
        return optional.map(Column::c).orElseGet(OptionalInt::empty);
    }

    private boolean b(GeneratorAccessSeed world, BlockPosition pos) {
        if (this.a((GeneratorAccess)world, pos) || this.a((GeneratorAccess)world, pos.d())) {
            return false;
        }
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            if (!this.a((GeneratorAccess)world, pos.a(direction))) continue;
            return false;
        }
        return true;
    }

    private boolean a(GeneratorAccess world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        return blockState.a(Blocks.G) || blockState.i();
    }
}

