/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2BooleanFunction;
import it.unimi.dsi.fastutil.longs.Long2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class StructureCheck {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = -1;
    private final ChunkScanAccess c;
    private final IRegistryCustom d;
    private final IRegistry<BiomeBase> e;
    private final IRegistry<Structure> f;
    private final StructureTemplateManager g;
    private final ResourceKey<WorldDimension> h;
    private final ChunkGenerator i;
    private final RandomState j;
    private final LevelHeightAccessor k;
    private final WorldChunkManager l;
    private final long m;
    private final DataFixer n;
    private static final int CHUNK_TOTAL_LIMIT = 2020050;
    private static final int PER_FEATURE_CHECK_LIMIT = 2020050;
    private final SynchronisedLong2ObjectMap<Object2IntMap<Structure>> loadedChunksSafe = new SynchronisedLong2ObjectMap(2020050);
    private final ConcurrentHashMap<Structure, SynchronisedLong2BooleanMap> featureChecksSafe = new ConcurrentHashMap();

    public StructureCheck(ChunkScanAccess chunkIoWorker, IRegistryCustom registryManager, StructureTemplateManager structureTemplateManager, ResourceKey<WorldDimension> worldKey, ChunkGenerator chunkGenerator, RandomState noiseConfig, LevelHeightAccessor world, WorldChunkManager biomeSource, long seed, DataFixer dataFixer) {
        this.c = chunkIoWorker;
        this.d = registryManager;
        this.g = structureTemplateManager;
        this.h = worldKey;
        this.i = chunkGenerator;
        this.j = noiseConfig;
        this.k = world;
        this.l = biomeSource;
        this.m = seed;
        this.n = dataFixer;
        this.e = registryManager.d(Registries.ap);
        this.f = registryManager.d(Registries.az);
    }

    public StructureCheckResult a(ChunkCoordIntPair pos, Structure type, boolean skipReferencedStructures) {
        long l2 = pos.a();
        Object2IntMap<Structure> object2IntMap = this.loadedChunksSafe.get(l2);
        if (object2IntMap != null) {
            return this.a(object2IntMap, type, skipReferencedStructures);
        }
        StructureCheckResult structureCheckResult = this.a(pos, type, skipReferencedStructures, l2);
        if (structureCheckResult != null) {
            return structureCheckResult;
        }
        boolean bl = this.featureChecksSafe.computeIfAbsent(type, structure2 -> new SynchronisedLong2BooleanMap(2020050)).getOrCompute(l2, chunkPos -> this.b(pos, type));
        return !bl ? StructureCheckResult.b : StructureCheckResult.c;
    }

    private boolean b(ChunkCoordIntPair pos, Structure structure) {
        return structure.b(new Structure.a(this.d, this.i, this.l, this.j, this.g, this.m, pos, this.k, structure.a()::a)).isPresent();
    }

    @Nullable
    private StructureCheckResult a(ChunkCoordIntPair pos, Structure structure, boolean skipReferencedStructures, long posLong) {
        NBTTagCompound compoundTag2;
        CollectFields collectFields = new CollectFields(new FieldSelector(NBTTagInt.a, "DataVersion"), new FieldSelector("Level", "Structures", NBTTagCompound.b, "Starts"), new FieldSelector("structures", NBTTagCompound.b, "starts"));
        try {
            this.c.a(pos, collectFields).join();
        }
        catch (Exception var13) {
            a.warn("Failed to read chunk {}", (Object)pos, (Object)var13);
            return StructureCheckResult.c;
        }
        NBTBase tag = collectFields.d();
        if (!(tag instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)tag;
        int i2 = IChunkLoader.a(compoundTag);
        if (i2 <= 1493) {
            return StructureCheckResult.c;
        }
        IChunkLoader.a(compoundTag, this.h, this.i.b());
        try {
            compoundTag2 = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, compoundTag, i2, SharedConstants.b().d().c());
        }
        catch (Exception var12) {
            a.warn("Failed to partially datafix chunk {}", (Object)pos, (Object)var12);
            return StructureCheckResult.c;
        }
        Object2IntMap<Structure> object2IntMap = this.a(compoundTag2);
        if (object2IntMap == null) {
            return null;
        }
        this.a(posLong, object2IntMap);
        return this.a(object2IntMap, structure, skipReferencedStructures);
    }

    @Nullable
    private Object2IntMap<Structure> a(NBTTagCompound nbt) {
        if (!nbt.b("structures", 10)) {
            return null;
        }
        NBTTagCompound compoundTag = nbt.p("structures");
        if (!compoundTag.b("starts", 10)) {
            return null;
        }
        NBTTagCompound compoundTag2 = compoundTag.p("starts");
        if (compoundTag2.g()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        IRegistry<Structure> registry = this.d.d(Registries.az);
        for (String string : compoundTag2.e()) {
            String string2;
            NBTTagCompound compoundTag3;
            Structure structure;
            MinecraftKey resourceLocation = MinecraftKey.a(string);
            if (resourceLocation == null || (structure = registry.a(resourceLocation)) == null || (compoundTag3 = compoundTag2.p(string)).g() || "INVALID".equals(string2 = compoundTag3.l("id"))) continue;
            int i2 = compoundTag3.h("references");
            object2IntMap.put((Object)structure, i2);
        }
        return object2IntMap;
    }

    private static Object2IntMap<Structure> a(Object2IntMap<Structure> map) {
        return map.isEmpty() ? Object2IntMaps.emptyMap() : map;
    }

    private StructureCheckResult a(Object2IntMap<Structure> referencesByStructure, Structure structure, boolean skipReferencedStructures) {
        int i2 = referencesByStructure.getOrDefault((Object)structure, -1);
        return i2 == -1 || skipReferencedStructures && i2 != 0 ? StructureCheckResult.b : StructureCheckResult.a;
    }

    public void a(ChunkCoordIntPair pos, Map<Structure, StructureStart> structureStarts) {
        long l2 = pos.a();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        structureStarts.forEach((arg_0, arg_1) -> StructureCheck.a((Object2IntMap)object2IntMap, arg_0, arg_1));
        this.a(l2, (Object2IntMap<Structure>)object2IntMap);
    }

    private void a(long pos, Object2IntMap<Structure> referencesByStructure) {
        this.loadedChunksSafe.put(pos, StructureCheck.a(referencesByStructure));
        for (SynchronisedLong2BooleanMap value : this.featureChecksSafe.values()) {
            value.remove(pos);
        }
    }

    public void a(ChunkCoordIntPair pos, Structure structure) {
        this.loadedChunksSafe.compute(pos.a(), (posx, referencesByStructure) -> {
            if (referencesByStructure == null) {
                referencesByStructure = new Object2IntOpenHashMap();
            } else {
                Object2IntOpenHashMap object2IntOpenHashMap;
                if (referencesByStructure instanceof Object2IntOpenHashMap) {
                    Object2IntOpenHashMap fastClone = (Object2IntOpenHashMap)referencesByStructure;
                    object2IntOpenHashMap = fastClone.clone();
                } else {
                    object2IntOpenHashMap = new Object2IntOpenHashMap(referencesByStructure);
                }
                referencesByStructure = object2IntOpenHashMap;
            }
            referencesByStructure.computeInt((Object)structure, (feature, references) -> references == null ? 1 : references + 1);
            return referencesByStructure;
        });
    }

    private static /* synthetic */ void a(Object2IntMap object2IntMap, Structure start, StructureStart structureStart) {
        if (structureStart.b()) {
            object2IntMap.put((Object)start, structureStart.f());
        }
    }

    private static final class SynchronisedLong2ObjectMap<V> {
        private final Long2ObjectLinkedOpenHashMap<V> map = new Long2ObjectLinkedOpenHashMap();
        private final int limit;

        public SynchronisedLong2ObjectMap(int limit) {
            this.limit = limit;
        }

        private void purgeEntries() {
            while (this.map.size() > this.limit) {
                this.map.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(long key) {
            Long2ObjectLinkedOpenHashMap<V> long2ObjectLinkedOpenHashMap = this.map;
            synchronized (long2ObjectLinkedOpenHashMap) {
                return (V)this.map.getAndMoveToFirst(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V put(long key, V value) {
            Long2ObjectLinkedOpenHashMap<V> long2ObjectLinkedOpenHashMap = this.map;
            synchronized (long2ObjectLinkedOpenHashMap) {
                Object ret = this.map.putAndMoveToFirst(key, value);
                this.purgeEntries();
                return (V)ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V compute(long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
            Long2ObjectLinkedOpenHashMap<V> long2ObjectLinkedOpenHashMap = this.map;
            synchronized (long2ObjectLinkedOpenHashMap) {
                this.map.compute(key, remappingFunction);
                Object ret = this.map.getAndMoveToFirst(key);
                this.purgeEntries();
                return (V)ret;
            }
        }
    }

    private static final class SynchronisedLong2BooleanMap {
        private final Long2BooleanLinkedOpenHashMap map = new Long2BooleanLinkedOpenHashMap();
        private final int limit;

        public SynchronisedLong2BooleanMap(int limit) {
            this.limit = limit;
        }

        private void purgeEntries() {
            while (this.map.size() > this.limit) {
                this.map.removeLastBoolean();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(long key) {
            Long2BooleanLinkedOpenHashMap long2BooleanLinkedOpenHashMap = this.map;
            synchronized (long2BooleanLinkedOpenHashMap) {
                return this.map.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getOrCompute(long key, Long2BooleanFunction ifAbsent) {
            Long2BooleanLinkedOpenHashMap long2BooleanLinkedOpenHashMap = this.map;
            synchronized (long2BooleanLinkedOpenHashMap) {
                if (this.map.containsKey(key)) {
                    return this.map.getAndMoveToFirst(key);
                }
            }
            boolean put = ifAbsent.get(key);
            Long2BooleanLinkedOpenHashMap long2BooleanLinkedOpenHashMap2 = this.map;
            synchronized (long2BooleanLinkedOpenHashMap2) {
                if (this.map.containsKey(key)) {
                    return this.map.getAndMoveToFirst(key);
                }
                this.map.putAndMoveToFirst(key, put);
                this.purgeEntries();
                return put;
            }
        }
    }
}

