/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String a = "INVALID";
    public static final StructureStart b = new StructureStart(null, new ChunkCoordIntPair(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger c = LogUtils.getLogger();
    private final Structure d;
    private final PiecesContainer e;
    private final ChunkCoordIntPair f;
    private int g;
    @Nullable
    private volatile StructureBoundingBox h;

    public StructureStart(Structure structure, ChunkCoordIntPair pos, int references, PiecesContainer children) {
        this.d = structure;
        this.f = pos;
        this.g = references;
        this.e = children;
    }

    @Nullable
    public static StructureStart a(StructurePieceSerializationContext context, NBTTagCompound nbt, long seed) {
        String string = nbt.l("id");
        if (a.equals(string)) {
            return b;
        }
        IRegistry<Structure> registry = context.b().d(Registries.az);
        Structure structure = registry.a(new MinecraftKey(string));
        if (structure == null) {
            c.error("Unknown stucture id: {}", (Object)string);
            return null;
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(nbt.h("ChunkX"), nbt.h("ChunkZ"));
        int i2 = nbt.h("references");
        NBTTagList listTag = nbt.c("Children", 10);
        try {
            PiecesContainer piecesContainer = PiecesContainer.a(listTag, context);
            if (structure instanceof OceanMonumentStructure) {
                piecesContainer = OceanMonumentStructure.a(chunkPos, seed, piecesContainer);
            }
            return new StructureStart(structure, chunkPos, i2, piecesContainer);
        }
        catch (Exception exception) {
            c.error("Failed Start with id {}", (Object)string, (Object)exception);
            return null;
        }
    }

    public StructureBoundingBox a() {
        StructureBoundingBox boundingBox = this.h;
        if (boundingBox == null) {
            this.h = boundingBox = this.d.a(this.e.b());
        }
        return boundingBox;
    }

    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos) {
        List<StructurePiece> list = this.e.c();
        if (list.isEmpty()) {
            return;
        }
        StructureBoundingBox boundingBox = list.get((int)0).f;
        BlockPosition blockPos = boundingBox.f();
        BlockPosition blockPos2 = new BlockPosition(blockPos.u(), boundingBox.h(), blockPos.w());
        for (StructurePiece structurePiece : list) {
            if (!structurePiece.f().a(chunkBox)) continue;
            structurePiece.a(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, blockPos2);
        }
        this.d.a(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, this.e);
    }

    public NBTTagCompound a(StructurePieceSerializationContext context, ChunkCoordIntPair chunkPos) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (!this.b()) {
            compoundTag.a("id", a);
            return compoundTag;
        }
        compoundTag.a("id", context.b().d(Registries.az).b(this.d).toString());
        compoundTag.a("ChunkX", chunkPos.e);
        compoundTag.a("ChunkZ", chunkPos.f);
        compoundTag.a("references", this.g);
        compoundTag.a("Children", this.e.a(context));
        return compoundTag;
    }

    public boolean b() {
        return !this.e.a();
    }

    public ChunkCoordIntPair c() {
        return this.f;
    }

    public boolean d() {
        return this.g < this.g();
    }

    public void e() {
        ++this.g;
    }

    public int f() {
        return this.g;
    }

    protected int g() {
        return 1;
    }

    public Structure h() {
        return this.d;
    }

    public List<StructurePiece> i() {
        return this.e.c();
    }
}

