/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.storage.loot.LootTables;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final Codec<DesertPyramidStructure> d = DesertPyramidStructure.a(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.c config) {
        super(DesertPyramidPiece::new, 21, 21, config);
    }

    @Override
    @Override
    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, PiecesContainer pieces) {
        Comparator set = ArraySetSorted.a(BaseBlockPosition::i);
        for (StructurePiece structurePiece : pieces.c()) {
            if (!(structurePiece instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece desertPyramidPiece = (DesertPyramidPiece)structurePiece;
            set.addAll(desertPyramidPiece.b());
            DesertPyramidStructure.a(box, world, desertPyramidPiece.c());
        }
        ObjectArrayList objectArrayList = new ObjectArrayList(set.stream().toList());
        RandomSource randomSource = RandomSource.a(world.A()).e().a(pieces.b().f());
        SystemUtils.b(objectArrayList, randomSource);
        int i2 = Math.min(set.size(), randomSource.b(5, 8));
        for (BlockPosition blockPos : objectArrayList) {
            if (i2 > 0) {
                --i2;
                DesertPyramidStructure.a(box, world, blockPos);
                continue;
            }
            if (!box.b(blockPos)) continue;
            world.a(blockPos, Blocks.I.n(), 2);
        }
    }

    private static void a(StructureBoundingBox box, GeneratorAccessSeed world, BlockPosition pos) {
        if (box.b(pos)) {
            world.a(pos, Blocks.J.n(), 2);
            world.a(pos, TileEntityTypes.N).ifPresent(blockEntity -> blockEntity.a(LootTables.aD, pos.a()));
        }
    }

    @Override
    @Override
    public StructureType<?> e() {
        return StructureType.b;
    }
}

