/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public final class JigsawStructure
extends Structure {
    public static final int d = 128;
    public static final Codec<JigsawStructure> e = ExtraCodecs.a(RecordCodecBuilder.mapCodec(instance -> instance.group(JigsawStructure.a(instance), (App)WorldGenFeatureDefinedStructurePoolTemplate.b.fieldOf("start_pool").forGetter(structure -> structure.f), (App)MinecraftKey.a.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.g), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.h), (App)HeightProvider.c.fieldOf("start_height").forGetter(structure -> structure.i), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.j), (App)HeightMap.Type.g.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.k), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.l)).apply((Applicative)instance, JigsawStructure::new)), JigsawStructure::a).codec();
    private final Holder<WorldGenFeatureDefinedStructurePoolTemplate> f;
    private final Optional<MinecraftKey> g;
    private final int h;
    private final HeightProvider i;
    private final boolean j;
    private final Optional<HeightMap.Type> k;
    private final int l;

    private static DataResult<JigsawStructure> a(JigsawStructure structure) {
        int i2;
        switch (structure.d()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case a: {
                int n2 = 0;
                break;
            }
            case b: 
            case c: 
            case d: {
                int n2 = i2 = 12;
            }
        }
        if (structure.l + i2 > 128) {
            return DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128");
        }
        return DataResult.success((Object)structure);
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, Optional<MinecraftKey> startJigsawName, int size, HeightProvider startHeight, boolean useExpansionHack, Optional<HeightMap.Type> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.f = startPool;
        this.g = startJigsawName;
        this.h = size;
        this.i = startHeight;
        this.j = useExpansionHack;
        this.k = projectStartToHeightmap;
        this.l = maxDistanceFromCenter;
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, int size, HeightProvider startHeight, boolean useExpansionHack, HeightMap.Type projectStartToHeightmap) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.of(projectStartToHeightmap), 80);
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, int size, HeightProvider startHeight, boolean useExpansionHack) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.empty(), 80);
    }

    @Override
    @Override
    public Optional<Structure.b> a(Structure.a context) {
        ChunkCoordIntPair chunkPos = context.h();
        int i2 = this.i.a(context.f(), new WorldGenerationContext(context.b(), context.i()));
        BlockPosition blockPos = new BlockPosition(chunkPos.d(), i2, chunkPos.e());
        return WorldGenFeatureDefinedStructureJigsawPlacement.a(context, this.f, this.g, this.h, blockPos, this.j, this.k, this.l);
    }

    @Override
    @Override
    public StructureType<?> e() {
        return StructureType.f;
    }
}

