/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import net.minecraft.world.level.lighting.LightEngineStorage;
import net.minecraft.world.level.lighting.LightEngineStorageArray;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class LightEngine<M extends LightEngineStorageArray<M>, S extends LightEngineStorage<M>>
implements LightEngineLayerEventListener {
    public static final int a = 15;
    protected static final int b = 1;
    protected static final long c = net.minecraft.world.level.lighting.LightEngine$a.a(1);
    private static final int g = 512;
    protected static final EnumDirection[] d = EnumDirection.values();
    protected final ILightAccess e;
    protected final S f;
    private final LongOpenHashSet h = new LongOpenHashSet(512, 0.5f);
    private final LongArrayFIFOQueue i = new LongArrayFIFOQueue();
    private final LongArrayFIFOQueue j = new LongArrayFIFOQueue();
    private final BlockPosition.MutableBlockPosition k = new BlockPosition.MutableBlockPosition();
    private static final int l = 2;
    private final long[] m = new long[2];
    private final LightChunk[] n = new LightChunk[2];

    protected LightEngine(ILightAccess chunkProvider, S lightStorage) {
        this.e = chunkProvider;
        this.f = lightStorage;
        this.c();
    }

    public static boolean a(IBlockAccess blockView, BlockPosition pos, IBlockData oldState, IBlockData newState) {
        if (newState == oldState) {
            return false;
        }
        return newState.b(blockView, pos) != oldState.b(blockView, pos) || newState.h() != oldState.h() || newState.g() || oldState.g();
    }

    public static int a(IBlockAccess world, IBlockData state1, BlockPosition pos1, IBlockData state2, BlockPosition pos2, EnumDirection direction, int opacity2) {
        VoxelShape voxelShape2;
        boolean bl = LightEngine.a(state1);
        boolean bl2 = LightEngine.a(state2);
        if (bl && bl2) {
            return opacity2;
        }
        VoxelShape voxelShape = bl ? VoxelShapes.a() : state1.c(world, pos1);
        VoxelShape voxelShape3 = voxelShape2 = bl2 ? VoxelShapes.a() : state2.c(world, pos2);
        if (VoxelShapes.b(voxelShape, voxelShape2, direction)) {
            return 16;
        }
        return opacity2;
    }

    public static VoxelShape a(IBlockAccess blockView, BlockPosition pos, IBlockData blockState, EnumDirection direction) {
        return LightEngine.a(blockState) ? VoxelShapes.a() : blockState.a(blockView, pos, direction);
    }

    protected static boolean a(IBlockData blockState) {
        return !blockState.p() || !blockState.g();
    }

    protected IBlockData c(BlockPosition pos) {
        int j2;
        int i2 = SectionPosition.a(pos.u());
        LightChunk lightChunk = this.a(i2, j2 = SectionPosition.a(pos.w()));
        if (lightChunk == null) {
            return Blocks.F.n();
        }
        return lightChunk.a_(pos);
    }

    protected int a(IBlockData state, BlockPosition pos) {
        return Math.max(1, state.b(this.e.q(), pos));
    }

    protected boolean a(long sourceId, IBlockData sourceState, long targetId, IBlockData targetState, EnumDirection direction) {
        VoxelShape voxelShape = this.a(sourceState, sourceId, direction);
        VoxelShape voxelShape2 = this.a(targetState, targetId, direction.g());
        return VoxelShapes.b(voxelShape, voxelShape2);
    }

    protected VoxelShape a(IBlockData blockState, long pos, EnumDirection direction) {
        return LightEngine.a(this.e.q(), (BlockPosition)this.k.f(pos), blockState, direction);
    }

    @Nullable
    protected LightChunk a(int chunkX, int chunkZ) {
        long l2 = ChunkCoordIntPair.c(chunkX, chunkZ);
        for (int i2 = 0; i2 < 2; ++i2) {
            if (l2 != this.m[i2]) continue;
            return this.n[i2];
        }
        LightChunk lightChunk = this.e.c(chunkX, chunkZ);
        for (int j2 = 1; j2 > 0; --j2) {
            this.m[j2] = this.m[j2 - 1];
            this.n[j2] = this.n[j2 - 1];
        }
        this.m[0] = l2;
        this.n[0] = lightChunk;
        return lightChunk;
    }

    private void c() {
        Arrays.fill(this.m, ChunkCoordIntPair.a);
        Arrays.fill(this.n, null);
    }

    @Override
    @Override
    public void a(BlockPosition pos) {
        this.h.add(pos.a());
    }

    public void a(long sectionPos, @Nullable NibbleArray lightArray) {
        ((LightEngineStorage)this.f).a(sectionPos, lightArray);
    }

    public void b(ChunkCoordIntPair pos, boolean retainData) {
        ((LightEngineStorage)this.f).c(SectionPosition.b(pos.e, pos.f), retainData);
    }

    @Override
    @Override
    public void a(SectionPosition pos, boolean notReady) {
        ((LightEngineStorage)this.f).d(pos.s(), notReady);
    }

    @Override
    @Override
    public void a(ChunkCoordIntPair pos, boolean retainData) {
        ((LightEngineStorage)this.f).b(SectionPosition.b(pos.e, pos.f), retainData);
    }

    @Override
    @Override
    public int a() {
        LongIterator longIterator = this.h.iterator();
        while (longIterator.hasNext()) {
            this.a(longIterator.nextLong());
        }
        this.h.clear();
        this.h.trim(512);
        int i2 = 0;
        i2 += this.e();
        this.c();
        ((LightEngineStorage)this.f).a(this);
        ((LightEngineStorage)this.f).b();
        return i2 += this.d();
    }

    private int d() {
        int i2 = 0;
        while (!this.j.isEmpty()) {
            long l2 = this.j.dequeueLong();
            long m2 = this.j.dequeueLong();
            int j2 = ((LightEngineStorage)this.f).e(l2);
            int k2 = net.minecraft.world.level.lighting.LightEngine$a.a(m2);
            if (net.minecraft.world.level.lighting.LightEngine$a.c(m2) && j2 < k2) {
                ((LightEngineStorage)this.f).a(l2, k2);
                j2 = k2;
            }
            if (j2 == k2) {
                this.a(l2, m2, j2);
            }
            ++i2;
        }
        return i2;
    }

    private int e() {
        int i2 = 0;
        while (!this.i.isEmpty()) {
            long l2 = this.i.dequeueLong();
            long m2 = this.i.dequeueLong();
            this.a(l2, m2);
            ++i2;
        }
        return i2;
    }

    protected void b(long blockPos, long flags) {
        this.i.enqueue(blockPos);
        this.i.enqueue(flags);
    }

    protected void c(long blockPos, long flags) {
        this.j.enqueue(blockPos);
        this.j.enqueue(flags);
    }

    @Override
    @Override
    public boolean E_() {
        return ((LightEngineStorage)this.f).a() || !this.h.isEmpty() || !this.i.isEmpty() || !this.j.isEmpty();
    }

    @Override
    @Nullable
    @Override
    public NibbleArray a(SectionPosition pos) {
        return ((LightEngineStorage)this.f).d(pos.s());
    }

    @Override
    @Override
    public int b(BlockPosition pos) {
        return ((LightEngineStorage)this.f).a(pos.a());
    }

    public String b(long sectionPos) {
        return this.c(sectionPos).a();
    }

    public LightEngineStorage.b c(long sectionPos) {
        return ((LightEngineStorage)this.f).k(sectionPos);
    }

    protected abstract void a(long var1);

    protected abstract void a(long var1, long var3, int var5);

    protected abstract void a(long var1, long var3);

    public static class a {
        private static final int a = 4;
        private static final int b = 6;
        private static final long c = 15L;
        private static final long d = 1008L;
        private static final long e = 1024L;
        private static final long f = 2048L;

        public static long a(int lightLevel, EnumDirection direction) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.c(1008L, direction);
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, lightLevel);
        }

        public static long a(int lightLevel) {
            return net.minecraft.world.level.lighting.LightEngine$a.a(1008L, lightLevel);
        }

        public static long a(int lightLevel, boolean trivial) {
            long l2 = 1008L;
            l2 |= 0x800L;
            if (trivial) {
                l2 |= 0x400L;
            }
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, lightLevel);
        }

        public static long a(int lightLevel, boolean trivial, EnumDirection direction) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.c(1008L, direction);
            if (trivial) {
                l2 |= 0x400L;
            }
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, lightLevel);
        }

        public static long b(int lightLevel, boolean trivial, EnumDirection direction) {
            long l2 = 0L;
            if (trivial) {
                l2 |= 0x400L;
            }
            l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, direction);
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, lightLevel);
        }

        public static long a(boolean down, boolean north, boolean south, boolean west, boolean east) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.a(0L, 15);
            if (down) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.a);
            }
            if (north) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.c);
            }
            if (south) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.d);
            }
            if (west) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.e);
            }
            if (east) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.f);
            }
            return l2;
        }

        public static int a(long packed) {
            return (int)(packed & 0xFL);
        }

        public static boolean b(long packed) {
            return (packed & 0x400L) != 0L;
        }

        public static boolean c(long packed) {
            return (packed & 0x800L) != 0L;
        }

        public static boolean a(long packed, EnumDirection direction) {
            return (packed & 1L << direction.ordinal() + 4) != 0L;
        }

        private static long a(long packed, int lightLevel) {
            return packed & 0xFFFFFFFFFFFFFFF0L | (long)lightLevel & 0xFL;
        }

        private static long b(long packed, EnumDirection direction) {
            return packed | 1L << direction.ordinal() + 4;
        }

        private static long c(long packed, EnumDirection direction) {
            return packed & (1L << direction.ordinal() + 4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

