/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootSerializerType;

public class JsonRegistry {
    public static <E, T extends LootSerializerType<E>> a<E, T> a(IRegistry<T> registry, String rootFieldName, String idFieldName, Function<E, T> typeGetter) {
        return new a<E, T>(registry, rootFieldName, idFieldName, typeGetter);
    }

    public static class a<E, T extends LootSerializerType<E>> {
        private final IRegistry<T> a;
        private final String b;
        private final String c;
        private final Function<E, T> d;
        @Nullable
        private Pair<T, b<? extends E>> e;
        @Nullable
        private T f;

        a(IRegistry<T> registry, String rootFieldName, String idFieldName, Function<E, T> typeIdentification) {
            this.a = registry;
            this.b = rootFieldName;
            this.c = idFieldName;
            this.d = typeIdentification;
        }

        public a<E, T> a(T type, b<? extends E> serializer) {
            this.e = Pair.of(type, serializer);
            return this;
        }

        public a<E, T> a(T defaultType) {
            this.f = defaultType;
            return this;
        }

        public Object a() {
            return new c<E, T>(this.a, this.b, this.c, this.d, this.f, this.e);
        }
    }

    public static interface b<T> {
        public JsonElement a(T var1, JsonSerializationContext var2);

        public T a(JsonElement var1, JsonDeserializationContext var2);
    }

    static class c<E, T extends LootSerializerType<E>>
    implements JsonDeserializer<E>,
    JsonSerializer<E> {
        private final IRegistry<T> a;
        private final String b;
        private final String c;
        private final Function<E, T> d;
        @Nullable
        private final T e;
        @Nullable
        private final Pair<T, b<? extends E>> f;

        c(IRegistry<T> registry, String rootFieldName, String idFieldName, Function<E, T> typeGetter, @Nullable T defaultType, @Nullable Pair<T, b<? extends E>> elementSerializer) {
            this.a = registry;
            this.b = rootFieldName;
            this.c = idFieldName;
            this.d = typeGetter;
            this.e = defaultType;
            this.f = elementSerializer;
        }

        @Override
        public E deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                LootSerializerType serializerType2;
                JsonObject jsonObject = ChatDeserializer.m(jsonElement, this.b);
                String string = ChatDeserializer.a(jsonObject, this.c, "");
                if (string.isEmpty()) {
                    T serializerType = this.e;
                } else {
                    MinecraftKey resourceLocation = new MinecraftKey(string);
                    serializerType2 = (LootSerializerType)this.a.a(resourceLocation);
                }
                if (serializerType2 == null) {
                    throw new JsonSyntaxException("Unknown type '" + string + "'");
                }
                return (E)serializerType2.a().a(jsonObject, jsonDeserializationContext);
            }
            if (this.f == null) {
                throw new UnsupportedOperationException("Object " + jsonElement + " can't be deserialized");
            }
            return (E)((b)this.f.getSecond()).a(jsonElement, jsonDeserializationContext);
        }

        @Override
        public JsonElement serialize(E object, Type type, JsonSerializationContext jsonSerializationContext) {
            LootSerializerType serializerType = (LootSerializerType)this.d.apply(object);
            if (this.f != null && this.f.getFirst() == serializerType) {
                return ((b)this.f.getSecond()).a(object, jsonSerializationContext);
            }
            if (serializerType == null) {
                throw new JsonSyntaxException("Unknown type: " + object);
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(this.c, this.a.b(serializerType).toString());
            serializerType.a().a(jsonObject, object, jsonSerializationContext);
            return jsonObject;
        }
    }
}

