/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.lang.invoke.TypeDescriptor;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootDataType<T> {
    private static final Logger d = LogUtils.getLogger();
    public static final LootDataType<LootItemCondition> a = new LootDataType(LootSerialization.a().create(), LootDataType.a(LootItemCondition.class, LootDataManager::a), "predicates", LootDataType.d());
    public static final LootDataType<LootItemFunction> b = new LootDataType(LootSerialization.b().create(), LootDataType.a(LootItemFunction.class, LootDataManager::a), "item_modifiers", LootDataType.d());
    public static final LootDataType<LootTable> c = new LootDataType<LootTable>(LootSerialization.c().create(), LootDataType.a(LootTable.class), "loot_tables", LootDataType.e());
    private final Gson e;
    private final BiFunction<MinecraftKey, JsonElement, Optional<T>> f;
    private final String g;
    private final a<T> h;

    private LootDataType(Gson gson, BiFunction<Gson, String, BiFunction<MinecraftKey, JsonElement, Optional<T>>> parserFactory, String id, a<T> validator) {
        this.e = gson;
        this.g = id;
        this.h = validator;
        this.f = parserFactory.apply(gson, id);
    }

    public Gson a() {
        return this.e;
    }

    public String b() {
        return this.g;
    }

    public void a(LootCollector reporter, LootDataId<T> key, T value) {
        this.h.run(reporter, key, value);
    }

    public Optional<T> a(MinecraftKey id, JsonElement json) {
        return this.f.apply(id, json);
    }

    public static Stream<LootDataType<?>> c() {
        return Stream.of(a, b, c);
    }

    private static <T> BiFunction<Gson, String, BiFunction<MinecraftKey, JsonElement, Optional<T>>> a(Class<T> clazz) {
        return (gson, dataTypeId) -> (id, json) -> {
            try {
                return Optional.of(gson.fromJson(json, clazz));
            }
            catch (Exception exception) {
                d.error("Couldn't parse element {}:{}", new Object[]{dataTypeId, id, exception});
                return Optional.empty();
            }
        };
    }

    private static <T> BiFunction<Gson, String, BiFunction<MinecraftKey, JsonElement, Optional<T>>> a(Class<T> clazz, Function<T[], T> combiner) {
        TypeDescriptor.OfField class_ = clazz.arrayType();
        return (arg_0, arg_1) -> LootDataType.a((Class)class_, combiner, clazz, arg_0, arg_1);
    }

    private static <T extends LootItemUser> a<T> d() {
        return (reporter, key, value) -> value.a(reporter.a("{" + key.a().g + ":" + key.b() + "}", key));
    }

    private static a<LootTable> e() {
        return (reporter, key, value) -> value.a(reporter.a(value.a()).a("{" + key.a().g + ":" + key.b() + "}", key));
    }

    private static /* synthetic */ BiFunction a(Class gson, Function dataTypeId, Class class_, Gson gson2, String string) {
        return (id, json) -> {
            try {
                if (json.isJsonArray()) {
                    Object[] objects = (Object[])gson2.fromJson(json, gson);
                    return Optional.of(dataTypeId.apply(objects));
                }
                return Optional.of(gson2.fromJson(json, class_));
            }
            catch (Exception exception) {
                d.error("Couldn't parse element {}:{}", new Object[]{string, id, exception});
                return Optional.empty();
            }
        };
    }

    @FunctionalInterface
    public static interface a<T> {
        public void run(LootCollector var1, LootDataId<T> var2, T var3);
    }
}

