/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;

public class LootParams {
    private final WorldServer a;
    private final Map<LootContextParameter<?>, Object> b;
    private final Map<MinecraftKey, b> c;
    private final float d;

    public LootParams(WorldServer world, Map<LootContextParameter<?>, Object> parameters, Map<MinecraftKey, b> dynamicDrops, float luck) {
        this.a = world;
        this.b = parameters;
        this.c = dynamicDrops;
        this.d = luck;
    }

    public WorldServer a() {
        return this.a;
    }

    public boolean a(LootContextParameter<?> parameter) {
        return this.b.containsKey(parameter);
    }

    public <T> T b(LootContextParameter<T> parameter) {
        Object object = this.b.get(parameter);
        if (object == null) {
            throw new NoSuchElementException(parameter.a().toString());
        }
        return (T)object;
    }

    @Nullable
    public <T> T c(LootContextParameter<T> parameter) {
        return (T)this.b.get(parameter);
    }

    @Nullable
    public <T> T d(LootContextParameter<T> parameter) {
        return (T)this.b.get(parameter);
    }

    public void a(MinecraftKey id, Consumer<ItemStack> lootConsumer) {
        b dynamicDrop = this.c.get(id);
        if (dynamicDrop != null) {
            dynamicDrop.add(lootConsumer);
        }
    }

    public float b() {
        return this.d;
    }

    @FunctionalInterface
    public static interface b {
        public void add(Consumer<ItemStack> var1);
    }

    public static class a {
        private final WorldServer a;
        private final Map<LootContextParameter<?>, Object> b = Maps.newIdentityHashMap();
        private final Map<MinecraftKey, b> c = Maps.newHashMap();
        private float d;

        public a(WorldServer world) {
            this.a = world;
        }

        public WorldServer a() {
            return this.a;
        }

        public <T> a a(LootContextParameter<T> parameter, T value) {
            this.b.put(parameter, value);
            return this;
        }

        public <T> a b(LootContextParameter<T> parameter, @Nullable T value) {
            if (value == null) {
                this.b.remove(parameter);
            } else {
                this.b.put(parameter, value);
            }
            return this;
        }

        public <T> T a(LootContextParameter<T> parameter) {
            Object object = this.b.get(parameter);
            if (object == null) {
                throw new NoSuchElementException(parameter.a().toString());
            }
            return (T)object;
        }

        @Nullable
        public <T> T b(LootContextParameter<T> parameter) {
            return (T)this.b.get(parameter);
        }

        public a a(MinecraftKey id, b dynamicDrop) {
            b dynamicDrop2 = this.c.put(id, dynamicDrop);
            if (dynamicDrop2 != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + this.c + "'");
            }
            return this;
        }

        public a a(float luck) {
            this.d = luck;
            return this;
        }

        public LootParams a(LootContextParameterSet contextType) {
            Sets.SetView set = Sets.difference(this.b.keySet(), contextType.b());
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + (Set)set);
            }
            Sets.SetView set2 = Sets.difference(contextType.a(), this.b.keySet());
            if (!set2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + (Set)set2);
            }
            return new LootParams(this.a, this.b, this.c, this.d);
        }
    }
}

