/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.ArrayUtils;

public abstract class LootSelectorEntry
extends LootEntryAbstract {
    public static final int c = 1;
    public static final int e = 0;
    protected final int f;
    protected final int g;
    protected final LootItemFunction[] h;
    final BiFunction<ItemStack, LootTableInfo, ItemStack> i;
    private final LootEntry j = new c(){

        @Override
        public void a(Consumer<ItemStack> lootConsumer, LootTableInfo context) {
            LootSelectorEntry.this.a(LootItemFunction.a(LootSelectorEntry.this.i, lootConsumer, context), context);
        }
    };
    private Float lastLuck = null;
    private int lastWeight = 0;

    protected LootSelectorEntry(int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(conditions);
        this.f = weight;
        this.g = quality;
        this.h = functions;
        this.i = LootItemFunctions.a(functions);
    }

    @Override
    public void a(LootCollector reporter) {
        super.a(reporter);
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            this.h[i2].a(reporter.b(".functions[" + i2 + "]"));
        }
    }

    protected abstract void a(Consumer<ItemStack> var1, LootTableInfo var2);

    @Override
    public boolean expand(LootTableInfo context, Consumer<LootEntry> choiceConsumer) {
        if (this.a(context)) {
            choiceConsumer.accept(this.j);
            return true;
        }
        return false;
    }

    public static a<?> a(d factory) {
        return new b(factory);
    }

    static class b
    extends a<b> {
        private final d c;

        public b(d factory) {
            this.c = factory;
        }

        protected b g() {
            return this;
        }

        @Override
        public LootEntryAbstract b() {
            return this.c.build(this.a, this.b, this.f(), this.a());
        }
    }

    @FunctionalInterface
    protected static interface d {
        public LootSelectorEntry build(int var1, int var2, LootItemCondition[] var3, LootItemFunction[] var4);
    }

    public static abstract class e<T extends LootSelectorEntry>
    extends LootEntryAbstract.Serializer<T> {
        @Override
        public void a(JsonObject json, T entry, JsonSerializationContext context) {
            if (((LootSelectorEntry)entry).f != 1) {
                json.addProperty("weight", (Number)((LootSelectorEntry)entry).f);
            }
            if (((LootSelectorEntry)entry).g != 0) {
                json.addProperty("quality", (Number)((LootSelectorEntry)entry).g);
            }
            if (!ArrayUtils.isEmpty((Object[])((LootSelectorEntry)entry).h)) {
                json.add("functions", context.serialize((Object)((LootSelectorEntry)entry).h));
            }
        }

        public final T a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            int i2 = ChatDeserializer.a(jsonObject, "weight", 1);
            int j2 = ChatDeserializer.a(jsonObject, "quality", 0);
            LootItemFunction[] lootItemFunctions = ChatDeserializer.a(jsonObject, "functions", new LootItemFunction[0], jsonDeserializationContext, LootItemFunction[].class);
            return this.b(jsonObject, jsonDeserializationContext, i2, j2, lootItemConditions, lootItemFunctions);
        }

        protected abstract T b(JsonObject var1, JsonDeserializationContext var2, int var3, int var4, LootItemCondition[] var5, LootItemFunction[] var6);
    }

    protected abstract class c
    implements LootEntry {
        protected c() {
        }

        @Override
        public int a(float luck) {
            if (LootSelectorEntry.this.lastLuck != null && LootSelectorEntry.this.lastLuck.floatValue() == luck) {
                return LootSelectorEntry.this.lastWeight;
            }
            float qualityModifer = (float)LootSelectorEntry.this.g * luck;
            double baseWeight = (float)LootSelectorEntry.this.f + qualityModifer;
            if (GlobalConfiguration.get().misc.useAlternativeLuckFormula) {
                int weightBoost = 100;
                double impacted = (baseWeight *= 100.0) * ((baseWeight - 100.0) / 100.0 / 100.0);
                float luckModifier = Math.min(100.0f, luck * 10.0f) / 100.0f;
                baseWeight = Math.ceil(baseWeight - impacted * (double)luckModifier);
            }
            LootSelectorEntry.this.lastLuck = Float.valueOf(luck);
            LootSelectorEntry.this.lastWeight = (int)Math.max(Math.floor(baseWeight), 0.0);
            return LootSelectorEntry.this.lastWeight;
        }
    }

    public static abstract class a<T extends a<T>>
    extends LootEntryAbstract.a<T>
    implements LootItemFunctionUser<T> {
        protected int a = 1;
        protected int b = 0;
        private final List<LootItemFunction> c = Lists.newArrayList();

        public T a(LootItemFunction.a builder) {
            this.c.add(builder.b());
            return (T)((a)this.at_());
        }

        protected LootItemFunction[] a() {
            return this.c.toArray(new LootItemFunction[0]);
        }

        public T a(int weight) {
            this.a = weight;
            return (T)((a)this.at_());
        }

        public T b(int quality) {
            this.b = quality;
            return (T)((a)this.at_());
        }
    }
}

