/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemFunctionConditional {
    private static final Logger a = LogUtils.getLogger();
    final MinecraftKey b;

    FunctionReference(LootItemCondition[] conditions, MinecraftKey name) {
        super(conditions);
        this.b = name;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.A;
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        LootDataId<LootItemFunction> lootDataId = new LootDataId<LootItemFunction>(LootDataType.b, this.b);
        if (reporter.a(lootDataId)) {
            reporter.a("Function " + this.b + " is recursively called");
            return;
        }
        super.a(reporter);
        reporter.b().getElementOptional(lootDataId).ifPresentOrElse(itemModifier -> itemModifier.a(reporter.a(".{" + this.b + "}", lootDataId)), () -> reporter.a("Unknown function table called " + this.b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected ItemStack a(ItemStack stack, LootTableInfo context) {
        LootItemFunction lootItemFunction = context.a().getElement(LootDataType.b, this.b);
        if (lootItemFunction == null) {
            a.warn("Unknown function: {}", (Object)this.b);
            return stack;
        }
        LootTableInfo.c<LootItemFunction> visitedEntry = LootTableInfo.a(lootItemFunction);
        if (context.b(visitedEntry)) {
            try {
                ItemStack itemStack = (ItemStack)lootItemFunction.apply(stack, context);
                return itemStack;
            }
            finally {
                context.c(visitedEntry);
            }
        }
        a.warn("Detected infinite loop in loot tables");
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(MinecraftKey name) {
        return FunctionReference.a((LootItemCondition[] conditions) -> new FunctionReference((LootItemCondition[])conditions, name));
    }

    public static class a
    extends LootItemFunctionConditional.c<FunctionReference> {
        @Override
        @Override
        public void a(JsonObject json, FunctionReference object, JsonSerializationContext context) {
            json.addProperty("name", object.b.toString());
        }

        @Override
        public FunctionReference a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.i(jsonObject, "name"));
            return new FunctionReference(lootItemConditions, resourceLocation);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

