/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetTable
extends LootItemFunctionConditional {
    final MinecraftKey a;
    final long b;
    final TileEntityTypes<?> c;

    LootItemFunctionSetTable(LootItemCondition[] conditions, MinecraftKey id, long seed, TileEntityTypes<?> type) {
        super(conditions);
        this.a = id;
        this.b = seed;
        this.c = type;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.r;
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (stack.b()) {
            return stack;
        }
        NBTTagCompound compoundTag = ItemBlock.a(stack);
        if (compoundTag == null) {
            compoundTag = new NBTTagCompound();
        }
        compoundTag.a("LootTable", this.a.toString());
        if (this.b != 0L) {
            compoundTag.a("LootTableSeed", this.b);
        }
        ItemBlock.a(stack, this.c, compoundTag);
        return stack;
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        super.a(reporter);
        LootDataId<LootTable> lootDataId = new LootDataId<LootTable>(LootDataType.c, this.a);
        if (reporter.b().getElementOptional(lootDataId).isEmpty()) {
            reporter.a("Missing loot table used for container: " + this.a);
        }
    }

    public static LootItemFunctionConditional.a<?> a(TileEntityTypes<?> type, MinecraftKey id) {
        return LootItemFunctionSetTable.a(conditions -> new LootItemFunctionSetTable((LootItemCondition[])conditions, id, 0L, type));
    }

    public static LootItemFunctionConditional.a<?> a(TileEntityTypes<?> type, MinecraftKey id, long seed) {
        return LootItemFunctionSetTable.a(conditions -> new LootItemFunctionSetTable((LootItemCondition[])conditions, id, seed, type));
    }

    public static class a
    extends LootItemFunctionConditional.c<LootItemFunctionSetTable> {
        @Override
        @Override
        public void a(JsonObject json, LootItemFunctionSetTable object, JsonSerializationContext context) {
            super.a(json, object, context);
            json.addProperty("name", object.a.toString());
            json.addProperty("type", BuiltInRegistries.l.b(object.c).toString());
            if (object.b != 0L) {
                json.addProperty("seed", (Number)object.b);
            }
        }

        @Override
        public LootItemFunctionSetTable a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.i(jsonObject, "name"));
            long l2 = ChatDeserializer.a(jsonObject, "seed", 0L);
            MinecraftKey resourceLocation2 = new MinecraftKey(ChatDeserializer.i(jsonObject, "type"));
            TileEntityTypes<?> blockEntityType = BuiltInRegistries.l.b(resourceLocation2).orElseThrow(() -> new JsonSyntaxException("Unknown block entity type id '" + resourceLocation2 + "'"));
            return new LootItemFunctionSetTable(lootItemConditions, resourceLocation, l2, blockEntityType);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

