/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class UniformGenerator
implements NumberProvider {
    final NumberProvider a;
    final NumberProvider b;

    UniformGenerator(NumberProvider min, NumberProvider max) {
        this.a = min;
        this.b = max;
    }

    @Override
    @Override
    public LootNumberProviderType b() {
        return NumberProviders.b;
    }

    public static UniformGenerator a(float min, float max) {
        return new UniformGenerator(ConstantValue.a(min), ConstantValue.a(max));
    }

    @Override
    @Override
    public int a(LootTableInfo context) {
        return MathHelper.a(context.b(), this.a.a(context), this.b.a(context));
    }

    @Override
    @Override
    public float b(LootTableInfo context) {
        return MathHelper.a(context.b(), this.a.b(context), this.b.b(context));
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return Sets.union(this.a.a(), this.b.a());
    }

    public static class a
    implements LootSerializer<UniformGenerator> {
        @Override
        public UniformGenerator b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            NumberProvider numberProvider = ChatDeserializer.a(jsonObject, "min", jsonDeserializationContext, NumberProvider.class);
            NumberProvider numberProvider2 = ChatDeserializer.a(jsonObject, "max", jsonDeserializationContext, NumberProvider.class);
            return new UniformGenerator(numberProvider, numberProvider2);
        }

        @Override
        @Override
        public void a(JsonObject json, UniformGenerator object, JsonSerializationContext context) {
            json.add("min", context.serialize((Object)object.a));
            json.add("max", context.serialize((Object)object.b));
        }

        @Override
        public /* synthetic */ Object a(JsonObject json, JsonDeserializationContext context) {
            return this.b(json, context);
        }
    }
}

