/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class AxisAlignedBB {
    private static final double g = 1.0E-7;
    public final double a;
    public final double b;
    public final double c;
    public final double d;
    public final double e;
    public final double f;

    public AxisAlignedBB(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.a = Math.min(x1, x2);
        this.b = Math.min(y1, y2);
        this.c = Math.min(z1, z2);
        this.d = Math.max(x1, x2);
        this.e = Math.max(y1, y2);
        this.f = Math.max(z1, z2);
    }

    public AxisAlignedBB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, boolean dummy) {
        this.a = minX;
        this.b = minY;
        this.c = minZ;
        this.d = maxX;
        this.e = maxY;
        this.f = maxZ;
    }

    public AxisAlignedBB(BlockPosition pos) {
        this(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1);
    }

    public AxisAlignedBB(BlockPosition pos1, BlockPosition pos2) {
        this(pos1.u(), pos1.v(), pos1.w(), pos2.u(), pos2.v(), pos2.w());
    }

    public AxisAlignedBB(Vec3D pos1, Vec3D pos2) {
        this(pos1.c, pos1.d, pos1.e, pos2.c, pos2.d, pos2.e);
    }

    public static AxisAlignedBB a(StructureBoundingBox mutable) {
        return new AxisAlignedBB(mutable.g(), mutable.h(), mutable.i(), mutable.j() + 1, mutable.k() + 1, mutable.l() + 1);
    }

    public static AxisAlignedBB a(Vec3D pos) {
        return new AxisAlignedBB(pos.c, pos.d, pos.e, pos.c + 1.0, pos.d + 1.0, pos.e + 1.0);
    }

    public AxisAlignedBB a(double minX) {
        return new AxisAlignedBB(minX, this.b, this.c, this.d, this.e, this.f);
    }

    public AxisAlignedBB b(double minY) {
        return new AxisAlignedBB(this.a, minY, this.c, this.d, this.e, this.f);
    }

    public AxisAlignedBB c(double minZ) {
        return new AxisAlignedBB(this.a, this.b, minZ, this.d, this.e, this.f);
    }

    public AxisAlignedBB d(double maxX) {
        return new AxisAlignedBB(this.a, this.b, this.c, maxX, this.e, this.f);
    }

    public AxisAlignedBB e(double maxY) {
        return new AxisAlignedBB(this.a, this.b, this.c, this.d, maxY, this.f);
    }

    public AxisAlignedBB f(double maxZ) {
        return new AxisAlignedBB(this.a, this.b, this.c, this.d, this.e, maxZ);
    }

    public double a(EnumDirection.EnumAxis axis) {
        return axis.a(this.a, this.b, this.c);
    }

    public double b(EnumDirection.EnumAxis axis) {
        return axis.a(this.d, this.e, this.f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AxisAlignedBB)) {
            return false;
        }
        AxisAlignedBB aABB = (AxisAlignedBB)object;
        if (Double.compare(aABB.a, this.a) != 0) {
            return false;
        }
        if (Double.compare(aABB.b, this.b) != 0) {
            return false;
        }
        if (Double.compare(aABB.c, this.c) != 0) {
            return false;
        }
        if (Double.compare(aABB.d, this.d) != 0) {
            return false;
        }
        if (Double.compare(aABB.e, this.e) != 0) {
            return false;
        }
        return Double.compare(aABB.f, this.f) == 0;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.a);
        int i2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.b);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.c);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.d);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.e);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.f);
        return 31 * i2 + (int)(l2 ^ l2 >>> 32);
    }

    public AxisAlignedBB a(double x2, double y2, double z2) {
        double d2 = this.a;
        double e2 = this.b;
        double f2 = this.c;
        double g2 = this.d;
        double h2 = this.e;
        double i2 = this.f;
        if (x2 < 0.0) {
            d2 -= x2;
        } else if (x2 > 0.0) {
            g2 -= x2;
        }
        if (y2 < 0.0) {
            e2 -= y2;
        } else if (y2 > 0.0) {
            h2 -= y2;
        }
        if (z2 < 0.0) {
            f2 -= z2;
        } else if (z2 > 0.0) {
            i2 -= z2;
        }
        return new AxisAlignedBB(d2, e2, f2, g2, h2, i2);
    }

    public AxisAlignedBB b(Vec3D scale) {
        return this.b(scale.c, scale.d, scale.e);
    }

    public AxisAlignedBB b(double x2, double y2, double z2) {
        double d2 = this.a;
        double e2 = this.b;
        double f2 = this.c;
        double g2 = this.d;
        double h2 = this.e;
        double i2 = this.f;
        if (x2 < 0.0) {
            d2 += x2;
        } else if (x2 > 0.0) {
            g2 += x2;
        }
        if (y2 < 0.0) {
            e2 += y2;
        } else if (y2 > 0.0) {
            h2 += y2;
        }
        if (z2 < 0.0) {
            f2 += z2;
        } else if (z2 > 0.0) {
            i2 += z2;
        }
        return new AxisAlignedBB(d2, e2, f2, g2, h2, i2);
    }

    public AxisAlignedBB c(double x2, double y2, double z2) {
        double d2 = this.a - x2;
        double e2 = this.b - y2;
        double f2 = this.c - z2;
        double g2 = this.d + x2;
        double h2 = this.e + y2;
        double i2 = this.f + z2;
        return new AxisAlignedBB(d2, e2, f2, g2, h2, i2);
    }

    public AxisAlignedBB g(double value) {
        return this.c(value, value, value);
    }

    public AxisAlignedBB a(AxisAlignedBB box) {
        double d2 = Math.max(this.a, box.a);
        double e2 = Math.max(this.b, box.b);
        double f2 = Math.max(this.c, box.c);
        double g2 = Math.min(this.d, box.d);
        double h2 = Math.min(this.e, box.e);
        double i2 = Math.min(this.f, box.f);
        return new AxisAlignedBB(d2, e2, f2, g2, h2, i2);
    }

    public AxisAlignedBB b(AxisAlignedBB box) {
        double d2 = Math.min(this.a, box.a);
        double e2 = Math.min(this.b, box.b);
        double f2 = Math.min(this.c, box.c);
        double g2 = Math.max(this.d, box.d);
        double h2 = Math.max(this.e, box.e);
        double i2 = Math.max(this.f, box.f);
        return new AxisAlignedBB(d2, e2, f2, g2, h2, i2);
    }

    public AxisAlignedBB d(double x2, double y2, double z2) {
        return new AxisAlignedBB(this.a + x2, this.b + y2, this.c + z2, this.d + x2, this.e + y2, this.f + z2);
    }

    public AxisAlignedBB a(BlockPosition blockPos) {
        return new AxisAlignedBB(this.a + (double)blockPos.u(), this.b + (double)blockPos.v(), this.c + (double)blockPos.w(), this.d + (double)blockPos.u(), this.e + (double)blockPos.v(), this.f + (double)blockPos.w());
    }

    public AxisAlignedBB c(Vec3D vec) {
        return this.d(vec.c, vec.d, vec.e);
    }

    public boolean c(AxisAlignedBB box) {
        return this.a(box.a, box.b, box.c, box.d, box.e, box.f);
    }

    public boolean a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.a < maxX && this.d > minX && this.b < maxY && this.e > minY && this.c < maxZ && this.f > minZ;
    }

    public boolean a(Vec3D pos1, Vec3D pos2) {
        return this.a(Math.min(pos1.c, pos2.c), Math.min(pos1.d, pos2.d), Math.min(pos1.e, pos2.e), Math.max(pos1.c, pos2.c), Math.max(pos1.d, pos2.d), Math.max(pos1.e, pos2.e));
    }

    public boolean d(Vec3D pos) {
        return this.e(pos.c, pos.d, pos.e);
    }

    public boolean e(double x2, double y2, double z2) {
        return x2 >= this.a && x2 < this.d && y2 >= this.b && y2 < this.e && z2 >= this.c && z2 < this.f;
    }

    public double a() {
        double d2 = this.b();
        double e2 = this.c();
        double f2 = this.d();
        return (d2 + e2 + f2) / 3.0;
    }

    public double b() {
        return this.d - this.a;
    }

    public double c() {
        return this.e - this.b;
    }

    public double d() {
        return this.f - this.c;
    }

    public AxisAlignedBB f(double x2, double y2, double z2) {
        return this.c(-x2, -y2, -z2);
    }

    public AxisAlignedBB h(double value) {
        return this.g(-value);
    }

    public Optional<Vec3D> b(Vec3D min, Vec3D max) {
        double[] ds = new double[]{1.0};
        double d2 = max.c - min.c;
        double e2 = max.d - min.d;
        double f2 = max.e - min.e;
        EnumDirection direction = AxisAlignedBB.a(this, min, ds, null, d2, e2, f2);
        if (direction == null) {
            return Optional.empty();
        }
        double g2 = ds[0];
        return Optional.of(min.b(g2 * d2, g2 * e2, g2 * f2));
    }

    @Nullable
    public static MovingObjectPositionBlock a(Iterable<AxisAlignedBB> boxes, Vec3D from, Vec3D to, BlockPosition pos) {
        double[] ds = new double[]{1.0};
        EnumDirection direction = null;
        double d2 = to.c - from.c;
        double e2 = to.d - from.d;
        double f2 = to.e - from.e;
        for (AxisAlignedBB aABB : boxes) {
            direction = AxisAlignedBB.a(aABB.a(pos), from, ds, direction, d2, e2, f2);
        }
        if (direction == null) {
            return null;
        }
        double g2 = ds[0];
        return new MovingObjectPositionBlock(from.b(g2 * d2, g2 * e2, g2 * f2), direction, pos, false);
    }

    @Nullable
    private static EnumDirection a(AxisAlignedBB box, Vec3D intersectingVector, double[] traceDistanceResult, @Nullable EnumDirection approachDirection, double deltaX, double deltaY, double deltaZ) {
        if (deltaX > 1.0E-7) {
            approachDirection = AxisAlignedBB.a(traceDistanceResult, approachDirection, deltaX, deltaY, deltaZ, box.a, box.b, box.e, box.c, box.f, EnumDirection.e, intersectingVector.c, intersectingVector.d, intersectingVector.e);
        } else if (deltaX < -1.0E-7) {
            approachDirection = AxisAlignedBB.a(traceDistanceResult, approachDirection, deltaX, deltaY, deltaZ, box.d, box.b, box.e, box.c, box.f, EnumDirection.f, intersectingVector.c, intersectingVector.d, intersectingVector.e);
        }
        if (deltaY > 1.0E-7) {
            approachDirection = AxisAlignedBB.a(traceDistanceResult, approachDirection, deltaY, deltaZ, deltaX, box.b, box.c, box.f, box.a, box.d, EnumDirection.a, intersectingVector.d, intersectingVector.e, intersectingVector.c);
        } else if (deltaY < -1.0E-7) {
            approachDirection = AxisAlignedBB.a(traceDistanceResult, approachDirection, deltaY, deltaZ, deltaX, box.e, box.c, box.f, box.a, box.d, EnumDirection.b, intersectingVector.d, intersectingVector.e, intersectingVector.c);
        }
        if (deltaZ > 1.0E-7) {
            approachDirection = AxisAlignedBB.a(traceDistanceResult, approachDirection, deltaZ, deltaX, deltaY, box.c, box.a, box.d, box.b, box.e, EnumDirection.c, intersectingVector.e, intersectingVector.c, intersectingVector.d);
        } else if (deltaZ < -1.0E-7) {
            approachDirection = AxisAlignedBB.a(traceDistanceResult, approachDirection, deltaZ, deltaX, deltaY, box.f, box.a, box.d, box.b, box.e, EnumDirection.d, intersectingVector.e, intersectingVector.c, intersectingVector.d);
        }
        return approachDirection;
    }

    @Nullable
    private static EnumDirection a(double[] traceDistanceResult, @Nullable EnumDirection approachDirection, double deltaX, double deltaY, double deltaZ, double begin, double minX, double maxX, double minZ, double maxZ, EnumDirection resultDirection, double startX, double startY, double startZ) {
        double d2 = (begin - startX) / deltaX;
        double e2 = startY + d2 * deltaY;
        double f2 = startZ + d2 * deltaZ;
        if (0.0 < d2 && d2 < traceDistanceResult[0] && minX - 1.0E-7 < e2 && e2 < maxX + 1.0E-7 && minZ - 1.0E-7 < f2 && f2 < maxZ + 1.0E-7) {
            traceDistanceResult[0] = d2;
            return resultDirection;
        }
        return approachDirection;
    }

    public double e(Vec3D pos) {
        double d2 = Math.max(Math.max(this.a - pos.c, pos.c - this.d), 0.0);
        double e2 = Math.max(Math.max(this.b - pos.d, pos.d - this.e), 0.0);
        double f2 = Math.max(Math.max(this.c - pos.e, pos.e - this.f), 0.0);
        return MathHelper.e(d2, e2, f2);
    }

    public String toString() {
        return "AABB[" + this.a + ", " + this.b + ", " + this.c + "] -> [" + this.d + ", " + this.e + ", " + this.f + "]";
    }

    public boolean e() {
        return Double.isNaN(this.a) || Double.isNaN(this.b) || Double.isNaN(this.c) || Double.isNaN(this.d) || Double.isNaN(this.e) || Double.isNaN(this.f);
    }

    public Vec3D f() {
        return new Vec3D(MathHelper.d(0.5, this.a, this.d), MathHelper.d(0.5, this.b, this.e), MathHelper.d(0.5, this.c, this.f));
    }

    public static AxisAlignedBB a(Vec3D center, double dx, double dy, double dz) {
        return new AxisAlignedBB(center.c - dx / 2.0, center.d - dy / 2.0, center.e - dz / 2.0, center.c + dx / 2.0, center.d + dy / 2.0, center.e + dz / 2.0);
    }
}

