/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import io.papermc.paper.voxel.AABBVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.DoubleListOffset;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeSlice;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class VoxelShape {
    public final VoxelShapeDiscrete a;
    @Nullable
    private VoxelShape[] b;

    public boolean intersects(AxisAlignedBB shape) {
        return VoxelShapes.c(this, new AABBVoxelShape(shape), OperatorBoolean.i);
    }

    protected VoxelShape(VoxelShapeDiscrete voxels) {
        this.a = voxels;
    }

    public double b(EnumDirection.EnumAxis axis) {
        int i2 = this.a.a(axis);
        return i2 >= this.a.c(axis) ? Double.POSITIVE_INFINITY : this.a(axis, i2);
    }

    public double c(EnumDirection.EnumAxis axis) {
        int i2 = this.a.b(axis);
        return i2 <= 0 ? Double.NEGATIVE_INFINITY : this.a(axis, i2);
    }

    public AxisAlignedBB a() {
        if (this.b()) {
            throw SystemUtils.b(new UnsupportedOperationException("No bounds for empty shape."));
        }
        return new AxisAlignedBB(this.b(EnumDirection.EnumAxis.a), this.b(EnumDirection.EnumAxis.b), this.b(EnumDirection.EnumAxis.c), this.c(EnumDirection.EnumAxis.a), this.c(EnumDirection.EnumAxis.b), this.c(EnumDirection.EnumAxis.c));
    }

    protected double a(EnumDirection.EnumAxis axis, int index) {
        return this.a(axis).getDouble(index);
    }

    protected abstract DoubleList a(EnumDirection.EnumAxis var1);

    public boolean b() {
        return this.a.a();
    }

    public VoxelShape a(double x2, double y2, double z2) {
        return this.b() ? VoxelShapes.a() : new VoxelShapeArray(this.a, (DoubleList)new DoubleListOffset(this.a(EnumDirection.EnumAxis.a), x2), (DoubleList)new DoubleListOffset(this.a(EnumDirection.EnumAxis.b), y2), (DoubleList)new DoubleListOffset(this.a(EnumDirection.EnumAxis.c), z2));
    }

    public VoxelShape c() {
        VoxelShape[] voxelShapes = new VoxelShape[]{VoxelShapes.a()};
        this.b((double minX, double minY, double minZ, double maxX, double maxY, double maxZ) -> {
            voxelShapes[0] = VoxelShapes.b(voxelShapes[0], VoxelShapes.a(minX, minY, minZ, maxX, maxY, maxZ), OperatorBoolean.o);
        });
        return voxelShapes[0];
    }

    public void a(VoxelShapes.a consumer) {
        this.a.a((int minX, int minY, int minZ, int maxX, int maxY, int maxZ) -> consumer.consume(this.a(EnumDirection.EnumAxis.a, minX), this.a(EnumDirection.EnumAxis.b, minY), this.a(EnumDirection.EnumAxis.c, minZ), this.a(EnumDirection.EnumAxis.a, maxX), this.a(EnumDirection.EnumAxis.b, maxY), this.a(EnumDirection.EnumAxis.c, maxZ)), true);
    }

    public void b(VoxelShapes.a consumer) {
        DoubleList doubleList = this.a(EnumDirection.EnumAxis.a);
        DoubleList doubleList2 = this.a(EnumDirection.EnumAxis.b);
        DoubleList doubleList3 = this.a(EnumDirection.EnumAxis.c);
        this.a.b((minX, minY, minZ, maxX, maxY, maxZ) -> consumer.consume(doubleList.getDouble(minX), doubleList2.getDouble(minY), doubleList3.getDouble(minZ), doubleList.getDouble(maxX), doubleList2.getDouble(maxY), doubleList3.getDouble(maxZ)), true);
    }

    public List<AxisAlignedBB> d() {
        ArrayList list = Lists.newArrayList();
        this.b((double x1, double y1, double z1, double x2, double y2, double z2) -> list.add(new AxisAlignedBB(x1, y1, z1, x2, y2, z2)));
        return list;
    }

    public double a(EnumDirection.EnumAxis axis, double from, double to) {
        int j2;
        EnumDirection.EnumAxis axis2 = EnumAxisCycle.b.a(axis);
        EnumDirection.EnumAxis axis3 = EnumAxisCycle.c.a(axis);
        int i2 = this.a(axis2, from);
        int k2 = this.a.a(axis, i2, j2 = this.a(axis3, to));
        return k2 >= this.a.c(axis) ? Double.POSITIVE_INFINITY : this.a(axis, k2);
    }

    public double b(EnumDirection.EnumAxis axis, double from, double to) {
        int j2;
        EnumDirection.EnumAxis axis2 = EnumAxisCycle.b.a(axis);
        EnumDirection.EnumAxis axis3 = EnumAxisCycle.c.a(axis);
        int i2 = this.a(axis2, from);
        int k2 = this.a.b(axis, i2, j2 = this.a(axis3, to));
        return k2 <= 0 ? Double.NEGATIVE_INFINITY : this.a(axis, k2);
    }

    protected int a(EnumDirection.EnumAxis axis, double coord) {
        return MathHelper.a(0, this.a.c(axis) + 1, i2 -> coord < this.a(axis, i2)) - 1;
    }

    @Nullable
    public MovingObjectPositionBlock a(Vec3D start, Vec3D end, BlockPosition pos) {
        if (this.b()) {
            return null;
        }
        Vec3D vec3 = end.d(start);
        if (vec3.g() < 1.0E-7) {
            return null;
        }
        Vec3D vec32 = start.e(vec3.a(0.001));
        return this.a.d(this.a(EnumDirection.EnumAxis.a, vec32.c - (double)pos.u()), this.a(EnumDirection.EnumAxis.b, vec32.d - (double)pos.v()), this.a(EnumDirection.EnumAxis.c, vec32.e - (double)pos.w())) ? new MovingObjectPositionBlock(vec32, EnumDirection.a(vec3.c, vec3.d, vec3.e).g(), pos, true) : AxisAlignedBB.a(this.d(), start, end, pos);
    }

    public Optional<Vec3D> a(Vec3D target) {
        if (this.b()) {
            return Optional.empty();
        }
        Vec3D[] vec3s = new Vec3D[1];
        this.b((double minX, double minY, double minZ, double maxX, double maxY, double maxZ) -> {
            double d2 = MathHelper.a(target.a(), minX, maxX);
            double e2 = MathHelper.a(target.b(), minY, maxY);
            double f2 = MathHelper.a(target.c(), minZ, maxZ);
            if (vec3s[0] == null || target.c(d2, e2, f2) < target.g(vec3s[0])) {
                vec3s[0] = new Vec3D(d2, e2, f2);
            }
        });
        return Optional.of(vec3s[0]);
    }

    public VoxelShape a(EnumDirection facing) {
        if (!this.b() && this != VoxelShapes.b()) {
            VoxelShape voxelShape2;
            if (this.b != null) {
                VoxelShape voxelShape = this.b[facing.ordinal()];
                if (voxelShape != null) {
                    return voxelShape;
                }
            } else {
                this.b = new VoxelShape[6];
            }
            this.b[facing.ordinal()] = voxelShape2 = this.b(facing);
            return voxelShape2;
        }
        return this;
    }

    protected VoxelShape b(EnumDirection direction) {
        EnumDirection.EnumAxis axis = direction.o();
        DoubleList doubleList = this.a(axis);
        if (doubleList.size() == 2 && DoubleMath.fuzzyEquals((double)doubleList.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)doubleList.getDouble(1), (double)1.0, (double)1.0E-7)) {
            return this;
        }
        EnumDirection.EnumAxisDirection axisDirection = direction.f();
        int i2 = this.a(axis, axisDirection == EnumDirection.EnumAxisDirection.a ? 0.9999999 : 1.0E-7);
        return new VoxelShapeSlice(this, axis, i2);
    }

    public double a(EnumDirection.EnumAxis axis, AxisAlignedBB box, double maxDist) {
        return this.a(EnumAxisCycle.a(axis, EnumDirection.EnumAxis.a), box, maxDist);
    }

    protected double a(EnumAxisCycle axisCycle, AxisAlignedBB box, double maxDist) {
        block11: {
            int n2;
            int l2;
            double e2;
            EnumDirection.EnumAxis axis;
            EnumAxisCycle axisCycle2;
            block10: {
                if (this.b()) {
                    return maxDist;
                }
                if (Math.abs(maxDist) < 1.0E-7) {
                    return 0.0;
                }
                axisCycle2 = axisCycle.a();
                axis = axisCycle2.a(EnumDirection.EnumAxis.a);
                EnumDirection.EnumAxis axis2 = axisCycle2.a(EnumDirection.EnumAxis.b);
                EnumDirection.EnumAxis axis3 = axisCycle2.a(EnumDirection.EnumAxis.c);
                double d2 = box.b(axis);
                e2 = box.a(axis);
                int i2 = this.a(axis, e2 + 1.0E-7);
                int j2 = this.a(axis, d2 - 1.0E-7);
                int k2 = Math.max(0, this.a(axis2, box.a(axis2) + 1.0E-7));
                l2 = Math.min(this.a.c(axis2), this.a(axis2, box.b(axis2) - 1.0E-7) + 1);
                int m2 = Math.max(0, this.a(axis3, box.a(axis3) + 1.0E-7));
                n2 = Math.min(this.a.c(axis3), this.a(axis3, box.b(axis3) - 1.0E-7) + 1);
                int o2 = this.a.c(axis);
                if (!(maxDist > 0.0)) break block10;
                for (int p2 = j2 + 1; p2 < o2; ++p2) {
                    for (int q2 = k2; q2 < l2; ++q2) {
                        for (int r2 = m2; r2 < n2; ++r2) {
                            if (!this.a.a(axisCycle2, p2, q2, r2)) continue;
                            double f2 = this.a(axis, p2) - d2;
                            if (f2 >= -1.0E-7) {
                                maxDist = Math.min(maxDist, f2);
                            }
                            return maxDist;
                        }
                    }
                }
                break block11;
            }
            if (!(maxDist < 0.0)) break block11;
            for (int s2 = i2 - 1; s2 >= 0; --s2) {
                for (int t2 = k2; t2 < l2; ++t2) {
                    for (int u2 = m2; u2 < n2; ++u2) {
                        if (!this.a.a(axisCycle2, s2, t2, u2)) continue;
                        double g2 = this.a(axis, s2 + 1) - e2;
                        if (g2 <= 1.0E-7) {
                            maxDist = Math.max(maxDist, g2);
                        }
                        return maxDist;
                    }
                }
            }
        }
        return maxDist;
    }

    public String toString() {
        return this.b() ? "EMPTY" : "VoxelShape[" + this.a() + "]";
    }
}

