/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.voxel.AABBVoxelShape;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class VoxelShapeArray
extends VoxelShape {
    private final DoubleList b;
    private final DoubleList c;
    private final DoubleList d;
    static final AxisAlignedBB[] EMPTY = new AxisAlignedBB[0];
    final AxisAlignedBB[] boundingBoxesRepresentation;
    final double offsetX;
    final double offsetY;
    final double offsetZ;

    protected VoxelShapeArray(VoxelShapeDiscrete shape, double[] xPoints, double[] yPoints, double[] zPoints) {
        this(shape, (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(xPoints, shape.b() + 1)), (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(yPoints, shape.c() + 1)), (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(zPoints, shape.d() + 1)));
    }

    VoxelShapeArray(VoxelShapeDiscrete shape, DoubleList xPoints, DoubleList yPoints, DoubleList zPoints) {
        this(shape, xPoints, yPoints, zPoints, null, 0.0, 0.0, 0.0);
    }

    VoxelShapeArray(VoxelShapeDiscrete shape, DoubleList xPoints, DoubleList yPoints, DoubleList zPoints, AxisAlignedBB[] boundingBoxesRepresentation, double offsetX, double offsetY, double offsetZ) {
        super(shape);
        int i2 = shape.b() + 1;
        int j2 = shape.c() + 1;
        int k2 = shape.d() + 1;
        if (i2 != xPoints.size() || j2 != yPoints.size() || k2 != zPoints.size()) {
            throw SystemUtils.b(new IllegalArgumentException("Lengths of point arrays must be consistent with the size of the VoxelShape."));
        }
        this.b = xPoints;
        this.c = yPoints;
        this.d = zPoints;
        this.boundingBoxesRepresentation = boundingBoxesRepresentation == null ? this.d().toArray(EMPTY) : boundingBoxesRepresentation;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    @Override
    protected DoubleList a(EnumDirection.EnumAxis axis) {
        switch (axis) {
            case a: {
                return this.b;
            }
            case b: {
                return this.c;
            }
            case c: {
                return this.d;
            }
        }
        throw new IllegalArgumentException();
    }

    public final AxisAlignedBB[] getBoundingBoxesRepresentation() {
        return this.boundingBoxesRepresentation;
    }

    public final double getOffsetX() {
        return this.offsetX;
    }

    public final double getOffsetY() {
        return this.offsetY;
    }

    public final double getOffsetZ() {
        return this.offsetZ;
    }

    @Override
    public List<AxisAlignedBB> d() {
        if (this.boundingBoxesRepresentation == null) {
            return super.d();
        }
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>(this.boundingBoxesRepresentation.length);
        double offX = this.offsetX;
        double offY = this.offsetY;
        double offZ = this.offsetZ;
        for (AxisAlignedBB boundingBox : this.boundingBoxesRepresentation) {
            ret.add(boundingBox.d(offX, offY, offZ));
        }
        return ret;
    }

    protected static DoubleArrayList getList(DoubleList from) {
        if (from instanceof DoubleArrayList) {
            return (DoubleArrayList)from;
        }
        return DoubleArrayList.wrap((double[])from.toDoubleArray());
    }

    @Override
    public VoxelShape a(double x2, double y2, double z2) {
        DoubleListOffsetExposed zPoints;
        double offsetZ;
        DoubleListOffsetExposed yPoints;
        double offsetY;
        DoubleListOffsetExposed xPoints;
        double offsetX;
        if (x2 == 0.0 && y2 == 0.0 && z2 == 0.0) {
            return this;
        }
        if (this.b instanceof DoubleListOffsetExposed) {
            offsetX = this.offsetX + x2;
            xPoints = new DoubleListOffsetExposed(((DoubleListOffsetExposed)this.b).list, offsetX);
            offsetY = this.offsetY + y2;
            yPoints = new DoubleListOffsetExposed(((DoubleListOffsetExposed)this.c).list, offsetY);
            offsetZ = this.offsetZ + z2;
            zPoints = new DoubleListOffsetExposed(((DoubleListOffsetExposed)this.d).list, offsetZ);
        } else {
            offsetX = x2;
            xPoints = new DoubleListOffsetExposed(VoxelShapeArray.getList(this.b), offsetX);
            offsetY = y2;
            yPoints = new DoubleListOffsetExposed(VoxelShapeArray.getList(this.c), offsetY);
            offsetZ = z2;
            zPoints = new DoubleListOffsetExposed(VoxelShapeArray.getList(this.d), offsetZ);
        }
        return new VoxelShapeArray(this.a, (DoubleList)xPoints, (DoubleList)yPoints, (DoubleList)zPoints, this.boundingBoxesRepresentation, offsetX, offsetY, offsetZ);
    }

    @Override
    public final boolean intersects(AxisAlignedBB axisalingedbb) {
        double offX = this.offsetX;
        double offY = this.offsetY;
        double offZ = this.offsetZ;
        for (AxisAlignedBB boundingBox : this.boundingBoxesRepresentation) {
            if (!CollisionUtil.voxelShapeIntersect(axisalingedbb, boundingBox.a + offX, boundingBox.b + offY, boundingBox.c + offZ, boundingBox.d + offX, boundingBox.e + offY, boundingBox.f + offZ)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void b(VoxelShapes.a doubleLineConsumer) {
        if (this.boundingBoxesRepresentation == null) {
            super.b(doubleLineConsumer);
            return;
        }
        for (AxisAlignedBB boundingBox : this.boundingBoxesRepresentation) {
            doubleLineConsumer.consume(boundingBox.a + this.offsetX, boundingBox.b + this.offsetY, boundingBox.c + this.offsetZ, boundingBox.d + this.offsetX, boundingBox.e + this.offsetY, boundingBox.f + this.offsetZ);
        }
    }

    @Override
    public VoxelShape c() {
        if (this == VoxelShapes.a() || this.boundingBoxesRepresentation.length == 0) {
            return this;
        }
        VoxelShape simplified = VoxelShapes.a();
        for (AxisAlignedBB boundingBox : this.boundingBoxesRepresentation) {
            simplified = VoxelShapes.b(simplified, VoxelShapes.a(boundingBox.a + this.offsetX, boundingBox.b + this.offsetY, boundingBox.c + this.offsetZ, boundingBox.d + this.offsetX, boundingBox.e + this.offsetY, boundingBox.f + this.offsetZ), OperatorBoolean.o);
        }
        if (!(simplified instanceof VoxelShapeArray)) {
            return simplified;
        }
        AxisAlignedBB[] boundingBoxesRepresentation = ((VoxelShapeArray)simplified).getBoundingBoxesRepresentation();
        if (boundingBoxesRepresentation.length == 1) {
            return new AABBVoxelShape(boundingBoxesRepresentation[0]).c();
        }
        return simplified;
    }

    public static final class DoubleListOffsetExposed
    extends AbstractDoubleList {
        public final DoubleArrayList list;
        public final double offset;

        public DoubleListOffsetExposed(DoubleArrayList list, double offset) {
            this.list = list;
            this.offset = offset;
        }

        public double getDouble(int index) {
            return this.list.getDouble(index) + this.offset;
        }

        public int size() {
            return this.list.size();
        }
    }
}

