/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.voxel.AABBVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeCube;
import net.minecraft.world.phys.shapes.VoxelShapeCubeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeCubePoint;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeMergerDisjoint;
import net.minecraft.world.phys.shapes.VoxelShapeMergerIdentical;
import net.minecraft.world.phys.shapes.VoxelShapeMergerList;
import net.minecraft.world.phys.shapes.VoxelShapeSlice;

public final class VoxelShapes {
    public static final double a = 1.0E-7;
    public static final double b = 1.0E-6;
    private static final VoxelShape d = SystemUtils.a(() -> {
        VoxelShapeBitSet discreteVoxelShape = new VoxelShapeBitSet(1, 1, 1);
        ((VoxelShapeDiscrete)discreteVoxelShape).c(0, 0, 0);
        return new VoxelShapeCube(discreteVoxelShape);
    });
    public static final VoxelShape c = VoxelShapes.a(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape e = new VoxelShapeArray((VoxelShapeDiscrete)new VoxelShapeBitSet(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));
    public static final AABBVoxelShape BLOCK_OPTIMISED = new AABBVoxelShape(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));

    public static VoxelShape getFullUnoptimisedCube() {
        return d;
    }

    public static VoxelShape a() {
        return e;
    }

    public static VoxelShape b() {
        return BLOCK_OPTIMISED;
    }

    public static VoxelShape a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(minX > maxX || minY > maxY || minZ > maxZ)) {
            return VoxelShapes.b(minX, minY, minZ, maxX, maxY, maxZ);
        }
        throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
    }

    public static VoxelShape b(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7)) {
            return new AABBVoxelShape(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        }
        return VoxelShapes.a();
    }

    public static VoxelShape a(AxisAlignedBB box) {
        return new AABBVoxelShape(box);
    }

    @VisibleForTesting
    protected static int a(double min, double max) {
        if (!(min < -1.0E-7) && !(max > 1.0000001)) {
            for (int i2 = 0; i2 <= 3; ++i2) {
                boolean bl2;
                int j2 = 1 << i2;
                double d2 = min * (double)j2;
                double e2 = max * (double)j2;
                boolean bl = Math.abs(d2 - (double)Math.round(d2)) < 1.0E-7 * (double)j2;
                boolean bl3 = bl2 = Math.abs(e2 - (double)Math.round(e2)) < 1.0E-7 * (double)j2;
                if (!bl || !bl2) continue;
                return i2;
            }
            return -1;
        }
        return -1;
    }

    protected static long a(int a2, int b2) {
        return (long)a2 * (long)(b2 / IntMath.gcd((int)a2, (int)b2));
    }

    public static VoxelShape a(VoxelShape first, VoxelShape second) {
        return VoxelShapes.a(first, second, OperatorBoolean.o);
    }

    public static VoxelShape a(VoxelShape first, VoxelShape ... others) {
        return Arrays.stream(others).reduce(first, VoxelShapes::a);
    }

    public static VoxelShape a(VoxelShape first, VoxelShape second, OperatorBoolean function) {
        return VoxelShapes.b(first, second, function).c();
    }

    public static VoxelShape b(VoxelShape one, VoxelShape two, OperatorBoolean function) {
        if (function.apply(false, false)) {
            throw SystemUtils.b(new IllegalArgumentException());
        }
        if (one == two) {
            return function.apply(true, true) ? one : VoxelShapes.a();
        }
        boolean bl = function.apply(true, false);
        boolean bl2 = function.apply(false, true);
        if (one.b()) {
            return bl2 ? two : VoxelShapes.a();
        }
        if (two.b()) {
            return bl ? one : VoxelShapes.a();
        }
        VoxelShapeMerger indexMerger = VoxelShapes.a(1, one.a(EnumDirection.EnumAxis.a), two.a(EnumDirection.EnumAxis.a), bl, bl2);
        VoxelShapeMerger indexMerger2 = VoxelShapes.a(indexMerger.size() - 1, one.a(EnumDirection.EnumAxis.b), two.a(EnumDirection.EnumAxis.b), bl, bl2);
        VoxelShapeMerger indexMerger3 = VoxelShapes.a((indexMerger.size() - 1) * (indexMerger2.size() - 1), one.a(EnumDirection.EnumAxis.c), two.a(EnumDirection.EnumAxis.c), bl, bl2);
        VoxelShapeBitSet bitSetDiscreteVoxelShape = VoxelShapeBitSet.a(one.a, two.a, indexMerger, indexMerger2, indexMerger3, function);
        return indexMerger instanceof VoxelShapeCubeMerger && indexMerger2 instanceof VoxelShapeCubeMerger && indexMerger3 instanceof VoxelShapeCubeMerger ? new VoxelShapeCube(bitSetDiscreteVoxelShape) : new VoxelShapeArray((VoxelShapeDiscrete)bitSetDiscreteVoxelShape, indexMerger.a(), indexMerger2.a(), indexMerger3.a());
    }

    public static boolean c(VoxelShape shape1, VoxelShape shape2, OperatorBoolean predicate) {
        if (predicate == OperatorBoolean.i) {
            if (shape1 instanceof AABBVoxelShape && shape2 instanceof AABBVoxelShape) {
                return CollisionUtil.voxelShapeIntersect(((AABBVoxelShape)shape1).aabb, ((AABBVoxelShape)shape2).aabb);
            }
            if (shape1 instanceof AABBVoxelShape && shape2 instanceof VoxelShapeArray) {
                return ((VoxelShapeArray)shape2).intersects(((AABBVoxelShape)shape1).aabb);
            }
            if (shape2 instanceof AABBVoxelShape && shape1 instanceof VoxelShapeArray) {
                return ((VoxelShapeArray)shape1).intersects(((AABBVoxelShape)shape2).aabb);
            }
        }
        return VoxelShapes.joinIsNotEmptyVanilla(shape1, shape2, predicate);
    }

    public static boolean joinIsNotEmptyVanilla(VoxelShape shape1, VoxelShape shape2, OperatorBoolean predicate) {
        if (predicate.apply(false, false)) {
            throw SystemUtils.b(new IllegalArgumentException());
        }
        boolean bl = shape1.b();
        boolean bl2 = shape2.b();
        if (!bl && !bl2) {
            if (shape1 == shape2) {
                return predicate.apply(true, true);
            }
            boolean bl3 = predicate.apply(true, false);
            boolean bl4 = predicate.apply(false, true);
            for (EnumDirection.EnumAxis axis : EnumAxisCycle.d) {
                if (shape1.c(axis) < shape2.b(axis) - 1.0E-7) {
                    return bl3 || bl4;
                }
                if (!(shape2.c(axis) < shape1.b(axis) - 1.0E-7)) continue;
                return bl3 || bl4;
            }
            VoxelShapeMerger indexMerger = VoxelShapes.a(1, shape1.a(EnumDirection.EnumAxis.a), shape2.a(EnumDirection.EnumAxis.a), bl3, bl4);
            VoxelShapeMerger indexMerger2 = VoxelShapes.a(indexMerger.size() - 1, shape1.a(EnumDirection.EnumAxis.b), shape2.a(EnumDirection.EnumAxis.b), bl3, bl4);
            VoxelShapeMerger indexMerger3 = VoxelShapes.a((indexMerger.size() - 1) * (indexMerger2.size() - 1), shape1.a(EnumDirection.EnumAxis.c), shape2.a(EnumDirection.EnumAxis.c), bl3, bl4);
            return VoxelShapes.a(indexMerger, indexMerger2, indexMerger3, shape1.a, shape2.a, predicate);
        }
        return predicate.apply(!bl, !bl2);
    }

    private static boolean a(VoxelShapeMerger mergedX, VoxelShapeMerger mergedY, VoxelShapeMerger mergedZ, VoxelShapeDiscrete shape1, VoxelShapeDiscrete shape2, OperatorBoolean predicate) {
        return !mergedX.a((x1, x2, index1) -> mergedY.a((y1, y2, index2) -> mergedZ.a((z1, z2, index3) -> !predicate.apply(shape1.d(x1, y1, z1), shape2.d(x2, y2, z2)))));
    }

    public static double a(EnumDirection.EnumAxis axis, AxisAlignedBB box, Iterable<VoxelShape> shapes, double maxDist) {
        for (VoxelShape voxelShape : shapes) {
            if (Math.abs(maxDist) < 1.0E-7) {
                return 0.0;
            }
            maxDist = voxelShape.a(axis, box, maxDist);
        }
        return maxDist;
    }

    public static boolean a(VoxelShape shape, VoxelShape neighbor, EnumDirection direction) {
        if (shape == VoxelShapes.b() && neighbor == VoxelShapes.b()) {
            return true;
        }
        if (neighbor.b()) {
            return false;
        }
        EnumDirection.EnumAxis axis = direction.o();
        EnumDirection.EnumAxisDirection axisDirection = direction.f();
        VoxelShape voxelShape = axisDirection == EnumDirection.EnumAxisDirection.a ? shape : neighbor;
        VoxelShape voxelShape2 = axisDirection == EnumDirection.EnumAxisDirection.a ? neighbor : shape;
        OperatorBoolean booleanOp = axisDirection == EnumDirection.EnumAxisDirection.a ? OperatorBoolean.e : OperatorBoolean.c;
        return DoubleMath.fuzzyEquals((double)voxelShape.c(axis), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)voxelShape2.b(axis), (double)0.0, (double)1.0E-7) && !VoxelShapes.c(new VoxelShapeSlice(voxelShape, axis, voxelShape.a.c(axis) - 1), new VoxelShapeSlice(voxelShape2, axis, 0), booleanOp);
    }

    public static VoxelShape a(VoxelShape shape, EnumDirection direction) {
        if (shape == d || shape == BLOCK_OPTIMISED) {
            return BLOCK_OPTIMISED;
        }
        if (shape == VoxelShapes.a()) {
            return VoxelShapes.a();
        }
        if (shape instanceof AABBVoxelShape) {
            AxisAlignedBB box = ((AABBVoxelShape)shape).aabb;
            switch (direction) {
                case e: 
                case f: {
                    boolean useEmpty = direction == EnumDirection.f ? !DoubleMath.fuzzyEquals((double)box.d, (double)1.0, (double)1.0E-7) : !DoubleMath.fuzzyEquals((double)box.a, (double)0.0, (double)1.0E-7);
                    return useEmpty ? VoxelShapes.a() : new AABBVoxelShape(new AxisAlignedBB(0.0, box.b, box.c, 1.0, box.e, box.f)).c();
                }
                case a: 
                case b: {
                    boolean useEmpty = direction == EnumDirection.b ? !DoubleMath.fuzzyEquals((double)box.e, (double)1.0, (double)1.0E-7) : !DoubleMath.fuzzyEquals((double)box.b, (double)0.0, (double)1.0E-7);
                    return useEmpty ? VoxelShapes.a() : new AABBVoxelShape(new AxisAlignedBB(box.a, 0.0, box.c, box.d, 1.0, box.f)).c();
                }
                case c: 
                case d: {
                    boolean useEmpty = direction == EnumDirection.d ? !DoubleMath.fuzzyEquals((double)box.f, (double)1.0, (double)1.0E-7) : !DoubleMath.fuzzyEquals((double)box.c, (double)0.0, (double)1.0E-7);
                    return useEmpty ? VoxelShapes.a() : new AABBVoxelShape(new AxisAlignedBB(box.a, box.b, 0.0, box.d, box.e, 1.0)).c();
                }
            }
        }
        return VoxelShapes.getFaceShapeVanilla(shape, direction);
    }

    public static VoxelShape getFaceShapeVanilla(VoxelShape shape, EnumDirection direction) {
        int i2;
        boolean bl;
        if (shape == VoxelShapes.b()) {
            return VoxelShapes.b();
        }
        EnumDirection.EnumAxis axis = direction.o();
        if (direction.f() == EnumDirection.EnumAxisDirection.a) {
            bl = DoubleMath.fuzzyEquals((double)shape.c(axis), (double)1.0, (double)1.0E-7);
            i2 = shape.a.c(axis) - 1;
        } else {
            bl = DoubleMath.fuzzyEquals((double)shape.b(axis), (double)0.0, (double)1.0E-7);
            i2 = 0;
        }
        return !bl ? VoxelShapes.a() : new VoxelShapeSlice(shape, axis, i2).c().c();
    }

    public static boolean b(VoxelShape one, VoxelShape two, EnumDirection direction) {
        if (one != VoxelShapes.b() && two != VoxelShapes.b()) {
            VoxelShape voxelShape2;
            EnumDirection.EnumAxis axis = direction.o();
            EnumDirection.EnumAxisDirection axisDirection = direction.f();
            VoxelShape voxelShape = axisDirection == EnumDirection.EnumAxisDirection.a ? one : two;
            VoxelShape voxelShape3 = voxelShape2 = axisDirection == EnumDirection.EnumAxisDirection.a ? two : one;
            if (!DoubleMath.fuzzyEquals((double)voxelShape.c(axis), (double)1.0, (double)1.0E-7)) {
                voxelShape = VoxelShapes.a();
            }
            if (!DoubleMath.fuzzyEquals((double)voxelShape2.b(axis), (double)0.0, (double)1.0E-7)) {
                voxelShape2 = VoxelShapes.a();
            }
            return !VoxelShapes.c(VoxelShapes.b(), VoxelShapes.b((VoxelShape)new VoxelShapeSlice(voxelShape, axis, voxelShape.a.c(axis) - 1), (VoxelShape)new VoxelShapeSlice(voxelShape2, axis, 0), OperatorBoolean.o), OperatorBoolean.e);
        }
        return true;
    }

    public static boolean b(VoxelShape one, VoxelShape two) {
        boolean v2Empty;
        if (one == VoxelShapes.getFullUnoptimisedCube() || one == BLOCK_OPTIMISED || two == VoxelShapes.getFullUnoptimisedCube() || two == BLOCK_OPTIMISED) {
            return true;
        }
        boolean v1Empty = one == VoxelShapes.a();
        boolean bl = v2Empty = two == VoxelShapes.a();
        if (v1Empty && v2Empty) {
            return false;
        }
        if ((one instanceof AABBVoxelShape || v1Empty) && (two instanceof AABBVoxelShape || v2Empty)) {
            if (!v1Empty && !v2Empty && one != two) {
                AxisAlignedBB boundingBox1 = ((AABBVoxelShape)one).aabb;
                AxisAlignedBB boundingBox2 = ((AABBVoxelShape)two).aabb;
                double minY = Math.min(boundingBox1.b, boundingBox2.b);
                double maxY = Math.max(boundingBox1.e, boundingBox2.e);
                if (minY > 1.0E-7 || maxY < 0.9999999) {
                    return false;
                }
                double minX = Math.min(boundingBox1.a, boundingBox2.a);
                double maxX = Math.max(boundingBox1.d, boundingBox2.d);
                if (minX > 1.0E-7 || maxX < 0.9999999) {
                    return false;
                }
                double minZ = Math.min(boundingBox1.c, boundingBox2.c);
                double maxZ = Math.max(boundingBox1.f, boundingBox2.f);
                if (minZ > 1.0E-7 || maxZ < 0.9999999) {
                    return false;
                }
            } else {
                AxisAlignedBB boundingBox = v1Empty ? ((AABBVoxelShape)two).aabb : ((AABBVoxelShape)one).aabb;
                return boundingBox.b <= 1.0E-7 && boundingBox.e >= 0.9999999 && boundingBox.a <= 1.0E-7 && boundingBox.d >= 0.9999999 && boundingBox.c <= 1.0E-7 && boundingBox.f >= 0.9999999;
            }
        }
        return VoxelShapes.faceShapeOccludesVanilla(one, two);
    }

    public static boolean faceShapeOccludesVanilla(VoxelShape one, VoxelShape two) {
        if (one != VoxelShapes.b() && two != VoxelShapes.b()) {
            if (one.b() && two.b()) {
                return false;
            }
            return !VoxelShapes.c(VoxelShapes.b(), VoxelShapes.b(one, two, OperatorBoolean.o), OperatorBoolean.e);
        }
        return true;
    }

    @VisibleForTesting
    private static VoxelShapeMerger a(int size, DoubleList first, DoubleList second, boolean includeFirst, boolean includeSecond) {
        if (first.getDouble(0) == Double.NEGATIVE_INFINITY && first.getDouble(first.size() - 1) == Double.POSITIVE_INFINITY) {
            return new VoxelShapeMergerList(first, second, includeFirst, includeSecond);
        }
        return VoxelShapes.lessCommonMerge(size, first, second, includeFirst, includeSecond);
    }

    private static VoxelShapeMerger lessCommonMerge(int size, DoubleList first, DoubleList second, boolean includeFirst, boolean includeSecond) {
        long l2;
        int i2 = first.size() - 1;
        int j2 = second.size() - 1;
        if (first instanceof VoxelShapeCubePoint && second instanceof VoxelShapeCubePoint && (long)size * (l2 = VoxelShapes.a(i2, j2)) <= 256L) {
            return new VoxelShapeCubeMerger(i2, j2);
        }
        if (i2 == j2 && Objects.equals(first, second)) {
            if (first instanceof VoxelShapeMergerIdentical) {
                return (VoxelShapeMerger)first;
            }
            if (second instanceof VoxelShapeMergerIdentical) {
                return (VoxelShapeMerger)second;
            }
            return new VoxelShapeMergerIdentical(first);
        }
        if (first.getDouble(i2) < second.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(first, second, false);
        }
        if (second.getDouble(j2) < first.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(second, first, true);
        }
        return new VoxelShapeMergerList(first, second, includeFirst, includeSecond);
    }

    public static interface a {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

