/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Preconditions;
import io.papermc.paper.world.structure.ConfiguredStructure;
import io.papermc.paper.world.structure.PaperConfiguredStructure;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.bukkit.GameEvent;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R1.CraftGameEvent;
import org.bukkit.craftbukkit.v1_20_R1.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_20_R1.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_20_R1.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_20_R1.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_20_R1.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.generator.structure.Structure;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static IRegistryCustom registry;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final IRegistry<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, M, B> minecraftToBukkit;

    public static void setMinecraftRegistry(IRegistryCustom registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static IRegistryCustom getMinecraftRegistry() {
        return registry;
    }

    public static <E> IRegistry<E> getMinecraftRegistry(ResourceKey<IRegistry<E>> key) {
        return CraftRegistry.getMinecraftRegistry().d(key);
    }

    public static <B extends Keyed> Registry<?> createRegistry(Class<B> bukkitClass, IRegistryCustom registryHolder) {
        if (bukkitClass == GameEvent.class) {
            return new CraftRegistry<CraftGameEvent, net.minecraft.world.level.gameevent.GameEvent>(registryHolder.d(Registries.z), CraftGameEvent::new);
        }
        if (bukkitClass == MusicInstrument.class) {
            return new CraftRegistry<CraftMusicInstrument, Instrument>(registryHolder.d(Registries.B), CraftMusicInstrument::new);
        }
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, net.minecraft.world.level.levelgen.structure.Structure>(registryHolder.d(Registries.az), CraftStructure::new);
        }
        if (bukkitClass == org.bukkit.generator.structure.StructureType.class) {
            return new CraftRegistry<CraftStructureType, StructureType>(BuiltInRegistries.U, CraftStructureType::new);
        }
        if (bukkitClass == org.bukkit.inventory.meta.trim.TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, TrimMaterial>(registryHolder.d(Registries.aD), CraftTrimMaterial::new);
        }
        if (bukkitClass == org.bukkit.inventory.meta.trim.TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, TrimPattern>(registryHolder.d(Registries.aE), CraftTrimPattern::new);
        }
        if (bukkitClass == ConfiguredStructure.class) {
            return new PaperConfiguredStructure.LegacyRegistry(registryHolder.d(Registries.az));
        }
        return null;
    }

    public CraftRegistry(IRegistry<M> minecraftRegistry, BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.b(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.e().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, M minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }
}

