/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.destroystokyo.paper.entity.ai.MobGoals;
import com.destroystokyo.paper.entity.ai.PaperMobGoals;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.CraftGameEventTag;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.PaperCommands;
import io.papermc.paper.commands.FeedbackForwardingSender;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.datapack.PaperDatapackManager;
import io.papermc.paper.logging.SysoutCatcher;
import io.papermc.paper.math.Position;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.entrypoint.Entrypoint;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.FallbackRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.FoliaAsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.management.MBeanServer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeRepair;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.conversations.Conversable;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_20_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R1.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_20_R1.ban.CraftIpBanList;
import org.bukkit.craftbukkit.v1_20_R1.ban.CraftProfileBanList;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_20_R1.boss.CraftKeyedBossbar;
import org.bukkit.craftbukkit.v1_20_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R1.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_20_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_20_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_20_R1.generator.OldCraftChunkData;
import org.bukkit.craftbukkit.v1_20_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.RecipeIterator;
import org.bukkit.craftbukkit.v1_20_R1.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_20_R1.map.CraftMapColorCache;
import org.bukkit.craftbukkit.v1_20_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_20_R1.metadata.EntityMetadataStore;
import org.bukkit.craftbukkit.v1_20_R1.metadata.PlayerMetadataStore;
import org.bukkit.craftbukkit.v1_20_R1.metadata.WorldMetadataStore;
import org.bukkit.craftbukkit.v1_20_R1.packs.CraftDataPackManager;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionBrewer;
import org.bukkit.craftbukkit.v1_20_R1.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_20_R1.scheduler.CraftScheduler;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_20_R1.structure.CraftStructureManager;
import org.bukkit.craftbukkit.v1_20_R1.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_20_R1.tag.CraftEntityTag;
import org.bukkit.craftbukkit.v1_20_R1.tag.CraftFluidTag;
import org.bukkit.craftbukkit.v1_20_R1.tag.CraftItemTag;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftIconCache;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_20_R1.util.DatFileFilter;
import org.bukkit.craftbukkit.v1_20_R1.util.Versioning;
import org.bukkit.craftbukkit.v1_20_R1.util.permissions.CraftDefaultPermissions;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;
import org.bukkit.packs.DataPackManager;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.StringUtil;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.permissions.DefaultPermissions;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.RestartCommand;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public final class CraftServer
implements Server {
    private final String serverName = "Paper";
    private final String serverVersion;
    private final String bukkitVersion = Versioning.getBukkitVersion();
    private final Logger logger = Logger.getLogger("Minecraft");
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final CraftScheduler scheduler = new CraftScheduler();
    private final CraftCommandMap commandMap = new CraftCommandMap(this);
    private final SimpleHelpMap helpMap = new SimpleHelpMap(this);
    private final StandardMessenger messenger = new StandardMessenger();
    private final SimplePluginManager pluginManager = new SimplePluginManager((Server)this, (SimpleCommandMap)this.commandMap);
    public final PaperPluginManagerImpl paperPluginManager = new PaperPluginManagerImpl(this, (CommandMap)this.commandMap, this.pluginManager);
    private final StructureManager structureManager;
    protected final DedicatedServer console;
    protected final DedicatedPlayerList playerList;
    private final Map<String, World> worlds;
    private final Map<Class<?>, Registry<?>> registries;
    private YamlConfiguration configuration;
    private YamlConfiguration commandsConfiguration;
    private final Yaml yaml;
    private final Map<UUID, OfflinePlayer> offlinePlayers;
    private final EntityMetadataStore entityMetadata;
    private final PlayerMetadataStore playerMetadata;
    private final WorldMetadataStore worldMetadata;
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit;
    private File container;
    private Warning.WarningState warningState;
    public String minimumAPI;
    public CraftScoreboardManager scoreboardManager;
    public CraftDataPackManager dataPackManager;
    public boolean playerCommandState;
    private boolean printSaveWarning;
    private CraftIconCache icon;
    private boolean overrideAllCommandBlockCommands;
    public boolean ignoreVanillaPermissions;
    private final List<CraftPlayer> playerView;
    public int reloadCount;
    private final PaperDatapackManager datapackManager;
    public static Exception excessiveVelEx;
    private final SysoutCatcher sysoutCatcher;
    private final CraftPotionBrewer potionBrewer;
    private final FallbackRegionScheduler regionizedScheduler;
    private final FoliaAsyncScheduler asyncScheduler;
    private final FoliaGlobalRegionScheduler globalRegionScheduler;
    private static final List<ChunkStatus> VANILLA_GEN_STATUSES;
    private final Server.Spigot spigot;
    private Iterable<? extends Audience> adventure$audiences;
    private MobGoals mobGoals;

    public final RegionScheduler getRegionScheduler() {
        return this.regionizedScheduler;
    }

    public final AsyncScheduler getAsyncScheduler() {
        return this.asyncScheduler;
    }

    public final FoliaGlobalRegionScheduler getGlobalRegionScheduler() {
        return this.globalRegionScheduler;
    }

    public final boolean isOwnedByCurrentRegion(World world, Position position) {
        return TickThread.isTickThreadFor(((CraftWorld)world).getHandle(), position.blockX() >> 4, position.blockZ() >> 4);
    }

    public final boolean isOwnedByCurrentRegion(World world, Position position, int squareRadiusChunks) {
        return TickThread.isTickThreadFor(((CraftWorld)world).getHandle(), position.blockX() >> 4, position.blockZ() >> 4, squareRadiusChunks);
    }

    public final boolean isOwnedByCurrentRegion(Location location) {
        World world = location.getWorld();
        return TickThread.isTickThreadFor(((CraftWorld)world).getHandle(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public final boolean isOwnedByCurrentRegion(Location location, int squareRadiusChunks) {
        World world = location.getWorld();
        return TickThread.isTickThreadFor(((CraftWorld)world).getHandle(), location.getBlockX() >> 4, location.getBlockZ() >> 4, squareRadiusChunks);
    }

    public final boolean isOwnedByCurrentRegion(World world, int chunkX, int chunkZ) {
        return TickThread.isTickThreadFor(((CraftWorld)world).getHandle(), chunkX, chunkZ);
    }

    public final boolean isOwnedByCurrentRegion(World world, int chunkX, int chunkZ, int squareRadiusChunks) {
        return TickThread.isTickThreadFor(((CraftWorld)world).getHandle(), chunkX, chunkZ, squareRadiusChunks);
    }

    public final boolean isOwnedByCurrentRegion(Entity entity) {
        return TickThread.isTickThreadFor(((CraftEntity)entity).getHandleRaw());
    }

    public CraftServer(DedicatedServer console, PlayerList playerList) {
        this.pluginManager.paperPluginManager = this.paperPluginManager;
        this.worlds = new LinkedHashMap<String, World>();
        this.registries = new HashMap();
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        this.offlinePlayers = new MapMaker().weakValues().makeMap();
        this.entityMetadata = new EntityMetadataStore();
        this.playerMetadata = new PlayerMetadataStore();
        this.worldMetadata = new WorldMetadataStore();
        this.spawnCategoryLimit = new Object2IntOpenHashMap();
        this.warningState = Warning.WarningState.DEFAULT;
        this.overrideAllCommandBlockCommands = false;
        this.ignoreVanillaPermissions = false;
        this.sysoutCatcher = new SysoutCatcher();
        this.potionBrewer = new CraftPotionBrewer();
        this.regionizedScheduler = new FallbackRegionScheduler();
        this.asyncScheduler = new FoliaAsyncScheduler();
        this.globalRegionScheduler = new FoliaGlobalRegionScheduler();
        this.spigot = new Server.Spigot(){

            @Deprecated
            public YamlConfiguration getConfig() {
                return SpigotConfig.config;
            }

            public YamlConfiguration getBukkitConfig() {
                return CraftServer.this.configuration;
            }

            public YamlConfiguration getSpigotConfig() {
                return SpigotConfig.config;
            }

            public YamlConfiguration getPaperConfig() {
                return CraftServer.this.console.paperConfigurations.createLegacyObject(CraftServer.this.console);
            }

            public void restart() {
                RestartCommand.restart();
            }

            public void broadcast(BaseComponent component) {
                for (Player player : CraftServer.this.getOnlinePlayers()) {
                    player.spigot().sendMessage(component);
                }
            }

            public void broadcast(BaseComponent ... components) {
                for (Player player : CraftServer.this.getOnlinePlayers()) {
                    player.spigot().sendMessage(components);
                }
            }
        };
        this.mobGoals = new PaperMobGoals();
        this.console = console;
        this.playerList = (DedicatedPlayerList)playerList;
        this.playerView = Collections.unmodifiableList(Lists.transform(playerList.k, (Function)new Function<EntityPlayer, CraftPlayer>(){

            public CraftPlayer apply(EntityPlayer player) {
                return player.getBukkitEntity();
            }
        }));
        this.serverVersion = CraftServer.class.getPackage().getImplementationVersion();
        this.structureManager = new CraftStructureManager(console.aT());
        this.dataPackManager = new CraftDataPackManager(this.getServer().aB());
        Bukkit.setServer((Server)this);
        CraftRegistry.setMinecraftRegistry(console.aV());
        Enchantments.n.getClass();
        Enchantment.stopAcceptingRegistrations();
        Potion.setPotionBrewer((PotionBrewer)this.potionBrewer);
        MobEffects.o.getClass();
        PotionEffectType.stopAcceptingRegistrations();
        if (!Main.useConsole) {
            this.getLogger().info("Console input is disabled due to --noconsole command argument");
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        this.configuration.options().copyDefaults(true);
        this.configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
        ConfigurationSection legacyAlias = null;
        if (!this.configuration.isString("aliases")) {
            legacyAlias = this.configuration.getConfigurationSection("aliases");
            this.configuration.set("aliases", (Object)"now-in-commands.yml");
        }
        this.saveConfig();
        if (this.getCommandsConfigFile().isFile()) {
            legacyAlias = null;
        }
        this.commandsConfiguration = YamlConfiguration.loadConfiguration((File)this.getCommandsConfigFile());
        this.commandsConfiguration.options().copyDefaults(true);
        YamlConfiguration commandsDefaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/commands.yml"), Charsets.UTF_8));
        if (this.commandsConfiguration.contains("aliases")) {
            commandsDefaults.set("aliases", null);
        }
        this.commandsConfiguration.setDefaults((Configuration)commandsDefaults);
        this.saveCommandsConfig();
        if (legacyAlias != null) {
            ConfigurationSection aliases = this.commandsConfiguration.createSection("aliases");
            for (String key : legacyAlias.getKeys(false)) {
                ArrayList<CallSite> commands = new ArrayList<CallSite>();
                if (legacyAlias.isList(key)) {
                    for (String command : legacyAlias.getStringList(key)) {
                        commands.add((CallSite)((Object)(command + " $1-")));
                    }
                } else {
                    commands.add((CallSite)((Object)(legacyAlias.getString(key) + " $1-")));
                }
                aliases.set(key, commands);
            }
        }
        this.saveCommandsConfig();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        this.overrideSpawnLimits();
        console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.warningState = Warning.WarningState.value((String)this.configuration.getString("settings.deprecated-verbose"));
        TicketType.PLUGIN.k = Math.min(20, this.configuration.getInt("chunk-gc.period-in-ticks"));
        this.minimumAPI = this.configuration.getString("settings.minimum-api");
        this.loadIcon();
        if (this.configuration.getBoolean("settings.use-map-color-cache")) {
            MapPalette.setMapColorCache((MapPalette.MapColorCache)new CraftMapColorCache(this.logger));
        }
        this.datapackManager = new PaperDatapackManager(console.aB());
    }

    public boolean getCommandBlockOverride(String command) {
        return this.overrideAllCommandBlockCommands || this.commandsConfiguration.getStringList("command-block-overrides").contains(command);
    }

    private File getConfigFile() {
        return (File)this.console.options.valueOf("bukkit-settings");
    }

    private File getCommandsConfigFile() {
        return (File)this.console.options.valueOf("commands-settings");
    }

    private void overrideSpawnLimits() {
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.spawnCategoryLimit.put((Object)spawnCategory, this.configuration.getInt(CraftSpawnCategory.getConfigNameSpawnLimit(spawnCategory)));
        }
    }

    private void saveConfig() {
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getConfigFile(), ex);
        }
    }

    private void saveCommandsConfig() {
        try {
            this.commandsConfiguration.save(this.getCommandsConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getCommandsConfigFile(), ex);
        }
    }

    public void loadPlugins() {
        LaunchEntryPointHandler.INSTANCE.enter(Entrypoint.PLUGIN);
    }

    public File getPluginsFolder() {
        return (File)this.console.options.valueOf("plugins");
    }

    private List<File> extraPluginJars() {
        List jars = this.console.options.valuesOf("add-plugin");
        ArrayList<File> list = new ArrayList<File>();
        for (File file : jars) {
            if (!file.exists()) {
                MinecraftServer.n.warn("File '{}' specified through 'add-plugin' argument does not exist, cannot load a plugin from it!", (Object)file.getAbsolutePath());
                continue;
            }
            if (!file.isFile()) {
                MinecraftServer.n.warn("File '{}' specified through 'add-plugin' argument is not a file, cannot load a plugin from it!", (Object)file.getAbsolutePath());
                continue;
            }
            if (!file.getName().endsWith(".jar")) {
                MinecraftServer.n.warn("File '{}' specified through 'add-plugin' argument is not a jar file, cannot load a plugin from it!", (Object)file.getAbsolutePath());
                continue;
            }
            list.add(file);
        }
        return list;
    }

    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        if (type == PluginLoadOrder.STARTUP) {
            this.helpMap.clear();
            this.helpMap.initializeGeneralTopics();
            if (GlobalConfiguration.get().misc.loadPermissionsYmlBeforePlugins) {
                this.loadCustomPermissions();
            }
        }
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.enablePlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.setVanillaCommands(true);
            this.commandMap.setFallbackCommands();
            this.setVanillaCommands(false);
            this.commandMap.registerServerAliases();
            DefaultPermissions.registerCorePermissions();
            CraftDefaultPermissions.registerCorePermissions();
            if (!GlobalConfiguration.get().misc.loadPermissionsYmlBeforePlugins) {
                this.loadCustomPermissions();
            }
            this.helpMap.initializeCommands();
            this.syncCommands();
        }
    }

    public void disablePlugins() {
        this.pluginManager.disablePlugins();
    }

    private void setVanillaCommands(boolean first) {
        CommandDispatcher dispatcher = this.console.vanillaCommandDispatcher;
        for (CommandNode cmd : dispatcher.a().getRoot().getChildren()) {
            VanillaCommandWrapper wrapper = new VanillaCommandWrapper(dispatcher, cmd);
            if (SpigotConfig.replaceCommands.contains(wrapper.getName())) {
                if (!first) continue;
                this.commandMap.register("minecraft", (Command)wrapper);
                continue;
            }
            if (first) continue;
            this.commandMap.register("minecraft", (Command)wrapper);
        }
    }

    public void syncCommands() {
        CommandDispatcher dispatcher = this.console.au.b().d = new CommandDispatcher();
        for (Map.Entry<String, Command> entry : this.commandMap.getKnownCommands().entrySet()) {
            String label = entry.getKey();
            Command command = entry.getValue();
            if (command instanceof VanillaCommandWrapper) {
                LiteralCommandNode node = (LiteralCommandNode)((VanillaCommandWrapper)command).vanillaCommand;
                if (!node.getLiteral().equals(label)) {
                    LiteralCommandNode clone = new LiteralCommandNode(label, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
                    for (CommandNode child : node.getChildren()) {
                        clone.addChild(child);
                    }
                    node = clone;
                }
                dispatcher.vanillaCommandNodes.add((CommandNode<CommandListenerWrapper>)node);
                dispatcher.a().getRoot().addChild((CommandNode)node);
                continue;
            }
            new BukkitCommandWrapper(this, entry.getValue()).register(dispatcher.a(), label);
        }
        for (EntityPlayer player : this.getHandle().k) {
            dispatcher.a(player);
        }
    }

    private void enablePlugin(Plugin plugin) {
        try {
            List perms = plugin.getDescription().getPermissions();
            ArrayList<Permission> permsToLoad = new ArrayList<Permission>();
            for (Permission perm : perms) {
                if (this.paperPluginManager.getPermission(perm.getName()) == null) {
                    permsToLoad.add(perm);
                    continue;
                }
                this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered");
            }
            this.paperPluginManager.addPermissions(permsToLoad);
            this.pluginManager.enablePlugin(plugin);
        }
        catch (Throwable ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " loading " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
    }

    public String getName() {
        return this.serverName;
    }

    public String getVersion() {
        return this.serverVersion + " (MC: " + this.console.G() + ")";
    }

    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public String getMinecraftVersion() {
        return this.console.G();
    }

    public List<CraftPlayer> getOnlinePlayers() {
        return this.playerView;
    }

    @Deprecated
    public Player getPlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Player found = this.getPlayerExact(name);
        if (found != null) {
            return found;
        }
        String lowerName = name.toLowerCase(Locale.ENGLISH);
        int delta = Integer.MAX_VALUE;
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getName().toLowerCase(Locale.ENGLISH).startsWith(lowerName)) continue;
            int curDelta = Math.abs(player.getName().length() - lowerName.length());
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    @Deprecated
    public Player getPlayerExact(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        EntityPlayer player = this.playerList.a(name);
        return player != null ? player.getBukkitEntity() : null;
    }

    public Player getPlayer(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        EntityPlayer player = this.playerList.a(id);
        if (player != null) {
            return player.getBukkitEntity();
        }
        return null;
    }

    @Deprecated
    public int broadcastMessage(String message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    @Deprecated
    public List<Player> matchPlayer(String partialName) {
        Preconditions.checkArgument((partialName != null ? 1 : 0) != 0, (Object)"partialName cannot be null");
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : this.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(partialName.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public int getMaxPlayers() {
        return this.playerList.n();
    }

    public void setMaxPlayers(int maxPlayers) {
        Preconditions.checkArgument((maxPlayers >= 0 ? 1 : 0) != 0, (Object)"maxPlayers must be >= 0");
        this.playerList.g = maxPlayers;
    }

    public int getPort() {
        return this.getServer().M();
    }

    public int getViewDistance() {
        return this.getProperties().F;
    }

    public int getSimulationDistance() {
        return this.getProperties().G;
    }

    public String getIp() {
        return this.getServer().u();
    }

    public String getWorldType() {
        return this.getProperties().Y.getProperty("level-type");
    }

    public boolean getGenerateStructures() {
        return this.getServer().aU().A().c();
    }

    public int getMaxWorldSize() {
        return this.getProperties().L;
    }

    public boolean getAllowEnd() {
        return this.configuration.getBoolean("settings.allow-end");
    }

    public boolean getAllowNether() {
        return this.getServer().B();
    }

    public boolean getWarnOnOverload() {
        return this.configuration.getBoolean("settings.warn-on-overload");
    }

    public boolean getQueryPlugins() {
        return this.configuration.getBoolean("settings.query-plugins");
    }

    public List<String> getInitialEnabledPacks() {
        return Collections.unmodifiableList(this.getProperties().T.a());
    }

    public List<String> getInitialDisabledPacks() {
        return Collections.unmodifiableList(this.getProperties().T.b());
    }

    public DataPackManager getDataPackManager() {
        return this.dataPackManager;
    }

    public String getResourcePack() {
        return this.getServer().S().map(MinecraftServer.ServerResourcePackInfo::a).orElse("");
    }

    public String getResourcePackHash() {
        return this.getServer().S().map(MinecraftServer.ServerResourcePackInfo::b).orElse("").toUpperCase(Locale.ROOT);
    }

    public String getResourcePackPrompt() {
        return this.getServer().S().map(MinecraftServer.ServerResourcePackInfo::d).map(CraftChatMessage::fromComponent).orElse("");
    }

    public boolean isResourcePackRequired() {
        return this.getServer().T();
    }

    public boolean hasWhitelist() {
        return this.getProperties().V.get();
    }

    private DedicatedServerProperties getProperties() {
        return this.console.a();
    }

    public String getUpdateFolder() {
        return this.configuration.getString("settings.update-folder", "update");
    }

    public File getUpdateFolderFile() {
        return new File((File)this.console.options.valueOf("plugins"), this.configuration.getString("settings.update-folder", "update"));
    }

    public long getConnectionThrottle() {
        if (SpigotConfig.bungee || GlobalConfiguration.get().proxies.velocity.enabled) {
            return -1L;
        }
        return this.configuration.getInt("settings.connection-throttle");
    }

    @Deprecated
    public int getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public int getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Deprecated
    public int getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public int getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public int getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public int getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    public int getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.configuration.getInt(CraftSpawnCategory.getConfigNameTicksPerSpawn(spawnCategory));
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CraftScheduler getScheduler() {
        return this.scheduler;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds.values());
    }

    public boolean isTickingWorlds() {
        return this.console.isIteratingOverLevels;
    }

    public DedicatedPlayerList getHandle() {
        return this.playerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchServerCommand(CommandSender sender, ServerCommand serverCommand) {
        Conversable conversable2;
        if (sender instanceof Conversable && (conversable2 = (Conversable)sender).isConversing()) {
            conversable2.acceptConversationInput(serverCommand.a);
            return true;
        }
        try {
            this.playerCommandState = true;
            boolean conversable2 = this.dispatchCommand(sender, serverCommand.a);
            return conversable2;
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Unexpected exception while parsing console command \"" + serverCommand.a + "\"", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.playerCommandState = false;
        }
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"sender cannot be null");
        Preconditions.checkArgument((commandLine != null ? 1 : 0) != 0, (Object)"commandLine cannot be null");
        AsyncCatcher.catchOp("Command Dispatched Async: " + commandLine);
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        if (!SpigotConfig.unknownCommandMessage.isEmpty()) {
            UnknownCommandEvent event = new UnknownCommandEvent(sender, commandLine, (Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.unknownCommandMessage));
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.message() != null) {
                sender.sendMessage(event.message());
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void reload() {
        void var3_8;
        WatchdogThread.hasStarted = false;
        ++this.reloadCount;
        this.configuration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        this.commandsConfiguration = YamlConfiguration.loadConfiguration((File)this.getCommandsConfigFile());
        this.console.u = new DedicatedServerSettings(this.console.options);
        DedicatedServerProperties config = this.console.u.a();
        this.console.f(config.f);
        this.console.g(config.g);
        this.console.d(config.h);
        this.overrideSpawnLimits();
        this.warningState = Warning.WarningState.value((String)this.configuration.getString("settings.deprecated-verbose"));
        TicketType.PLUGIN.k = Math.min(20, this.configuration.getInt("chunk-gc.period-in-ticks"));
        this.minimumAPI = this.configuration.getString("settings.minimum-api");
        this.printSaveWarning = false;
        this.console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.loadIcon();
        try {
            this.playerList.g().f();
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to load banned-ips.json, " + ex.getMessage());
        }
        try {
            this.playerList.f().f();
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Failed to load banned-players.json, " + ex.getMessage());
        }
        SpigotConfig.init((File)this.console.options.valueOf("spigot-settings"));
        this.console.paperConfigurations.reloadConfigs(this.console);
        for (WorldServer worldServer : this.console.F()) {
            worldServer.b(worldServer.K.s() != EnumDifficulty.a && config.w, config.d);
            SpawnCategory[] interruptedException = SpawnCategory.values();
            int n2 = interruptedException.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                SpawnCategory spawnCategory = interruptedException[i2];
                if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
                long ticksPerCategorySpawn = this.getTicksPerSpawns(spawnCategory);
                if (ticksPerCategorySpawn < 0L) {
                    worldServer.ticksPerSpawnCategory.put((Object)spawnCategory, CraftSpawnCategory.getDefaultTicksPerSpawn(spawnCategory));
                    continue;
                }
                worldServer.ticksPerSpawnCategory.put((Object)spawnCategory, ticksPerCategorySpawn);
            }
            worldServer.spigotConfig.init();
        }
        Plugin[] pluginClone = (Plugin[])this.pluginManager.getPlugins().clone();
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        for (Plugin plugin : pluginClone) {
            this.entityMetadata.removeAll(plugin);
            this.worldMetadata.removeAll(plugin);
            this.playerMetadata.removeAll(plugin);
        }
        this.reloadData();
        SpigotConfig.registerCommands();
        PaperCommands.registerCommands(this.console);
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        boolean bl = false;
        while (var3_8 < 50 && this.getScheduler().getActiveWorkers().size() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++var3_8;
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            this.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), "This plugin is not properly shutting down its async tasks when it is being reloaded.  This may cause conflicts with the newly loaded version of the plugin"));
            if (!this.console.isDebugging()) continue;
            TraceUtil.dumpTraceForThread(worker.getThread(), "still running");
        }
        PluginInitializerManager.reload(this.console);
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.RELOAD));
        WatchdogThread.hasStarted = true;
    }

    public void waitForAsyncTasksShutdown() {
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            this.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getPluginMeta().getAuthors(), plugin.getPluginMeta().getDisplayName(), "This plugin is not properly shutting down its async tasks when it is being shut down. This task may throw errors during the final shutdown logs and might not complete before process dies."));
        }
    }

    public void reloadData() {
        CommandReload.reload(this.console);
    }

    public void updateResources() {
        this.playerList.u();
    }

    public void updateRecipes() {
        this.playerList.reloadRecipeData();
    }

    private void loadIcon() {
        this.icon = new CraftIconCache(null);
        try {
            File file = new File(new File("."), "server-icon.png");
            if (file.isFile()) {
                this.icon = CraftServer.loadServerIcon0(file);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Couldn't load server icon", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomPermissions() {
        Map perms;
        FileInputStream stream;
        File file = new File(this.configuration.getString("settings.permissions-file"));
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            try {
                file.createNewFile();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            perms = (Map)this.yaml.load((InputStream)stream);
        }
        catch (MarkedYAMLException ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML: " + ex.toString());
            return;
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML.", ex);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (perms == null) {
            this.getLogger().log(Level.INFO, "Server permissions file " + file + " is empty, ignoring it");
            return;
        }
        List permsList = Permission.loadPermissions((Map)perms, (String)("Permission node '%s' in " + file + " is invalid"), (PermissionDefault)Permission.DEFAULT_PERMISSION);
        for (Permission perm : permsList) {
            try {
                this.pluginManager.addPermission(perm);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().log(Level.SEVERE, "Permission in " + file + " was already defined", ex);
            }
        }
    }

    public String toString() {
        return "CraftServer{serverName=" + this.serverName + ",serverVersion=" + this.serverVersion + ",minecraftVersion=" + this.console.G() + "}";
    }

    public World createWorld(String name, World.Environment environment) {
        return WorldCreator.name((String)name).environment(environment).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).createWorld();
    }

    public World createWorld(String name, World.Environment environment, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).generator(generator).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).generator(generator).createWorld();
    }

    public World createWorld(WorldCreator creator) {
        String levelName;
        WorldDataServer worlddata;
        Convertable.ConversionSession worldSession;
        Preconditions.checkState((boolean)this.console.F().iterator().hasNext(), (Object)"Cannot create additional worlds on STARTUP");
        Preconditions.checkArgument((creator != null ? 1 : 0) != 0, (Object)"WorldCreator cannot be null");
        String name = creator.name();
        ChunkGenerator generator = creator.generator();
        BiomeProvider biomeProvider = creator.biomeProvider();
        File folder = new File(this.getWorldContainer(), name);
        World world = this.getWorld(name);
        World worldByKey = this.getWorld(creator.key());
        if (world != null || worldByKey != null) {
            if (world == worldByKey) {
                return world;
            }
            throw new IllegalArgumentException("Cannot create a world with key " + creator.key() + " and name " + name + " one (or both) already match a world that exists");
        }
        if (folder.exists()) {
            Preconditions.checkArgument((boolean)folder.isDirectory(), (String)"File (%s) exists and isn't a folder", (Object)name);
        }
        if (generator == null) {
            generator = this.getGenerator(name);
        }
        if (biomeProvider == null) {
            biomeProvider = this.getBiomeProvider(name);
        }
        ResourceKey<WorldDimension> actualDimension = switch (creator.environment()) {
            case World.Environment.NORMAL -> WorldDimension.b;
            case World.Environment.NETHER -> WorldDimension.c;
            case World.Environment.THE_END -> WorldDimension.d;
            default -> throw new IllegalArgumentException("Illegal dimension (" + creator.environment() + ")");
        };
        try {
            worldSession = Convertable.b(this.getWorldContainer().toPath()).validateAndCreateAccess(name, actualDimension);
        }
        catch (IOException | ContentValidationException ex) {
            throw new RuntimeException(ex);
        }
        boolean hardcore = creator.hardcore();
        WorldLoader.a worldloader_a = this.console.worldLoader;
        IRegistry<WorldDimension> iregistry = worldloader_a.d().d(Registries.aI);
        RegistryOps<NBTBase> dynamicops = RegistryOps.a(DynamicOpsNBT.a, worldloader_a.c());
        Pair<SaveData, WorldDimensions.b> pair = worldSession.a(dynamicops, worldloader_a.b(), iregistry, worldloader_a.c().d());
        if (pair != null) {
            worlddata = (WorldDataServer)pair.getFirst();
            iregistry = ((WorldDimensions.b)pair.getSecond()).c();
        } else {
            WorldOptions worldoptions = new WorldOptions(creator.seed(), creator.generateStructures(), false);
            DedicatedServerProperties.WorldDimensionData properties = new DedicatedServerProperties.WorldDimensionData(ChatDeserializer.a(creator.generatorSettings().isEmpty() ? "{}" : creator.generatorSettings()), creator.type().name().toLowerCase(Locale.ROOT));
            WorldSettings worldsettings = new WorldSettings(name, EnumGamemode.a(this.getDefaultGameMode().getValue()), hardcore, EnumDifficulty.b, false, new GameRules(), worldloader_a.b());
            WorldDimensions worlddimensions = properties.a(worldloader_a.c());
            WorldDimensions.b worlddimensions_b = worlddimensions.a(iregistry);
            Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
            worlddata = new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            iregistry = worlddimensions_b.c();
        }
        worlddata.customDimensions = iregistry;
        worlddata.checkName(name);
        worlddata.a(this.console.getServerModName(), this.console.K().a());
        long j2 = BiomeManager.a(worlddata.A().b());
        ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(worlddata));
        WorldDimension worlddimension = iregistry.a(actualDimension);
        CraftWorldInfo worldInfo = new CraftWorldInfo(worlddata, worldSession, creator.environment(), worlddimension.a().a(), worlddimension.b(), this.getHandle().b().aV());
        if (biomeProvider == null && generator != null) {
            biomeProvider = generator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        if (this.console.options.has("forceUpgrade")) {
            net.minecraft.server.Main.convertWorldButItWorks(actualDimension, worldSession, DataConverterRegistry.a(), worlddimension.b().b(), this.console.options.has("eraseCache"));
        }
        ResourceKey<net.minecraft.world.level.World> worldKey = name.equals((levelName = this.getServer().a().m) + "_nether") ? net.minecraft.world.level.World.i : (name.equals(levelName + "_the_end") ? net.minecraft.world.level.World.j : ResourceKey.a(Registries.aH, new MinecraftKey(creator.key().getNamespace().toLowerCase(Locale.ENGLISH), creator.key().getKey().toLowerCase(Locale.ENGLISH))));
        WorldServer internal = new WorldServer(this.console, this.console.as, worldSession, worlddata, worldKey, worlddimension, this.getServer().H.create(11), worlddata.C(), j2, (List<MobSpawner>)(creator.environment() == World.Environment.NORMAL ? list : ImmutableList.of()), true, this.console.D().H(), creator.environment(), generator, biomeProvider);
        if (!this.worlds.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return null;
        }
        this.console.addLevel(internal);
        this.console.initWorld(internal, worlddata, worlddata, worlddata.A());
        internal.b(true, true);
        internal.keepSpawnInMemory = creator.keepSpawnLoaded().toBooleanOrElse(internal.getWorld().getKeepSpawnInMemory());
        this.getServer().prepareLevels(internal.k().a.D, internal);
        this.pluginManager.callEvent((Event)new WorldLoadEvent((World)internal.getWorld()));
        return internal.getWorld();
    }

    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        WorldServer handle = ((CraftWorld)world).getHandle();
        if (this.console.a(handle.ac()) == null) {
            return false;
        }
        if (handle.ac() == net.minecraft.world.level.World.h) {
            return false;
        }
        if (handle.v().size() > 0) {
            return false;
        }
        WorldUnloadEvent e2 = new WorldUnloadEvent((World)handle.getWorld());
        this.pluginManager.callEvent((Event)e2);
        if (e2.isCancelled()) {
            return false;
        }
        try {
            if (save) {
                handle.a(null, true, false);
            }
            handle.k().close(save);
            handle.convertable.close();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.worlds.remove(world.getName().toLowerCase(Locale.ENGLISH));
        this.console.removeLevel(handle);
        return true;
    }

    public DedicatedServer getServer() {
        return this.console;
    }

    public World getWorld(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        return this.worlds.get(name.toLowerCase(Locale.ENGLISH));
    }

    public World getWorld(UUID uid) {
        for (World world : this.worlds.values()) {
            if (!world.getUID().equals(uid)) continue;
            return world;
        }
        return null;
    }

    public World getWorld(NamespacedKey worldKey) {
        WorldServer worldServer = this.console.a(ResourceKey.a(Registries.aH, CraftNamespacedKey.toMinecraft(worldKey)));
        if (worldServer == null) {
            return null;
        }
        return worldServer.getWorld();
    }

    public void addWorld(World world) {
        if (this.getWorld(world.getUID()) != null) {
            System.out.println("World " + world.getName() + " is a duplicate of another world and has been prevented from loading. Please delete the uid.dat file from " + world.getName() + "'s world directory if you want to be able to load the duplicate world.");
            return;
        }
        this.worlds.put(world.getName().toLowerCase(Locale.ENGLISH), world);
    }

    public WorldBorder createWorldBorder() {
        return new CraftWorldBorder(new net.minecraft.world.level.border.WorldBorder());
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PluginCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        if (command instanceof PluginCommand) {
            return (PluginCommand)command;
        }
        return null;
    }

    public void savePlayers() {
        this.checkSaveState();
        this.playerList.h();
    }

    public boolean addRecipe(Recipe recipe) {
        return this.addRecipe(recipe, false);
    }

    public boolean addRecipe(Recipe recipe, boolean resendRecipes) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            toAdd = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)recipe);
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)recipe);
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)recipe);
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)recipe);
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)recipe);
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)recipe);
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)recipe);
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)recipe);
        } else {
            if (recipe instanceof ComplexRecipe) {
                throw new UnsupportedOperationException("Cannot add custom complex recipe");
            }
            return false;
        }
        toAdd.addToCraftingManager();
        if (resendRecipes) {
            this.playerList.reloadRecipeData();
        }
        return true;
    }

    public List<Recipe> getRecipesFor(ItemStack result) {
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator<Recipe> iter = this.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = iter.next();
            ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    public Recipe getRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"NamespacedKey recipeKey cannot be null");
        return this.getServer().aE().a(CraftNamespacedKey.toMinecraft(recipeKey)).map(IRecipe::toBukkitRecipe).orElse(null);
    }

    public Recipe getCraftingRecipe(ItemStack[] craftingMatrix, World world) {
        Container container = new Container(null, -1){

            @Override
            public InventoryView getBukkitView() {
                return null;
            }

            @Override
            public boolean a(EntityHuman player) {
                return false;
            }

            @Override
            public net.minecraft.world.item.ItemStack a(EntityHuman player, int slot) {
                return net.minecraft.world.item.ItemStack.b;
            }
        };
        TransientCraftingContainer inventoryCrafting = new TransientCraftingContainer(container, 3, 3);
        return this.getNMSRecipe(craftingMatrix, inventoryCrafting, (CraftWorld)world).map(IRecipe::toBukkitRecipe).orElse(null);
    }

    public ItemStack craftItem(ItemStack[] craftingMatrix, World world, Player player) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ContainerWorkbench container = new ContainerWorkbench(-1, craftPlayer.getHandle().fN());
        TransientCraftingContainer inventoryCrafting = container.craftSlots;
        InventoryCraftResult craftResult = container.s;
        Optional<RecipeCrafting> recipe = this.getNMSRecipe(craftingMatrix, inventoryCrafting, craftWorld);
        net.minecraft.world.item.ItemStack itemstack = net.minecraft.world.item.ItemStack.b;
        if (recipe.isPresent()) {
            RecipeCrafting recipeCrafting = recipe.get();
            if (craftResult.a(craftWorld.getHandle(), craftPlayer.getHandle(), recipeCrafting)) {
                itemstack = recipeCrafting.a(inventoryCrafting, craftWorld.getHandle().B_());
            }
        }
        net.minecraft.world.item.ItemStack result = CraftEventFactory.callPreCraftEvent(inventoryCrafting, craftResult, itemstack, container.getBukkitView(), recipe.orElse(null) instanceof RecipeRepair);
        for (int i2 = 0; i2 < craftingMatrix.length; ++i2) {
            Item remaining = inventoryCrafting.getContents().get(i2).d().s();
            craftingMatrix[i2] = remaining != null ? CraftItemStack.asBukkitCopy(remaining.ae_()) : null;
        }
        return CraftItemStack.asBukkitCopy(result);
    }

    private Optional<RecipeCrafting> getNMSRecipe(ItemStack[] craftingMatrix, InventoryCrafting inventoryCrafting, CraftWorld world) {
        Preconditions.checkArgument((craftingMatrix != null ? 1 : 0) != 0, (Object)"craftingMatrix must not be null");
        Preconditions.checkArgument((craftingMatrix.length == 9 ? 1 : 0) != 0, (Object)"craftingMatrix must be an array of length 9");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        for (int i2 = 0; i2 < craftingMatrix.length; ++i2) {
            inventoryCrafting.a(i2, CraftItemStack.asNMSCopy(craftingMatrix[i2]));
        }
        return this.getServer().aE().a(Recipes.a, inventoryCrafting, world.getHandle());
    }

    public Iterator<Recipe> recipeIterator() {
        return new RecipeIterator();
    }

    public void clearRecipes() {
        this.console.aE().clearRecipes();
    }

    public void resetRecipes() {
        this.reloadData();
    }

    public boolean removeRecipe(NamespacedKey recipeKey) {
        return this.removeRecipe(recipeKey, false);
    }

    public boolean removeRecipe(NamespacedKey recipeKey, boolean resendRecipes) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"recipeKey == null");
        MinecraftKey mcKey = CraftNamespacedKey.toMinecraft(recipeKey);
        boolean removed = this.getServer().aE().removeRecipe(mcKey);
        if (removed && resendRecipes) {
            this.playerList.reloadRecipeData();
        }
        return removed;
    }

    public Map<String, String[]> getCommandAliases() {
        ConfigurationSection section = this.commandsConfiguration.getConfigurationSection("aliases");
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        if (section != null) {
            for (String key : section.getKeys(false)) {
                List commands = section.isList(key) ? section.getStringList(key) : ImmutableList.of((Object)section.getString(key));
                result.put(key, commands.toArray(new String[commands.size()]));
            }
        }
        return result;
    }

    public void removeBukkitSpawnRadius() {
        this.configuration.set("settings.spawn-radius", null);
        this.saveConfig();
    }

    public int getBukkitSpawnRadius() {
        return this.configuration.getInt("settings.spawn-radius", -1);
    }

    public Component shutdownMessage() {
        String msg = this.getShutdownMessage();
        return msg != null ? LegacyComponentSerializer.legacySection().deserialize(msg) : null;
    }

    @Deprecated
    public String getShutdownMessage() {
        return this.configuration.getString("settings.shutdown-message");
    }

    public int getSpawnRadius() {
        return this.getServer().ah();
    }

    public void setSpawnRadius(int value) {
        this.configuration.set("settings.spawn-radius", (Object)value);
        this.saveConfig();
    }

    public boolean shouldSendChatPreviews() {
        return false;
    }

    public boolean isEnforcingSecureProfiles() {
        return this.getServer().aw();
    }

    public boolean getHideOnlinePlayers() {
        return this.console.aj();
    }

    public boolean getOnlineMode() {
        return this.console.U();
    }

    public boolean getAllowFlight() {
        return this.console.Z();
    }

    public boolean isHardcore() {
        return this.console.h();
    }

    public ChunkGenerator getGenerator(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        ChunkGenerator result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("generator")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultWorldGenerator(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world generator");
                    }
                }
                catch (Throwable t2) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t2);
                }
            }
        }
        return result;
    }

    public BiomeProvider getBiomeProvider(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        BiomeProvider result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("biome-provider")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultBiomeProvider(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world biome provider");
                    }
                }
                catch (Throwable t2) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t2);
                }
            }
        }
        return result;
    }

    @Deprecated
    public CraftMapView getMap(int id) {
        WorldMap worldmap = this.console.a(net.minecraft.world.level.World.h).a("map_" + id);
        if (worldmap == null) {
            return null;
        }
        return worldmap.mapView;
    }

    public CraftMapView createMap(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        WorldServer minecraftWorld = ((CraftWorld)world).getHandle();
        int newId = ItemWorldMap.a(minecraftWorld, minecraftWorld.u_().a(), minecraftWorld.u_().c(), 3, false, false, minecraftWorld.ac());
        return ((net.minecraft.world.level.World)minecraftWorld).a((String)ItemWorldMap.a((int)newId)).mapView;
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        return this.createExplorerMap(world, location, structureType, 100, true);
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        Preconditions.checkArgument((structureType != null ? 1 : 0) != 0, (Object)"StructureType cannot be null");
        Preconditions.checkArgument((structureType.getMapIcon() != null ? 1 : 0) != 0, (String)"Cannot create explorer maps for StructureType %s", (Object)structureType.getName());
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        Location structureLocation = world.locateNearestStructure(location, structureType, radius, findUnexplored);
        if (structureLocation == null) {
            throw new IllegalStateException("Could not find a structure for " + structureType);
        }
        BlockPosition structurePosition = CraftLocation.toBlockPosition(structureLocation);
        net.minecraft.world.item.ItemStack stack = ItemWorldMap.a(worldServer, structurePosition.u(), structurePosition.w(), MapView.Scale.NORMAL.getValue(), true, true);
        ItemWorldMap.a(worldServer, stack);
        ItemWorldMap.a(stack, (net.minecraft.world.level.World)worldServer);
        WorldMap.a(stack, structurePosition, "+", MapIcon.Type.a(structureType.getMapIcon().getValue()));
        return CraftItemStack.asBukkitCopy(stack);
    }

    public ItemStack createExplorerMap(World world, Location location, org.bukkit.generator.structure.StructureType structureType, MapCursor.Type mapIcon, int radius, boolean findUnexplored) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((structureType != null ? 1 : 0) != 0, (Object)"StructureType cannot be null");
        Preconditions.checkArgument((mapIcon != null ? 1 : 0) != 0, (Object)"mapIcon cannot be null");
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        StructureSearchResult structureSearchResult = world.locateNearestStructure(location, structureType, radius, findUnexplored);
        if (structureSearchResult == null) {
            return null;
        }
        Location structureLocation = structureSearchResult.getLocation();
        BlockPosition structurePosition = new BlockPosition(structureLocation.getBlockX(), structureLocation.getBlockY(), structureLocation.getBlockZ());
        net.minecraft.world.item.ItemStack stack = ItemWorldMap.a(worldServer, structurePosition.u(), structurePosition.w(), MapView.Scale.NORMAL.getValue(), true, true);
        ItemWorldMap.a(worldServer, stack);
        ItemWorldMap.a(stack, (net.minecraft.world.level.World)worldServer);
        WorldMap.a(stack, structurePosition, "+", MapIcon.Type.a(mapIcon.getValue()));
        return CraftItemStack.asBukkitCopy(stack);
    }

    public void shutdown() {
        this.console.a(false);
    }

    @Deprecated
    public int broadcast(String message, String permission) {
        return this.broadcast((Component)LegacyComponentSerializer.legacySection().deserialize(message), permission);
    }

    public int broadcast(Component message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    public int broadcast(Component message, String permission) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (Permissible permissible : this.getPluginManager().getPermissionSubscriptions(permission)) {
            if (!(permissible instanceof CommandSender) || permissible instanceof BlockCommandSender || !permissible.hasPermission(permission)) continue;
            recipients.add((CommandSender)permissible);
        }
        BroadcastMessageEvent broadcastMessageEvent = new BroadcastMessageEvent(!Bukkit.isPrimaryThread(), message, recipients);
        this.getPluginManager().callEvent((Event)broadcastMessageEvent);
        if (broadcastMessageEvent.isCancelled()) {
            return 0;
        }
        message = broadcastMessageEvent.message();
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    @Nullable
    public UUID getPlayerUniqueId(String name) {
        Player player = Bukkit.getPlayerExact((String)name);
        if (player != null) {
            return player.getUniqueId();
        }
        GameProfile profile = GlobalConfiguration.get().proxies.isProxyOnlineMode() ? (GameProfile)this.console.ap().a(name).orElse(null) : new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name);
        return profile != null ? profile.getId() : null;
    }

    @Deprecated
    public OfflinePlayer getOfflinePlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Preconditions.checkArgument((!name.isBlank() ? 1 : 0) != 0, (Object)"name cannot be empty");
        Player result = this.getPlayerExact(name);
        if (result == null) {
            GameProfile profile = null;
            if (this.getOnlineMode() || GlobalConfiguration.get().proxies.isProxyOnlineMode()) {
                profile = this.console.ap().a(name).orElse(null);
            }
            result = profile == null ? this.getOfflinePlayer(new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name)) : this.getOfflinePlayer(profile);
        } else {
            this.offlinePlayers.remove(result.getUniqueId());
        }
        return result;
    }

    @Nullable
    public OfflinePlayer getOfflinePlayerIfCached(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name cannot be null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name cannot be empty");
        Player result = this.getPlayerExact(name);
        if (result == null) {
            GameProfile profile = this.console.ap().getProfileIfCached(name);
            if (profile != null) {
                result = this.getOfflinePlayer(profile);
            }
        } else {
            this.offlinePlayers.remove(result.getUniqueId());
        }
        return result;
    }

    public OfflinePlayer getOfflinePlayer(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        Object result = this.getPlayer(id);
        if (result == null) {
            result = this.offlinePlayers.get(id);
            if (result == null) {
                result = new CraftOfflinePlayer(this, new GameProfile(id, null));
                this.offlinePlayers.put(id, (OfflinePlayer)result);
            }
        } else {
            this.offlinePlayers.remove(id);
        }
        return result;
    }

    public PlayerProfile createPlayerProfile(UUID uniqueId, String name) {
        return new CraftPlayerProfile(uniqueId, name);
    }

    public PlayerProfile createPlayerProfile(UUID uniqueId) {
        return new CraftPlayerProfile(uniqueId, null);
    }

    public PlayerProfile createPlayerProfile(String name) {
        return new CraftPlayerProfile(null, name);
    }

    public OfflinePlayer getOfflinePlayer(GameProfile profile) {
        CraftOfflinePlayer player = new CraftOfflinePlayer(this, profile);
        this.offlinePlayers.put(profile.getId(), player);
        return player;
    }

    public Set<String> getIPBans() {
        return this.playerList.g().d().stream().map(JsonListEntry::g).collect(Collectors.toSet());
    }

    public void banIP(String address) {
        Preconditions.checkArgument((address != null && !address.isBlank() ? 1 : 0) != 0, (Object)"Address cannot be null or blank.");
        this.getBanList(BanList.Type.IP).addBan(address, null, null, null);
    }

    public void unbanIP(String address) {
        Preconditions.checkArgument((address != null && !address.isBlank() ? 1 : 0) != 0, (Object)"Address cannot be null or blank.");
        this.getBanList(BanList.Type.IP).pardon(address);
    }

    public void banIP(InetAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address cannot be null.");
        ((CraftIpBanList)this.getBanList(BanList.Type.IP)).addBan(address, null, (Date)null, null);
    }

    public void unbanIP(InetAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address cannot be null.");
        ((CraftIpBanList)this.getBanList(BanList.Type.IP)).pardon(address);
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (GameProfileBanEntry entry : this.playerList.f().d()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.g()));
        }
        return result;
    }

    public <T extends BanList<?>> T getBanList(BanList.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"BanList.Type cannot be null");
        return (T)(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BanList.Type.IP -> new CraftIpBanList(this.playerList.g());
            case BanList.Type.PROFILE, BanList.Type.NAME -> new CraftProfileBanList(this.playerList.f());
        });
    }

    public void setWhitelist(boolean value) {
        this.playerList.a(value);
        this.console.i(value);
    }

    public boolean isWhitelistEnforced() {
        return this.console.aK();
    }

    public void setWhitelistEnforced(boolean value) {
        this.console.h(value);
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        LinkedHashSet<OfflinePlayer> result = new LinkedHashSet<OfflinePlayer>();
        for (WhiteListEntry entry : this.playerList.i().d()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.g()));
        }
        return result;
    }

    public Set<OfflinePlayer> getOperators() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (OpListEntry entry : this.playerList.k().d()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.g()));
        }
        return result;
    }

    public void reloadWhitelist() {
        this.playerList.a();
    }

    public GameMode getDefaultGameMode() {
        return GameMode.getByValue((int)this.console.a(net.minecraft.world.level.World.h).K.m().a());
    }

    public void setDefaultGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        for (World world : this.getWorlds()) {
            ((CraftWorld)world).getHandle().K.a(EnumGamemode.a(mode.getValue()));
        }
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.console.console;
    }

    public CommandSender createCommandSender(Consumer<? super Component> feedback) {
        return new FeedbackForwardingSender(feedback, this);
    }

    public EntityMetadataStore getEntityMetadata() {
        return this.entityMetadata;
    }

    public PlayerMetadataStore getPlayerMetadata() {
        return this.playerMetadata;
    }

    public WorldMetadataStore getWorldMetadata() {
        return this.worldMetadata;
    }

    public File getWorldContainer() {
        return this.getServer().h.a(net.minecraft.world.level.World.h).getParent().toFile();
    }

    public OfflinePlayer[] getOfflinePlayers() {
        WorldNBTStorage storage = this.console.i;
        String[] files = storage.getPlayerDir().list(new DatFileFilter());
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String file : files) {
            try {
                players.add(this.getOfflinePlayer(UUID.fromString(file.substring(0, file.length() - 4))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        players.addAll(this.getOnlinePlayers());
        return players.toArray(new OfflinePlayer[players.size()]);
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"InventoryType cannot be null");
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"InventoryType.%s cannot be used to create a inventory", (Object)type);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type);
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"Cannot open an inventory of type ", (Object)type);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type, title);
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"InventoryType cannot be null");
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"InventoryType.%s cannot be used to create a inventory", (Object)type);
        Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"title cannot be null");
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type, title);
    }

    public Inventory createInventory(InventoryHolder owner, int size) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)"Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got %s)", (int)size);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size);
    }

    public Inventory createInventory(InventoryHolder owner, int size, Component title) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (Object)("Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got " + size + ")"));
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size, title);
    }

    public Inventory createInventory(InventoryHolder owner, int size, String title) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)"Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got %s)", (int)size);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size, title);
    }

    public Merchant createMerchant(Component title) {
        return new CraftMerchantCustom(title == null ? InventoryType.MERCHANT.defaultTitle() : title);
    }

    @Deprecated
    public Merchant createMerchant(String title) {
        return new CraftMerchantCustom(title == null ? InventoryType.MERCHANT.getDefaultTitle() : title);
    }

    public int getMaxChainedNeighborUpdates() {
        return this.getServer().bd();
    }

    public HelpMap getHelpMap() {
        return this.helpMap;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    public int getSpawnLimit(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (Object)("SpawnCategory." + spawnCategory + " does not have a spawn limit."));
        return this.getSpawnLimitUnsafe(spawnCategory);
    }

    public int getSpawnLimitUnsafe(SpawnCategory spawnCategory) {
        return this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
    }

    public boolean isPrimaryThread() {
        return TickThread.isTickThread();
    }

    public Component motd() {
        return this.console.motd();
    }

    public void motd(Component motd) {
        this.console.motd(motd);
    }

    public String getMotd() {
        return this.console.aa();
    }

    public void setMotd(String motd) {
        this.console.d(motd);
    }

    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    public List<String> tabComplete(CommandSender sender, String message, WorldServer world, Vec3D pos, boolean forceCommand) {
        if (!(sender instanceof Player)) {
            return ImmutableList.of();
        }
        Player player = (Player)sender;
        List<String> offers = message.startsWith("/") || forceCommand ? this.tabCompleteCommand(player, message, world, pos) : this.tabCompleteChat(player, message);
        TabCompleteEvent tabEvent = new TabCompleteEvent((CommandSender)player, message, offers, message.startsWith("/") || forceCommand, pos != null ? MCUtil.toLocation(((CraftWorld)player.getWorld()).getHandle(), BlockPosition.a(pos)) : null);
        this.getPluginManager().callEvent((Event)tabEvent);
        return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
    }

    public List<String> tabCompleteCommand(Player player, String message, WorldServer world, Vec3D pos) {
        if (!(SpigotConfig.tabComplete >= 0 && message.length() > SpigotConfig.tabComplete || message.contains(" "))) {
            return ImmutableList.of();
        }
        List completions = null;
        try {
            if (message.startsWith("/")) {
                message = message.substring(1);
            }
            completions = pos == null ? this.getCommandMap().tabComplete((CommandSender)player, message) : this.getCommandMap().tabComplete((CommandSender)player, message, CraftLocation.toBukkit(pos, (World)world.getWorld()));
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to tab-complete this command");
            this.getLogger().log(Level.SEVERE, "Exception when " + player.getName() + " attempted to tab complete " + message, ex);
        }
        return completions == null ? ImmutableList.of() : completions;
    }

    public List<String> tabCompleteChat(Player player, String message) {
        ArrayList<String> completions = new ArrayList<String>();
        PlayerChatTabCompleteEvent event = new PlayerChatTabCompleteEvent(player, message, completions);
        String token = event.getLastToken();
        for (Player p2 : this.getOnlinePlayers()) {
            if (!player.canSee(p2) || !StringUtil.startsWithIgnoreCase((String)p2.getName(), (String)token)) continue;
            completions.add(p2.getName());
        }
        this.pluginManager.callEvent((Event)event);
        Iterator it = completions.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current instanceof String) continue;
            it.remove();
        }
        Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    public CraftItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public CraftScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public Criteria getScoreboardCriteria(String name) {
        return CraftCriteria.getFromBukkit(name);
    }

    public void checkSaveState() {
        if (this.playerCommandState || this.printSaveWarning || this.console.autosavePeriod <= 0) {
            return;
        }
        this.printSaveWarning = true;
        this.getLogger().log(Level.WARNING, "A manual (plugin-induced) save has been detected while server is configured to auto-save. This may affect performance.", this.warningState == Warning.WarningState.ON ? new Throwable() : null);
    }

    public CraftIconCache getServerIcon() {
        return this.icon;
    }

    public CraftIconCache loadServerIcon(File file) throws Exception {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (String)"File (%s) is not a valid file", (Object)file);
        return CraftServer.loadServerIcon0(file);
    }

    static CraftIconCache loadServerIcon0(File file) throws Exception {
        return CraftServer.loadServerIcon0(ImageIO.read(file));
    }

    public CraftIconCache loadServerIcon(BufferedImage image) throws Exception {
        Preconditions.checkArgument((image != null ? 1 : 0) != 0, (Object)"BufferedImage image cannot be null");
        return CraftServer.loadServerIcon0(image);
    }

    static CraftIconCache loadServerIcon0(BufferedImage image) throws Exception {
        Preconditions.checkArgument((image.getWidth() == 64 ? 1 : 0) != 0, (String)"BufferedImage must be 64 pixels wide (%s)", (int)image.getWidth());
        Preconditions.checkArgument((image.getHeight() == 64 ? 1 : 0) != 0, (String)"BufferedImage must be 64 pixels high (%s)", (int)image.getHeight());
        ByteArrayOutputStream bytebuf = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", bytebuf);
        return new CraftIconCache(bytebuf.toByteArray());
    }

    public void setIdleTimeout(int threshold) {
        this.console.c(threshold);
    }

    public int getIdleTimeout() {
        return this.console.al();
    }

    public ChunkGenerator.ChunkData createChunkData(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        WorldServer handle = ((CraftWorld)world).getHandle();
        return new OldCraftChunkData(world.getMinHeight(), world.getMaxHeight(), handle.B_().d(Registries.ap), world);
    }

    @Deprecated(forRemoval=true)
    public ChunkGenerator.ChunkData createVanillaChunkData(World world, int x2, int z2) {
        net.minecraft.world.level.chunk.ChunkGenerator chunkGenerator;
        WorldServer serverLevel = ((CraftWorld)world).getHandle();
        IRegistry<BiomeBase> biomeRegistry = serverLevel.n().aV().d(Registries.ap);
        ProtoChunk protoChunk = new ProtoChunk(new ChunkCoordIntPair(x2, z2), ChunkConverter.a, serverLevel, biomeRegistry, null);
        net.minecraft.world.level.chunk.ChunkGenerator chunkGenerator2 = serverLevel.I.g();
        if (chunkGenerator2 instanceof CustomChunkGenerator) {
            CustomChunkGenerator bukkit = (CustomChunkGenerator)chunkGenerator2;
            chunkGenerator = bukkit.getDelegate();
        } else {
            chunkGenerator = serverLevel.I.g();
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(x2, z2);
        ThreadedMailbox<Runnable> mailbox = ThreadedMailbox.a(SystemUtils.f(), "CraftServer#createVanillaChunkData(worldName='" + world.getName() + "', x='" + x2 + "', z='" + z2 + "')");
        for (ChunkStatus chunkStatus : VANILLA_GEN_STATUSES) {
            ArrayList chunks = Lists.newArrayList();
            int statusRange = Math.max(1, chunkStatus.e());
            for (int zz = chunkPos.f - statusRange; zz <= chunkPos.f + statusRange; ++zz) {
                for (int xx = chunkPos.e - statusRange; xx <= chunkPos.e + statusRange; ++xx) {
                    if (xx == chunkPos.e && zz == chunkPos.f) {
                        chunks.add(protoChunk);
                        continue;
                    }
                    Holder.c<BiomeBase> biomeHolder = serverLevel.B_().d(Registries.ap).f(Biomes.b);
                    ChunkEmpty chunk2 = new ChunkEmpty((net.minecraft.world.level.World)serverLevel, new ChunkCoordIntPair(xx, zz), biomeHolder);
                    chunks.add(chunk2);
                }
            }
            ((CompletableFuture)chunkStatus.a(mailbox::a, serverLevel, chunkGenerator, serverLevel.p(), serverLevel.I.a(), chunk -> {
                throw new UnsupportedOperationException("Not creating full chunks here");
            }, chunks).thenAccept(either -> {
                if (chunkStatus == ChunkStatus.g) {
                    either.left().ifPresent(chunk -> HeightMap.a(chunk, ChunkStatus.b));
                }
            })).join();
        }
        OldCraftChunkData data = (OldCraftChunkData)this.createChunkData(world);
        data.setRawChunkData(protoChunk.d());
        return data;
    }

    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        return new CraftBossBar(title, color, style, flags);
    }

    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor barColor, BarStyle barStyle, BarFlag ... barFlags) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        Preconditions.checkArgument((barColor != null ? 1 : 0) != 0, (Object)"BarColor key cannot be null");
        Preconditions.checkArgument((barStyle != null ? 1 : 0) != 0, (Object)"BarStyle key cannot be null");
        BossBattleCustom bossBattleCustom = this.getServer().aJ().a(CraftNamespacedKey.toMinecraft(key), CraftChatMessage.fromString(title, true)[0]);
        CraftKeyedBossbar craftKeyedBossbar = new CraftKeyedBossbar(bossBattleCustom);
        craftKeyedBossbar.setColor(barColor);
        craftKeyedBossbar.setStyle(barStyle);
        for (BarFlag flag : barFlags) {
            if (flag == null) continue;
            craftKeyedBossbar.addFlag(flag);
        }
        return craftKeyedBossbar;
    }

    public Iterator<KeyedBossBar> getBossBars() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.getServer().aJ().b().iterator(), (Function)new Function<BossBattleCustom, KeyedBossBar>(){

            public KeyedBossBar apply(BossBattleCustom bossBattleCustom) {
                return bossBattleCustom.getBukkitEntity();
            }
        }));
    }

    public KeyedBossBar getBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        BossBattleCustom bossBattleCustom = this.getServer().aJ().a(CraftNamespacedKey.toMinecraft(key));
        return bossBattleCustom == null ? null : bossBattleCustom.getBukkitEntity();
    }

    public boolean removeBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        BossBattleCustomData bossBattleCustomData = this.getServer().aJ();
        BossBattleCustom bossBattleCustom = bossBattleCustomData.a(CraftNamespacedKey.toMinecraft(key));
        if (bossBattleCustom != null) {
            bossBattleCustomData.a(bossBattleCustom);
            return true;
        }
        return false;
    }

    public Entity getEntity(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        for (WorldServer world : this.getServer().F()) {
            net.minecraft.world.entity.Entity entity = world.a(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    public Advancement getAdvancement(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        net.minecraft.advancements.Advancement advancement = this.console.az().a(CraftNamespacedKey.toMinecraft(key));
        return advancement == null ? null : advancement.bukkit;
    }

    public Iterator<Advancement> advancementIterator() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.console.az().a().iterator(), (Function)new Function<net.minecraft.advancements.Advancement, Advancement>(){

            public Advancement apply(net.minecraft.advancements.Advancement advancement) {
                return advancement.bukkit;
            }
        }));
    }

    public BlockData createBlockData(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.createBlockData(material, (String)null);
    }

    public BlockData createBlockData(Material material, Consumer<BlockData> consumer) {
        BlockData data = this.createBlockData(material);
        if (consumer != null) {
            consumer.accept(data);
        }
        return data;
    }

    public BlockData createBlockData(String data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"data cannot be null");
        return this.createBlockData(null, data);
    }

    public BlockData createBlockData(Material material, String data) {
        Preconditions.checkArgument((material != null || data != null ? 1 : 0) != 0, (Object)"Must provide one of material or data");
        return CraftBlockData.newData(material, data);
    }

    public <T extends Keyed> Tag<T> getTag(String registry, NamespacedKey tag, Class<T> clazz) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"registry cannot be null");
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"NamespacedKey tag cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class clazz cannot be null");
        MinecraftKey key = CraftNamespacedKey.toMinecraft(tag);
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Block namespace (%s) must have material type", (Object)clazz.getName());
                TagKey<Block> blockTagKey = TagKey.a(Registries.e, key);
                if (!BuiltInRegistries.f.b(blockTagKey).isPresent()) break;
                return new CraftBlockTag((IRegistry<Block>)BuiltInRegistries.f, blockTagKey);
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Item namespace (%s) must have material type", (Object)clazz.getName());
                TagKey<Item> itemTagKey = TagKey.a(Registries.D, key);
                if (!BuiltInRegistries.i.b(itemTagKey).isPresent()) break;
                return new CraftItemTag((IRegistry<Item>)BuiltInRegistries.i, itemTagKey);
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Fluid.class ? 1 : 0) != 0, (String)"Fluid namespace (%s) must have fluid type", (Object)clazz.getName());
                TagKey<FluidType> fluidTagKey = TagKey.a(Registries.w, key);
                if (!BuiltInRegistries.d.b(fluidTagKey).isPresent()) break;
                return new CraftFluidTag((IRegistry<FluidType>)BuiltInRegistries.d, fluidTagKey);
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == EntityType.class ? 1 : 0) != 0, (String)"Entity type namespace (%s) must have entity type", (Object)clazz.getName());
                TagKey<EntityTypes<?>> entityTagKey = TagKey.a(Registries.s, key);
                if (!BuiltInRegistries.h.b(entityTagKey).isPresent()) break;
                return new CraftEntityTag((IRegistry<EntityTypes<?>>)BuiltInRegistries.h, entityTagKey);
            }
            case "game_events": {
                Preconditions.checkArgument((clazz == GameEvent.class ? 1 : 0) != 0, (Object)"Game Event namespace must have GameEvent type");
                TagKey<net.minecraft.world.level.gameevent.GameEvent> gameEventTagKey = TagKey.a(Registries.z, key);
                if (!BuiltInRegistries.b.b(gameEventTagKey).isPresent()) break;
                return new CraftGameEventTag((IRegistry<net.minecraft.world.level.gameevent.GameEvent>)BuiltInRegistries.b, gameEventTagKey);
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"registry cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class clazz cannot be null");
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Block namespace (%s) must have material type", (Object)clazz.getName());
                RegistryBlocks<Block> blockTags = BuiltInRegistries.f;
                return (Iterable)blockTags.i().map(pair -> new CraftBlockTag((IRegistry<Block>)blockTags, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Item namespace (%s) must have material type", (Object)clazz.getName());
                RegistryBlocks<Item> itemTags = BuiltInRegistries.i;
                return (Iterable)itemTags.i().map(pair -> new CraftItemTag((IRegistry<Item>)itemTags, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Fluid namespace (%s) must have fluid type", (Object)clazz.getName());
                RegistryBlocks<FluidType> fluidTags = BuiltInRegistries.d;
                return (Iterable)fluidTags.i().map(pair -> new CraftFluidTag((IRegistry<FluidType>)fluidTags, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == EntityType.class ? 1 : 0) != 0, (String)"Entity type namespace (%s) must have entity type", (Object)clazz.getName());
                RegistryBlocks<EntityTypes<?>> entityTags = BuiltInRegistries.h;
                return (Iterable)entityTags.i().map(pair -> new CraftEntityTag((IRegistry<EntityTypes<?>>)entityTags, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
            case "game_events": {
                Preconditions.checkArgument((clazz == GameEvent.class ? 1 : 0) != 0);
                RegistryBlocks<net.minecraft.world.level.gameevent.GameEvent> gameEvents = BuiltInRegistries.b;
                return (Iterable)gameEvents.i().map(pair -> new CraftGameEventTag((IRegistry<net.minecraft.world.level.gameevent.GameEvent>)gameEvents, (TagKey)pair.getFirst())).collect(ImmutableList.toImmutableList());
            }
        }
        throw new IllegalArgumentException();
    }

    public LootTable getLootTable(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        LootDataManager registry = this.getServer().aH();
        MinecraftKey lootTableKey = CraftNamespacedKey.toMinecraft(key);
        if (registry.getLootTable(lootTableKey) == net.minecraft.world.level.storage.loot.LootTable.a) {
            return null;
        }
        return new CraftLootTable(key, registry.getLootTable(lootTableKey));
    }

    public List<Entity> selectEntities(CommandSender sender, String selector) {
        List<? extends net.minecraft.world.entity.Entity> nms;
        Preconditions.checkArgument((selector != null ? 1 : 0) != 0, (Object)"selector cannot be null");
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"CommandSender sender cannot be null");
        ArgumentEntity arg = ArgumentEntity.b();
        try {
            StringReader reader = new StringReader(selector);
            nms = arg.parse(reader, true).b(VanillaCommandWrapper.getListener(sender));
            Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (String)"Spurious trailing data in selector: %s", (Object)selector);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse selector: " + selector, ex);
        }
        return new ArrayList<Entity>(Lists.transform(nms, entity -> entity.getBukkitEntity()));
    }

    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    public <T extends Keyed> Registry<T> getRegistry(Class<T> aClass) {
        return this.registries.computeIfAbsent(aClass, key -> CraftRegistry.createRegistry(aClass, this.console.aV()));
    }

    @Deprecated
    public UnsafeValues getUnsafe() {
        return CraftMagicNumbers.INSTANCE;
    }

    public double[] getTPS() {
        return new double[]{MinecraftServer.getServer().tps1.getAverage(), MinecraftServer.getServer().tps5.getAverage(), MinecraftServer.getServer().tps15.getAverage()};
    }

    public long[] getTickTimes() {
        return this.getServer().tickTimes5s.getTimes();
    }

    public double getAverageTickTime() {
        return this.getServer().tickTimes5s.getAverage();
    }

    public Server.Spigot spigot() {
        return this.spigot;
    }

    public void playSound(Sound sound) {
        long seed = sound.seed().orElseGet(this.console.D().y_()::g);
        for (EntityPlayer player : this.playerList.t()) {
            player.c.a(PaperAdventure.asSoundPacket(sound, player.dn(), player.dp(), player.dt(), seed, null));
        }
    }

    public void playSound(Sound sound, double x2, double y2, double z2) {
        PaperAdventure.asSoundPacket(sound, x2, y2, z2, sound.seed().orElseGet(this.console.D().y_()::g), this.playSound0(x2, y2, z2, this.console.F()));
    }

    public void playSound(Sound sound, Sound.Emitter emitter) {
        long seed = sound.seed().orElseGet(this.console.D().y_()::g);
        if (emitter == Sound.Emitter.self()) {
            for (EntityPlayer player : this.playerList.t()) {
                player.c.a(PaperAdventure.asSoundPacket(sound, player, seed, null));
            }
        } else if (emitter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)emitter;
            net.minecraft.world.entity.Entity entity = craftEntity.getHandle();
            PaperAdventure.asSoundPacket(sound, entity, seed, this.playSound0(entity.dn(), entity.dp(), entity.dt(), List.of((WorldServer)entity.dI())));
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + emitter);
        }
    }

    private BiConsumer<Packet<?>, Float> playSound0(double x2, double y2, double z2, Iterable<WorldServer> levels) {
        return (packet, distance) -> {
            for (WorldServer level : levels) {
                level.n().ac().a(null, x2, y2, z2, distance.floatValue(), level.ac(), (Packet<?>)packet);
            }
        };
    }

    public static Path dumpHeap(Path dir, String name) {
        try {
            Path file;
            Files.createDirectories(dir, new FileAttribute[0]);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                Class<?> clazz = Class.forName("openj9.lang.management.OpenJ9DiagnosticsMXBean");
                Object openj9Mbean = ManagementFactory.newPlatformMXBeanProxy(server, "openj9.lang.management:type=OpenJ9Diagnostics", clazz);
                Method m2 = clazz.getMethod("triggerDumpToFile", String.class, String.class);
                file = dir.resolve(name + ".phd");
                m2.invoke(openj9Mbean, "heap", file.toString());
            }
            catch (ClassNotFoundException e2) {
                Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
                Method m3 = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
                file = dir.resolve(name + ".hprof");
                m3.invoke(hotspotMBean, file.toString(), true);
            }
            return file;
        }
        catch (Throwable t2) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not write heap", t2);
            return null;
        }
    }

    public Iterable<? extends Audience> audiences() {
        if (this.adventure$audiences == null) {
            this.adventure$audiences = Iterables.concat(Collections.singleton(this.getConsoleSender()), (Iterable)this.getOnlinePlayers());
        }
        return this.adventure$audiences;
    }

    public void reloadPermissions() {
        this.pluginManager.clearPermissions();
        if (GlobalConfiguration.get().misc.loadPermissionsYmlBeforePlugins) {
            this.loadCustomPermissions();
        }
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            for (Permission perm : plugin.getDescription().getPermissions()) {
                try {
                    this.pluginManager.addPermission(perm);
                }
                catch (IllegalArgumentException ex) {
                    this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered", ex);
                }
            }
        }
        if (!GlobalConfiguration.get().misc.loadPermissionsYmlBeforePlugins) {
            this.loadCustomPermissions();
        }
        DefaultPermissions.registerCorePermissions();
        CraftDefaultPermissions.registerCorePermissions();
    }

    public boolean reloadCommandAliases() {
        Set removals = this.getCommandAliases().keySet().stream().map(key -> key.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        this.getCommandMap().getKnownCommands().keySet().removeIf(removals::contains);
        File file = this.getCommandsConfigFile();
        try {
            this.commandsConfiguration.load(file);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException | InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
            return false;
        }
        this.commandMap.registerServerAliases();
        return true;
    }

    public boolean suggestPlayerNamesWhenNullTabCompletions() {
        return GlobalConfiguration.get().commands.suggestPlayerNamesWhenNullTabCompletions;
    }

    public String getPermissionMessage() {
        return LegacyComponentSerializer.legacyAmpersand().serialize(GlobalConfiguration.get().messages.noPermission);
    }

    public Component permissionMessage() {
        return GlobalConfiguration.get().messages.noPermission;
    }

    public com.destroystokyo.paper.profile.PlayerProfile createProfile(@Nonnull UUID uuid) {
        return this.createProfile(uuid, null);
    }

    public com.destroystokyo.paper.profile.PlayerProfile createProfile(@Nonnull String name) {
        return this.createProfile(null, name);
    }

    public com.destroystokyo.paper.profile.PlayerProfile createProfile(@Nullable UUID uuid, @Nullable String name) {
        Player player;
        Object object = uuid != null ? Bukkit.getPlayer((UUID)uuid) : (player = name != null ? Bukkit.getPlayerExact((String)name) : null);
        if (player != null) {
            return new com.destroystokyo.paper.profile.CraftPlayerProfile((CraftPlayer)player);
        }
        return new com.destroystokyo.paper.profile.CraftPlayerProfile(uuid, name);
    }

    public com.destroystokyo.paper.profile.PlayerProfile createProfileExact(@Nullable UUID uuid, @Nullable String name) {
        Player player;
        Object object = uuid != null ? Bukkit.getPlayer((UUID)uuid) : (player = name != null ? Bukkit.getPlayerExact((String)name) : null);
        if (player == null) {
            return new com.destroystokyo.paper.profile.CraftPlayerProfile(uuid, name);
        }
        if (Objects.equals(uuid, player.getUniqueId()) && Objects.equals(name, player.getName())) {
            return new com.destroystokyo.paper.profile.CraftPlayerProfile((CraftPlayer)player);
        }
        GameProfile profile = new GameProfile(uuid, name);
        profile.getProperties().putAll((Multimap)((CraftPlayer)player).getHandle().fM().getProperties());
        return new com.destroystokyo.paper.profile.CraftPlayerProfile(profile);
    }

    public int getCurrentTick() {
        return MinecraftServer.currentTick;
    }

    public boolean isStopping() {
        return MinecraftServer.getServer().hasStopped();
    }

    public MobGoals getMobGoals() {
        return this.mobGoals;
    }

    public PaperDatapackManager getDatapackManager() {
        return this.datapackManager;
    }

    public CraftPotionBrewer getPotionBrewer() {
        return this.potionBrewer;
    }

    static {
        ConfigurationSerialization.registerClass(CraftOfflinePlayer.class);
        ConfigurationSerialization.registerClass(CraftPlayerProfile.class);
        ConfigurationSerialization.registerClass(com.destroystokyo.paper.profile.CraftPlayerProfile.class);
        CraftItemFactory.instance();
        VANILLA_GEN_STATUSES = List.of(ChunkStatus.c, ChunkStatus.d, ChunkStatus.e, ChunkStatus.f, ChunkStatus.g, ChunkStatus.h, ChunkStatus.i, ChunkStatus.j, ChunkStatus.k, ChunkStatus.l);
    }
}

