/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.attribute;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;

public class CraftAttributeInstance
implements AttributeInstance {
    private final AttributeModifiable handle;
    private final Attribute attribute;

    public CraftAttributeInstance(AttributeModifiable handle, Attribute attribute) {
        this.handle = handle;
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.handle.b();
    }

    public void setBaseValue(double d2) {
        this.handle.a(d2);
    }

    public Collection<AttributeModifier> getModifiers() {
        ArrayList<AttributeModifier> result = new ArrayList<AttributeModifier>();
        for (net.minecraft.world.entity.ai.attributes.AttributeModifier nms : this.handle.c()) {
            result.add(CraftAttributeInstance.convert(nms));
        }
        return result;
    }

    public void addModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.c(CraftAttributeInstance.convert(modifier));
    }

    public void addTransientModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.b(CraftAttributeInstance.convert(modifier));
    }

    public void removeModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.d(CraftAttributeInstance.convert(modifier));
    }

    public double getValue() {
        return this.handle.f();
    }

    public double getDefaultValue() {
        return this.handle.a().a();
    }

    public static net.minecraft.world.entity.ai.attributes.AttributeModifier convert(AttributeModifier bukkit) {
        return new net.minecraft.world.entity.ai.attributes.AttributeModifier(bukkit.getUniqueId(), bukkit.getName(), bukkit.getAmount(), AttributeModifier.Operation.values()[bukkit.getOperation().ordinal()]);
    }

    public static AttributeModifier convert(net.minecraft.world.entity.ai.attributes.AttributeModifier nms) {
        return new AttributeModifier(nms.a(), nms.b(), nms.d(), AttributeModifier.Operation.values()[nms.c().ordinal()]);
    }

    public static AttributeModifier convert(net.minecraft.world.entity.ai.attributes.AttributeModifier nms, EquipmentSlot slot) {
        return new AttributeModifier(nms.a(), nms.b(), nms.d(), AttributeModifier.Operation.values()[nms.c().ordinal()], slot);
    }
}

