/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.animal.allay.Allay;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.inventory.Inventory;

public class CraftAllay
extends CraftCreature
implements org.bukkit.entity.Allay {
    public CraftAllay(CraftServer server, Allay entity) {
        super(server, entity);
    }

    @Override
    public Allay getHandle() {
        return (Allay)this.entity;
    }

    @Override
    public String toString() {
        return "CraftAllay";
    }

    public Inventory getInventory() {
        return new CraftInventory(this.getHandle().w());
    }

    public boolean canDuplicate() {
        return this.getHandle().gi();
    }

    public void setCanDuplicate(boolean canDuplicate) {
        this.getHandle().setCanDuplicate(canDuplicate);
    }

    public long getDuplicationCooldown() {
        return this.getHandle().cj;
    }

    public void setDuplicationCooldown(long l2) {
        this.getHandle().cj = l2;
    }

    public void resetDuplicationCooldown() {
        this.getHandle().gh();
    }

    public boolean isDancing() {
        return this.getHandle().fY();
    }

    public void startDancing(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)location.getBlock().getType().equals((Object)Material.JUKEBOX), (Object)"The Block in the Location need to be a JukeBox");
        this.getHandle().b(CraftLocation.toBlockPosition(location), true);
    }

    public void startDancing() {
        this.getHandle().forceDancing = true;
        this.getHandle().w(true);
    }

    public void stopDancing() {
        this.getHandle().forceDancing = false;
        this.getHandle().ci = null;
        this.getHandle().w(false);
    }

    public org.bukkit.entity.Allay duplicateAllay() {
        Allay nmsAllay = this.getHandle().duplicateAllay();
        return nmsAllay != null ? (org.bukkit.entity.Allay)nmsAllay.getBukkitEntity() : null;
    }

    public Location getJukebox() {
        BlockPosition nmsJukeboxPos = this.getHandle().ci;
        return nmsJukeboxPos != null ? CraftLocation.toBukkit(nmsJukeboxPos, this.getWorld()) : null;
    }
}

