/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collection;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.EnumChatFormat;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final ScoreboardTeam team;

    CraftTeam(CraftScoreboard scoreboard, ScoreboardTeam team) {
        super(scoreboard);
        this.team = team;
    }

    public String getName() {
        this.checkState();
        return this.team.b();
    }

    public Component displayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return PaperAdventure.asAdventure(this.team.c());
    }

    public void displayName(Component displayName) throws IllegalStateException, IllegalArgumentException {
        if (displayName == null) {
            displayName = Component.empty();
        }
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(PaperAdventure.asVanilla(displayName));
    }

    public Component prefix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return PaperAdventure.asAdventure(this.team.e());
    }

    public void prefix(Component prefix) throws IllegalStateException, IllegalArgumentException {
        if (prefix == null) {
            prefix = Component.empty();
        }
        CraftScoreboard scoreboard = this.checkState();
        this.team.b(PaperAdventure.asVanilla(prefix));
    }

    public Component suffix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return PaperAdventure.asAdventure(this.team.f());
    }

    public void suffix(Component suffix) throws IllegalStateException, IllegalArgumentException {
        if (suffix == null) {
            suffix = Component.empty();
        }
        CraftScoreboard scoreboard = this.checkState();
        this.team.c(PaperAdventure.asVanilla(suffix));
    }

    public boolean hasColor() {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.n().f() != null;
    }

    public TextColor color() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        if (this.team.n().f() == null) {
            throw new IllegalStateException("Team colors must have hex values");
        }
        TextColor color = TextColor.color((int)this.team.n().f());
        if (!(color instanceof NamedTextColor)) {
            throw new IllegalStateException("Team doesn't have a NamedTextColor");
        }
        return (NamedTextColor)color;
    }

    public void color(NamedTextColor color) {
        CraftScoreboard scoreboard = this.checkState();
        if (color == null) {
            this.team.a(EnumChatFormat.v);
        } else {
            this.team.a(PaperAdventure.asVanilla((TextColor)color));
        }
    }

    public String getDisplayName() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.c());
    }

    public void setDisplayName(String displayName) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        this.checkState();
        this.team.a(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getPrefix() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.e());
    }

    public void setPrefix(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix cannot be null");
        this.checkState();
        this.team.b(CraftChatMessage.fromStringOrNull(prefix));
    }

    public String getSuffix() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.f());
    }

    public void setSuffix(String suffix) {
        Preconditions.checkArgument((suffix != null ? 1 : 0) != 0, (Object)"Suffix cannot be null");
        this.checkState();
        this.team.c(CraftChatMessage.fromStringOrNull(suffix));
    }

    public ChatColor getColor() {
        this.checkState();
        return CraftChatMessage.getColor(this.team.n());
    }

    public void setColor(ChatColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"Color cannot be null");
        this.checkState();
        this.team.a(CraftChatMessage.getColor(color));
    }

    public boolean allowFriendlyFire() {
        this.checkState();
        return this.team.h();
    }

    public void setAllowFriendlyFire(boolean enabled) {
        this.checkState();
        this.team.a(enabled);
    }

    public boolean canSeeFriendlyInvisibles() {
        this.checkState();
        return this.team.i();
    }

    public void setCanSeeFriendlyInvisibles(boolean enabled) {
        this.checkState();
        this.team.b(enabled);
    }

    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        this.checkState();
        return CraftTeam.notchToBukkit(this.team.j());
    }

    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        this.checkState();
        this.team.a(CraftTeam.bukkitToNotch(visibility));
    }

    public Set<OfflinePlayer> getPlayers() {
        this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.g()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName));
        }
        return players.build();
    }

    public Set<String> getEntries() {
        this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.g()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    public int getSize() {
        this.checkState();
        return this.team.g().size();
    }

    public void addPlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    public void addEntry(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.a(entry, this.team);
    }

    public void addEntities(Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        this.addEntries(entities.stream().map(entity -> ((CraftEntity)entity).getHandle().cv()).toList());
    }

    public void addEntries(Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        ((ScoreboardServer)scoreboard.board).addPlayersToTeam(entries, this.team);
    }

    public boolean removePlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    public boolean removeEntry(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.g().contains(entry)) {
            return false;
        }
        scoreboard.board.b(entry, this.team);
        return true;
    }

    public boolean removeEntities(Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        return this.removeEntries(entities.stream().map(entity -> ((CraftEntity)entity).getHandle().cv()).toList());
    }

    public boolean removeEntries(Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        for (String entry : entries) {
            if (!this.team.g().contains(entry)) continue;
            ((ScoreboardServer)scoreboard.board).removePlayersFromTeam(entries, this.team);
            return true;
        }
        return false;
    }

    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        return this.team.g().contains(entry);
    }

    @Override
    public void unregister() {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.d(this.team);
    }

    public Team.OptionStatus getOption(Team.Option option) {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.j().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.k().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.l().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + option);
    }

    public void setOption(Team.Option option, Team.OptionStatus status) {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.a(ScoreboardTeamBase.EnumNameTagVisibility.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.b(ScoreboardTeamBase.EnumNameTagVisibility.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.a(ScoreboardTeamBase.EnumTeamPush.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + option);
            }
        }
    }

    public void addEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.addEntry(((CraftEntity)entity).getHandle().cv());
    }

    public boolean removeEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.removeEntry(((CraftEntity)entity).getHandle().cv());
    }

    public boolean hasEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.hasEntry(((CraftEntity)entity).getHandle().cv());
    }

    public static ScoreboardTeamBase.EnumNameTagVisibility bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return ScoreboardTeamBase.EnumNameTagVisibility.a;
            }
            case NEVER: {
                return ScoreboardTeamBase.EnumNameTagVisibility.b;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return ScoreboardTeamBase.EnumNameTagVisibility.c;
            }
            case HIDE_FOR_OWN_TEAM: {
                return ScoreboardTeamBase.EnumNameTagVisibility.d;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    public static NameTagVisibility notchToBukkit(ScoreboardTeamBase.EnumNameTagVisibility visibility) {
        switch (visibility) {
            case a: {
                return NameTagVisibility.ALWAYS;
            }
            case b: {
                return NameTagVisibility.NEVER;
            }
            case c: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case d: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    @Override
    CraftScoreboard checkState() {
        Preconditions.checkState((this.getScoreboard().board.f(this.team.b()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

