/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.launcher.updater.StreamVersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.LogClient;
import net.minecraft.launcher.versions.ModifiedVersion;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.Argument;
import net.minecraft.launcher.versions.json.ArgumentType;
import org.apache.log4j.Logger;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.share.ForgeStringComparator;
import org.tlauncher.modpack.domain.client.share.NameIdDTO;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;

public class LocalVersionList
extends StreamVersionList {
    private static final Logger log = Logger.getLogger(LocalVersionList.class);
    private File baseDirectory;
    private File baseVersionsDir;

    public LocalVersionList(File baseDirectory) throws IOException {
        this.setBaseDirectory(baseDirectory);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("Base directory is NULL!");
        }
        FileUtil.createFolder(directory);
        this.log("Base directory:", directory.getAbsolutePath());
        this.baseDirectory = directory;
        this.baseVersionsDir = new File(this.baseDirectory, "versions");
    }

    @Override
    public synchronized void refreshVersions() {
        this.clearCache();
        File[] files = this.baseVersionsDir.listFiles();
        if (files == null) {
            return;
        }
        for (File directory : files) {
            String id = directory.getName();
            File jsonFile = new File(directory, id + ".json");
            if (!directory.isDirectory() || !jsonFile.isFile()) continue;
            try {
                String res = this.getUrl("versions/" + id + "/" + id + ".json");
                CompleteVersion version = this.gson.fromJson(res, CompleteVersion.class);
                if (version == null) {
                    this.log("JSON descriptor of version \"" + id + "\" in NULL, it won't be added in list as local.");
                    continue;
                }
                if ("1.17".equals(version.getAssets()) && Objects.isNull(version.getJavaVersion())) continue;
                version.setID(id);
                version.setSource(ClientInstanceRepo.LOCAL_VERSION_REPO);
                version.setVersionList(this);
                this.fixedGameAndForgeModpack(version);
                if (version.getID().equalsIgnoreCase(version.getInheritsFrom())) {
                    version = this.renameVersion(version, this.findNewVersionName(version.getID(), 0));
                }
                this.checkDoubleArgument(version);
                this.fixedlog4j(version);
                this.addVersion(version);
            }
            catch (Throwable ex) {
                this.log("Error occurred while parsing local version", id, ex);
                try {
                    SimpleDateFormat s = new SimpleDateFormat("dd_HH_mm_ss");
                    Files.move(directory.toPath(), Paths.get(directory.toString() + "_error_version_" + s.format(new Date()), new String[0]), new CopyOption[0]);
                }
                catch (IOException e) {
                    U.log(e);
                }
            }
        }
    }

    private void fixedGameAndForgeModpack(CompleteVersion version) throws FileNotFoundException, IOException {
        ModpackVersionDTO mv;
        if (version.isModpack() && Objects.isNull((mv = (ModpackVersionDTO)version.getModpack().getVersion()).getGameVersionDTO())) {
            Path modifiedVersionModel = MinecraftUtil.buildWorkingPath("versions", version.getID(), "TLauncherAdditional.json");
            try (FileReader fileReader = new FileReader(modifiedVersionModel.toFile());){
                JsonObject object = new JsonParser().parse(fileReader).getAsJsonObject();
                String gameVersion = object.getAsJsonObject("modpack").getAsJsonObject("version").get("gameVersion").getAsString();
                String forgeVersion = object.getAsJsonObject("modpack").getAsJsonObject("version").get("forgeVersion").getAsString();
                ModpackManager mm = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
                GameVersionDTO gv = mm.getGameVersionByName(gameVersion);
                mm.getVersionsByGameVersionAndMinecraftVersionType(gv.getId(), new NameIdDTO(1L, "forge")).stream().filter(e -> e.getName().equals(forgeVersion)).findAny().ifPresent(e -> mv.setMinecraftVersionName(new NameIdDTO(e.getId(), e.getName())));
                mv.setGameVersionDTO(gv);
                log.info(version.getID() + " updated old game and forge version " + mv.getGameVersionDTO().toString() + mv.getMinecraftVersionName().toString());
                this.saveVersion(version);
            }
        }
    }

    private void fixedlog4j(CompleteVersion version) throws IOException {
        String id;
        Map<String, LogClient> map = version.getLogging();
        ForgeStringComparator comparator = new ForgeStringComparator();
        if (Objects.nonNull(version.getJar())) {
            id = version.getJar();
        } else {
            id = version.getAssets().replaceAll("pre-", "").replaceAll("-af", "").replaceAll("-aprilfools", "").replaceAll("14w30c", "1.7.10").replaceAll("14w31a", "1.7.10").replaceAll("14w25a", "1.7.10");
            if (id.equals("legacy")) {
                id = version.getID().split(" ").length == 2 ? version.getID().split(" ")[1] : "1.7";
            }
        }
        try {
            if (comparator.compare("1.6.9", id) == 1 && (Objects.isNull(map) || Objects.isNull(map.get("client")))) {
                LogClient l;
                map = new HashMap<String, LogClient>();
                String message = "set logging %s version type %s, version id %s";
                if (comparator.compare("1.11.9", id) == -1) {
                    log.info(String.format(message, "1.7.10.json", id, version.getID()));
                    l = this.gson.fromJson((Reader)new InputStreamReader(FileUtil.getResourceAppStream("/fix_log4j/1.7.10.json")), LogClient.class);
                } else {
                    log.info(String.format(message, "1.12.json", id, version.getID()));
                    l = this.gson.fromJson((Reader)new InputStreamReader(FileUtil.getResourceAppStream("/fix_log4j/1.12.json")), LogClient.class);
                }
                map.put("client", l);
                version.setLogging(map);
                Path versionPath = MinecraftUtil.buildWorkingPath("versions", version.getID(), version.getID() + ".json");
                FileUtil.writeFile(versionPath.toFile(), this.gson.toJson(this.serializeVersion(version).getAsJsonObject()));
                this.saveVersion(version);
            }
        }
        catch (NumberFormatException e) {
            log.warn("can't patch fix log4j" + id);
        }
    }

    private void checkDoubleArgument(CompleteVersion version) throws IOException {
        Map<ArgumentType, List<Argument>> map = version.getArguments();
        if (Objects.nonNull(map)) {
            List<Argument> list = map.get((Object)ArgumentType.GAME);
            if (Objects.isNull(list)) {
                return;
            }
            if (list.size() > 30) {
                HashSet set = new HashSet();
                list.removeIf(e -> {
                    String value = Arrays.toString(e.getValues());
                    if (set.contains(value)) {
                        U.log("removed arg " + e);
                        return true;
                    }
                    set.add(value);
                    return false;
                });
                this.saveVersion(version);
            }
        }
    }

    private String findNewVersionName(String name, int i) {
        String newName = name + " fixed " + i;
        File f = new File(this.baseVersionsDir, newName);
        if (f.exists()) {
            return this.findNewVersionName(name, ++i);
        }
        return newName;
    }

    public synchronized void saveVersion(CompleteVersion version) throws IOException {
        this.fixedlog4j(version);
        Path versionPath = MinecraftUtil.buildWorkingPath("versions", version.getID(), version.getID() + ".json");
        Path modifiedVersionPath = MinecraftUtil.buildWorkingPath("versions", version.getID(), "TLauncherAdditional.json");
        ModifiedVersion mv = version.getModifiedVersion();
        if (Objects.nonNull(version.getRemoteVersion())) {
            FileUtil.writeFile(versionPath.toFile(), version.getRemoteVersion());
        } else if (Files.notExists(versionPath, new LinkOption[0]) || !ClientInstanceRepo.LOCAL_VERSION_REPO.equals(mv.getSource())) {
            FileUtil.writeFile(versionPath.toFile(), this.gson.toJson(this.serializeVersion(version).getAsJsonObject()));
        }
        mv.setSource(ClientInstanceRepo.LOCAL_VERSION_REPO);
        FileUtil.writeFile(modifiedVersionPath.toFile(), this.gson.toJson(mv));
    }

    public synchronized void deleteVersion(String id, boolean deleteLibraries) throws IOException {
        CompleteVersion version = this.getCompleteVersion(id);
        if (version == null) {
            throw new IllegalArgumentException("Version is not installed! id = " + id);
        }
        File dir = new File(this.baseVersionsDir, id + '/');
        if (!dir.isDirectory()) {
            throw new IOException("Cannot find directory: " + dir.getAbsolutePath());
        }
        FileUtil.deleteDirectory(dir);
        if (!deleteLibraries) {
            return;
        }
        for (File library : version.getClassPath(this.baseDirectory)) {
            FileUtil.deleteFile(library);
        }
        for (String nativeLib : version.getNatives()) {
            FileUtil.deleteFile(new File(this.baseDirectory, nativeLib));
        }
    }

    @Override
    protected InputStream getInputStream(String uri) throws IOException {
        return new FileInputStream(new File(this.baseDirectory, uri));
    }

    @Override
    public boolean hasAllFiles(CompleteVersion version, OS os) {
        Set<String> files = version.getRequiredFiles(os);
        for (String file : files) {
            File required = new File(this.baseDirectory, file);
            if (required.isFile() && required.length() != 0L) continue;
            return false;
        }
        return true;
    }

    public synchronized CompleteVersion renameVersion(CompleteVersion version, String name) throws IOException {
        File newFolder;
        CompleteVersion newVersion = version.fullCopy(new CompleteVersion());
        newVersion.setID(name);
        if (Objects.nonNull(version.getModpack())) {
            newVersion.getModpack().setName(name);
        }
        if ((newFolder = new File(this.baseVersionsDir.toString(), newVersion.getID())).exists()) {
            throw new IOException("folder exists " + newFolder);
        }
        String oldName = version.getID();
        File oldJar = new File(this.baseVersionsDir.toString(), version.getID() + "/" + version.getID() + ".jar");
        File newJar = new File(this.baseVersionsDir.toString(), version.getID() + "/" + newVersion.getID() + ".jar");
        if (oldJar.exists() && !oldJar.renameTo(newJar)) {
            throw new IOException("can't rename from " + oldJar + "to " + newJar);
        }
        File oldFolder = new File(this.baseVersionsDir.toString(), oldName);
        if (!oldFolder.renameTo(newFolder)) {
            throw new IOException("can't rename from " + version.getID() + "to " + newVersion.getID());
        }
        FileUtil.deleteFile(new File(this.baseVersionsDir.toString(), newVersion.getID() + "/" + version.getID() + ".json"));
        this.saveVersion(newVersion);
        return newVersion;
    }

    public synchronized void refreshLocalVersion(CompleteVersion version) throws IOException {
        this.saveVersion(version);
        version.setSource(ClientInstanceRepo.LOCAL_VERSION_REPO);
        version.setVersionList(this);
        this.byName.put(version.getID(), version);
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!((Version)this.versions.get(i)).getID().equalsIgnoreCase(version.getID())) continue;
            this.versions.remove(i);
            this.versions.add(i, version);
            return;
        }
    }
}

