/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.tlauncher.entity.TLauncherLib;

public class TLauncherVersionChanger {
    private Set<String> tlauncherSkinCapeVersion;
    private double version;
    private List<TLauncherLib> libraries;
    private List<TLauncherLib> additionalMods;
    public static final List<String> defaultVersionTypes = Lists.newArrayList((Object[])new String[]{"Forge", "OptiFine", "Fabric"});

    public List<TLauncherLib> getAddedMods(CompleteVersion v) {
        String id = this.getVersionIDForUserSkinCapeVersion(v);
        return this.additionalMods.stream().filter(l -> l.getSupports().contains(id)).collect(Collectors.toList());
    }

    public List<TLauncherLib> getAddedMods(CompleteVersion v, boolean tlSkinType) {
        return this.getAddedMods(v).stream().filter(l -> l.isProperAccountTypeLib(tlSkinType)).collect(Collectors.toList());
    }

    public String getVersionIDForUserSkinCapeVersion(CompleteVersion complete) {
        Optional<String> res;
        if (complete.isActivateSkinCapeForUserVersion() && Objects.nonNull(complete.getJar()) && (res = defaultVersionTypes.stream().filter(s -> StringUtils.containsIgnoreCase((CharSequence)complete.getID(), (CharSequence)s)).findFirst()).isPresent()) {
            return res.get() + " " + complete.getJar();
        }
        return complete.getID();
    }

    public Set<String> getTlauncherSkinCapeVersion() {
        return this.tlauncherSkinCapeVersion;
    }

    public double getVersion() {
        return this.version;
    }

    public List<TLauncherLib> getLibraries() {
        return this.libraries;
    }

    public List<TLauncherLib> getAdditionalMods() {
        return this.additionalMods;
    }

    public void setTlauncherSkinCapeVersion(Set<String> tlauncherSkinCapeVersion) {
        this.tlauncherSkinCapeVersion = tlauncherSkinCapeVersion;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public void setLibraries(List<TLauncherLib> libraries) {
        this.libraries = libraries;
    }

    public void setAdditionalMods(List<TLauncherLib> additionalMods) {
        this.additionalMods = additionalMods;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TLauncherVersionChanger)) {
            return false;
        }
        TLauncherVersionChanger other = (TLauncherVersionChanger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$tlauncherSkinCapeVersion = this.getTlauncherSkinCapeVersion();
        Set<String> other$tlauncherSkinCapeVersion = other.getTlauncherSkinCapeVersion();
        if (this$tlauncherSkinCapeVersion == null ? other$tlauncherSkinCapeVersion != null : !((Object)this$tlauncherSkinCapeVersion).equals(other$tlauncherSkinCapeVersion)) {
            return false;
        }
        if (Double.compare(this.getVersion(), other.getVersion()) != 0) {
            return false;
        }
        List<TLauncherLib> this$libraries = this.getLibraries();
        List<TLauncherLib> other$libraries = other.getLibraries();
        if (this$libraries == null ? other$libraries != null : !((Object)this$libraries).equals(other$libraries)) {
            return false;
        }
        List<TLauncherLib> this$additionalMods = this.getAdditionalMods();
        List<TLauncherLib> other$additionalMods = other.getAdditionalMods();
        return !(this$additionalMods == null ? other$additionalMods != null : !((Object)this$additionalMods).equals(other$additionalMods));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TLauncherVersionChanger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $tlauncherSkinCapeVersion = this.getTlauncherSkinCapeVersion();
        result = result * 59 + ($tlauncherSkinCapeVersion == null ? 43 : ((Object)$tlauncherSkinCapeVersion).hashCode());
        long $version = Double.doubleToLongBits(this.getVersion());
        result = result * 59 + (int)($version >>> 32 ^ $version);
        List<TLauncherLib> $libraries = this.getLibraries();
        result = result * 59 + ($libraries == null ? 43 : ((Object)$libraries).hashCode());
        List<TLauncherLib> $additionalMods = this.getAdditionalMods();
        result = result * 59 + ($additionalMods == null ? 43 : ((Object)$additionalMods).hashCode());
        return result;
    }

    public String toString() {
        return "TLauncherVersionChanger(tlauncherSkinCapeVersion=" + this.getTlauncherSkinCapeVersion() + ", version=" + this.getVersion() + ", libraries=" + this.getLibraries() + ", additionalMods=" + this.getAdditionalMods() + ")";
    }
}

