/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import by.gdev.http.download.service.GsonService;
import by.gdev.util.model.download.Repo;
import com.github.junrar.Archive;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import javax.inject.Named;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.tlauncher.exceptions.ParseModPackException;
import org.tlauncher.modpack.domain.client.ForgeVersionDTO;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameEntityDependencyDTO;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.PictureType;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;
import org.tlauncher.modpack.domain.client.ShaderpackDTO;
import org.tlauncher.modpack.domain.client.SubModpackDTO;
import org.tlauncher.modpack.domain.client.share.CategoryDTO;
import org.tlauncher.modpack.domain.client.share.DependencyType;
import org.tlauncher.modpack.domain.client.share.GameEntitySort;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.share.InfoMod;
import org.tlauncher.modpack.domain.client.share.MinecraftVersionDTO;
import org.tlauncher.modpack.domain.client.share.NameIdDTO;
import org.tlauncher.modpack.domain.client.share.ParsedElementDTO;
import org.tlauncher.modpack.domain.client.share.StateGameElement;
import org.tlauncher.modpack.domain.client.site.CommonPage;
import org.tlauncher.modpack.domain.client.version.MapMetadataDTO;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.modpack.domain.client.version.ModVersionDTO;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.InnerConfiguration;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.mods.GameEntityHandler;
import org.tlauncher.tlauncher.downloader.mods.MapDownloader;
import org.tlauncher.tlauncher.downloader.mods.UnzipEntityDownloader;
import org.tlauncher.tlauncher.entity.MinecraftInstance;
import org.tlauncher.tlauncher.exceptions.GameEntityNotFound;
import org.tlauncher.tlauncher.exceptions.RequiredRemoteVersionError;
import org.tlauncher.tlauncher.exceptions.RequiredTLAccountException;
import org.tlauncher.tlauncher.exceptions.SameMapFoldersException;
import org.tlauncher.tlauncher.exceptions.SelectedAnyOneTLAccountException;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionManagerListener;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftListener;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.rmo.DiscordStatus;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityAdapter;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.listener.mods.UpdateFavoriteValueListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.modpack.HandleInstallModpackElementFrame;
import org.tlauncher.tlauncher.ui.modpack.ModpackBackupFrame;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;

@Singleton
public class ModpackManager
implements VersionManagerListener,
MinecraftListener,
ItemListener {
    private final Map<GameType, List<GameEntityListener>> gameListeners = Collections.synchronizedMap(new HashMap<GameType, List<GameEntityListener>>(){
        {
            this.put(GameType.MAP, Collections.synchronizedList(new ArrayList()));
            this.put(GameType.MOD, Collections.synchronizedList(new ArrayList()));
            this.put(GameType.MODPACK, Collections.synchronizedList(new ArrayList()));
            this.put(GameType.RESOURCEPACK, Collections.synchronizedList(new ArrayList()));
            this.put(GameType.SHADERPACK, Collections.synchronizedList(new ArrayList()));
        }
    });
    private final File STATUS_MODPACK_FILE = FileUtil.getRelativeConfigFile("status.modpack");
    @Inject
    @Named(value="GsonCompleteVersion")
    private Gson gson;
    @Inject
    private TLauncher tLauncher;
    @Inject
    private CloseableHttpClient closeableHttpClient;
    @Inject
    private GsonService gsonService;
    @Inject
    @Named(value="anyVersionType")
    private NameIdDTO anyVersionType;
    private final InnerConfiguration innerConfiguration = TLauncher.getInnerSettings();
    private InfoMod infoMod;
    private Set<Long> statusModpackElement = new HashSet<Long>();
    private final AtomicBoolean addedVersionListener = new AtomicBoolean(false);
    private String modpackApiURL;
    @Inject
    private CloseableHttpClient client;
    @Inject
    private EventBus eventBus;
    @Inject
    private RequestConfig requestConfig;
    @Inject
    @Named(value="modpackExecutorService")
    private ExecutorService modpackExecutorService;
    private Map<GameType, List<CategoryDTO>> map = Collections.synchronizedMap(new HashMap());
    private List<NameIdDTO> minecraftVersionTypes = Collections.synchronizedList(new ArrayList());
    private Map<NameIdDTO, List<GameVersionDTO>> gameVersions = Collections.synchronizedMap(new HashMap());
    private Map<String, Set<Long>> favoriteGameEntityIds = Collections.synchronizedMap(new HashMap());

    public ModpackManager() {
        GameEntityAdapter listener = new GameEntityAdapter(){

            @Override
            public void installEntity(CompleteVersion e) {
                this.update();
            }

            private void update() {
                TLauncher.getInstance().getVersionManager().getLocalList().refreshVersions();
            }

            @Override
            public void removeCompleteVersion(CompleteVersion e) {
                this.update();
            }
        };
        this.gameListeners.get((Object)GameType.MODPACK).add(listener);
        this.modpackApiURL = this.innerConfiguration.get("modpack.operation.url");
    }

    private void log(Object ... s) {
        U.log("[Modpack] ", s);
    }

    public synchronized void loadInfo() {
        this.infoMod = new InfoMod();
        this.tLauncher.getFrame().mp.modpackScene.prepareView(this.getModpackVersions());
        this.eventBus.post((Object)DiscordStatus.TLMODS);
        if (!this.addedVersionListener.get()) {
            this.addedVersionListener.set(true);
            this.tLauncher.getVersionManager().addListener(this);
        }
        this.readStatusGameElement();
        if (!this.statusModpackElement.isEmpty()) {
            try {
                this.importUserGameEntities(this.statusModpackElement.stream().map(e -> {
                    GameEntityDTO d = new GameEntityDTO();
                    d.setId((Long)e);
                    return d;
                }).collect(Collectors.toList()));
                SwingUtilities.invokeLater(() -> Alert.showLocMessage("export.old.favorite.elements"));
            }
            catch (Throwable e2) {
                this.log("error", e2);
            }
        }
        this.getFavoriteGameEntities();
    }

    public void fillVersionTypesAndGameVersion() throws IOException {
        if (this.minecraftVersionTypes.size() < 2) {
            this.minecraftVersionTypes.addAll(this.getMinecraftVersionTypesRemote());
        }
        if (this.gameVersions.isEmpty()) {
            for (NameIdDTO nid : this.getMinecraftVersionTypes()) {
                List<GameVersionDTO> list = this.getGameVersionsRemote(nid);
                this.gameVersions.put(nid, list);
                if (!nid.getId().equals(1L)) continue;
                this.gameVersions.put(this.anyVersionType, list);
            }
        }
    }

    public void fillCategories() throws IOException {
        if (this.map.isEmpty()) {
            this.map.putAll((Map)this.gsonService.getObjectWithoutSaving(this.modpackApiURL + "client/categories", new TypeToken<Map<GameType, List<CategoryDTO>>>(){}.getType()));
        }
    }

    public DownloadableContainer getContainer(CompleteVersion version, boolean force) {
        DownloadableContainer container = new DownloadableContainer();
        Path versionFolder = ModpackUtil.getPathByVersion(version);
        if (version.getModpack() != null && version.getModpack().getVersion() != null) {
            Downloadable d;
            ModpackVersionDTO versionDTO = (ModpackVersionDTO)version.getModpack().getVersion();
            List<MetadataDTO> list = this.checkResources(versionDTO, force, versionFolder);
            for (MetadataDTO m : list) {
                m.setLocalDestination(new File(versionFolder.toFile(), m.getPath()));
                d = new Downloadable(ClientInstanceRepo.createModpackRepo(), m, force);
                container.add(d);
            }
            list = this.checkCompositeResources(versionDTO, force, versionFolder);
            for (MetadataDTO m : list) {
                m.setLocalDestination(new File(versionFolder.toFile(), m.getPath()));
                d = new MapDownloader(force, m);
                container.add(d);
            }
            if (Objects.nonNull(versionDTO.getAdditionalFile())) {
                MetadataDTO metadataDTO = versionDTO.getAdditionalFile();
                Path additionalFile = ModpackUtil.getPathByVersion(version, metadataDTO.getPath());
                metadataDTO.setLocalDestination(additionalFile.toFile());
                if (Files.notExists(additionalFile, new LinkOption[0]) || !metadataDTO.getSha1().equals(FileUtil.getChecksum(metadataDTO.getLocalDestination()))) {
                    container.add(new UnzipEntityDownloader(force, metadataDTO));
                }
            }
            container.addHandler(new GameEntityHandler());
        }
        return container;
    }

    private List<MetadataDTO> checkResources(ModpackVersionDTO version, boolean force, Path versionFolder) {
        this.log("check resources");
        ArrayList<MetadataDTO> list = new ArrayList<MetadataDTO>();
        for (ModDTO mod : version.getMods()) {
            if (mod.isUserInstall() || mod.getStateGameElement() == StateGameElement.NO_ACTIVE || !this.notExistOrCorrect(versionFolder, mod, force) || this.fillFromCache(GameType.MOD, mod, version, versionFolder)) continue;
            list.add(mod.getVersion().getMetadata());
        }
        for (ResourcePackDTO resourcePack : version.getResourcePacks()) {
            if (resourcePack.isUserInstall() || resourcePack.getStateGameElement() == StateGameElement.NO_ACTIVE || !this.notExistOrCorrect(versionFolder, resourcePack, force) || this.fillFromCache(GameType.RESOURCEPACK, resourcePack, version, versionFolder)) continue;
            list.add(resourcePack.getVersion().getMetadata());
        }
        for (ShaderpackDTO shader : version.getShaderpacks()) {
            if (shader.isUserInstall() || shader.getStateGameElement() == StateGameElement.NO_ACTIVE || !this.notExistOrCorrect(versionFolder, shader, force) || this.fillFromCache(GameType.SHADERPACK, shader, version, versionFolder)) continue;
            list.add(shader.getVersion().getMetadata());
        }
        return list;
    }

    private boolean notExistOrCorrect(Path versionFolder, GameEntityDTO e, boolean hash) {
        Path path = Paths.get(versionFolder.toString(), e.getVersion().getMetadata().getPath());
        if (Files.notExists(path, new LinkOption[0])) {
            return true;
        }
        if (hash) {
            return !FileUtil.getChecksum(path.toFile()).equals(e.getVersion().getMetadata().getSha1());
        }
        return false;
    }

    private List<MetadataDTO> checkCompositeResources(ModpackVersionDTO version, boolean force, Path versionFolder) {
        this.log("check CompositeResources");
        ArrayList<MetadataDTO> list = new ArrayList<MetadataDTO>();
        for (MapDTO map : version.getMaps()) {
            if (map.isUserInstall()) continue;
            list.add(map.getVersion().getMetadata());
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String folder;
            MetadataDTO meta = (MetadataDTO)it.next();
            U.debug(meta);
            if (((MapMetadataDTO)meta).getFolders() == null || ((MapMetadataDTO)meta).getFolders().size() == 0 || !new File(folder = versionFolder.toString() + "/saves/" + ((MapMetadataDTO)meta).getFolders().get(0)).exists()) continue;
            it.remove();
        }
        return list;
    }

    public void backupModPack(List<CompleteVersion> list, File saveFolder, ModpackBackupFrame.HandleListener handleListener) {
        AsyncThread.execute(() -> {
            this.log("backuping modpack");
            File versionFolder = FileUtil.getRelative("versions").toFile();
            ArrayList<File> files = new ArrayList<File>();
            for (CompleteVersion v : list) {
                File version = new File(versionFolder, v.getID());
                files.addAll(this.findCopiedFiles(v, version));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            ArrayList<String> names = new ArrayList<String>();
            for (CompleteVersion v : list) {
                map.put(v.getID() + ".json", this.gson.toJson(v));
                names.add(v.getID());
            }
            try {
                if (saveFolder.exists() && !saveFolder.delete()) {
                    throw new IOException("can't delete old version of the file");
                }
                FileUtil.backupModpacks(map, files, versionFolder.toPath(), saveFolder, names);
                handleListener.operationSuccess();
            }
            catch (IOException e) {
                this.log(e);
                handleListener.processError(e);
            }
        });
    }

    private List<File> findCopiedFiles(CompleteVersion completeVersion, File version) {
        IOFileFilter filter = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter("natives"), FileFilterUtils.nameFileFilter(FileUtil.GameEntityFolder.SAVES.toString()), FileFilterUtils.nameFileFilter(FileUtil.GameEntityFolder.MODS.toString()), FileFilterUtils.nameFileFilter(FileUtil.GameEntityFolder.RESOURCEPACKS.toString())));
        IOFileFilter filesFilter = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter(completeVersion.getID() + ".jar"), FileFilterUtils.nameFileFilter(completeVersion.getID() + ".jar.bak")));
        List list = (List)FileUtils.listFiles(version, filesFilter, filter);
        if (TLauncher.DEBUG) {
            U.log("filter by IOFileFilter");
            for (File f : list) {
                U.log(f);
            }
        }
        ModpackVersionDTO modpackVersion = (ModpackVersionDTO)completeVersion.getModpack().getVersion();
        for (GameEntityDTO gameEntityDTO : modpackVersion.getMaps()) {
            File map = new File(version, "saves/" + FilenameUtils.getBaseName(gameEntityDTO.getVersion().getMetadata().getPath()));
            if (!map.exists()) continue;
            list.addAll(FileUtils.listFiles(map, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE));
        }
        for (SubModpackDTO subModpackDTO : modpackVersion.getMods()) {
            if (!subModpackDTO.isUserInstall()) continue;
            this.addToList(version, list, subModpackDTO);
        }
        for (SubModpackDTO subModpackDTO : modpackVersion.getResourcePacks()) {
            if (!subModpackDTO.isUserInstall()) continue;
            this.addToList(version, list, subModpackDTO);
        }
        if (TLauncher.DEBUG) {
            U.log("backed files");
            for (File file : list) {
                U.log(file);
            }
        }
        return list;
    }

    private void addToList(File version, List<File> list, SubModpackDTO en) {
        if (en.getStateGameElement() == StateGameElement.NO_ACTIVE) {
            list.add(new File(version, en.getVersion().getMetadata().getPath() + ".deactivation"));
        } else {
            list.add(new File(version, en.getVersion().getMetadata().getPath()));
        }
    }

    public void installModPack(File file, ModpackBackupFrame.HandleListener handleListener) {
        AsyncThread.execute(() -> {
            this.log("installModPack");
            File versionFolder = FileUtil.getRelative("versions").toFile();
            try {
                List<String> modpackNames = this.analizeArchiver(file);
                FileUtil.unzipUniversal(file, versionFolder);
                for (String name : modpackNames) {
                    File modPackFolder = new File(versionFolder, name);
                    File fileVersion = new File(modPackFolder, name + ".json");
                    CompleteVersion version = Files.notExists(fileVersion.toPath(), new LinkOption[0]) ? this.parseCurse(versionFolder, name, modPackFolder, fileVersion) : this.gson.fromJson(FileUtil.readFile(fileVersion), CompleteVersion.class);
                    for (GameEntityListener listener : this.gameListeners.get((Object)GameType.MODPACK)) {
                        listener.installEntity(version);
                    }
                }
                handleListener.installedSuccess(modpackNames);
            }
            catch (Exception e) {
                U.log(e);
                handleListener.processError(e);
            }
        });
    }

    private CompleteVersion parseCurse(File versionFolder, String modpackName, File modPackFolder, File version) throws Exception {
        File instance = new File(modPackFolder, "minecraftinstance.json");
        if (Files.exists(instance.toPath(), new LinkOption[0])) {
            MinecraftInstance minecraftInstance;
            File mods = new File(modPackFolder, "mods");
            File resourcepacks = new File(modPackFolder, "resourcepacks");
            File maps = new File(modPackFolder, "saves");
            if (!(Files.exists(mods.toPath(), new LinkOption[0]) || Files.exists(resourcepacks.toPath(), new LinkOption[0]) || Files.exists(maps.toPath(), new LinkOption[0]))) {
                this.log("modpack doesn't exist");
            }
            if ((minecraftInstance = this.gson.fromJson(FileUtil.readFile(instance), MinecraftInstance.class)) == null) {
                throw new Exception("broken config");
            }
            ModpackDTO modPack = new ModpackDTO();
            modPack.setId(-U.n());
            ModpackVersionDTO modpackVersion = new ModpackVersionDTO();
            String[] formats = new String[]{"jar", "zip"};
            CompleteVersion completeVersion = this.gson.fromJson(minecraftInstance.baseModLoader.VersionJson, CompleteVersion.class);
            ForgeVersionDTO fv = new ForgeVersionDTO();
            fv.setName(completeVersion.getID());
            modpackVersion.setForgeVersionDTO(fv);
            GameVersionDTO gv = new GameVersionDTO();
            gv.setName(minecraftInstance.baseModLoader.MinecraftVersion);
            modpackVersion.setGameVersionDTO(gv);
            completeVersion.setID(modpackName);
            modPack.setName(completeVersion.getID());
            modpackVersion.setId(-U.n() - 1L);
            modpackVersion.setName("1.0");
            modpackVersion.setMods(this.createHandleGameEntities(mods, formats, ModDTO.class));
            modpackVersion.setResourcePacks(this.createHandleGameEntities(resourcepacks, formats, ResourcePackDTO.class));
            modpackVersion.setMaps(this.createMapsByFolder(maps));
            modPack.setVersion(modpackVersion);
            completeVersion.setModpackDTO(modPack);
            FileUtil.writeFile(version, this.gson.toJson(completeVersion));
            return completeVersion;
        }
        throw new Exception("dont' find config file");
    }

    private List<MapDTO> createMapsByFolder(File maps) {
        ArrayList<MapDTO> list = new ArrayList<MapDTO>();
        FilenameFilter filter = (dir, name) -> dir.isDirectory();
        for (File file : Objects.requireNonNull(maps.listFiles(filter))) {
            MapDTO map = new MapDTO();
            VersionDTO v = new VersionDTO();
            v.setName("1.0");
            MetadataDTO meta = new MetadataDTO();
            meta.setPath(FileUtil.GameEntityFolder.getPath(GameType.MAP) + "/" + file.getName() + ".zip");
            v.setMetadata(meta);
            map.setUserInstall(true);
            map.setName(file.getName());
            map.setVersion(v);
            list.add(map);
        }
        return list;
    }

    public List<String> analizeArchiver(File file) throws ParseModPackException {
        try {
            String ext = FilenameUtils.getExtension(file.getCanonicalPath());
            List<String> list = new ArrayList<String>();
            switch (ext) {
                case "rar": {
                    list = FileUtil.topFolders(new Archive(file));
                    break;
                }
                case "zip": {
                    list = FileUtil.topFolders(new ZipFile(file));
                }
            }
            if (list.isEmpty()) {
                throw new ParseModPackException("The archive doesn't contain any folders");
            }
            if (!this.checkNameVersion(list)) {
                throw new ParseModPackException("there is a version with same name");
            }
            return list;
        }
        catch (Exception e) {
            this.log("error during analize archiver " + file);
            throw new ParseModPackException(e);
        }
    }

    public boolean checkNameVersion(List<String> list) {
        for (String s : list) {
            if (!Objects.nonNull(this.tLauncher.getVersionManager().getVersionSyncInfo(s))) continue;
            return false;
        }
        return true;
    }

    private List<? extends GameEntityDTO> createHandleGameEntities(File folder, String[] exts, Class<? extends GameEntityDTO> t) {
        ArrayList<GameEntityDTO> list = new ArrayList<GameEntityDTO>();
        List files = (List)FileUtils.listFiles(folder, exts, true);
        for (File f : files) {
            try {
                GameEntityDTO c = this.createHandleGameEntity(folder, t, f);
                list.add(c);
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.log(e);
            }
        }
        return list;
    }

    private GameEntityDTO createHandleGameEntity(File folder, Class<? extends GameEntityDTO> t, File f) throws InstantiationException, IllegalAccessException {
        GameEntityDTO c = t.newInstance();
        c.setId(-U.n());
        c.setName(FilenameUtils.getBaseName(f.getName()));
        c.setUserInstall(true);
        MetadataDTO meta = FileUtil.createMetadata(f, folder, t);
        meta.setPath(FileUtil.GameEntityFolder.getPath(t, true).concat(meta.getPath()));
        meta.setUrl(FileUtil.GameEntityFolder.getPath(t, true).concat(meta.getUrl()));
        VersionDTO standardVersion = new VersionDTO();
        standardVersion.setId(-U.n());
        standardVersion.setName("1.0");
        standardVersion.setMetadata(meta);
        c.setVersion(standardVersion);
        return c;
    }

    public void createModpack(String name, ModpackDTO modpackDTO, boolean usedSkin) {
        try {
            ModDTO m;
            ModpackVersionDTO mvd = (ModpackVersionDTO)modpackDTO.getVersion();
            CompleteVersion completeVersion = this.getCompleteVersionByMinecraftVersionTypeAndId(mvd.findFirstMinecraftVersionType(), mvd.getMinecraftVersionName());
            completeVersion.setID(name);
            completeVersion.setModpackDTO(modpackDTO);
            this.tLauncher.getVersionManager().getLocalList().saveVersion(completeVersion);
            for (GameEntityListener l : this.gameListeners.get((Object)GameType.MODPACK)) {
                l.installEntity(completeVersion);
                l.installEntity(completeVersion.getModpack(), GameType.MODPACK);
            }
            if (usedSkin) {
                this.installTLSkinCapeMod(mvd);
            }
            if (mvd.getMinecraftVersionTypes().stream().filter(f -> f.getId().equals(2L)).findAny().isPresent()) {
                m = new ModDTO();
                m.setId(ModDTO.FABRIC_API_ID);
                this.installEntity(m, null, GameType.MOD, null, true);
            } else if (mvd.getMinecraftVersionTypes().stream().filter(f -> f.getId().equals(4L)).findAny().isPresent()) {
                m = new ModDTO();
                m.setId(ModDTO.QUILTED_FABRIC_API_ID);
                this.installEntity(m, null, GameType.MOD, null, true);
            }
        }
        catch (IOException e) {
            U.log(e);
        }
    }

    public void installTLSkinCapeMod(ModpackVersionDTO mvd) {
        ModDTO m = new ModDTO();
        m.setId(ModDTO.TL_SKIN_CAPE_ID);
        this.installEntity(m, null, GameType.MOD, null, false);
    }

    public CompleteVersion getCompleteVersionByMinecraftVersionTypeAndId(NameIdDTO type, NameIdDTO version) throws IOException, RequiredRemoteVersionError {
        MinecraftVersionDTO minecraftVersion = this.getCompleteVersion(type, version);
        try {
            CompleteVersion completeVersion = this.gson.fromJson(minecraftVersion.getValue(), CompleteVersion.class);
            completeVersion = completeVersion.resolve(this.tLauncher.getVersionManager(), true);
            if (Objects.isNull(completeVersion)) {
                this.tLauncher.getVersionManager().asyncRefresh();
                throw new RequiredRemoteVersionError();
            }
            TlauncherUtil.processRemoteVersionToSave(completeVersion, minecraftVersion.getValue(), this.gson);
            return completeVersion;
        }
        catch (NullPointerException e) {
            U.log(" type " + Objects.isNull(type));
            U.log(" version " + Objects.isNull(version));
            U.log(" minecraftVersion " + minecraftVersion);
            U.log("error request " + minecraftVersion.getValue() + " " + type.toString() + " " + version.toString());
            throw e;
        }
    }

    private void addEntityToModpack(GameEntityDTO gameEntity, CompleteVersion completeVersion, GameType type) throws IOException {
        ModpackDTO modPack = completeVersion.getModpack();
        ModpackVersionDTO modpackVersion = (ModpackVersionDTO)modPack.getVersion();
        if (modpackVersion == null) {
            modpackVersion = new ModpackVersionDTO();
            modpackVersion.setMaps(new ArrayList<MapDTO>());
            modpackVersion.setMods(new ArrayList<ModDTO>());
            modpackVersion.setResourcePacks(new ArrayList<ResourcePackDTO>());
            modPack.setVersion(modpackVersion);
        }
        try {
            GameEntityDTO removedEntity = this.findAndRemoveGameEntity(completeVersion, gameEntity, type);
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.removeEntity(removedEntity);
            }
        }
        catch (GameEntityNotFound gameEntityNotFound) {
            // empty catch block
        }
        modpackVersion.add(type, gameEntity);
    }

    private boolean checkAddedElement(VersionDTO version, GameType type, GameEntityDTO entity) {
        ModpackVersionDTO v = (ModpackVersionDTO)version;
        if (v != null && type != GameType.MODPACK) {
            for (GameEntityDTO gameEntityDTO : v.getByType(type)) {
                if (!gameEntityDTO.getId().equals(entity.getId())) continue;
                return false;
            }
        }
        return true;
    }

    public void showFullGameEntity(GameEntityDTO entity, GameType type) {
        CompletableFuture.runAsync(() -> {
            ModpackManager modpackManager = this;
            synchronized (modpackManager) {
                try {
                    MainPane mp = this.tLauncher.getFrame().mp;
                    GameEntityDTO ge = this.getGameEntity(type, entity.getId());
                    Configuration configuration = TLauncher.getInstance().getConfiguration();
                    if (!this.isAllowShowByAdult(ge, configuration)) {
                        return;
                    }
                    if (type == GameType.MODPACK) {
                        mp.modpackEnitityScene.showModpackEntity(ge);
                    } else {
                        mp.completeSubEntityScene.showFullGameEntity(ge, type);
                    }
                }
                catch (SocketTimeoutException e) {
                    Alert.showLocError("modpack.internet.update");
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(() -> {
                        U.log(e);
                        Alert.showError("", Localizable.get("modpack.remote.not.found", Localizable.get("modpack.try.later")), null);
                    });
                }
            }
        }, this.modpackExecutorService).exceptionally(e -> {
            U.log(e);
            return null;
        });
    }

    private boolean isAllowShowByAdult(GameEntityDTO ge, Configuration configuration) {
        if (Boolean.TRUE.equals(ge.getAdult())) {
            if (configuration.getBoolean("adult")) {
                return true;
            }
            int num = Alert.showErrorMessage(Localizable.get("adult.title"), Localizable.get("adult"), Localizable.get("adult.yes"), Localizable.get("adult.no"));
            if (num == 0) {
                configuration.set("adult", (Object)"true");
                return true;
            }
            return false;
        }
        return true;
    }

    public void showSubModpackElement(GameEntityDTO entity, GameEntityDTO parent, GameType type) throws IOException {
        GameEntityDTO entity1 = this.getGameEntity(type, entity.getId());
        if (entity1 == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.tLauncher.getFrame().mp.completeSubEntityScene.showModpackElement(entity1, type));
    }

    public <T> T readFromServer(Class<T> t, GameEntityDTO e, VersionDTO version) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", e.getId());
        map.put("versionId", version.getId());
        String res = Http.performGet(this.innerConfiguration.get("modpack.operation.url") + "read/" + t.getSimpleName().toLowerCase(), map, U.getConnectionTimeout(), this.innerConfiguration.getInteger("modpack.update.time.connect"));
        return this.gson.fromJson(res, t);
    }

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        if (!manager.isLocalRefresh()) {
            this.loadInfo();
        }
    }

    private void processGameElementByStatus() {
        this.readStatusGameElement();
    }

    private void readStatusGameElement() {
        try {
            if (this.STATUS_MODPACK_FILE.exists()) {
                HashSet set = (HashSet)this.gson.fromJson(FileUtil.readFile(this.STATUS_MODPACK_FILE), new TypeToken<HashSet<Long>>(){}.getType());
                if (Objects.nonNull(set)) {
                    this.statusModpackElement.addAll(set);
                }
            } else {
                this.writeStatusGameElement();
            }
        }
        catch (JsonSyntaxException | IOException e) {
            U.log(e);
            this.writeStatusGameElement();
        }
    }

    private void writeStatusGameElement() {
        try {
            FileUtil.writeFile(this.STATUS_MODPACK_FILE, this.gson.toJson(this.statusModpackElement));
        }
        catch (IOException e1) {
            U.log(e1);
        }
    }

    public synchronized InfoMod getInfoMod() {
        return this.infoMod;
    }

    private List<CompleteVersion> getModpackVersions() {
        return Lists.newArrayList(this.tLauncher.getVersionManager().getLocalList().getVersions()).stream().filter(e -> {
            CompleteVersion cv = (CompleteVersion)e;
            return cv.isModpack();
        }).map(e -> (CompleteVersion)e).collect(Collectors.toList());
    }

    public void changeModpackElementState(GameEntityDTO entity, GameType type) {
        CompleteVersion completeVersion = this.tLauncher.getFrame().mp.modpackScene.getSelectedCompleteVersion();
        ModpackVersionDTO versionDTO = (ModpackVersionDTO)completeVersion.getModpack().getVersion();
        Optional<GameEntityDTO> op = versionDTO.getByType(type).stream().filter(e -> e.getId().equals(entity.getId())).findFirst();
        if (!op.isPresent()) {
            return;
        }
        SubModpackDTO en = (SubModpackDTO)op.get();
        AsyncThread.execute(() -> {
            for (GameEntityListener gameEntityListener : this.gameListeners.get((Object)type)) {
                gameEntityListener.activationStarted(en);
            }
            try {
                switch (type) {
                    case SHADERPACK: {
                        for (ShaderpackDTO shaderpackDTO : versionDTO.getShaderpacks()) {
                            if (shaderpackDTO.getId().equals(en.getId()) || shaderpackDTO.getStateGameElement() != StateGameElement.ACTIVE) continue;
                            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                                shaderpackDTO.setStateGameElement(StateGameElement.NO_ACTIVE);
                                l.activation(shaderpackDTO);
                            }
                        }
                        Object command = "";
                        if (en.getStateGameElement() == StateGameElement.ACTIVE) {
                            en.setStateGameElement(StateGameElement.NO_ACTIVE);
                        } else {
                            en.setStateGameElement(StateGameElement.ACTIVE);
                            command = FileUtil.getFilename(en.getVersion().getMetadata().getPath());
                        }
                        ModpackUtil.addOrReplaceShaderConfig(completeVersion, "shaderPack", (String)command);
                        for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                            l.activation(en);
                        }
                        break;
                    }
                    case MOD: 
                    case RESOURCEPACK: {
                        this.changeActivation(en, type, completeVersion);
                        if (en.getDependencies() == null || en.getStateGameElement() != StateGameElement.ACTIVE) break;
                        for (GameEntityDependencyDTO d : en.getDependencies()) {
                            Optional<GameEntityDTO> optional;
                            if (d.getDependencyType() != DependencyType.REQUIRED || !(optional = versionDTO.getByType(type).stream().filter(e -> e.getId().equals(d.getGameEntityId())).filter(e -> ((SubModpackDTO)e).getStateGameElement() == StateGameElement.NO_ACTIVE).findFirst()).isPresent()) continue;
                            this.changeActivation((SubModpackDTO)optional.get(), d.getGameType(), completeVersion);
                        }
                        break;
                    }
                    default: {
                        this.log(new Object[]{"strange type of ", type, "for entity ", entity});
                    }
                }
                for (GameEntityListener gameEntityListener : this.gameListeners.get((Object)GameType.MODPACK)) {
                    gameEntityListener.updateVersion(completeVersion, completeVersion);
                }
                this.tLauncher.getVersionManager().getLocalList().refreshLocalVersion(completeVersion);
            }
            catch (Exception e2) {
                this.log(e2);
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.activationError(entity, e2);
                }
            }
        });
    }

    private void changeActivation(SubModpackDTO entity, GameType type, CompleteVersion completeVersion) throws IOException {
        File modpackFolder = FileUtil.getRelative("versions/" + completeVersion.getID()).toFile();
        try {
            File target = new File(modpackFolder, entity.getVersion().getMetadata().getPath());
            if (entity.getStateGameElement() == StateGameElement.ACTIVE) {
                Files.move(target.toPath(), Paths.get(target.toString() + ".deactivation", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(Paths.get(target.toString() + ".deactivation", new String[0]), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (NoSuchFileException e) {
            this.log((Object)((Object)entity.getStateGameElement()) + " ", e.getMessage());
        }
        if (entity.getStateGameElement() == StateGameElement.NO_ACTIVE) {
            entity.setStateGameElement(StateGameElement.ACTIVE);
        } else {
            entity.setStateGameElement(StateGameElement.NO_ACTIVE);
        }
        for (GameEntityListener l : this.gameListeners.get((Object)type)) {
            l.activation(entity);
        }
    }

    public synchronized void installEntity(GameEntityDTO e, VersionDTO version, GameType type, GameVersionDTO gameVersion, boolean throwError) {
        block12: {
            if (type != GameType.MODPACK && !this.tLauncher.getFrame().mp.modpackScene.isSelectedCompleteVersion()) {
                Alert.showLocMessage("modpack.select.modpack");
                return;
            }
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.processingStarted(e, version);
            }
            try {
                GameEntityDTO gameEntity = null;
                if (GameType.MODPACK.equals((Object)type)) {
                    ModpackDTO installed = new ModpackDTO();
                    installed.setId(e.getId());
                    installed.setName(e.getName());
                    ModpackVersionDTO mv = this.getInstallingModpackVersionDTO(e, version);
                    installed.setVersion(mv);
                    CompleteVersion cv = this.getCompleteVersionByMinecraftVersionTypeAndId(mv.findFirstMinecraftVersionType(), mv.getMinecraftVersionName()).resolve(this.tLauncher.getVersionManager(), true);
                    cv.setID(installed.getName() + " " + installed.getVersion().getName());
                    cv.setModpackDTO(installed);
                    gameEntity = installed;
                    this.tLauncher.getVersionManager().getLocalList().saveVersion(cv);
                    SwingUtilities.invokeLater(() -> {
                        for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                            l.installEntity(cv);
                        }
                    });
                } else {
                    CompleteVersion completeVersion = this.tLauncher.getFrame().mp.modpackScene.getSelectedCompleteVersion();
                    ModpackVersionDTO mv = (ModpackVersionDTO)completeVersion.getModpack().getVersion();
                    gameEntity = Objects.isNull(version) ? this.getInstallingGameEntity(type, e, null, this.getGameVersion(mv), mv.findFirstMinecraftVersionType()) : this.getInstallingGameEntity(type, e, version, null, null);
                    if (ModDTO.TL_SKIN_CAPE_ID.equals(gameEntity.getId())) {
                        completeVersion.setSkinVersion(true);
                    }
                    this.checkMapFolders(completeVersion, gameEntity, type);
                    this.addDependencies(gameEntity, completeVersion);
                    if (type == GameType.SHADERPACK) {
                        this.preInstallingShader(type, gameEntity, completeVersion);
                    }
                    this.addEntityToModpack(gameEntity, completeVersion, type);
                    this.resaveVersion(completeVersion);
                }
                GameEntityDTO gamEntityDTO2 = gameEntity;
                SwingUtilities.invokeLater(() -> {
                    for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                        l.installEntity(gamEntityDTO2, type);
                    }
                });
            }
            catch (IOException e1) {
                U.log(e1);
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.installError(e, version, e1);
                }
                if (e1 instanceof RequiredRemoteVersionError) {
                    Alert.showLocWarning("\u041d\u0435 \u0441\u043c\u043e\u0433\u043b\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0431\u0430\u0437\u043e\u0432\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u0434\u043b\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438, \u043d\u0430\u0447\u0430\u0442\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439, \u043a\u0430\u043a \u043e\u043d\u043e \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u0442\u044c\u0441\u044f \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430!");
                }
                if (!throwError) break block12;
                Alert.showLocMessage("", "modpack.try.later", null);
            }
            catch (SameMapFoldersException e1) {
                Alert.showLocWarning("modpack.map.same.folder");
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.installError(e, version, e1);
                }
            }
        }
    }

    private void preInstallingShader(GameType type, GameEntityDTO installEntity, CompleteVersion completeVersion) throws IOException {
        List<ShaderpackDTO> shaderpacks = ((ModpackVersionDTO)completeVersion.getModpack().getVersion()).getShaderpacks();
        for (ShaderpackDTO d : shaderpacks) {
            d.setStateGameElement(StateGameElement.NO_ACTIVE);
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.activation(d);
            }
        }
        ModpackUtil.addOrReplaceShaderConfig(completeVersion, "shaderPack", FileUtil.getFilename(installEntity.getVersion().getMetadata().getPath()));
    }

    private void checkMapFolders(CompleteVersion completeVersion, GameEntityDTO installEntity, GameType type) throws SameMapFoldersException {
        if (type != GameType.MAP) {
            return;
        }
        List<String> remoteFolders = ((MapMetadataDTO)installEntity.getVersion().getMetadata()).getFolders();
        for (MapDTO mapDTO : ((ModpackVersionDTO)completeVersion.getModpack().getVersion()).getMaps()) {
            List<String> folders = ((MapMetadataDTO)mapDTO.getVersion().getMetadata()).getFolders();
            if (folders == null || remoteFolders == null || Collections.disjoint(folders, remoteFolders)) continue;
            throw new SameMapFoldersException(String.format("maps have same folders local: %s remote: %s", folders.toString(), remoteFolders.toString()));
        }
    }

    public void installEntity(GameEntityDTO e, VersionDTO version, GameType type, boolean async) {
        if (async) {
            CompletableFuture.runAsync(() -> this.installEntity(e, version, type, null, true), this.modpackExecutorService).exceptionally(t -> {
                U.log("error", t);
                return null;
            });
        } else {
            this.installEntity(e, version, type, null, true);
        }
    }

    private void addDependencies(GameEntityDTO e, CompleteVersion version) throws IOException {
        List<GameEntityDependencyDTO> list = e.getDependencies();
        if (list == null || list.size() == 0) {
            return;
        }
        ModpackVersionDTO mv = (ModpackVersionDTO)version.getModpack().getVersion();
        for (GameEntityDependencyDTO d : list) {
            if (d.getDependencyType() == DependencyType.INCOMPATIBLE || d.getDependencyType() == DependencyType.OPTIONAL || e.getId().equals(d.getGameEntityId())) continue;
            GameEntityDTO dto = new GameEntityDTO();
            dto.setId(d.getGameEntityId());
            if (Objects.nonNull(this.findGameFromCollection(dto, d.getGameType(), mv))) {
                this.log("it has already added  " + dto.getId());
                continue;
            }
            try {
                dto = this.getInstallingGameEntity(d.getGameType(), dto, null, this.getGameVersion(mv), mv.findFirstMinecraftVersionType());
            }
            catch (IOException ex) {
                if (StringUtils.contains((CharSequence)ex.getMessage(), (CharSequence)"404")) {
                    this.log(String.format("can't resolve dependency for game entity %s, dependency id %s name %s", e.getName(), d.getGameEntityId(), d.getName()));
                    continue;
                }
                throw ex;
            }
            this.addEntityToModpack(dto, version, d.getGameType());
            for (GameEntityListener l : this.gameListeners.get((Object)d.getGameType())) {
                l.installEntity(dto, d.getGameType());
            }
            this.addDependencies(dto, version);
        }
    }

    public void installHandleEntity(File[] files, CompleteVersion completeVersion, GameType type, HandleInstallModpackElementFrame.HandleListener handleListener) {
        Path folder = FileUtil.getRelative("versions/" + completeVersion.getID() + "/" + FileUtil.GameEntityFolder.getPath(type));
        folder.toFile().mkdir();
        try {
            ArrayList<GameEntityDTO> list = new ArrayList<GameEntityDTO>();
            for (File f : files) {
                GameEntityDTO entity = this.initHanldeEntity(type, f, folder);
                Path target = Paths.get(folder.toString(), f.getName());
                if (!this.checkAddedElement(completeVersion.getModpack().getVersion(), type, entity)) {
                    throw new ParseModPackException("entity exists" + entity);
                }
                Files.copy(f.toPath(), target, new CopyOption[0]);
                if (type == GameType.MAP) {
                    FileUtil.unzipUniversal(target.toFile(), target.toFile().getParentFile());
                    FileUtil.deleteFile(target.toFile());
                } else if (type == GameType.SHADERPACK) {
                    this.preInstallingShader(GameType.SHADERPACK, entity, completeVersion);
                }
                this.addEntityToModpack(entity, completeVersion, type);
                list.add(entity);
            }
            for (GameEntityDTO entity : list) {
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.installEntity(entity, type);
                }
            }
            this.resaveVersion(completeVersion);
            handleListener.installedSuccess();
        }
        catch (Exception e) {
            U.log(e);
            handleListener.processError(e);
        }
    }

    private GameEntityDTO initHanldeEntity(GameType type, File f, Path folder) throws ParseModPackException {
        SubModpackDTO entity;
        VersionDTO versionDTO = new VersionDTO();
        switch (type) {
            case MOD: {
                ModDTO modDTO = new ModDTO();
                ModVersionDTO modVersionDTO = new ModVersionDTO();
                modVersionDTO.setIncompatibleMods(new ArrayList<String>());
                modVersionDTO.setIncompatibleMods(new ArrayList<String>());
                versionDTO = modVersionDTO;
                entity = modDTO;
                break;
            }
            case MAP: {
                entity = new MapDTO();
                break;
            }
            case RESOURCEPACK: {
                entity = new ResourcePackDTO();
                break;
            }
            case SHADERPACK: {
                entity = new ShaderpackDTO();
                break;
            }
            default: {
                throw new ParseModPackException("not proper type");
            }
        }
        entity.setId(-U.n());
        versionDTO.setId(-U.n() - 1L);
        entity.setVersion(versionDTO);
        entity.setStateGameElement(StateGameElement.ACTIVE);
        entity.setName(FilenameUtils.getBaseName(f.getName()));
        entity.setUserInstall(true);
        VersionDTO v = new VersionDTO();
        v.setName("1.0");
        MetadataDTO meta = new MetadataDTO();
        if (type == GameType.MAP) {
            MapMetadataDTO mapMetadata = new MapMetadataDTO();
            mapMetadata.setFolders(this.analizeArchiver(f));
            meta = mapMetadata;
        }
        if (type == GameType.MAP) {
            meta.setPath("saves/" + f.getName());
        } else {
            meta.setPath(type.toString() + "s/" + f.getName());
        }
        v.setMetadata(meta);
        entity.setVersion(v);
        return entity;
    }

    public synchronized void removeEntity(GameEntityDTO entity, VersionDTO versionDTO, GameType type) {
        for (GameEntityListener l : this.gameListeners.get((Object)type)) {
            l.processingStarted(entity, versionDTO);
        }
        try {
            GameEntityDTO removedEntity = entity;
            switch (type) {
                case MODPACK: {
                    CompleteVersion version = this.tLauncher.getFrame().mp.modpackScene.getCompleteVersion((ModpackDTO)entity, versionDTO);
                    if (Objects.isNull(version)) {
                        return;
                    }
                    this.tLauncher.getVersionManager().getLocalList().deleteVersion(version.getID(), false);
                    for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                        l.removeCompleteVersion(version);
                    }
                    this.tLauncher.getVersionManager().getLocalList().refreshVersions();
                    removedEntity = version.getModpack();
                    break;
                }
                case MOD: 
                case MAP: 
                case RESOURCEPACK: 
                case SHADERPACK: {
                    removedEntity = this.findAndRemoveGameEntity(this.tLauncher.getFrame().mp.modpackScene.getSelectedCompleteVersion(), entity, type);
                }
            }
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.removeEntity(removedEntity);
            }
        }
        catch (Throwable e) {
            U.log(e);
            SwingUtilities.invokeLater(() -> {
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.installError(entity, versionDTO, e);
                }
            });
        }
    }

    public void removeEntity(GameEntityDTO entity, VersionDTO versionDTO, GameType type, boolean sync) {
        this.removeEntity(entity, versionDTO, type);
    }

    private GameEntityDTO findAndRemoveGameEntity(CompleteVersion selected, GameEntityDTO entity, GameType type) throws IOException, GameEntityNotFound {
        ModpackVersionDTO versionDTO = (ModpackVersionDTO)selected.getModpack().getVersion();
        GameEntityDTO current = this.findGameFromCollection(entity, type, versionDTO);
        if (current != null) {
            MetadataDTO meta = current.getVersion().getMetadata();
            File removedFile = null;
            File removedFileDeactivated = null;
            switch (type) {
                case MOD: 
                case RESOURCEPACK: 
                case SHADERPACK: {
                    removedFile = FileUtil.getRelative("versions/" + selected.getID() + "/" + meta.getPath()).toFile();
                    removedFileDeactivated = FileUtil.getRelative("versions/" + selected.getID() + "/" + meta.getPath() + ".deactivation").toFile();
                    break;
                }
                case MAP: {
                    removedFile = FileUtil.getRelative("versions/" + selected.getID() + FilenameUtils.removeExtension(meta.getPath())).toFile();
                }
            }
            if (removedFile != null) {
                FileUtil.deleteFile(removedFile);
            }
            if (removedFileDeactivated != null) {
                FileUtil.deleteFile(removedFileDeactivated);
            }
            versionDTO.getByType(type).remove(current);
            if (ModDTO.SKIN_MODS.contains(current.getId())) {
                selected.setSkinVersion(false);
            }
            this.tLauncher.getVersionManager().getLocalList().refreshLocalVersion(selected);
            return current;
        }
        throw new GameEntityNotFound("can't find in complete version: " + selected.getID() + " gameEntity: " + entity.getName());
    }

    private GameEntityDTO findGameFromCollection(GameEntityDTO entity, GameType type, ModpackVersionDTO versionDTO) {
        for (GameEntityDTO gameEntityDTO : versionDTO.getByType(type)) {
            if (!entity.getId().equals(gameEntityDTO.getId())) continue;
            return gameEntityDTO;
        }
        return null;
    }

    public void addGameListener(GameType type, GameEntityListener listener) {
        this.gameListeners.get((Object)type).add(listener);
    }

    public void removeGameListener(GameType type, GameEntityListener listener) {
        this.gameListeners.get((Object)type).remove(listener);
    }

    public void renameModpack(CompleteVersion version, String newName) {
        try {
            CompleteVersion newVersion = this.tLauncher.getVersionManager().getLocalList().renameVersion(version, newName);
            this.tLauncher.getVersionManager().getLocalList().refreshVersions();
            for (GameEntityListener l : this.gameListeners.get((Object)GameType.MODPACK)) {
                l.updateVersion(version, newVersion);
            }
            version.setID(newName);
        }
        catch (IOException e) {
            U.log(e);
            Alert.showError(Localizable.get("modpack.rename.exception.title"), Localizable.get("modpack.rename.exception"));
        }
    }

    public void resaveVersion(CompleteVersion completeVersion) {
        try {
            TLauncher.getInstance().getVersionManager().getLocalList().refreshLocalVersion(completeVersion);
            for (GameEntityListener l : this.gameListeners.get((Object)GameType.MODPACK)) {
                l.updateVersion(completeVersion, completeVersion);
            }
        }
        catch (IOException e) {
            U.log(e);
            Alert.showError(Localizable.get("modpack.resave.exception.title"), Localizable.get("modpack.resave.exception"));
        }
    }

    public void resaveVersionWithNewForge(CompleteVersion completeVersion) {
        this.resaveVersion(completeVersion);
        for (GameEntityListener l : this.gameListeners.get((Object)GameType.MODPACK)) {
            l.updateVersionStorageAndScene(completeVersion, completeVersion);
        }
    }

    public void checkFolderSubGameEntity(CompleteVersion selectedValue, GameType current) {
        boolean find;
        ModpackVersionDTO versionDTO = (ModpackVersionDTO)selectedValue.getModpack().getVersion();
        Path subFolder = ModpackUtil.getPathByVersion(selectedValue, FileUtil.GameEntityFolder.getPath(current));
        if (Files.notExists(subFolder, new LinkOption[0])) {
            return;
        }
        switch (current) {
            case MOD: {
                find = this.isFind(FileUtils.listFiles(subFolder.toFile(), new String[]{"jar", "zip"}, true), current, versionDTO, subFolder);
                break;
            }
            case RESOURCEPACK: 
            case SHADERPACK: {
                find = this.isFind(FileUtils.listFiles(subFolder.toFile(), new String[]{"zip"}, true), current, versionDTO, subFolder);
                break;
            }
            case MAP: {
                find = this.isFindMap(current, versionDTO, subFolder);
                break;
            }
            default: {
                return;
            }
        }
        if (find) {
            this.resaveVersion(selectedValue);
        }
    }

    private boolean isFindMap(GameType current, ModpackVersionDTO versionDTO, Path subFolder) {
        boolean find = false;
        HashSet<String> set = new HashSet<String>();
        for (GameEntityDTO gameEntityDTO : versionDTO.getByType(current)) {
            if (((MapMetadataDTO)gameEntityDTO.getVersion().getMetadata()).getFolders() == null) continue;
            set.addAll(((MapMetadataDTO)gameEntityDTO.getVersion().getMetadata()).getFolders());
        }
        String[] array = subFolder.toFile().list(DirectoryFileFilter.DIRECTORY);
        for (String m : Objects.requireNonNull(array)) {
            if (set.contains(m)) continue;
            try {
                GameEntityDTO dto = this.createHandleGameEntity(subFolder.toFile(), MapDTO.class, new File(subFolder.toFile(), m));
                versionDTO.getByType(current).add(dto);
            }
            catch (IllegalAccessException | InstantiationException e) {
                U.log(e);
            }
            find = true;
        }
        return find;
    }

    private boolean isFind(Collection<File> list, GameType current, ModpackVersionDTO versionDTO, Path subFolder) {
        boolean find = false;
        for (File f : list) {
            boolean foundFile = false;
            String name = f.getName();
            GameEntityDTO gd = null;
            try {
                Iterator<? extends GameEntityDTO> iterator = versionDTO.getByType(current).iterator();
                while (iterator.hasNext()) {
                    GameEntityDTO g;
                    gd = g = iterator.next();
                    if (!g.getVersion().getMetadata().getPath().endsWith(name)) continue;
                    foundFile = true;
                    break;
                }
            }
            catch (NullPointerException n) {
                U.log("meta is null " + gd.toString());
                throw n;
            }
            if (foundFile) continue;
            try {
                GameEntityDTO dto = this.createHandleGameEntity(subFolder.toFile(), GameType.createDTO(current), f);
                versionDTO.getByType(current).add(dto);
                find = true;
            }
            catch (Exception e) {
                this.log(e);
            }
        }
        return find;
    }

    private void checkShaderStatus(CompleteVersion completeVersion) throws IOException {
        List<ShaderpackDTO> shaderpacks = ((ModpackVersionDTO)completeVersion.getModpack().getVersion()).getShaderpacks();
        if (shaderpacks.isEmpty()) {
            return;
        }
        String name = ModpackUtil.readShaderpackConfigField(completeVersion, "shaderPack");
        Optional<ShaderpackDTO> op = shaderpacks.stream().filter(d -> d.getStateGameElement() == StateGameElement.ACTIVE).findFirst();
        if (StringUtils.isEmpty((CharSequence)name) && op.isPresent()) {
            op.get().setStateGameElement(StateGameElement.NO_ACTIVE);
        } else if (StringUtils.isNotEmpty((CharSequence)name)) {
            String fileName;
            if (op.isPresent() && (fileName = FileUtil.getFilename(op.get().getVersion().getMetadata().getPath())).equalsIgnoreCase(name)) {
                return;
            }
            shaderpacks.stream().filter(d -> d.getStateGameElement() == StateGameElement.ACTIVE).forEach(d -> {
                d.setStateGameElement(StateGameElement.NO_ACTIVE);
                SwingUtilities.invokeLater(() -> {
                    for (GameEntityListener l : this.gameListeners.get((Object)GameType.SHADERPACK)) {
                        l.activation((GameEntityDTO)d);
                    }
                });
            });
            shaderpacks.stream().filter(d -> FileUtil.getFilename(d.getVersion().getMetadata().getPath()).equalsIgnoreCase(name)).forEach(d -> {
                d.setStateGameElement(StateGameElement.ACTIVE);
                SwingUtilities.invokeLater(() -> {
                    for (GameEntityListener l : this.gameListeners.get((Object)GameType.SHADERPACK)) {
                        l.activation((GameEntityDTO)d);
                    }
                });
            });
        }
    }

    public void openModpackFolder(CompleteVersion version) {
        OS.openFolder(FileUtil.getRelative("versions/" + version.getID()).toFile());
    }

    public CompleteVersion getCompleteVersion(String name) throws IOException {
        try {
            String value = Http.performGet(this.innerConfiguration.get("modpack.operation.url") + "read/forgeversion?name=" + name);
            CompleteVersion completeVersion = this.gson.fromJson(value, CompleteVersion.class);
            completeVersion = completeVersion.resolve(this.tLauncher.getVersionManager(), true);
            TlauncherUtil.processRemoteVersionToSave(completeVersion, value, this.gson);
            return completeVersion;
        }
        catch (NullPointerException e) {
            this.log("forge version " + name);
            throw e;
        }
    }

    private boolean fillFromCache(GameType t, GameEntityDTO e, ModpackVersionDTO versionDTO, Path versionFolder) {
        for (CompleteVersion v : this.getModpackVersions()) {
            if (v.getModpack().getVersion() == versionDTO) continue;
            for (GameEntityDTO gameEntityDTO : ((ModpackVersionDTO)v.getModpack().getVersion()).getByType(t)) {
                Path cachedFolder;
                if (((SubModpackDTO)gameEntityDTO).getStateGameElement() == StateGameElement.NO_ACTIVE || gameEntityDTO.isUserInstall() || e.isUserInstall() || !e.getId().equals(gameEntityDTO.getId()) || !e.getVersion().getId().equals(gameEntityDTO.getVersion().getId()) || this.notExistOrCorrect(cachedFolder = ModpackUtil.getPathByVersion(v), e, true)) continue;
                File dest = new File(versionFolder.toFile(), e.getVersion().getMetadata().getPath());
                try {
                    FileUtil.copyFile(new File(cachedFolder.toFile(), e.getVersion().getMetadata().getPath()), dest, true);
                    return true;
                }
                catch (IOException e1) {
                    this.log(e1);
                    if (dest.exists()) {
                        FileUtil.deleteFile(dest);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public List<GameEntityDTO> findDependenciesFromGameEntityDTO(GameEntityDTO entityDTO) {
        ArrayList<GameEntityDTO> list = new ArrayList<GameEntityDTO>();
        CompleteVersion completeVersion = this.tLauncher.getFrame().mp.modpackScene.getSelectedCompleteVersion();
        if (completeVersion != null && !entityDTO.isUserInstall() && ((SubModpackDTO)entityDTO).getStateGameElement() != StateGameElement.NO_ACTIVE) {
            for (GameType t : GameType.values()) {
                for (GameEntityDTO gameEntityDTO : ((ModpackVersionDTO)completeVersion.getModpack().getVersion()).getByType(t)) {
                    if (gameEntityDTO.getDependencies() == null || ((SubModpackDTO)gameEntityDTO).getStateGameElement() == StateGameElement.NO_ACTIVE) continue;
                    for (GameEntityDependencyDTO d : gameEntityDTO.getDependencies()) {
                        if (d.getDependencyType() != DependencyType.REQUIRED || !entityDTO.getId().equals(d.getGameEntityId())) continue;
                        list.add(gameEntityDTO);
                    }
                }
            }
        }
        return list;
    }

    public void resetInfoMod() {
        this.infoMod = null;
    }

    @Override
    public void onMinecraftPrepare() {
    }

    @Override
    public void onMinecraftAbort() {
    }

    @Override
    public void onMinecraftLaunch() {
    }

    @Override
    public void onMinecraftClose() {
        try {
            ModpackScene scene = this.tLauncher.getFrame().mp.modpackScene;
            if (scene.isSelectedCompleteVersion()) {
                this.checkShaderStatus(scene.getSelectedCompleteVersion());
            }
        }
        catch (IOException io) {
            U.log(io);
        }
    }

    @Override
    public void onMinecraftError(Throwable e) {
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
    }

    public void openModpackElement(Long id, GameType type) {
        this.loadInfo();
        SwingUtilities.invokeLater(() -> {
            GameEntityDTO dto = new GameEntityDTO();
            dto.setId(id);
            this.showFullGameEntity(dto, type);
            U.log(String.format("can't find game entity %s %s", new Object[]{type, id}));
            this.tLauncher.getFrame().setAlwaysOnTop(true);
            this.tLauncher.getFrame().setAlwaysOnTop(false);
        });
    }

    public List<GameVersionDTO> getGameVersionsRemote(NameIdDTO nameIdDTO) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("minecraftVersionType", nameIdDTO.getId());
        map.put("lv", TLauncher.getVersion());
        return (List)this.gsonService.getObjectWithoutSaving(Http.get(this.modpackApiURL + "gameversions", map), new TypeToken<List<GameVersionDTO>>(){}.getType());
    }

    public List<CategoryDTO> getCategories(GameType type) throws IOException {
        return (List)this.gsonService.getObjectWithoutSaving(this.modpackApiURL + "categories/" + type.toString(), new TypeToken<List<CategoryDTO>>(){}.getType());
    }

    public CategoryDTO[] getLocalCategories(GameType type) {
        if (Objects.isNull(this.map.get((Object)type))) {
            return new CategoryDTO[0];
        }
        return this.map.get((Object)type).toArray(new CategoryDTO[0]);
    }

    public List<MinecraftVersionDTO> getVersionsByGameVersionAndMinecraftVersionType(Long id, NameIdDTO minecraftVersionType) throws IOException {
        return (List)this.gsonService.getObjectWithoutSaving(String.format("%s%s%s%s%s", this.modpackApiURL, "gameversions/", id, "/minecraftversiontypes/", minecraftVersionType.getId()), new TypeToken<List<MinecraftVersionDTO>>(){}.getType());
    }

    public GameVersionDTO getGameVersionByName(String name) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        return this.gsonService.getObjectWithoutSaving(Http.get(this.modpackApiURL + "gameversions/search/findbyname", map), GameVersionDTO.class);
    }

    public MinecraftVersionDTO getCompleteVersion(NameIdDTO type, NameIdDTO version) throws IOException {
        return this.gsonService.getObjectWithoutSaving(String.format("%s%s%s%s%s", this.modpackApiURL, "minecraftversiontypes/", type.getId(), "/baseversion/", version.getId()), MinecraftVersionDTO.class);
    }

    public CommonPage<GameEntityDTO> getGameEntities(GameType type, NameIdDTO minecraftVesionType, GameVersionDTO gameVersion, String search, Set<CategoryDTO> categories, Integer page, GameEntitySort sort, boolean favorite) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        if (Objects.nonNull(minecraftVesionType)) {
            map.put("minecraftVesionType", minecraftVesionType.getId());
        }
        if (Objects.nonNull(gameVersion)) {
            map.put("gameversion", gameVersion.getId());
        }
        if (Objects.nonNull(search)) {
            map.put("search", search);
        }
        if (Objects.nonNull(categories)) {
            map.put("category", categories.stream().map(e -> e.getId().toString()).collect(Collectors.joining(",")));
        }
        if (Objects.nonNull(page)) {
            map.put("page", page);
        }
        map.put("lang", this.tLauncher.getConfiguration().getLocale().toString().toUpperCase());
        map.put("sort", (Object)sort);
        if (favorite) {
            try {
                map.put("uuid", this.tLauncher.getProfileManager().findUniqueTlauncherAccount().getUUID().toString());
                map.put("favorite", "true");
            }
            catch (RequiredTLAccountException | SelectedAnyOneTLAccountException e1) {
                this.log("some problem with favorites", e1);
            }
        }
        return (CommonPage)this.gsonService.getObjectWithoutSaving(Http.get(this.modpackApiURL + "client/gameentities", map), new TypeToken<CommonPage<GameEntityDTO>>(){}.getType());
    }

    public GameEntityDTO getGameEntity(GameType type, Long id) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        map.put("lang", this.tLauncher.getConfiguration().getLocale().toString().toUpperCase());
        return this.gsonService.getObjectWithoutSaving(Http.get(this.modpackApiURL + "client/gameentities/" + id, map), GameType.createDTO(type));
    }

    public GameEntityDTO getInstallingGameEntity(GameType type, GameEntityDTO gameEntity, VersionDTO version, GameVersionDTO gameVersion, NameIdDTO minecraftVersionType) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        if (Objects.nonNull(gameVersion)) {
            map.put("gameversion", gameVersion.getId());
        }
        if (Objects.nonNull(minecraftVersionType)) {
            map.put("minecraftVersionType", minecraftVersionType.getId());
        }
        if (Objects.nonNull(version)) {
            map.put("version", version.getId());
        }
        String uri = Http.get(String.format("%sclient/gameentities/%s/installing", this.modpackApiURL, gameEntity.getId()), map);
        return this.gsonService.getObjectWithoutSaving(uri, GameType.createDTO(type));
    }

    public ModpackVersionDTO getInstallingModpackVersionDTO(GameEntityDTO gameEntity, VersionDTO version) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Objects.nonNull(version)) {
            map.put("version", version.getId());
        }
        String uri = Http.get(String.format("%sclient/modpacks/%s/installing", this.modpackApiURL, gameEntity.getId()), map);
        return this.gsonService.getObjectWithoutSaving(uri, ModpackVersionDTO.class);
    }

    public Repo getGameEntitiesPictures(GameType type, Long gameEntity, PictureType pictureType) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        map.put("picturetype", (Object)pictureType);
        String uri = Http.get(String.format("%sclient/gameentities/%s/pictures", this.modpackApiURL, gameEntity), map);
        return this.gsonService.getObjectWithoutSaving(uri, Repo.class);
    }

    public CommonPage<VersionDTO> getGameEntityVersions(GameType type, Long gameEntity, Integer page) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        map.put("page", page);
        String uri = Http.get(String.format("%sclient/gameentities/%s/versions", this.modpackApiURL, gameEntity), map);
        return (CommonPage)this.gsonService.getObjectWithoutSaving(uri, new TypeToken<CommonPage<VersionDTO>>(){}.getType());
    }

    public List<GameEntityDTO> getModpackVersionSubElements(GameType type, Long gameEntity) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        String uri = Http.get(String.format("%sclient/modpacks/%s/versions/subelements", this.modpackApiURL, gameEntity), map);
        return (List)this.gsonService.getObjectWithoutSaving(uri, new TypeToken<List<GameEntityDTO>>(){}.getType());
    }

    public void updateOldGameEntity(GameType type, Long gameEntity, String sourceURI) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        map.put("url", sourceURI);
        HttpPut put = new HttpPut(Http.get(String.format("%sclient/gameentities/old/%s", this.modpackApiURL, gameEntity), map));
        put.setConfig(this.requestConfig);
        CloseableHttpResponse r = this.client.execute(put);
        HttpEntity entity = r.getEntity();
        if (r.getStatusLine().getStatusCode() > 400) {
            EntityUtils.consume(entity);
            throw new IOException(String.valueOf(r.getStatusLine()));
        }
    }

    public GameVersionDTO getGameVersion(ModpackVersionDTO mv) throws IOException {
        if (Objects.isNull(mv.getMinecraftVersionTypes())) {
            NameIdDTO mvt = new NameIdDTO();
            mvt.setId(1L);
            mvt.setName("forge");
            mv.setMinecraftVersionTypes(Lists.newArrayList((Object[])new NameIdDTO[]{mvt}));
        }
        if (Objects.isNull(mv.getMinecraftVersionName()) && Objects.nonNull(mv.getForgeVersionDTO())) {
            ForgeVersionDTO fvdto = mv.getForgeVersionDTO();
            NameIdDTO ver = new NameIdDTO();
            ver.setId(fvdto.getId());
            ver.setName(fvdto.getName());
            mv.setMinecraftVersionName(ver);
        }
        return mv.getGameVersionDTO();
    }

    public GameEntityDTO getGameEntityDescriptions(GameType type, Long id) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        map.put("lang", "en");
        return this.gsonService.getObjectWithoutSaving(Http.get(String.format("%sclient/gameentities/%s/descriptions", this.modpackApiURL, id), map), GameType.createDTO(type));
    }

    public GameEntityDTO getGameEntityWithParserField(Long id, GameType type) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        return this.gsonService.getObjectWithoutSaving(Http.get(String.format("%sclient/gameentities/%s/parser/status", this.modpackApiURL, id), map), GameType.createDTO(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedElementDTO labelForParsingGameEntity(Long id, GameType type) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        HttpPatch patch = new HttpPatch(Http.get(String.format("%sclient/gameentities/%s/parser", this.modpackApiURL, id), map));
        CloseableHttpResponse hr = null;
        try {
            hr = this.closeableHttpClient.execute(patch);
            if (hr.getStatusLine().getStatusCode() != 200) {
                U.log("not proper response " + hr.getStatusLine().toString());
                throw new IOException("not proper response " + hr.getStatusLine());
            }
            ParsedElementDTO parsedElementDTO = this.gson.fromJson(IOUtils.toString(hr.getEntity().getContent(), StandardCharsets.UTF_8), ParsedElementDTO.class);
            return parsedElementDTO;
        }
        finally {
            if (Objects.nonNull(hr)) {
                EntityUtils.consumeQuietly(hr.getEntity());
            }
        }
    }

    public List<NameIdDTO> getMinecraftVersionTypesRemote() throws IOException {
        return (List)this.gsonService.getObjectWithoutSaving(this.modpackApiURL + "minecraftversiontypes?lv=" + TLauncher.getVersion(), new TypeToken<List<NameIdDTO>>(){}.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendRequest(HttpRequestBase http, Object ob, String urn, Map<String, Object> map) throws IOException, ClientProtocolException, RequiredTLAccountException, SelectedAnyOneTLAccountException {
        if (Objects.nonNull(map)) {
            urn = Http.get(urn, map);
        }
        http.setURI(U.makeURI(urn));
        if (Objects.nonNull(ob)) {
            ((HttpEntityEnclosingRequestBase)http).setEntity(new StringEntity(this.gson.toJson(ob), ContentType.APPLICATION_JSON));
        }
        http.setConfig(this.requestConfig);
        TlauncherUtil.addAuthHeaders(http);
        CloseableHttpResponse hr = null;
        try {
            hr = this.closeableHttpClient.execute(http);
            if (hr.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("not proper code " + hr.getStatusLine().toString());
            }
            String string = IOUtils.toString(hr.getEntity().getContent(), StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (Objects.nonNull(hr)) {
                http.abort();
                EntityUtils.consumeQuietly(hr.getEntity());
            }
        }
    }

    public void addFavoriteGameEntities(GameEntityDTO dto, GameType type) throws ClientProtocolException, IOException, RequiredTLAccountException, SelectedAnyOneTLAccountException {
        Account ac = this.tLauncher.getProfileManager().findUniqueTlauncherAccount();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        this.sendRequest(new HttpPost(), null, String.format("%suser/client/gameentities/%s/favorite/", this.modpackApiURL, dto.getId()), map);
        Set<Long> set = this.favoriteGameEntityIds.get(ac.getUUID());
        if (Objects.isNull(set)) {
            set = Collections.synchronizedSet(new HashSet());
            this.favoriteGameEntityIds.put(ac.getUUID(), set);
        }
        set.add(dto.getId());
    }

    public void deleteFavoriteGameEntities(GameEntityDTO dto, GameType type) throws ClientProtocolException, IOException, RequiredTLAccountException, SelectedAnyOneTLAccountException {
        Account ac = this.tLauncher.getProfileManager().findUniqueTlauncherAccount();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", (Object)type);
        this.sendRequest(new HttpDelete(), null, String.format("%suser/client/gameentities/%s/favorite/", this.modpackApiURL, dto.getId()), map);
        Set<Long> set = this.favoriteGameEntityIds.get(ac.getUUID());
        if (Objects.nonNull(set)) {
            set.remove(dto.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFavoriteGameEntities() {
        this.log("try to update favorite");
        HttpGet request = new HttpGet(String.format("%suser/client/gameentities/favorite", this.modpackApiURL));
        HttpResponse hr = null;
        try {
            Account ac = this.tLauncher.getProfileManager().findUniqueTlauncherAccount();
            if (this.favoriteGameEntityIds.containsKey(ac.getUUID())) {
                return;
            }
            this.log("updated favorites for account " + ac.getDisplayName());
            request.setConfig(this.requestConfig);
            TlauncherUtil.addAuthHeaders(request);
            hr = this.closeableHttpClient.execute(request);
            if (hr.getStatusLine().getStatusCode() != 200) {
                U.log("not proper response " + hr.getStatusLine().toString());
            } else {
                List list = (List)this.gson.fromJson((Reader)new InputStreamReader(hr.getEntity().getContent()), new TypeToken<List<NameIdDTO>>(){}.getType());
                this.favoriteGameEntityIds.put(ac.getUUID(), Collections.synchronizedSet(list.stream().map(e -> e.getId()).collect(Collectors.toSet())));
            }
        }
        catch (RequiredTLAccountException | SelectedAnyOneTLAccountException e2) {
            this.log("couldn't get favorites for current accounts");
        }
        catch (Exception e3) {
            this.log(e3);
        }
        finally {
            if (Objects.nonNull(hr)) {
                request.abort();
                EntityUtils.consumeQuietly(hr.getEntity());
            }
        }
    }

    public void importUserGameEntities(List<GameEntityDTO> list) throws ClientProtocolException, IOException, RequiredTLAccountException, SelectedAnyOneTLAccountException {
        this.readStatusGameElement();
        if (!this.statusModpackElement.isEmpty()) {
            this.sendRequest(new HttpPost(), list, String.format("%suser/client/export/gameentities/favorite/", this.modpackApiURL), null);
            int size = this.statusModpackElement.size();
            this.statusModpackElement.clear();
            this.writeStatusGameElement();
            this.log("exported favorite game entities successfully " + size);
            this.favoriteGameEntityIds.clear();
        }
    }

    public Set<Long> getFavoriteGameEntitiesByAccount() {
        try {
            Account ac = this.tLauncher.getProfileManager().findUniqueTlauncherAccount();
            Set<Long> set = this.favoriteGameEntityIds.get(ac.getUUID());
            if (Objects.nonNull(set)) {
                return set;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new HashSet<Long>();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            CompletableFuture.runAsync(() -> {
                PseudoScene s = this.tLauncher.getFrame().mp.getScene();
                if (s instanceof UpdateFavoriteValueListener) {
                    this.getFavoriteGameEntities();
                    SwingUtilities.invokeLater(() -> ((UpdateFavoriteValueListener)((Object)s)).updateFavoriteValue());
                }
            });
        }
    }

    public ExecutorService getModpackExecutorService() {
        return this.modpackExecutorService;
    }

    public Map<GameType, List<CategoryDTO>> getMap() {
        return this.map;
    }

    public List<NameIdDTO> getMinecraftVersionTypes() {
        return this.minecraftVersionTypes;
    }

    public Map<NameIdDTO, List<GameVersionDTO>> getGameVersions() {
        return this.gameVersions;
    }

    public static enum ModpackServerCommand {
        UPDATE,
        DOWNLOAD,
        ADD_NEW_GAME_ENTITY;

    }
}

