/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.launcher.assitent;

import by.gdev.utils.service.FileMapperService;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.tlauncher.tlauncher.configuration.enums.BackupSetting;
import org.tlauncher.tlauncher.entity.BackupWorldList;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.MinecraftLauncherAssistantWrapper;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.U;

@Singleton
public class BackupWorldAssistant
extends MinecraftLauncherAssistantWrapper {
    private static final Logger log = Logger.getLogger(BackupWorldAssistant.class);
    @Inject
    private TLauncher tLauncher;
    @Inject
    private FileMapperService fileMapperService;
    private BackupWorldList backupWorldList;
    @Inject
    private Gson gson;

    @Inject
    public void init() throws IOException {
        this.backupWorldList = new BackupWorldList();
        File worldJson = new File(MinecraftUtil.getWorkingDirectory(), "worlds.json");
        FileUtil.createFile(worldJson);
        this.backupWorldList = this.fileMapperService.read("worlds.json", BackupWorldList.class);
        if (Objects.isNull(this.backupWorldList)) {
            this.backupWorldList = new BackupWorldList();
        }
        if (log.isDebugEnabled()) {
            log.debug(this.gson.toJson(this.backupWorldList));
        }
    }

    @Override
    public void constructJavaArguments(MinecraftLauncher launcher) throws MinecraftException {
        try {
            if (this.isBackupAvailable()) {
                this.tLauncher.getFrame().mp.getProgress().onWorldBackup(" ");
                this.collectNewWorlds();
                this.checkIfWorldsAreChanged();
                this.checkIfModpackWorldsAreChanged();
                this.backupWorld();
                this.saveWorlds();
            }
            this.deleteOldBackupOrNotExistedWorlds();
        }
        catch (IOException e) {
            U.log(e.getMessage());
        }
    }

    private boolean isBackupAvailable() {
        boolean res = false;
        if (!this.tLauncher.getConfiguration().getBoolean(BackupSetting.SKIP_USER_BACKUP.toString())) {
            int requestFreeGB = this.tLauncher.getConfiguration().getInteger(BackupSetting.FREE_PARTITION_SIZE.toString());
            res = FileUtil.checkFreeSpace(MinecraftUtil.getWorkingDirectory(), requestFreeGB * 1024 * 1024);
            if (!res) {
                log.warn("Free space on partition doesn't enough for backup : " + (double)MinecraftUtil.getWorkingDirectory().getFreeSpace() / Math.pow(1024.0, 3.0));
            }
        }
        log.info("backup world is active: " + res);
        return res;
    }

    private void saveWorlds() throws IOException {
        log.debug("saved backup world configuration");
        this.fileMapperService.write(this.backupWorldList, "worlds.json");
    }

    private void collectNewWorlds() throws IOException {
        Path simpleWorlds = MinecraftUtil.buildWorkingPath("saves");
        Path versions = MinecraftUtil.buildWorkingPath("versions");
        Path destForSimpleWorld = MinecraftUtil.buildWorkingPath("backup/saves", "saves");
        Path destForModPackWorlds = MinecraftUtil.buildWorkingPath("backup/saves", "modpacks_saves");
        Files.createDirectories(destForSimpleWorld, new FileAttribute[0]);
        Files.createDirectories(destForModPackWorlds, new FileAttribute[0]);
        this.addWorldToBackupSet(destForSimpleWorld.toFile(), Files.walk(simpleWorlds, 1, new FileVisitOption[0]));
        Files.walk(versions, 1, new FileVisitOption[0]).filter(version -> new File(version + "/" + "saves").exists()).forEach(version -> {
            try {
                Stream<Path> walk2 = Files.walk(Paths.get(version.toString(), "saves"), 1, new FileVisitOption[0]);
                this.addWorldToBackupSet(destForModPackWorlds.toFile(), walk2);
            }
            catch (IOException e) {
                U.log(e.getMessage());
            }
        });
    }

    private void addWorldToBackupSet(File dest, Stream<Path> walk) {
        walk.filter(world -> !world.toFile().getName().equals("saves")).forEach(world -> {
            try {
                LocalDateTime time = LocalDateTime.ofInstant(((FileTime)Files.getAttribute(world, BackupSetting.LAST_MODIFIED_TIME.toString(), new LinkOption[0])).toInstant(), ZoneId.systemDefault());
                if (this.backupWorldList.getWorlds().stream().anyMatch(backup -> backup.getSource().equals(world.toString()))) {
                    return;
                }
                File destination = new File(dest, world.getFileName().toString());
                this.backupWorldList.getWorlds().add(new BackupWorldList.BackupWorld(world.toFile().getName(), world.toString(), destination.getAbsolutePath(), time.withNano(0).toString(), false));
                log.info("Add new world to backup list: " + world.toFile().getName());
            }
            catch (IOException e) {
                log.warn("exception", e);
            }
        });
    }

    private void backupWorld() {
        this.backupWorldList.getWorlds().stream().filter(BackupWorldList.BackupWorld::isBackup).filter(b -> Files.isDirectory(Paths.get(b.getSource(), new String[0]), new LinkOption[0])).forEach(backupWorld -> {
            log.info("backup world: " + backupWorld.getName());
            this.tLauncher.getFrame().mp.getProgress().onWorldBackup(" " + backupWorld.getName() + " ");
            try {
                LocalDateTime time = LocalDateTime.ofInstant(((FileTime)Files.getAttribute(Paths.get(backupWorld.getSource(), new String[0]), BackupSetting.LAST_MODIFIED_TIME.toString(), new LinkOption[0])).toInstant(), ZoneId.systemDefault());
                backupWorld.setLastChanged(time.withNano(0).toString());
                backupWorld.setBackup(false);
                FileUtil.createFolder(new File(backupWorld.getDestination()));
                File dest = Paths.get(backupWorld.getDestination(), backupWorld.getName().concat("_").concat(backupWorld.getLastChanged().replaceAll(":", "_")).concat(".zip")).toFile();
                FileUtil.zipFolder(new File(backupWorld.getSource()), dest);
                log.info("backup world finished: " + backupWorld.getName());
            }
            catch (Exception e) {
                log.warn("exception", e);
            }
        });
    }

    private void deleteOldBackupOrNotExistedWorlds() throws IOException {
        Files.walk(MinecraftUtil.buildWorkingPath("backup/saves"), new FileVisitOption[0]).filter(backupWorld -> backupWorld.toFile().isFile()).filter(backupWorld -> {
            try {
                LocalDateTime time = LocalDateTime.ofInstant(((FileTime)Files.getAttribute(Paths.get(backupWorld.toString(), new String[0]), BackupSetting.LAST_MODIFIED_TIME.toString(), new LinkOption[0])).toInstant(), ZoneId.systemDefault());
                long daysBetween = ChronoUnit.DAYS.between(time, LocalDateTime.now());
                return daysBetween > (long)this.tLauncher.getConfiguration().getInteger(BackupSetting.MAX_TIME_FOR_BACKUP.toString());
            }
            catch (IOException e) {
                U.log(e.getMessage());
                return false;
            }
        }).forEach(oldWorld -> {
            log.info("Deleted world: " + oldWorld.toAbsolutePath());
            FileUtil.deleteFile(oldWorld.toFile());
        });
        Set<BackupWorldList.BackupWorld> existedWorlds = this.backupWorldList.getWorlds().stream().filter(backupWorld -> Paths.get(backupWorld.getSource(), new String[0]).toFile().exists()).collect(Collectors.toSet());
        if (existedWorlds.size() < this.backupWorldList.getWorlds().size()) {
            this.backupWorldList.setWorlds(existedWorlds);
            this.saveWorlds();
        }
    }

    private void checkIfModpackWorldsAreChanged() throws IOException {
        List versions = Files.walk(MinecraftUtil.buildWorkingPath("versions"), 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
        for (Path version : versions) {
            Path versionSaves = Paths.get(version.toString(), "saves");
            if (Files.notExists(versionSaves, new LinkOption[0])) continue;
            this.checkIfWorldsAreChanged(Files.walk(versionSaves, 1, new FileVisitOption[0]).collect(Collectors.toList()));
        }
    }

    private void checkIfWorldsAreChanged() throws IOException {
        Path source = MinecraftUtil.buildWorkingPath("saves");
        this.checkIfWorldsAreChanged(Files.walk(source, 1, new FileVisitOption[0]).collect(Collectors.toList()));
    }

    private void checkIfWorldsAreChanged(List<Path> files) throws IOException {
        for (Path world : files) {
            FileTime creationTime = (FileTime)Files.getAttribute(world, BackupSetting.LAST_MODIFIED_TIME.toString(), new LinkOption[0]);
            LocalDateTime convertedFileTime = LocalDateTime.ofInstant(creationTime.toInstant(), ZoneId.systemDefault());
            Optional<BackupWorldList.BackupWorld> backupWorld1 = this.backupWorldList.getWorlds().stream().filter(backupWorld -> backupWorld.getSource().equals(world.toString())).findAny();
            if (!backupWorld1.isPresent()) continue;
            String worldTime = backupWorld1.get().getLastChanged();
            if (Paths.get(backupWorld1.get().getDestination(), new String[0]).toFile().listFiles() == null) {
                backupWorld1.get().setBackup(true);
                continue;
            }
            if (worldTime.equals(convertedFileTime.withNano(0).toString())) continue;
            if (Paths.get(backupWorld1.get().getDestination(), new String[0]).toFile().listFiles() == null) {
                backupWorld1.get().setBackup(true);
                continue;
            }
            if (this.isProperBackupWorld(backupWorld1.get())) continue;
            backupWorld1.get().setBackup(true);
        }
    }

    private boolean isProperBackupWorld(BackupWorldList.BackupWorld backupWorld) throws IOException {
        long lastBackupSize = Paths.get(backupWorld.getDestination(), backupWorld.getName().concat("_").concat(backupWorld.getLastChanged().replaceAll(":", "_").concat(".zip"))).toFile().length();
        LocalDateTime backupLastChanged = LocalDateTime.parse(backupWorld.getLastChanged());
        long totalHoursPassed = Duration.between(backupLastChanged, LocalDateTime.now()).toHours();
        if (this.tLauncher.getConfiguration().getInteger(BackupSetting.REPEAT_BACKUP.toString()) == 1) {
            return totalHoursPassed < 24L;
        }
        return (double)lastBackupSize / Math.pow(1024.0, 2.0) > (double)this.tLauncher.getConfiguration().getInteger(BackupSetting.MAX_SIZE_FOR_WORLD.toString());
    }
}

