/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.editor;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.tlauncher.tlauncher.ui.converter.StringConverter;
import org.tlauncher.tlauncher.ui.editor.EditorField;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedComboBox;
import org.tlauncher.tlauncher.ui.swing.scroll.VersionScrollBarUI;
import org.tlauncher.tlauncher.ui.ui.TlauncherBasicComboBoxUI;

public class EditorComboBox<T>
extends ExtendedComboBox<T>
implements EditorField {
    private static final long serialVersionUID = -2320340434786516374L;
    private final boolean allowNull;

    public EditorComboBox(StringConverter<T> converter, T[] values, boolean allowNull) {
        super(converter);
        this.allowNull = allowNull;
        if (values == null) {
            return;
        }
        for (T value : values) {
            this.addItem(value);
        }
    }

    public EditorComboBox(StringConverter<T> converter, T[] values) {
        this(converter, values, false);
    }

    @Override
    public String getSettingsValue() {
        Object value = this.getSelectedValue();
        return this.convert(value);
    }

    @Override
    public void setSettingsValue(String string) {
        Object value = this.convert(string);
        if (!this.allowNull && string == null) {
            boolean hasNull = false;
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (this.getItemAt(i) != null) continue;
                hasNull = true;
            }
            if (!hasNull) {
                return;
            }
        }
        this.setSelectedValue(value);
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    @Override
    protected void init() {
        TlauncherBasicComboBoxUI list = new TlauncherBasicComboBoxUI(){

            @Override
            protected ComboPopup createPopup() {
                BasicComboPopup basic = new BasicComboPopup(this.comboBox){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected JScrollPane createScroller() {
                        VersionScrollBarUI barUI = new VersionScrollBarUI(){

                            @Override
                            protected Dimension getMinimumThumbSize() {
                                return new Dimension(10, 40);
                            }

                            @Override
                            public Dimension getMaximumSize(JComponent c) {
                                Dimension dim = super.getMaximumSize(c);
                                dim.setSize(10.0, dim.getHeight());
                                return dim;
                            }

                            @Override
                            public Dimension getPreferredSize(JComponent c) {
                                Dimension dim = super.getPreferredSize(c);
                                dim.setSize(10.0, dim.getHeight());
                                return dim;
                            }
                        };
                        barUI.setGapThubm(5);
                        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                        scroller.setBackground(Color.WHITE);
                        scroller.getVerticalScrollBar().setUI(barUI);
                        return scroller;
                    }
                };
                basic.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.BLACK));
                return basic;
            }
        };
        this.setUI(list);
    }
}

