/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.listener;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.json.Argument;
import net.minecraft.launcher.versions.json.ArgumentType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.configuration.enums.ActionOnLaunch;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.crash.CrashSignatureContainer;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftListener;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.LanguageAssistance;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.StringUtil;
import org.tlauncher.util.U;

public class MinecraftUIListener
implements MinecraftListener {
    private final TLauncher t;
    private final LangConfiguration lang;

    public MinecraftUIListener(TLauncher tlauncher) {
        this.t = tlauncher;
        this.lang = this.t.getLang();
    }

    @Override
    public void onMinecraftPrepare() {
    }

    @Override
    public void onMinecraftAbort() {
    }

    @Override
    public void onMinecraftLaunch() {
        if (!this.t.getConfiguration().getActionOnLaunch().equals((Object)ActionOnLaunch.NOTHING)) {
            this.t.hide();
        }
    }

    @Override
    public void onMinecraftClose() {
        if (!this.t.getLauncher().isLaunchAssist()) {
            return;
        }
        this.t.show();
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
        if (!this.t.getLauncher().isLaunchAssist()) {
            this.t.show();
        }
        Configuration c = this.t.getConfiguration();
        String p = "crash.";
        String title = Localizable.get(p + "title");
        String report = crash.getFile();
        String skipAccountProperty = "skip.account.property";
        if (!crash.isRecognized()) {
            this.showPossibleSolutions();
        } else {
            for (CrashSignatureContainer.CrashSignature sign : crash.getSignatures()) {
                String path = sign.getPath();
                String message = p + path;
                if ("not proper gpu1".equalsIgnoreCase(sign.getName()) && !c.getBoolean("fixed.gpu.jre.error") && OS.is(OS.WINDOWS)) {
                    c.set("fixed.gpu.jre.error", (Object)true);
                    U.log("set new jre");
                } else if ("Bad video drivers".equalsIgnoreCase(sign.getName()) && !c.getBoolean("fixed.gpu.jre.error") && OS.is(OS.WINDOWS) && OS.VERSION.contains("10") && (StringUtils.contains((CharSequence)this.t.getConfiguration().get("gpu.info.full"), (CharSequence)"Intel(R) HD Graphics Family") || StringUtils.contains((CharSequence)this.t.getConfiguration().get("gpu.info.full"), (CharSequence)"Pentium"))) {
                    c.set("fixed.gpu.jre.error", (Object)true);
                    Alert.showLocMessageWithoutTitle("crash.restart");
                    U.log("set new jre");
                } else if (c.getBoolean("fixed.gpu.jre.error") && "Bad video drivers".equalsIgnoreCase(sign.getName())) {
                    Alert.showLocMessageWithoutTitle("crash.opengl.windows10.error");
                }
                if (sign.getName().equalsIgnoreCase("thread creation problem")) {
                    if (!this.replaceJVMParam()) {
                        this.showPossibleSolutions();
                        return;
                    }
                } else {
                    if (sign.getName().equalsIgnoreCase("Not reserve ram") && this.t.getConfiguration().getInteger("minecraft.memory.ram2") == OS.Arch.PREFERRED_MEMORY) {
                        this.showProperMemoryMessage();
                        continue;
                    }
                    if (sign.getName().equalsIgnoreCase("Not reserve ram") || sign.getName().equalsIgnoreCase("jetty ram problem")) {
                        if (Alert.showLocQuestion(title, message)) {
                            this.t.getConfiguration().set("minecraft.memory.ram2", OS.Arch.PREFERRED_MEMORY, true);
                        }
                        return;
                    }
                    if (sign.getName().equalsIgnoreCase("gson lenient") && !this.t.getConfiguration().getBoolean(skipAccountProperty)) {
                        this.t.getConfiguration().set(skipAccountProperty, (Object)true);
                    } else {
                        if (sign.getName().equalsIgnoreCase("Bad video drivers")) {
                            String gpuLink = "";
                            String gpuName = this.t.getConfiguration().get("gpu.info");
                            String cpuLink = "";
                            String cpuName = this.t.getConfiguration().get("process.info");
                            int i = 2;
                            if (!Strings.isNullOrEmpty((String)gpuName)) {
                                gpuName = String.join((CharSequence)" ", gpuName, OS.NAME, OS.VERSION, Localizable.get("crash.opengl.download.driver"));
                                gpuLink = Http.get("https://www.google.com/search", "q", gpuName);
                                gpuLink = String.format("<br>%s)%s <a href='%s'>%s</a>", i++, Localizable.get("crash.opengl.install.gpu"), gpuLink, Localizable.get("click.me"));
                            }
                            if (!Strings.isNullOrEmpty((String)cpuName)) {
                                cpuName = String.join((CharSequence)" ", cpuName, OS.NAME, OS.VERSION, Localizable.get("crash.opengl.download.driver"));
                                cpuLink = Http.get("https://www.google.com/search", "q", cpuName);
                                cpuLink = String.format("<br>%s)%s <a href='%s'>%s</a>", i++, Localizable.get("crash.opengl.install.cpu"), cpuLink, Localizable.get("click.me"));
                            }
                            message = String.format(Localizable.get(message), gpuLink, cpuLink, Localizable.get("crash.opengl.help"));
                            Alert.showErrorHtml("", message);
                            continue;
                        }
                        if ("vbo fix".equals(sign.getName()) && !this.fixProblem()) {
                            this.showPossibleSolutions();
                            return;
                        }
                        if (("OutOfMemory error".equals(sign.getName()) || "PermGen error".equals(sign.getName())) && "system.32x.not.proper".equals(c.get("memory.problem.message"))) {
                            message = Localizable.get(message) + Localizable.get("crash.outofmemory.32bit");
                        } else {
                            Path configDir;
                            if ("problem g1gc".equals(sign.getName())) {
                                Alert.showLocMessageWithoutTitle(message);
                                Alert.showLocMessageWithoutTitle("crash.swap.file.increase");
                                this.t.getConfiguration().set("minecraft.memory.ram2", OS.Arch.PREFERRED_MEMORY, true);
                                return;
                            }
                            if ("failed create event loop".equals(sign.getName())) {
                                long l = c.getLong("reset.net");
                                if (l == 0L || new Date(l).before(new Date())) {
                                    this.executeFixed();
                                    return;
                                }
                            } else if ("forge config error".equalsIgnoreCase(sign.getName()) && Files.exists(configDir = Paths.get(this.t.getLauncher().getRunningMinecraftDir().getPath(), "config"), new LinkOption[0]) && Files.isDirectory(configDir, new LinkOption[0])) {
                                FileUtil.deleteDirectory(configDir.toFile());
                            }
                        }
                    }
                }
                Alert.showLocMessage(title, message, report);
            }
        }
    }

    private void executeFixed() {
        Alert.showLocMessage("", "crash.switch.antivirus.system.auto", null);
        String path = "http://repo.tlauncher.org/update/downloads/libraries/org/tlauncher/updater/TLauncherUpdater.exe";
        try {
            Path runner = Files.createTempFile("TLauncherUpdater", ".exe", new FileAttribute[0]);
            FileUtils.copyURLToFile(new URL(path), runner.toFile(), 30000, 30000);
            Process p = Runtime.getRuntime().exec(new String[]{"cmd", "/c", runner.toString(), "\\\"netsh winsock reset\\\""});
            int code = p.waitFor();
            if (code == 0) {
                this.t.getConfiguration().set("reset.net", DateUtils.addDays((Date)new Date(), (int)7).getTime(), true);
            }
            U.log("finished fixed with code " + code);
        }
        catch (IOException | InterruptedException e) {
            U.log(e);
        }
    }

    private boolean fixProblem() {
        boolean canFixed = false;
        File options = new File(this.t.getLauncher().getRunningMinecraftDir(), LanguageAssistance.OPTIONS);
        if (options.exists()) {
            try {
                List<String> lines = Files.readAllLines(options.toPath(), StandardCharsets.UTF_8);
                int indexVsync = -1;
                int indexVbo = -1;
                for (int i = 0; i < lines.size(); ++i) {
                    if (lines.get(i).contains("enableVsync:")) {
                        indexVsync = i;
                    }
                    if (!lines.get(i).contains("useVbo:")) continue;
                    indexVbo = i;
                }
                String vbo = "useVbo:false";
                String vsync = "enableVsync:true";
                if (indexVbo == -1) {
                    lines.add(vbo);
                    canFixed = true;
                } else if (lines.get(indexVbo).endsWith("true")) {
                    lines.remove(indexVbo);
                    lines.add(indexVbo, vbo);
                    canFixed = true;
                }
                if (indexVsync == -1) {
                    lines.add(vsync);
                    canFixed = true;
                } else if (lines.get(indexVsync).endsWith("false")) {
                    lines.remove(indexVsync);
                    lines.add(indexVsync, vsync);
                    canFixed = true;
                }
                if (canFixed) {
                    FileUtil.writeFile(options, String.join((CharSequence)System.lineSeparator(), lines));
                }
            }
            catch (Throwable t) {
                U.log(t);
                return false;
            }
        }
        return canFixed;
    }

    private void showProperMemoryMessage() {
        String recommendedMemory = "";
        String link = TLauncher.getInstance().getConfiguration().isUSSRLocale() ? StringUtil.getLink("https://www.dmosk.ru/polezno.php?review=memory-notfull") : StringUtil.getLink("https://www.howtogeek.com/131632/hardware-upgrade-why-windows-cant-see-all-your-ram") + "<br>" + StringUtil.getLink("https://windowsreport.com/windows-10-isnt-using-all-ram");
        if (OS.Arch.TOTAL_RAM_MB < 1600) {
            recommendedMemory = Localizable.get("crash.java.not.enough.memory.solve.additional.low.memory");
        }
        Alert.showErrorHtml(String.format(Localizable.get("crash.java.not.enough.memory.solve"), OS.Arch.TOTAL_RAM_MB, recommendedMemory, link), 500);
    }

    private boolean replaceJVMParam() {
        try {
            CompleteVersion version = this.t.getVersionManager().getLocalList().getCompleteVersion(this.t.getLauncher().getVersion().getID());
            Map<ArgumentType, List<Argument>> args = version.getArguments();
            if (Objects.nonNull(args) && Objects.nonNull(args.get((Object)ArgumentType.JVM))) {
                List<Argument> list = args.get((Object)ArgumentType.JVM);
                for (int i = 0; i < list.size(); ++i) {
                    Optional<String> xss1024 = Arrays.stream(list.get(i).getValues()).filter(e -> e.equalsIgnoreCase("-Xss1M")).findAny();
                    Optional<String> xss512 = Arrays.stream(list.get(i).getValues()).filter(e -> e.equalsIgnoreCase("-Xss512K")).findAny();
                    if (xss1024.isPresent()) {
                        int ram = OS.Arch.PREFERRED_MEMORY - 256;
                        if (ram > 512) {
                            this.t.getConfiguration().set("minecraft.memory.ram2", ram, false);
                        }
                        list.remove(i);
                        list.add(i, new Argument(new String[]{"-Xss512K"}, null));
                        return true;
                    }
                    if (!xss512.isPresent()) continue;
                    list.remove(i);
                    list.add(i, new Argument(new String[]{"-Xss256K"}, null));
                    return true;
                }
                this.t.getVersionManager().getLocalList().saveVersion(version);
            }
        }
        catch (IOException e2) {
            U.log(new Object[0]);
        }
        return false;
    }

    @Override
    public void onMinecraftError(Throwable e) {
        this.showPossibleSolutions();
    }

    private void showPossibleSolutions() {
        MinecraftLauncher launcher = this.t.getLauncher();
        if (Objects.nonNull(launcher.getVersion()) && launcher.getVersion().isModpack()) {
            Alert.showErrorHtml("launcher.error.modpack.solutions", 400);
        } else {
            File mods = new File(MinecraftUtil.getWorkingDirectory(), "mods");
            File resourcepacks = new File(MinecraftUtil.getWorkingDirectory(), "resourcepacks");
            File shaderpacks = new File(MinecraftUtil.getWorkingDirectory(), "shaderpacks");
            String modpackStructureMessage = "";
            if (mods.exists() && FileUtils.listFiles(mods, new String[]{"jar", "zip"}, true).size() > 2) {
                modpackStructureMessage = Localizable.get("launcher.error.standard.version.point.mod");
            } else if (resourcepacks.exists() && !FileUtils.listFiles(resourcepacks, new String[]{"zip"}, true).isEmpty()) {
                modpackStructureMessage = Localizable.get("launcher.error.standard.version.point.resourcepack");
            } else if (shaderpacks.exists() && !FileUtils.listFiles(shaderpacks, new String[]{"zip"}, true).isEmpty()) {
                modpackStructureMessage = Localizable.get("launcher.error.standard.version.point.shaderpack");
            }
            if (!modpackStructureMessage.isEmpty()) {
                Alert.showErrorHtml(Localizable.get(modpackStructureMessage, Localizable.get("crash.opengl.help")), 600);
                return;
            }
            Alert.showErrorHtml(Localizable.get("launcher.error.standard.version.solutions", modpackStructureMessage, Localizable.get("crash.opengl.help")), 400);
        }
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        Alert.showError(this.lang.get("launcher.error.title"), this.lang.get("launcher.error." + e.getLangPath(), e.getLangVars()), e.getCause());
    }
}

