/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.tlauncher.tlauncher.ui.loc.LocalizableButton;

public class UpdaterButton
extends LocalizableButton {
    private static final long serialVersionUID = 1L;
    protected Color unEnableColor;
    private Color backgroundColor;

    public UpdaterButton(Color color, String value) {
        this.backgroundColor = color;
        this.setText(value);
        this.setOpaque(true);
        this.setBackground(color);
    }

    public UpdaterButton(Color color, Color unEnableColor, String value) {
        this(color, value);
        this.unEnableColor = unEnableColor;
    }

    public UpdaterButton(Color color, Color unEnableColor, Color foreground, String value) {
        this(color, unEnableColor, value);
        this.setForeground(foreground);
    }

    public UpdaterButton(Color color) {
        this.backgroundColor = color;
        this.setText(null);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.setBackground(this.backgroundColor);
    }

    public UpdaterButton() {
        this.setText(null);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rec = this.getVisibleRect();
        g.setColor(this.getBackground());
        g.fillRect(rec.x, rec.y, rec.width, rec.height);
        String text = this.getText();
        ButtonModel buttonModel = this.getModel();
        Color colorText = this.getForeground();
        if (this.unEnableColor != null && (buttonModel.isRollover() && this.model.isEnabled() || !this.isEnabled())) {
            g.setColor(this.unEnableColor);
        } else {
            g.setColor(this.backgroundColor);
        }
        g.fillRect(rec.x, rec.y, rec.width, rec.height);
        g.setColor(colorText);
        UpdaterButton component = this;
        if (text != null) {
            this.paintText(g, component, rec, text);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(text, g2d);
        int x = (this.getWidth() - (int)r.getWidth()) / 2;
        int y = (this.getHeight() - (int)r.getHeight()) / 2 + fm.getAscent();
        g2d.drawString(text, x, y);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

