/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javafx.application.Platform;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.listeners.auth.LoginProcessListener;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.BlockablePanel;
import org.tlauncher.tlauncher.ui.loc.LocalizableCheckbox;
import org.tlauncher.tlauncher.ui.login.InputPanel;
import org.tlauncher.tlauncher.ui.login.LoginException;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.swing.CheckBoxListener;
import org.tlauncher.util.OS;

public class CheckBoxPanel
extends BlockablePanel
implements LoginProcessListener {
    private static final long serialVersionUID = 768489049585749260L;
    public final LocalizableCheckbox forceupdate;
    private static boolean helperOpen = false;
    private final LocalizableCheckbox chooseTypeAccount;
    private final Configuration settings;
    private boolean state;
    private final LoginForm loginForm;
    private final InputPanel inputPanel;

    CheckBoxPanel(LoginForm lf, InputPanel input, boolean chooserState) {
        this.loginForm = lf;
        this.inputPanel = input;
        this.forceupdate = new LocalizableCheckbox("loginform.checkbox.forceupdate");
        this.forceupdate.setForeground(Color.WHITE);
        this.forceupdate.setFocusable(false);
        this.chooseTypeAccount = new LocalizableCheckbox("loginform.checkbox.account");
        this.chooseTypeAccount.setForeground(Color.WHITE);
        this.settings = TLauncher.getInstance().getConfiguration();
        if (!OS.is(OS.WINDOWS)) {
            Font f = this.chooseTypeAccount.getFont();
            this.chooseTypeAccount.setFont(new Font(f.getFamily(), f.getStyle(), 11));
            this.forceupdate.setFont(new Font(f.getFamily(), f.getStyle(), 11));
        }
        this.add((Component)this.forceupdate);
        this.add((Component)this.chooseTypeAccount);
        this.chooseTypeAccount.getModel().setSelected(chooserState);
        this.forceupdate.addItemListener(new CheckBoxListener(){

            @Override
            public void itemStateChanged(boolean newstate) {
                CheckBoxPanel.this.state = newstate;
                ((CheckBoxPanel)CheckBoxPanel.this).loginForm.play.updateState();
            }
        });
        this.chooseTypeAccount.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CheckBoxPanel.this.inputPanel.changeTypeAccount(Account.AccountType.SPECIAL);
                        TLauncher.getInstance().getConfiguration().set("chooser.type.account", (Object)true);
                        if (CheckBoxPanel.this.settings.isFirstRun() && !helperOpen) {
                            ((CheckBoxPanel)CheckBoxPanel.this).loginForm.pane.openAccountEditor();
                            ((CheckBoxPanel)CheckBoxPanel.this).loginForm.pane.accountEditor.setShownAccountHelper(true, true);
                            helperOpen = true;
                            ((CheckBoxPanel)CheckBoxPanel.this).loginForm.pane.accountEditor.addComponentListener(new ComponentListener(){

                                @Override
                                public void componentShown(ComponentEvent e) {
                                }

                                @Override
                                public void componentResized(ComponentEvent e) {
                                }

                                @Override
                                public void componentMoved(ComponentEvent e) {
                                }

                                @Override
                                public void componentHidden(ComponentEvent e) {
                                    ((CheckBoxPanel)CheckBoxPanel.this).loginForm.pane.accountEditor.setShownAccountHelper(false, false);
                                }
                            });
                        }
                    }
                });
            } else {
                this.inputPanel.changeTypeAccount(Account.AccountType.FREE);
                TLauncher.getInstance().getConfiguration().set("chooser.type.account", (Object)false);
            }
        });
    }

    @Override
    public void validatePreGameLaunch() throws LoginException {
        VersionSyncInfo syncInfo = this.loginForm.versions.getVersion();
        if (syncInfo == null) {
            return;
        }
        boolean supporting = syncInfo.hasRemote();
        boolean installed = syncInfo.isInstalled();
        if (this.state) {
            if (!supporting) {
                Alert.showLocError("forceupdate.local");
                throw new LoginException("Cannot update local version!");
            }
            if (installed && !Alert.showLocQuestion("forceupdate.question")) {
                throw new LoginException("User has cancelled force updating.");
            }
        }
    }
}

