/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.SpringLayout;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.listeners.auth.LoginProcessListener;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.BlockablePanel;
import org.tlauncher.tlauncher.ui.loc.LocalizableCheckbox;
import org.tlauncher.tlauncher.ui.login.LoginException;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.login.VersionComboBox;
import org.tlauncher.tlauncher.ui.swing.CheckBoxListener;
import org.tlauncher.tlauncher.ui.ui.VersionComboBoxUI;
import org.tlauncher.util.OS;

public class VersionPanel
extends BlockablePanel
implements LoginProcessListener {
    public final VersionComboBox version;
    public final LocalizableCheckbox forceupdate;
    public final LoginForm loginForm;
    private boolean state;

    public VersionPanel(LoginForm lf) {
        this.loginForm = lf;
        this.version = new VersionComboBox(lf);
        this.version.setUI(new VersionComboBoxUI());
        ((ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class)).addGameListener(GameType.MODPACK, this.version);
        ((ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class)).addGameListener(GameType.MOD, this.version);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        springLayout.putConstraint("North", (Component)this.version, 11, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.version, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)this.version, 35, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.version, 0, "East", (Component)this);
        this.add((Component)this.version);
        this.forceupdate = new LocalizableCheckbox("loginform.checkbox.forceupdate");
        this.forceupdate.setForeground(Color.WHITE);
        this.forceupdate.setIconTextGap(14);
        this.forceupdate.setFocusPainted(false);
        springLayout.putConstraint("North", (Component)this.forceupdate, 44, "North", (Component)this);
        springLayout.putConstraint("South", (Component)this.forceupdate, -11, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.forceupdate, -4, "West", (Component)this);
        springLayout.putConstraint("East", (Component)this.forceupdate, 0, "East", (Component)this);
        this.add((Component)this.forceupdate);
        if (!OS.is(OS.WINDOWS)) {
            Font f = this.version.getFont();
            this.forceupdate.setFont(new Font(f.getFamily(), f.getStyle(), 11));
        }
        this.forceupdate.addItemListener(new CheckBoxListener(){

            @Override
            public void itemStateChanged(boolean newstate) {
                VersionPanel.this.state = newstate;
                VersionPanel.this.loginForm.play.updateState();
            }
        });
    }

    @Override
    public void validatePreGameLaunch() throws LoginException {
        VersionSyncInfo syncInfo = this.loginForm.versions.getVersion();
        if (syncInfo == null) {
            return;
        }
        boolean supporting = syncInfo.hasRemote();
        Version versionLocal = syncInfo.getLocal();
        if (versionLocal instanceof CompleteVersion && ((CompleteVersion)versionLocal).isModpack()) {
            supporting = true;
        }
        if (this.state) {
            if (!supporting) {
                Alert.showLocError("forceupdate.local");
                throw new LoginException("Cannot update local version!");
            }
            if (syncInfo.isInstalled() && !Alert.showLocQuestion("forceupdate.question")) {
                throw new LoginException("User has cancelled force updating.");
            }
        }
    }
}

