/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.menu;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicMenuItemUI;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.LocalizableMenuItem;
import org.tlauncher.tlauncher.ui.modpack.AddedModpackStuffFrame;
import org.tlauncher.tlauncher.ui.modpack.HandleInstallModpackElementFrame;
import org.tlauncher.tlauncher.ui.modpack.ModpackBackupFrame;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

public class ModpackPopup
extends JPopupMenu {
    private static final long serialVersionUID = 1985825573230509140L;
    public static Color BACKGROUND_ITEM = new Color(240, 240, 240);
    public static Color LINE = new Color(204, 204, 204);

    public ModpackPopup() {
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, LINE));
    }

    public ModpackPopup(final ModpackComboBox localmodpacks) {
        this();
        ModpackMenuItem notFound = new ModpackMenuItem("modpack.backup.not.found");
        ModpackMenuItem hand = new ModpackMenuItem("modpack.backup.install.hand");
        ModpackMenuItem backup = new ModpackMenuItem("modpack.backup.settings");
        this.add(backup);
        this.add(notFound);
        this.add(hand);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 97));
        notFound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddedModpackStuffFrame addedModpackStuffView = new AddedModpackStuffFrame((JFrame)TLauncher.getInstance().getFrame(), "modpack.added.request", "modpack.added.request.message");
                addedModpackStuffView.setVisible(true);
            }
        });
        hand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (localmodpacks.getSelectedIndex() == 0) {
                    Alert.showLocMessage("modpack.select.modpack");
                    return;
                }
                HandleInstallModpackElementFrame frame = new HandleInstallModpackElementFrame(TLauncher.getInstance().getFrame(), (CompleteVersion)localmodpacks.getSelectedValue());
                frame.setVisible(true);
            }
        });
        backup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModpackBackupFrame frame = new ModpackBackupFrame(TLauncher.getInstance().getFrame(), localmodpacks);
                frame.setVisible(true);
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rec = this.getVisibleRect();
        g.setColor(LINE);
        g.fillRect(rec.x, rec.y, rec.width, rec.height);
    }

    public static class ModpackMenuItem
    extends LocalizableMenuItem {
        private static final long serialVersionUID = 371263248187501160L;
        int item_gup = 20;

        public ModpackMenuItem(String name) {
            super(name);
            this.setBackground(BACKGROUND_ITEM);
            SwingUtil.changeFontFamily(this, FontTL.ROBOTO_REGULAR, 12, ColorUtil.COLOR_16);
            this.setUI(new BasicMenuItemUI(){

                @Override
                protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int gup) {
                    Rectangle rec = c.getVisibleRect();
                    ButtonModel model = this.getModel();
                    if (model.isPressed()) {
                        g.setColor(ColorUtil.COLOR_195);
                    } else if (model.isArmed()) {
                        g.setColor(ColorUtil.COLOR_215);
                    } else {
                        g.setColor(this.getBackground());
                    }
                    g.fillRect(rec.x, rec.y, rec.width, rec.height);
                    g.setColor(LINE);
                    this.paintBorder(g);
                    this.paintText(g, c, rec, this.getText());
                }

                protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    FontMetrics fm = g2d.getFontMetrics();
                    Rectangle2D r = fm.getStringBounds(text, g2d);
                    g.setFont(this.getFont());
                    g.setColor(Color.BLACK);
                    int x = item_gup;
                    int y = (textRect.height - (int)r.getHeight()) / 2 + fm.getAscent();
                    g2d.drawString(text, x, y);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            this.ui.paint(g, this);
        }

        @Override
        protected void paintBorder(Graphics g) {
            Rectangle rec = this.getVisibleRect();
            g.setColor(LINE);
            g.drawLine(rec.x, rec.y + rec.height - 1, rec.x + rec.width, rec.y + rec.height - 1);
        }
    }
}

