/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.tlauncher.tlauncher.rmo.Bootstrapper;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.modpack.ApplicationDependencies;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

public class AboutApplicationFrame
extends TemlateModpackFrame {
    private JLabel tlauncher;
    private GridLayout gridLayout;
    private JPanel cPanel;
    private static ApplicationDependencies dependencies;
    @Inject
    private Gson gson;
    private static final long serialVersionUID = 1L;

    public AboutApplicationFrame() {
        super(TLauncher.getInstance().getFrame(), "settings.select.program", new Dimension(600, 440));
    }

    @Inject
    public void init() {
        dependencies = this.gson.fromJson((Reader)new InputStreamReader(Bootstrapper.class.getResourceAsStream("/tl_dependencies.json"), StandardCharsets.UTF_8), ApplicationDependencies.class);
        this.tlauncher = new JLabel((Icon)ImageCache.getIcon((String)"fav-icon-76.png"));
        SpringLayout spring = new SpringLayout();
        JPanel panel = new JPanel(spring);
        panel.setBorder(new EmptyBorder(0, 0, 33, 0));
        this.addCenter(panel);
        panel.setBackground(Color.WHITE);
        LocalizableLabel tlaunherName = new LocalizableLabel("TLauncher (2013-2023)");
        LocalizableLabel gammeLauncher = new LocalizableLabel("The Game Launcher");
        LocalizableLabel text1 = new LocalizableLabel("settings.information.contacting");
        LocalizableLabel helpPage = new LocalizableLabel("settings.information.help");
        LocalizableLabel safetyInformation = new LocalizableLabel("settings.information.safety");
        LocalizableLabel developerAnnouncement = new LocalizableLabel("settings.information.developer");
        LocalizableLabel turikhay = new LocalizableLabel("settings.information.turikhay");
        LocalizableLabel libraries = new LocalizableLabel("settings.information.library");
        this.gridLayout = new GridLayout(5, 3);
        this.cPanel = new JPanel(this.gridLayout);
        this.cPanel.setBackground(Color.WHITE);
        dependencies.getLibraries().forEach(e -> {
            JLabel jl = new JLabel("<html><a style='color:#78d7ff;' href='" + e.getLink() + "'><b>" + e.getName() + "</b></a></html>");
            SwingUtil.changeFontFamily(jl, FontTL.ROBOTO_REGULAR, 12);
            this.cPanel.add(jl);
            jl.addMouseListener(new MouseAdapter((ApplicationDependencies.DependencyDescription)e){
                final /* synthetic */ ApplicationDependencies.DependencyDescription val$e;
                {
                    this.val$e = dependencyDescription;
                }

                @Override
                public void mouseClicked(MouseEvent j) {
                    if (SwingUtilities.isLeftMouseButton(j)) {
                        OS.openLink(this.val$e.getLink());
                    }
                }
            });
        });
        spring.putConstraint("West", (Component)gammeLauncher, 30, "West", (Component)panel);
        spring.putConstraint("East", (Component)gammeLauncher, 327, "West", (Component)panel);
        spring.putConstraint("North", (Component)gammeLauncher, 20, "North", (Component)panel);
        spring.putConstraint("South", (Component)gammeLauncher, 40, "North", (Component)panel);
        panel.add(gammeLauncher);
        spring.putConstraint("West", (Component)this.tlauncher, 75, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.tlauncher, 160, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.tlauncher, 10, "South", (Component)gammeLauncher);
        spring.putConstraint("South", (Component)this.tlauncher, 95, "South", (Component)gammeLauncher);
        panel.add(this.tlauncher);
        spring.putConstraint("West", (Component)tlaunherName, 30, "West", (Component)panel);
        spring.putConstraint("East", (Component)tlaunherName, 380, "West", (Component)panel);
        spring.putConstraint("North", (Component)tlaunherName, 10, "South", (Component)this.tlauncher);
        spring.putConstraint("South", (Component)tlaunherName, 23, "South", (Component)this.tlauncher);
        panel.add(tlaunherName);
        spring.putConstraint("West", (Component)text1, 300, "West", (Component)panel);
        spring.putConstraint("East", (Component)text1, 600, "West", (Component)panel);
        spring.putConstraint("North", (Component)text1, 75, "North", (Component)panel);
        spring.putConstraint("South", (Component)text1, 50, "North", (Component)panel);
        panel.add(text1);
        spring.putConstraint("West", (Component)helpPage, 250, "West", (Component)panel);
        spring.putConstraint("East", (Component)helpPage, 600, "West", (Component)panel);
        spring.putConstraint("North", (Component)helpPage, 5, "South", (Component)text1);
        spring.putConstraint("South", (Component)helpPage, 25, "South", (Component)text1);
        panel.add(helpPage);
        spring.putConstraint("West", (Component)safetyInformation, 250, "West", (Component)panel);
        spring.putConstraint("East", (Component)safetyInformation, 600, "West", (Component)panel);
        spring.putConstraint("North", (Component)safetyInformation, 7, "South", (Component)helpPage);
        spring.putConstraint("South", (Component)safetyInformation, 25, "South", (Component)helpPage);
        panel.add(safetyInformation);
        spring.putConstraint("West", (Component)developerAnnouncement, 250, "West", (Component)panel);
        spring.putConstraint("East", (Component)developerAnnouncement, 600, "West", (Component)panel);
        spring.putConstraint("North", (Component)developerAnnouncement, 7, "South", (Component)safetyInformation);
        spring.putConstraint("South", (Component)developerAnnouncement, 25, "South", (Component)safetyInformation);
        panel.add(developerAnnouncement);
        spring.putConstraint("West", (Component)turikhay, 30, "West", (Component)panel);
        spring.putConstraint("East", (Component)turikhay, 600, "West", (Component)panel);
        spring.putConstraint("North", (Component)turikhay, 15, "South", (Component)tlaunherName);
        spring.putConstraint("South", (Component)turikhay, 32, "South", (Component)tlaunherName);
        panel.add(turikhay);
        spring.putConstraint("West", (Component)libraries, 30, "West", (Component)panel);
        spring.putConstraint("East", (Component)libraries, 400, "West", (Component)panel);
        spring.putConstraint("North", (Component)libraries, 15, "South", (Component)turikhay);
        spring.putConstraint("South", (Component)libraries, 32, "South", (Component)turikhay);
        panel.add(libraries);
        spring.putConstraint("West", (Component)this.cPanel, 30, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.cPanel, 600, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.cPanel, 10, "South", (Component)libraries);
        spring.putConstraint("South", (Component)this.cPanel, 160, "South", (Component)libraries);
        panel.add(this.cPanel);
        gammeLauncher.setFont(new JLabel().getFont().deriveFont(1, 18.0f));
        tlaunherName.setFont(new JLabel().getFont().deriveFont(1, 16.0f));
        libraries.setFont(new JLabel().getFont().deriveFont(1, 16.0f));
        text1.setFont(new JLabel().getFont().deriveFont(1, 16.0f));
        SwingUtil.changeFontFamily(turikhay, FontTL.CALIBRI_BOLD, 12);
        SwingUtil.changeFontFamily(helpPage, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(safetyInformation, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(developerAnnouncement, FontTL.ROBOTO_REGULAR, 14);
        helpPage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    String url = String.format("https://tlauncher.org/%s/help.html", TLauncher.getInstance().getConfiguration().isUSSRLocale() ? "ru" : "en");
                    OS.openLink(url);
                }
            }
        });
        safetyInformation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    String url = String.format("https://ad.tlauncher.org/l/security%s", TLauncher.getInstance().getConfiguration().isUSSRLocale() ? "-ru" : "");
                    OS.openLink(url);
                }
            }
        });
        developerAnnouncement.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    String url = String.format("https://ad.tlauncher.org/l/developer-announcement%s", TLauncher.getInstance().getConfiguration().isUSSRLocale() ? "-ru" : "");
                    OS.openLink(url);
                }
            }
        });
    }
}

