/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import by.gdev.util.DesktopUtil;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tlauncher.modpack.domain.client.CommentDTO;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameEntitySort;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.share.TopicType;
import org.tlauncher.modpack.domain.client.site.CommonPage;
import org.tlauncher.tlauncher.controller.CommentModpackController;
import org.tlauncher.tlauncher.exceptions.RequiredTLAccountException;
import org.tlauncher.tlauncher.exceptions.SelectedAnyOneTLAccountException;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.model.CurrentUserPosition;
import org.tlauncher.tlauncher.ui.model.InsertCommentDTO;
import org.tlauncher.tlauncher.ui.modpack.UserPositionCommentCheckbox;
import org.tlauncher.tlauncher.ui.modpack.form.CommentCreationForm;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.HtmlTextPane;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class DiscussionPanel
extends ExtendedPanel {
    private static final Logger log = LoggerFactory.getLogger(DiscussionPanel.class);
    private static final Object ob = new Object();
    private static final long serialVersionUID = -6938564413758462564L;
    private GameEntityDTO dto;
    private GameType type;
    private boolean first;
    @Inject
    private CommentModpackController controller;
    @Inject
    @Named(value="singleDownloadExecutor")
    private Executor singleDownloadExecutor;
    private CommentCreationForm commentCreationForm;
    private JScrollPane scrollPane;
    public final SimpleDateFormat format = new SimpleDateFormat(" dd.MM.YYYY HH:MM", Localizable.get().getSelected());
    private int oneGapeCommentWidth = 25;
    private int commentDescriptionWidth = 695;
    int v = 210;
    private JButton addedComment = new UpdaterButton(new Color(this.v, this.v, this.v), new Color(this.v - 30, this.v - 30, this.v - 30), "modpack.comment.leave");
    private Component gapeSpace;

    public DiscussionPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.scrollPane = ModpackScene.createScrollWrapper(this);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (DiscussionPanel.this.first) {
                    return;
                }
                DiscussionPanel.this.preparingContent(DiscussionPanel.this.dto.getId(), 0, 1, TopicType.GAME_ENTITY, 0);
            }
        });
        this.scrollPane.setPreferredSize(new Dimension(ModpackScene.SIZE.width, 500));
        ExtendedPanel ex = new ExtendedPanel(new FlowLayout(2, 0, 0));
        ex.setBorder(BorderFactory.createEmptyBorder(3, 3, 15, 92));
        ((Container)ex).add(this.addedComment);
        ex.setBackground(Color.GREEN);
        SwingUtil.changeFontFamily(this.addedComment, FontTL.ROBOTO_REGULAR, 15, Color.WHITE);
        this.add((Component)ex);
        this.addedComment.addActionListener(c -> SwingUtilities.invokeLater(() -> {
            this.commentCreationForm.setChangedComment(null);
            this.commentCreationForm.preparedForNewComment();
            this.commentCreationForm.setTopicPage(this.dto.getId());
            this.commentCreationForm.setTopicId(this.dto.getId());
            this.commentCreationForm.setType(this.type);
            this.commentCreationForm.setTopicType(TopicType.GAME_ENTITY);
            this.commentCreationForm.setVisible(true);
        }));
        this.gapeSpace = Box.createVerticalStrut(1);
    }

    public void preparingContent(Long id, int page, int insertElement, TopicType type, int gape) {
        CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
            CommonPage<CommentDTO> commonPage = this.controller.getComments(id, page, GameEntitySort.UPDATE, type);
            SwingUtilities.invokeLater(() -> {
                ArrayList result = new ArrayList();
                this.addedComment(result, commonPage, gape, id, null);
                int current = insertElement;
                for (Component c : result) {
                    this.add(c, current++);
                }
                this.calculateGape();
                this.scrollPane.revalidate();
                this.scrollPane.repaint();
                this.first = true;
            });
            return null;
        })).exceptionally(t -> {
            U.log(t);
            return null;
        });
    }

    private void calculateGape() {
        int size1 = 4;
        this.remove(this.gapeSpace);
        int size = this.getComponents().length;
        if (size < size1 && size != 1) {
            this.gapeSpace.setPreferredSize(new Dimension(0, (size1 - size) * 85));
            this.add(this.gapeSpace);
        } else if (this.findIndexElement(this.gapeSpace) != -1) {
            this.remove(this.gapeSpace);
        }
    }

    private void addedComment(List<? super Component> result, final CommonPage<CommentDTO> page, final int gape, final Long id, CommentDTO parent) {
        for (CommentDTO c : page.getContent()) {
            result.add(new Comment(c, gape, parent));
            if (!Objects.nonNull(c.getSubComments())) continue;
            this.addedComment(result, c.getSubComments(), gape + 1, c.getId(), c);
        }
        if (page.isNext()) {
            LocalizableLabel l = new LocalizableLabel("modpack.comment.show.more");
            final ExtendedPanel p = new ExtendedPanel(new BorderLayout(0, 0));
            l.setHorizontalAlignment(2);
            p.setBorder(BorderFactory.createEmptyBorder(0, 25 + gape * this.oneGapeCommentWidth, 10, 0));
            SwingUtil.changeFontFamily(l, FontTL.ROBOTO_REGULAR, 16, ColorUtil.BLUE_COLOR);
            p.add((Component)l, "West");
            result.add(p);
            l.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        int j = DiscussionPanel.this.findIndexElement(p);
                        SwingUtilities.invokeLater(() -> DiscussionPanel.this.remove(p));
                        DiscussionPanel.this.preparingContent(id, page.getCurrent() + 1, j, gape == 0 ? TopicType.GAME_ENTITY : TopicType.SUB_COMMENT, gape);
                    }
                }
            });
        }
    }

    @Subscribe
    public void insertComment(InsertCommentDTO comment) {
        SwingUtilities.invokeLater(() -> {
            if (Objects.isNull(comment.getParent())) {
                this.add((Component)new Comment(comment, 0, null), 1);
            } else {
                int j = this.findIndexElement(comment.getParent());
                this.add((Component)new Comment(comment, comment.getParent().getGape() + 1, comment.getParent().getComment()), j + 1);
            }
            this.calculateGape();
            this.revalidate();
            this.repaint();
        });
    }

    @Subscribe
    public void insertComment(CommentDTO comment) {
        SwingUtilities.invokeLater(() -> {
            Comment com = this.findIndexElement(comment);
            if (Objects.nonNull(com)) {
                com.setComment(comment);
                com.updateText();
            }
        });
    }

    private int findIndexElement(Component p) {
        int j = -1;
        for (int i = 0; i < this.getComponents().length; ++i) {
            if (!this.getComponents()[i].equals(p)) continue;
            j = i;
            break;
        }
        return j;
    }

    private Comment findIndexElement(CommentDTO c) {
        for (int i = 0; i < this.getComponents().length; ++i) {
            Component cc = this.getComponents()[i];
            if (!(cc instanceof Comment) || !((Comment)cc).getComment().getId().equals(c.getId())) continue;
            return (Comment)cc;
        }
        return null;
    }

    public void setDto(GameEntityDTO dto) {
        this.dto = dto;
    }

    public void setType(GameType type) {
        this.type = type;
    }

    public void setCommentCreationForm(CommentCreationForm commentCreationForm) {
        this.commentCreationForm = commentCreationForm;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public class Comment
    extends ExtendedPanel {
        private static final long serialVersionUID = 6313239430482145868L;
        private int gape;
        private volatile CommentDTO comment;
        private JPanel centerComment;
        private HtmlTextPane descriptionFull;

        public Comment(final CommentDTO c, int gape, CommentDTO parent) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 25 + gape * DiscussionPanel.this.oneGapeCommentWidth, 5, 0));
            this.gape = gape;
            this.comment = c;
            this.setLayout(new BorderLayout());
            ButtonGroup bg = new ButtonGroup();
            JLabel authorImage = new JLabel();
            final LocalizableLabel response = new LocalizableLabel("modpack.response");
            JLabel author = new JLabel(c.getAuthor());
            JLabel commentDate = new JLabel(DiscussionPanel.this.format.format(new Date(c.getUpdated())));
            ExtendedPanel topCommentPanel = new ExtendedPanel(new FlowLayout(0, 0, 0));
            this.centerComment = new ExtendedPanel(new BorderLayout());
            ExtendedPanel buttons = new ExtendedPanel(new FlowLayout(0, 0, 0));
            ExtendedPanel likes = new ExtendedPanel();
            BoxLayout bl = new BoxLayout(likes, 1);
            likes.setLayout(bl);
            UserPositionCommentCheckbox dislike = new UserPositionCommentCheckbox("modpack/icon-dislike-whole.png", "modpack/icon-dislike.png", bg, false);
            UserPositionCommentCheckbox like = new UserPositionCommentCheckbox("modpack/icon-like-whole.png", "modpack/icon-like.png", bg, true);
            CurrentUserPosition userPos = new CurrentUserPosition();
            if (Objects.nonNull(c.getAuthorPosition())) {
                if (c.getAuthorPosition().isPosition()) {
                    like.setSelected(true);
                    userPos.setGood((byte)1);
                } else {
                    dislike.setSelected(true);
                    userPos.setBad((byte)1);
                }
            }
            this.updateText();
            this.createUserPosition(c, dislike, userPos);
            this.createUserPosition(c, like, userPos);
            bg.add(dislike);
            bg.add(like);
            ((Container)likes).add(Box.createVerticalStrut(10));
            ((Container)likes).add(dislike);
            ((Container)likes).add(like);
            likes.setPreferredSize(new Dimension(100, 50));
            ExtendedPanel userAvatar = new ExtendedPanel(new BorderLayout());
            userAvatar.setPreferredSize(new Dimension(45, 45));
            authorImage.setPreferredSize(new Dimension(45, 30));
            userAvatar.add((Component)authorImage, "North");
            ((Container)buttons).add(response);
            if (c.isEdited()) {
                LocalizableLabel deleted = new LocalizableLabel("modpack.popup.delete");
                ((Container)buttons).add(deleted);
                deleted.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                SwingUtil.changeFontFamily(deleted, FontTL.ROBOTO_REGULAR, 15, Color.RED);
                deleted.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            int res = Alert.showConfirmDialog(0, 2, "", Localizable.get("modpack.comment.delete"), null, Localizable.get("ui.yes"), Localizable.get("ui.no"));
                            if (res != 0) {
                                return;
                            }
                            CompletableFuture.runAsync(() -> {
                                try {
                                    DiscussionPanel.this.controller.delete(c.getId(), DiscussionPanel.this.dto.getId());
                                    SwingUtilities.invokeLater(() -> {
                                        if (Objects.nonNull(c.getSubComments())) {
                                            c.setRemoved(true);
                                            Comment.this.updateText();
                                        } else {
                                            DiscussionPanel.this.remove(Comment.this);
                                            DiscussionPanel.this.calculateGape();
                                            DiscussionPanel.this.revalidate();
                                            DiscussionPanel.this.repaint();
                                        }
                                    });
                                }
                                catch (RequiredTLAccountException | SelectedAnyOneTLAccountException e1) {
                                    Alert.showLocError("modpack.right.panel.required.tl.account.title", "modpack.right.panel.select.account.tl", null);
                                }
                                catch (IOException ex) {
                                    log.warn("error", ex);
                                    Alert.showLocMessage("", "modpack.try.later", null);
                                }
                            });
                        }
                    }
                });
            }
            ((Container)topCommentPanel).add(author);
            ((Container)topCommentPanel).add(commentDate);
            if (c.isEdited()) {
                LocalizableLabel changed = new LocalizableLabel("settings.change");
                ((Container)topCommentPanel).add(changed);
                SwingUtil.changeFontFamily(changed, FontTL.ROBOTO_REGULAR, 15, Color.GRAY);
                changed.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                changed.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            SwingUtilities.invokeLater(() -> {
                                DiscussionPanel.this.commentCreationForm.setChangedComment(Comment.this.comment);
                                DiscussionPanel.this.commentCreationForm.preparedForNewComment();
                                DiscussionPanel.this.commentCreationForm.setTopicPage(DiscussionPanel.this.dto.getId());
                                DiscussionPanel.this.commentCreationForm.setTopicId(Comment.this.comment.getId());
                                DiscussionPanel.this.commentCreationForm.setType(null);
                                DiscussionPanel.this.commentCreationForm.setTopicType(null);
                                DiscussionPanel.this.commentCreationForm.setVisible(true);
                            });
                        }
                    }
                });
            }
            this.centerComment.add((Component)topCommentPanel, "North");
            this.centerComment.add((Component)this.descriptionFull, "Center");
            this.centerComment.add((Component)buttons, "South");
            this.add((Component)userAvatar, "West");
            this.add((Component)this.centerComment, "Center");
            this.add((Component)likes, "East");
            authorImage.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            like.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            SwingUtil.changeFontFamily(author, FontTL.ROBOTO_REGULAR, 15, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(commentDate, FontTL.ROBOTO_REGULAR, 15, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(response, FontTL.ROBOTO_REGULAR, 15, Color.GRAY);
            SwingUtil.changeFontFamily(dislike, FontTL.ROBOTO_REGULAR, 15, Color.BLACK);
            SwingUtil.changeFontFamily(like, FontTL.ROBOTO_REGULAR, 15, Color.BLACK);
            response.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    response.setForeground(ColorUtil.COLOR_25);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    response.setForeground(Color.GRAY);
                }
            });
            response.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && !c.isRemoved()) {
                        if (Comment.this.getGape() >= TLauncher.getInnerSettings().getInteger("modpack.comment.max.branch")) {
                            Alert.showLocMessage("skin.notification.title", "modpack.comment.max.branch", null);
                        } else {
                            DiscussionPanel.this.commentCreationForm.setChangedComment(null);
                            DiscussionPanel.this.commentCreationForm.preparedForNewComment();
                            DiscussionPanel.this.commentCreationForm.setTopicPage(DiscussionPanel.this.dto.getId());
                            DiscussionPanel.this.commentCreationForm.setTopicId(c.getId());
                            DiscussionPanel.this.commentCreationForm.setType(DiscussionPanel.this.type);
                            DiscussionPanel.this.commentCreationForm.setTopicType(TopicType.SUB_COMMENT);
                            DiscussionPanel.this.commentCreationForm.setParent(Comment.this);
                            DiscussionPanel.this.commentCreationForm.setVisible(true);
                        }
                    }
                }
            });
            CompletableFuture.runAsync(() -> {
                ImageIcon image = DiscussionPanel.this.controller.loadIcon(c.getAuthor());
                if (Objects.nonNull(image)) {
                    SwingUtilities.invokeLater(() -> {
                        authorImage.setIcon(image);
                        userAvatar.repaint();
                    });
                }
            }, DiscussionPanel.this.singleDownloadExecutor).exceptionally(e -> {
                log.warn("error", (Throwable)e);
                return null;
            });
            if (c.isRemoved()) {
                response.setVisible(false);
                likes.setVisible(false);
            }
        }

        public void updateText() {
            if (Objects.nonNull(this.descriptionFull)) {
                this.centerComment.remove(this.descriptionFull);
            }
            String text = this.comment.isRemoved() ? Localizable.get("modpack.comment.deleted") : this.comment.getDescription();
            this.descriptionFull = HtmlTextPane.getWithWidth(text, DiscussionPanel.this.commentDescriptionWidth - this.gape * DiscussionPanel.this.oneGapeCommentWidth);
            this.descriptionFull.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            this.centerComment.add((Component)this.descriptionFull, "Center");
            this.centerComment.revalidate();
            this.centerComment.repaint();
        }

        private void createUserPosition(CommentDTO c, UserPositionCommentCheckbox dislike, CurrentUserPosition pos) {
            dislike.setObject(ob);
            dislike.setController(DiscussionPanel.this.controller);
            dislike.setExecutor(DiscussionPanel.this.singleDownloadExecutor);
            dislike.setComment(c);
            dislike.setHorizontalTextPosition(4);
            dislike.setPos(pos);
            dislike.initCounterPosition();
        }

        public int getGape() {
            return this.gape;
        }

        public CommentDTO getComment() {
            return this.comment;
        }

        public JPanel getCenterComment() {
            return this.centerComment;
        }

        public HtmlTextPane getDescriptionFull() {
            return this.descriptionFull;
        }

        public void setGape(int gape) {
            this.gape = gape;
        }

        public void setComment(CommentDTO comment) {
            this.comment = comment;
        }

        public void setCenterComment(JPanel centerComment) {
            this.centerComment = centerComment;
        }

        public void setDescriptionFull(HtmlTextPane descriptionFull) {
            this.descriptionFull = descriptionFull;
        }

        @Override
        public String toString() {
            return "DiscussionPanel.Comment(gape=" + this.getGape() + ", comment=" + this.getComment() + ", centerComment=" + this.getCenterComment() + ", descriptionFull=" + this.getDescriptionFull() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getGape() != other.getGape()) {
                return false;
            }
            CommentDTO this$comment = this.getComment();
            CommentDTO other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !((Object)this$comment).equals(other$comment)) {
                return false;
            }
            JPanel this$centerComment = this.getCenterComment();
            JPanel other$centerComment = other.getCenterComment();
            if (this$centerComment == null ? other$centerComment != null : !this$centerComment.equals(other$centerComment)) {
                return false;
            }
            HtmlTextPane this$descriptionFull = this.getDescriptionFull();
            HtmlTextPane other$descriptionFull = other.getDescriptionFull();
            return !(this$descriptionFull == null ? other$descriptionFull != null : !this$descriptionFull.equals(other$descriptionFull));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Comment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getGape();
            CommentDTO $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : ((Object)$comment).hashCode());
            JPanel $centerComment = this.getCenterComment();
            result = result * 59 + ($centerComment == null ? 43 : $centerComment.hashCode());
            HtmlTextPane $descriptionFull = this.getDescriptionFull();
            result = result * 59 + ($descriptionFull == null ? 43 : $descriptionFull.hashCode());
            return result;
        }
    }
}

