/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.nio.file.NoSuchFileException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.explorer.filters.FilesAndExtentionFilter;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.tlauncher.ui.swing.GameInstallRadioButton;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;
import org.tlauncher.util.swing.FontTL;

public class HandleInstallModpackElementFrame
extends TemlateModpackFrame {
    private GameType type = GameType.MOD;
    private static final Dimension DEFAULT_SIZE = new Dimension(572, 470);
    private File[] files;
    private LocalizableLabel installToModpack;

    public HandleInstallModpackElementFrame(JFrame parent, CompleteVersion version) {
        super(parent, "modpack.install.handle.title", DEFAULT_SIZE);
        SpringLayout spring = new SpringLayout();
        JPanel panel = new JPanel(spring);
        ButtonGroup group = new ButtonGroup();
        this.addCenter(panel);
        FileChooser chooser = (FileChooser)TLauncher.getInjector().getInstance(FileChooser.class);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new FilesAndExtentionFilter("zip,rar,jar", "zip", "rar", "jar"));
        GameInstallRadioButton mods = new GameInstallRadioButton("modpack.button.mod");
        GameInstallRadioButton texturePacks = new GameInstallRadioButton("modpack.button.resourcepack");
        GameInstallRadioButton maps = new GameInstallRadioButton("modpack.button.map");
        GameInstallRadioButton shaderpacks = new GameInstallRadioButton("modpack.button.shaderpack");
        UpdaterButton chooseFiles = new UpdaterButton(ColorUtil.COLOR_215, "modpack.explorer.files");
        this.installToModpack = new LocalizableLabel();
        LocalizableLabel warningLabel = new LocalizableLabel("modpack.install.handle.warning");
        UpdaterButton install = new UpdaterButton(BLUE_COLOR, BLUE_COLOR_UNDER, "loginform.enter.install");
        this.installToModpack.setHorizontalAlignment(0);
        warningLabel.setHorizontalAlignment(0);
        group.add(mods);
        group.add(texturePacks);
        group.add(maps);
        group.add(shaderpacks);
        SwingUtil.changeFontFamily(mods, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(texturePacks, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(maps, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(shaderpacks, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(chooseFiles, FontTL.ROBOTO_MEDIUM, 12, ColorUtil.get(96));
        SwingUtil.changeFontFamily(this.installToModpack, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(warningLabel, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(install, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        warningLabel.setBackground(ColorUtil.COLOR_244);
        panel.setBackground(Color.WHITE);
        warningLabel.setOpaque(true);
        spring.putConstraint("West", (Component)mods, 0, "West", (Component)panel);
        spring.putConstraint("East", (Component)mods, 143, "West", (Component)panel);
        spring.putConstraint("North", (Component)mods, 0, "North", (Component)panel);
        spring.putConstraint("South", (Component)mods, 58, "North", (Component)panel);
        panel.add(mods);
        spring.putConstraint("West", (Component)texturePacks, 143, "West", (Component)panel);
        spring.putConstraint("East", (Component)texturePacks, 286, "West", (Component)panel);
        spring.putConstraint("North", (Component)texturePacks, 0, "North", (Component)panel);
        spring.putConstraint("South", (Component)texturePacks, 58, "North", (Component)panel);
        panel.add(texturePacks);
        spring.putConstraint("West", (Component)maps, 286, "West", (Component)panel);
        spring.putConstraint("East", (Component)maps, 429, "West", (Component)panel);
        spring.putConstraint("North", (Component)maps, 0, "North", (Component)panel);
        spring.putConstraint("South", (Component)maps, 58, "North", (Component)panel);
        panel.add(maps);
        spring.putConstraint("West", (Component)shaderpacks, 429, "West", (Component)panel);
        spring.putConstraint("East", (Component)shaderpacks, 0, "East", (Component)panel);
        spring.putConstraint("North", (Component)shaderpacks, 0, "North", (Component)panel);
        spring.putConstraint("South", (Component)shaderpacks, 58, "North", (Component)panel);
        panel.add(shaderpacks);
        spring.putConstraint("West", (Component)chooseFiles, 179, "West", (Component)panel);
        spring.putConstraint("East", (Component)chooseFiles, -177, "East", (Component)panel);
        spring.putConstraint("North", (Component)chooseFiles, 97, "North", (Component)panel);
        spring.putConstraint("South", (Component)chooseFiles, 135, "North", (Component)panel);
        panel.add(chooseFiles);
        spring.putConstraint("West", (Component)this.installToModpack, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.installToModpack, -27, "East", (Component)panel);
        spring.putConstraint("North", (Component)this.installToModpack, 156, "North", (Component)panel);
        spring.putConstraint("South", (Component)this.installToModpack, 182, "North", (Component)panel);
        panel.add(this.installToModpack);
        spring.putConstraint("West", (Component)warningLabel, 0, "West", (Component)panel);
        spring.putConstraint("East", (Component)warningLabel, 0, "East", (Component)panel);
        spring.putConstraint("North", (Component)warningLabel, 208, "North", (Component)panel);
        spring.putConstraint("South", (Component)warningLabel, 326, "North", (Component)panel);
        panel.add(warningLabel);
        spring.putConstraint("West", (Component)install, 205, "West", (Component)panel);
        spring.putConstraint("East", (Component)install, 368, "West", (Component)panel);
        spring.putConstraint("North", (Component)install, -68, "South", (Component)panel);
        spring.putConstraint("South", (Component)install, -29, "South", (Component)panel);
        panel.add(install);
        mods.addItemListener(e -> {
            if (1 == e.getStateChange()) {
                chooseFiles.setText(Localizable.get("modpack.explorer.files"));
                this.files = null;
                this.type = GameType.MOD;
                this.updateInfoLabel(version);
            }
        });
        maps.addItemListener(e -> {
            if (1 == e.getStateChange()) {
                chooseFiles.setText(Localizable.get("modpack.explorer.files"));
                this.files = null;
                this.type = GameType.MAP;
                this.updateInfoLabel(version);
            }
        });
        texturePacks.addItemListener(e -> {
            if (1 == e.getStateChange()) {
                chooseFiles.setText(Localizable.get("modpack.explorer.files"));
                this.files = null;
                this.type = GameType.RESOURCEPACK;
                this.updateInfoLabel(version);
            }
        });
        shaderpacks.addItemListener(e -> {
            if (1 == e.getStateChange()) {
                chooseFiles.setText(Localizable.get("modpack.explorer.files"));
                this.files = null;
                this.type = GameType.SHADERPACK;
                this.updateInfoLabel(version);
            }
        });
        chooseFiles.addActionListener(e -> {
            chooseFiles.setBorder(BorderFactory.createEmptyBorder());
            try {
                int result = chooser.showDialog(this, Localizable.get("modpack.explorer.files"));
                if (result == 0) {
                    this.files = chooser.getSelectedFiles();
                    chooseFiles.setText(Localizable.get("explorer.backup.file.chosen"));
                }
            }
            catch (NullPointerException ex) {
                U.log(ex);
            }
        });
        install.addActionListener(e -> {
            if (this.files == null) {
                chooseFiles.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
                return;
            }
            AsyncThread.execute(() -> ((ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class)).installHandleEntity(this.files, version, this.type, new HandleListener(){

                @Override
                public void processError(Throwable e1) {
                    HandleInstallModpackElementFrame.this.setVisible(false);
                    String message = "modpack.install.files.error";
                    if (e1 instanceof NoSuchFileException) {
                        message = Localizable.get("file.not.exist", e1.getMessage());
                    }
                    Alert.showLocError(message);
                    HandleInstallModpackElementFrame.this.setVisible(true);
                }

                @Override
                public void installedSuccess() {
                    HandleInstallModpackElementFrame.this.setVisible(false);
                    Alert.showLocMessage("modpack.install.files.installed");
                    HandleInstallModpackElementFrame.this.setVisible(true);
                }
            }));
        });
        mods.setSelected(true);
    }

    private void updateInfoLabel(CompleteVersion version) {
        this.installToModpack.setText(Localizable.get("modpack.install.handle." + this.type.toString().toLowerCase()).replace("modpack.name", version.getModpack().getName()));
    }

    public static interface HandleListener {
        public void installedSuccess();

        public void processError(Throwable var1);
    }
}

