/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import by.gdev.util.DesktopUtil;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.share.CategoryDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.site.CommonPage;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.button.StatusStarButton;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityPanel;
import org.tlauncher.tlauncher.ui.listener.mods.UpdateFavoriteValueListener;
import org.tlauncher.tlauncher.ui.listener.mods.VersionsAdjustmentListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterFullButton;
import org.tlauncher.tlauncher.ui.loc.modpack.GameRightButton;
import org.tlauncher.tlauncher.ui.loc.modpack.ModpackActButton;
import org.tlauncher.tlauncher.ui.loc.modpack.ModpackTableVersionButton;
import org.tlauncher.tlauncher.ui.loc.modpack.UpInstallButton;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.menu.ModpackCategoryPopupMenu;
import org.tlauncher.tlauncher.ui.modpack.AddedButtonOldVersion;
import org.tlauncher.tlauncher.ui.modpack.AddedModpackStuffFrame;
import org.tlauncher.tlauncher.ui.modpack.DiscussionPanel;
import org.tlauncher.tlauncher.ui.modpack.GroupPanel;
import org.tlauncher.tlauncher.ui.modpack.PicturePanel;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.modpack.form.CommentCreationForm;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.tlauncher.ui.server.BackPanel;
import org.tlauncher.tlauncher.ui.swing.GameRadioButton;
import org.tlauncher.tlauncher.ui.swing.HtmlTextPane;
import org.tlauncher.tlauncher.ui.swing.ScrollPane;
import org.tlauncher.tlauncher.ui.swing.TextWrapperLabel;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.renderer.JTableButtonRenderer;
import org.tlauncher.tlauncher.ui.ui.ModpackScrollBarUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class CompleteSubEntityScene
extends PseudoScene
implements UpdateFavoriteValueListener {
    public static final AtomicBoolean b = new AtomicBoolean(false);
    protected final ExtendedPanel panel = new ExtendedPanel(new GridLayout(1, 1, 0, 0));
    private JLayeredPane layeredPane;
    protected final String REVIEW_S = "REVIEW";
    protected final String VERSION_S = "VERSIONS";
    protected final String PICTURES_S = "PICTURES";
    protected final String DISCUSSION_S = "DISCUSSION";
    protected final ModpackManager manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
    private static Executor singleDownloadExecutor = (Executor)TLauncher.getInjector().getInstance(Key.get(Executor.class, (Annotation)Names.named((String)"singleDownloadExecutor")));
    protected FullGameEntity fullGameEntity;
    public static final int BUTTON_PANEL_SUB_VIEW = 130;
    private static final int activeColumn = 5;
    private CommentCreationForm commentCreationForm;

    public CompleteSubEntityScene(MainPane main) {
        super(main);
        this.layeredPane = new JLayeredPane(){

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        this.panel.setOpaque(true);
        this.panel.setForeground(Color.BLACK);
        this.panel.setSize(ModpackScene.SIZE);
        this.layeredPane.setSize(ModpackScene.SIZE);
        this.commentCreationForm = (CommentCreationForm)TLauncher.getInjector().getInstance(CommentCreationForm.class);
        this.layeredPane.add(this.commentCreationForm);
        this.layeredPane.add(this.panel);
        this.add((Component)this.layeredPane);
    }

    @Override
    public void onResize() {
        super.onResize();
        this.layeredPane.setLocation(this.getWidth() / 2 - this.layeredPane.getWidth() / 2, (this.getHeight() - LoginForm.LOGIN_SIZE.height) / 2 - this.layeredPane.getHeight() / 2);
    }

    public void showFullGameEntity(GameEntityDTO gameEntityDTO, final GameType type) {
        this.clean(type);
        U.debug("open " + gameEntityDTO.getName() + " " + U.memoryStatus());
        BackPanel backPanel = new BackPanel("", new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    CompleteSubEntityScene.this.getMainPane().setScene(CompleteSubEntityScene.this.getMainPane().modpackScene);
                    CompleteSubEntityScene.this.clean(type);
                    SwingUtilities.invokeLater(() -> CompleteSubEntityScene.this.getMainPane().modpackScene.resetSelectedRightElement());
                }
            }
        }, ImageCache.getIcon((String)"back-arrow.png"));
        this.fullGameEntity = new FullGameEntity(gameEntityDTO, backPanel, type);
        this.panel.removeAll();
        this.panel.add((Component)this.fullGameEntity);
        if (this.getMainPane().getScene() != this) {
            this.getMainPane().setScene(this);
        } else {
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    protected void clean(GameType type) {
        if (this.fullGameEntity != null) {
            this.panel.remove(this.fullGameEntity);
            this.fullGameEntity.clearContent();
            this.manager.removeGameListener(type, this.fullGameEntity);
            this.fullGameEntity = null;
        }
    }

    public void showModpackElement(GameEntityDTO completeGameEntity, final GameType type) {
        this.clean(type);
        BackPanel backPanel = new BackPanel("", new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    CompleteSubEntityScene.this.getMainPane().setScene(CompleteSubEntityScene.this.getMainPane().modpackEnitityScene);
                    CompleteSubEntityScene.this.clean(type);
                }
            }
        }, ImageCache.getIcon((String)"back-arrow.png"));
        this.fullGameEntity = new FullGameEntity(completeGameEntity, backPanel, type);
        this.panel.add((Component)this.fullGameEntity);
        this.revalidate();
        this.repaint();
        this.getMainPane().setScene(this);
    }

    @Override
    public void updateFavoriteValue() {
        if (Objects.nonNull(this.fullGameEntity)) {
            ((FullGameEntity)this.fullGameEntity).viewEntity.statusStarButton.updateStatus();
        }
    }

    public class FullGameEntity
    extends GameEntityPanel {
        private final Color UP_BACKGROUND = new Color(60, 170, 232);
        private final UpInstallButton installButton;
        private final GameEntityDTO entity;
        private final GameType type;
        private final DescriptionGamePanel viewEntity;
        private final Injector injector;
        private final GroupPanel centerButtons;
        private final JPanel centerView;
        private JTable table;
        private Integer nextPageIndex = 0;
        private boolean nextPage = true;
        private boolean processingRequest;
        private HtmlTextPane descriptionFull;
        private JScrollPane jScrollPane;

        public GroupPanel getCenterButtons() {
            return this.centerButtons;
        }

        public void clearContent() {
            U.log("clean");
            this.descriptionFull.setText("");
        }

        public JPanel getCenterView() {
            return this.centerView;
        }

        private FullGameEntity(final GameEntityDTO entity, BackPanel backPanel, final GameType type) {
            this.entity = entity;
            this.type = type;
            this.injector = TLauncher.getInjector();
            SpringLayout spring = new SpringLayout();
            this.setLayout(spring);
            UpdaterFullButton officialSite = new UpdaterFullButton(this.UP_BACKGROUND, ColorUtil.BLUE_MODPACK_BUTTON_UP, "modpack.complete.site.button", "official-site.png");
            officialSite.setIconTextGap(15);
            UpdaterFullButton tlmodsSite = new UpdaterFullButton(this.UP_BACKGROUND, ColorUtil.BLUE_MODPACK_BUTTON_UP, "tlmods.open.link", "official-site.png");
            tlmodsSite.setIconTextGap(15);
            if (entity.getLinkProject() == null) {
                officialSite.setVisible(false);
            }
            if (Objects.isNull(entity.getTlmodsLinkProject())) {
                tlmodsSite.setVisible(false);
            }
            ButtonGroup group = new ButtonGroup();
            GameRadioButton reviewButton = new GameRadioButton("modpack.complete.review.button");
            GameRadioButton picturesButton = new GameRadioButton("modpack.complete.picture.button");
            GameRadioButton discussionButton = new GameRadioButton(Localizable.get("modpack.complete.discussion.button") + String.format(" (%s)", entity.getTotalComments()));
            reviewButton.setSelected(true);
            reviewButton.setActionCommand("REVIEW");
            picturesButton.setActionCommand("PICTURES");
            discussionButton.setActionCommand("DISCUSSION");
            group.add(reviewButton);
            group.add(picturesButton);
            group.add(discussionButton);
            GameRadioButton versionsButton = new GameRadioButton("modpack.complete.versions.button");
            versionsButton.setActionCommand("VERSIONS");
            group.add(versionsButton);
            final Color backgroundOldButtonColor = new Color(213, 213, 213);
            final UpdaterButton oldButton = new UpdaterButton(backgroundOldButtonColor, "modpack.complete.old.button");
            oldButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    oldButton.setBackground(new Color(160, 160, 160));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    oldButton.setBackground(backgroundOldButtonColor);
                }
            });
            oldButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                        AddedModpackStuffFrame amsf;
                        String message = "modpack.element.old.question";
                        if (CompleteSubEntityScene.this.manager.getGameEntityWithParserField(entity.getId(), type).isParser()) {
                            message = "modpack.added.request.message1";
                            amsf = new AddedButtonOldVersion(TLauncher.getInstance().getFrame(), "modpack.added.request", message, entity.getId(), type);
                        } else {
                            amsf = new AddedModpackStuffFrame((JFrame)TLauncher.getInstance().getFrame(), "modpack.added.request", message);
                        }
                        amsf.setVisible(true);
                        return null;
                    })).exceptionally(t -> {
                        SwingUtilities.invokeLater(() -> {
                            if (t.getMessage().contains("code 429 phrase")) {
                                Alert.showLocWarning("modpack.added.request.limit");
                            } else {
                                Alert.showLocMessage("", "modpack.try.later", null);
                            }
                        });
                        U.log(t);
                        return null;
                    });
                }
            });
            final JLabel originalEnDescription = new JLabel((Icon)ImageCache.getIcon((String)"modpack-original-transation.png"));
            originalEnDescription.setPreferredSize(new Dimension(66, 52));
            originalEnDescription.setBorder(BorderFactory.createEmptyBorder());
            if (TLauncher.getInstance().getConfiguration().getLocale().getLanguage().equals("en")) {
                originalEnDescription.setVisible(false);
            }
            this.installButton = new UpInstallButton(entity, type, CompleteSubEntityScene.this.getMainPane().modpackScene.localmodpacks);
            this.installButton.setBorder(BorderFactory.createEmptyBorder(0, 19, 0, 0));
            this.installButton.setIconTextGap(18);
            ExtendedPanel reviewPanel = new ExtendedPanel();
            reviewPanel.setLayout(new FlowLayout(0, 0, 0));
            reviewPanel.setOpaque(true);
            reviewPanel.setBackground(ColorUtil.COLOR_246);
            ExtendedPanel versionsPanel = new ExtendedPanel();
            versionsPanel.setLayout(new BorderLayout());
            this.viewEntity = new CompleteDescriptionGamePanel(entity, type);
            final VersionModel model = new VersionModel();
            backPanel.addBackListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        CompleteSubEntityScene.this.manager.removeGameListener(type, model);
                    }
                }
            });
            CompleteSubEntityScene.this.manager.addGameListener(type, model);
            this.table = new ModpackTable(model);
            this.table.setBackground(Color.WHITE);
            ScrollPane c = ModpackScene.createScrollWrapper(this.table);
            versionsPanel.add((Component)c, "Center");
            SpringLayout upSpring = new SpringLayout();
            ExtendedPanel upButtons = new ExtendedPanel(upSpring);
            upButtons.setOpaque(true);
            upButtons.setBackground(this.UP_BACKGROUND);
            JPanel centerButtonsWrapper = new JPanel(new BorderLayout(0, 0));
            this.centerButtons = new GroupPanel(242);
            this.centerButtons.setLayout(new GridBagLayout());
            this.centerButtons.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
            this.centerButtons.addInGroup(reviewButton, 0);
            this.centerButtons.addInGroup(picturesButton, 1);
            this.centerButtons.addInGroup(versionsButton, 2);
            if (!GameType.MODPACK.equals((Object)type)) {
                this.centerButtons.addInGroup(discussionButton, 3);
                this.centerButtons.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 320));
            } else {
                this.centerButtons.addInGroup(discussionButton, 7);
            }
            this.centerView = new JPanel(new CardLayout(0, 0));
            this.centerView.setBackground(Color.WHITE);
            this.centerView.setOpaque(true);
            SwingUtil.configHorizontalSpingLayout(upSpring, backPanel, upButtons, 66);
            upSpring.putConstraint("West", (Component)backPanel, 0, "West", (Component)upButtons);
            upSpring.putConstraint("East", (Component)backPanel, 66, "West", (Component)upButtons);
            upButtons.add((Component)backPanel);
            SwingUtil.configHorizontalSpingLayout(upSpring, this.installButton, backPanel, 168);
            upButtons.add((Component)this.installButton);
            SwingUtil.configHorizontalSpingLayout(upSpring, tlmodsSite, this.installButton, 0);
            upSpring.putConstraint("West", (Component)tlmodsSite, 312, "East", (Component)this.installButton);
            upSpring.putConstraint("East", (Component)tlmodsSite, 562, "East", (Component)this.installButton);
            upButtons.add((Component)tlmodsSite);
            SwingUtil.configHorizontalSpingLayout(upSpring, officialSite, this.installButton, 0);
            upSpring.putConstraint("West", (Component)officialSite, 563, "East", (Component)this.installButton);
            upSpring.putConstraint("East", (Component)officialSite, 762, "East", (Component)this.installButton);
            upButtons.add((Component)officialSite);
            int gup = 20;
            this.descriptionFull = new HtmlTextPane("text/html", "");
            this.descriptionFull.setText(entity.getDescription());
            this.descriptionFull.setOpaque(true);
            this.descriptionFull.setBackground(ColorUtil.COLOR_246);
            this.jScrollPane = new JScrollPane(this.descriptionFull, 20, 31);
            this.jScrollPane.getVerticalScrollBar().setUI(new ModpackScrollBarUI(){

                @Override
                public Dimension getPreferredSize(JComponent c) {
                    return new Dimension(13, super.getPreferredSize((JComponent)c).height);
                }
            });
            this.jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            SwingUtilities.invokeLater(() -> this.jScrollPane.getVerticalScrollBar().setValue(0));
            int height = 318;
            ExtendedPanel panelDescription = new ExtendedPanel(new FlowLayout(0, 0, 0));
            panelDescription.setPreferredSize(new Dimension(ModpackScene.SIZE.width, height));
            this.jScrollPane.setPreferredSize(new Dimension(ModpackScene.SIZE.width - gup * 2, height - 40));
            panelDescription.setBorder(BorderFactory.createEmptyBorder(20, gup, 20, gup));
            ((Container)panelDescription).add(this.jScrollPane);
            ((Container)reviewPanel).add(panelDescription);
            SwingUtil.changeFontFamily(this.installButton, FontTL.ROBOTO_BOLD, 14, Color.WHITE);
            SwingUtil.changeFontFamily(officialSite, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
            SwingUtil.changeFontFamily(tlmodsSite, FontTL.ROBOTO_REGULAR, 14, Color.YELLOW);
            SwingUtil.changeFontFamily(reviewButton, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(versionsButton, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(picturesButton, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(discussionButton, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(oldButton, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
            PicturePanel picturePanel = new PicturePanel(entity, type);
            this.centerView.setBackground(Color.WHITE);
            this.centerView.add((Component)reviewPanel, "REVIEW");
            this.centerView.add((Component)picturePanel, "PICTURES");
            this.centerView.add((Component)versionsPanel, "VERSIONS");
            DiscussionPanel dp = (DiscussionPanel)this.injector.getInstance(DiscussionPanel.class);
            dp.setDto(entity);
            dp.setType(type);
            dp.setCommentCreationForm(CompleteSubEntityScene.this.commentCreationForm);
            this.centerView.add((Component)dp.getScrollPane(), "DISCUSSION");
            spring.putConstraint("North", (Component)upButtons, 0, "North", (Component)this);
            spring.putConstraint("West", (Component)upButtons, 0, "West", (Component)this);
            spring.putConstraint("South", (Component)upButtons, 56, "North", (Component)this);
            spring.putConstraint("East", (Component)upButtons, 0, "East", (Component)this);
            this.add((Component)upButtons);
            spring.putConstraint("North", (Component)this.viewEntity, 0, "South", (Component)upButtons);
            spring.putConstraint("West", (Component)this.viewEntity, 0, "West", (Component)this);
            spring.putConstraint("South", (Component)this.viewEntity, 159, "South", (Component)upButtons);
            spring.putConstraint("East", (Component)this.viewEntity, 0, "East", (Component)this);
            this.add((Component)this.viewEntity);
            centerButtonsWrapper.add((Component)this.centerButtons, "Center");
            JPanel rightPart = new JPanel(new BorderLayout());
            rightPart.add((Component)originalEnDescription, "East");
            rightPart.setBackground(Color.WHITE);
            rightPart.add((Component)oldButton, "West");
            oldButton.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
            centerButtonsWrapper.add((Component)rightPart, "East");
            spring.putConstraint("North", (Component)centerButtonsWrapper, 0, "South", (Component)this.viewEntity);
            spring.putConstraint("West", (Component)centerButtonsWrapper, 0, "West", (Component)this);
            spring.putConstraint("South", (Component)centerButtonsWrapper, 52, "South", (Component)this.viewEntity);
            spring.putConstraint("East", (Component)centerButtonsWrapper, 0, "East", (Component)this);
            this.add((Component)centerButtonsWrapper);
            spring.putConstraint("North", (Component)this.centerView, 0, "South", (Component)centerButtonsWrapper);
            spring.putConstraint("West", (Component)this.centerView, 0, "West", (Component)this);
            spring.putConstraint("South", (Component)this.centerView, 321, "South", (Component)centerButtonsWrapper);
            spring.putConstraint("East", (Component)this.centerView, 0, "East", (Component)this);
            this.add((Component)this.centerView);
            ModpackManager modpackManager = (ModpackManager)this.injector.getInstance(ModpackManager.class);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((CardLayout)FullGameEntity.this.centerView.getLayout()).show(FullGameEntity.this.centerView, e.getActionCommand());
                }
            };
            reviewButton.addActionListener(listener);
            versionsButton.addActionListener(listener);
            picturesButton.addActionListener(listener);
            discussionButton.addActionListener(listener);
            officialSite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OS.openLink(entity.getLinkProject());
                }
            });
            tlmodsSite.addActionListener(ev -> OS.openLink(entity.getTlmodsLinkProject()));
            modpackManager.addGameListener(type, this);
            backPanel.addBackListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        CompleteSubEntityScene.this.manager.removeGameListener(type, FullGameEntity.this);
                    }
                }
            });
            originalEnDescription.addMouseListener(new MouseAdapter(){
                private boolean active = true;

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        int currentValue = FullGameEntity.this.jScrollPane.getVerticalScrollBar().getValue();
                        if (this.active) {
                            CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                                if (entity.getEnDescription() == null) {
                                    entity.setEnDescription(CompleteSubEntityScene.this.manager.getGameEntityDescriptions(type, entity.getId()).getDescription());
                                }
                                this.active = false;
                                FullGameEntity.this.descriptionFull.setText(entity.getEnDescription());
                                SwingUtilities.invokeLater(() -> FullGameEntity.this.jScrollPane.getVerticalScrollBar().setValue(currentValue));
                                return null;
                            })).exceptionally(ex -> {
                                U.log(ex);
                                Alert.showError("", Localizable.get("modpack.remote.not.found", Localizable.get("modpack.try.later")), null);
                                return null;
                            });
                        } else {
                            FullGameEntity.this.descriptionFull.setText(entity.getDescription());
                            this.active = true;
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    originalEnDescription.setIcon((Icon)ImageCache.getIcon((String)"modpack-original-transation-up.png"));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    originalEnDescription.setIcon((Icon)ImageCache.getIcon((String)"modpack-original-transation.png"));
                }
            });
            versionsPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    if (FullGameEntity.this.table.getModel().getRowCount() > 0) {
                        return;
                    }
                    FullGameEntity.this.fillVersions();
                }
            });
            c.getVerticalScrollBar().addAdjustmentListener(new VersionsAdjustmentListener(this.table, this));
        }

        @Override
        public void processingStarted(GameEntityDTO e, VersionDTO version) {
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
            this.installButton.installEntity(e, type);
        }

        @Override
        public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
        }

        @Override
        public void populateStatus(GameEntityDTO entity, GameType type, boolean state) {
            if (entity.getId().equals(this.entity.getId())) {
                this.viewEntity.getStatusStarButton().setStatus(state);
            }
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
            this.installButton.removeEntity(e);
        }

        public void fillVersions() {
            CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                if (this.nextPage) {
                    this.setProcessingRequest(true);
                    CommonPage<VersionDTO> versions = CompleteSubEntityScene.this.manager.getGameEntityVersions(this.type, this.entity.getId(), this.nextPageIndex);
                    this.nextPageIndex = versions.getCurrent() + 1;
                    this.nextPage = versions.isNext();
                    SwingUtilities.invokeLater(() -> {
                        ((VersionModel)this.table.getModel()).addElements(versions.getContent());
                        this.table.revalidate();
                        this.table.repaint();
                    });
                    this.setProcessingRequest(false);
                }
                return null;
            })).exceptionally(t -> {
                this.setProcessingRequest(false);
                U.log(t);
                return null;
            });
        }

        public Integer getNextPageIndex() {
            return this.nextPageIndex;
        }

        public void setNextPageIndex(Integer nextPageIndex) {
            this.nextPageIndex = nextPageIndex;
        }

        public boolean isNextPage() {
            return this.nextPage;
        }

        public void setNextPage(boolean nextPage) {
            this.nextPage = nextPage;
        }

        public boolean isProcessingRequest() {
            return this.processingRequest;
        }

        public void setProcessingRequest(boolean processingRequest) {
            this.processingRequest = processingRequest;
        }

        class CompleteDescriptionGamePanel
        extends DescriptionGamePanel {
            public static final int SHADOW_PANEL = 223;

            public CompleteDescriptionGamePanel(GameEntityDTO entity, GameType type) {
                super(entity, type);
            }

            @Override
            protected void paintComponent(Graphics g0) {
                super.paintComponent(g0);
                Rectangle rec = this.getVisibleRect();
                int i = 223;
                Graphics2D g2 = (Graphics2D)g0;
                for (int y = rec.y; y < rec.height + rec.y; ++y) {
                    g2.setColor(new Color(i, i, i));
                    if (i != 255) {
                        ++i;
                    }
                    g2.drawLine(rec.x, y, rec.x + rec.width, y);
                }
            }
        }

        class VersionModel
        extends BaseSubtypeModel<VersionModelElement> {
            VersionModel() {
            }

            public void addElements(List<? extends VersionDTO> list) {
                ModpackComboBox modpackComboBox = TLauncher.getInstance().getFrame().mp.modpackScene.localmodpacks;
                BaseModpackFilter<VersionDTO> bmd = BaseModpackFilter.getBaseModpackStandardFilters(FullGameEntity.this.entity, FullGameEntity.this.type, modpackComboBox);
                for (VersionDTO versionDTO : list) {
                    ModpackTableVersionButton button = new ModpackTableVersionButton(FullGameEntity.this.entity, FullGameEntity.this.type, modpackComboBox, versionDTO, bmd);
                    this.list.add(new VersionModelElement(button, FullGameEntity.this.entity, versionDTO));
                }
            }

            @Override
            public int getRowCount() {
                return this.list.size();
            }

            @Override
            public int getColumnCount() {
                return 6;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                VersionDTO v = ((VersionModelElement)this.list.get(rowIndex)).getVersion();
                switch (columnIndex) {
                    case 0: {
                        return this.format.format(new Date(v.getUpdateDate()));
                    }
                    case 1: {
                        return v.getName();
                    }
                    case 2: {
                        return Objects.isNull(v.getMinecraftVersionTypes()) || v.getMinecraftVersionTypes().isEmpty() ? Localizable.get("modpack.version.any") : v.getMinecraftVersionTypes().stream().map(vv -> Localizable.get("modpack.version." + vv.getName())).collect(Collectors.joining(", "));
                    }
                    case 3: {
                        return v.getType();
                    }
                    case 4: {
                        if (v.getGameVersionsDTO().isEmpty()) {
                            return Localizable.get("modpack.version.any");
                        }
                        return v.getGameVersionsDTO().stream().map(GameVersionDTO::getName).collect(Collectors.joining(", "));
                    }
                    case 5: {
                        return ((VersionModelElement)this.list.get(rowIndex)).getModpackActButton();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 5) {
                    return BaseModelElement.class;
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public String getColumnName(int column) {
                String line = "";
                switch (column) {
                    case 0: {
                        line = Localizable.get("version.manager.editor.field.time");
                        return line.substring(0, line.length() - 1);
                    }
                    case 1: {
                        return Localizable.get("version.release");
                    }
                    case 2: {
                        line = Localizable.get("version.manager.editor.field.type");
                        return line.substring(0, line.length() - 1);
                    }
                    case 3: {
                        return Localizable.get("modpack.table.version.maturiry");
                    }
                    case 4: {
                        return Localizable.get("modpack.table.pack.element.version");
                    }
                    case 5: {
                        return Localizable.get("modpack.table.pack.element.operation");
                    }
                }
                return "";
            }

            @Override
            public void installEntity(GameEntityDTO e, GameType type) {
                int index = this.findByVersion(e, e.getVersion());
                if (index != -1) {
                    ((VersionModelElement)this.list.get(index)).getModpackActButton().setTypeButton("REMOVE");
                    this.fireTableCellUpdated(index, 5);
                }
            }

            @Override
            public void removeEntity(GameEntityDTO e) {
                int index = this.findByVersion(e, e.getVersion());
                if (index != -1) {
                    ((VersionModelElement)this.list.get(index)).getModpackActButton().setTypeButton("INSTALL");
                    this.fireTableCellUpdated(index, 5);
                }
            }

            @Override
            public void processingStarted(GameEntityDTO e, VersionDTO version) {
                if (Objects.nonNull(version) && e.getId().equals(FullGameEntity.this.entity.getId())) {
                    for (int i = 0; i < this.list.size(); ++i) {
                        if (!((VersionModelElement)this.list.get(i)).getVersion().getId().equals(version.getId())) continue;
                        ((VersionModelElement)this.list.get(i)).getModpackActButton().setTypeButton("PROCESSING");
                        this.fireTableCellUpdated(i, 5);
                        return;
                    }
                }
            }

            @Override
            public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
                int index = this.findByVersion(e, v);
                if (index != -1) {
                    ((VersionModelElement)this.list.get(index)).getModpackActButton().reset();
                    this.fireTableCellUpdated(index, 5);
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 5;
            }

            public int findByVersion(GameEntityDTO e, VersionDTO v) {
                if (e.getId().equals(FullGameEntity.this.entity.getId())) {
                    for (int i = 0; i < this.list.size(); ++i) {
                        VersionModelElement element = (VersionModelElement)this.list.get(i);
                        if (!element.getVersion().getId().equals(v.getId())) continue;
                        return i;
                    }
                }
                return -1;
            }

            @Override
            public GameEntityDTO getRowObject(int rowIndex) {
                return null;
            }
        }
    }

    protected class ModpackTableRenderer
    extends DefaultTableCellRenderer {
        protected ModpackTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultTableCellRenderer cell = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setHorizontalAlignment(0);
            if (column == 1) {
                cell.setHorizontalAlignment(2);
            }
            SwingUtil.changeFontFamily(cell, FontTL.ROBOTO_REGULAR, 12, ColorUtil.COLOR_25);
            cell.setFocusable(false);
            if (hasFocus) {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            return cell;
        }
    }

    protected class ModpackTable
    extends JTable {
        protected void init() {
            this.setRowHeight(58);
            this.getColumnModel().setColumnSelectionAllowed(false);
            this.setShowVerticalLines(false);
            this.setCellSelectionEnabled(false);
            this.setGridColor(ColorUtil.COLOR_244);
            JTableHeader header = this.getTableHeader();
            header.setPreferredSize(new Dimension(header.getPreferredSize().width - 20, 48));
            header.setDefaultRenderer(new TableCellRenderer(){
                final DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    DefaultTableCellRenderer comp = (DefaultTableCellRenderer)this.cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    comp.setBorder(BorderFactory.createEmptyBorder());
                    comp.setBackground(new Color(63, 186, 255));
                    comp.setHorizontalAlignment(0);
                    SwingUtil.changeFontFamily(comp, FontTL.ROBOTO_REGULAR, 12, Color.WHITE);
                    return comp;
                }
            });
            ModpackTableRenderer centerRenderer = new ModpackTableRenderer();
            for (int i = 0; i < this.getModel().getColumnCount() - 1; ++i) {
                this.getColumnModel().getColumn(i).setCellRenderer(centerRenderer);
            }
            this.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.getTableHeader().setReorderingAllowed(false);
            this.setDefaultEditor(BaseModelElement.class, new JTableButtonRenderer());
            this.setDefaultRenderer(BaseModelElement.class, new JTableButtonRenderer());
        }

        public ModpackTable(AbstractTableModel model) {
            super(model);
            this.init();
        }
    }

    protected abstract class GameEntityTableModel
    extends AbstractTableModel
    implements GameEntityListener {
        protected GameEntityTableModel() {
        }

        @Override
        public void activationStarted(GameEntityDTO e) {
        }

        @Override
        public void activation(GameEntityDTO e) {
        }

        @Override
        public void activationError(GameEntityDTO e, Throwable t) {
        }

        @Override
        public void processingStarted(GameEntityDTO e, VersionDTO version) {
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
        }

        @Override
        public void installEntity(CompleteVersion e) {
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
        }

        @Override
        public void removeCompleteVersion(CompleteVersion e) {
        }

        @Override
        public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
        }

        @Override
        public void populateStatus(GameEntityDTO status, GameType type, boolean state) {
        }

        @Override
        public void updateVersion(CompleteVersion v, CompleteVersion newVersion) {
        }
    }

    private class VersionModelElement
    extends BaseModelElement {
        private VersionDTO version;

        public VersionModelElement(ModpackActButton modpackActButton, GameEntityDTO entity, VersionDTO version) {
            super(modpackActButton, entity);
            this.version = version;
        }

        public VersionDTO getVersion() {
            return this.version;
        }

        public void setVersion(VersionDTO version) {
            this.version = version;
        }

        @Override
        public String toString() {
            return "CompleteSubEntityScene.VersionModelElement(version=" + this.getVersion() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VersionModelElement)) {
                return false;
            }
            VersionModelElement other = (VersionModelElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VersionDTO this$version = this.getVersion();
            VersionDTO other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof VersionModelElement;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            VersionDTO $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            return result;
        }
    }

    protected static class BaseModelElement {
        private ModpackActButton modpackActButton;
        private GameEntityDTO entity;

        public BaseModelElement(ModpackActButton modpackActButton, GameEntityDTO entity) {
            this.modpackActButton = modpackActButton;
            this.entity = entity;
        }

        public ModpackActButton getModpackActButton() {
            return this.modpackActButton;
        }

        public GameEntityDTO getEntity() {
            return this.entity;
        }

        public void setModpackActButton(ModpackActButton modpackActButton) {
            this.modpackActButton = modpackActButton;
        }

        public void setEntity(GameEntityDTO entity) {
            this.entity = entity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseModelElement)) {
                return false;
            }
            BaseModelElement other = (BaseModelElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ModpackActButton this$modpackActButton = this.getModpackActButton();
            ModpackActButton other$modpackActButton = other.getModpackActButton();
            if (this$modpackActButton == null ? other$modpackActButton != null : !this$modpackActButton.equals(other$modpackActButton)) {
                return false;
            }
            GameEntityDTO this$entity = this.getEntity();
            GameEntityDTO other$entity = other.getEntity();
            return !(this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaseModelElement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ModpackActButton $modpackActButton = this.getModpackActButton();
            result = result * 59 + ($modpackActButton == null ? 43 : $modpackActButton.hashCode());
            GameEntityDTO $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
            return result;
        }

        public String toString() {
            return "CompleteSubEntityScene.BaseModelElement(modpackActButton=" + this.getModpackActButton() + ", entity=" + this.getEntity() + ")";
        }
    }

    private abstract class BaseSubtypeModel<T extends BaseModelElement>
    extends GameEntityTableModel {
        protected List<T> list = new ArrayList<T>();
        protected final SimpleDateFormat format = new SimpleDateFormat("dd/MM/YYYY", Localizable.get().getSelected());

        private BaseSubtypeModel() {
        }

        public abstract GameEntityDTO getRowObject(int var1);

        public int find(GameEntityDTO entity) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!entity.getId().equals(((BaseModelElement)this.list.get(i)).getEntity().getId())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
            int index = this.find(e);
            if (index != -1) {
                ((BaseModelElement)this.list.get(index)).getModpackActButton().reset();
                this.fireTableCellUpdated(index, 5);
            }
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
            int index = this.find(e);
            if (index != -1) {
                ((BaseModelElement)this.list.get(index)).getModpackActButton().setTypeButton("REMOVE");
                this.fireTableCellUpdated(index, 5);
            }
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
            int index = this.find(e);
            if (index != -1) {
                ((BaseModelElement)this.list.get(index)).getModpackActButton().setTypeButton("INSTALL");
                this.fireTableCellUpdated(index, 5);
            }
        }
    }

    public static class DescriptionGamePanel
    extends JPanel {
        protected StatusStarButton statusStarButton;
        protected SpringLayout descriptionLayout;
        protected JLabel name;
        protected JTextArea description;
        protected JLabel downloadLabel;
        protected JLabel updateLabel;
        protected JLabel gameVersion;
        protected ImagePanel imagePanel;
        private final int gupPair = 30;
        private final int gup = 5;
        private final SimpleDateFormat format = new SimpleDateFormat("dd MMMM YYYY", Localizable.get().getSelected());

        public StatusStarButton getStatusStarButton() {
            return this.statusStarButton;
        }

        public DescriptionGamePanel(GameEntityDTO entity, GameType type) {
            this.descriptionLayout = new SpringLayout();
            this.statusStarButton = new StatusStarButton(entity, type);
            this.setLayout(this.descriptionLayout);
            this.imagePanel = new ImagePanel(entity);
            ExtendedPanel descriptionEntityPanel = new ExtendedPanel();
            this.name = new JLabel(entity.getName());
            this.name.setForeground(Color.black);
            LocalizableLabel authorLabel = new LocalizableLabel("modpack.complete.author");
            JLabel authorValue = new JLabel(entity.getAuthor());
            this.downloadLabel = new LocalizableLabel("modpack.description.download");
            JLabel downloadValue = new JLabel(this.getStringDownloadingCount(entity.getDownloadALL()));
            this.updateLabel = new LocalizableLabel("modpack.description.date");
            JLabel updateValue = new JLabel(this.format.format(new Date(entity.getUpdate())));
            this.gameVersion = new JLabel();
            LocalizableLabel gameVersionLabel = new LocalizableLabel("modpack.creation.version.game");
            if (Objects.isNull(entity.getLastGameVersion())) {
                this.gameVersion.setVisible(false);
                gameVersionLabel.setVisible(false);
            } else {
                this.gameVersion.setText(entity.getLastGameVersion().getName());
            }
            this.description = new TextWrapperLabel(entity.getShortDescription());
            this.description.setVisible(false);
            authorValue.setHorizontalAlignment(2);
            downloadValue.setHorizontalAlignment(2);
            updateValue.setHorizontalAlignment(2);
            this.gameVersion.setHorizontalAlignment(2);
            SwingUtil.changeFontFamily(this.name, FontTL.ROBOTO_BOLD, 18);
            SwingUtil.changeFontFamily(authorLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_193);
            SwingUtil.changeFontFamily(this.downloadLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(gameVersionLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(this.updateLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(authorValue, FontTL.ROBOTO_REGULAR, 14, ColorUtil.BLUE_MODPACK);
            SwingUtil.changeFontFamily(downloadValue, FontTL.ROBOTO_REGULAR, 14, ColorUtil.BLUE_MODPACK);
            SwingUtil.changeFontFamily(updateValue, FontTL.ROBOTO_REGULAR, 14, ColorUtil.BLUE_MODPACK);
            SwingUtil.changeFontFamily(this.gameVersion, FontTL.ROBOTO_REGULAR, 14, ColorUtil.BLUE_MODPACK);
            SwingUtil.changeFontFamily(this.description, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_64);
            SpringLayout descriptionSpring = new SpringLayout();
            descriptionEntityPanel.setLayout(descriptionSpring);
            this.descriptionLayout.putConstraint("West", (Component)this.imagePanel, 66, "West", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)this.imagePanel, 177, "West", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)this.imagePanel, 25, "North", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)this.imagePanel, -25, "South", (Component)this);
            this.add(this.imagePanel);
            this.descriptionLayout.putConstraint("West", (Component)descriptionEntityPanel, 13, "East", (Component)this.imagePanel);
            this.descriptionLayout.putConstraint("East", (Component)descriptionEntityPanel, 0, "East", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)descriptionEntityPanel, 25, "North", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)descriptionEntityPanel, -20, "South", (Component)this);
            this.add(descriptionEntityPanel);
            descriptionSpring.putConstraint("West", (Component)this.name, 0, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("East", (Component)this.name, 250, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)this.name, 0, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.name, 23, "North", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.name);
            descriptionSpring.putConstraint("West", (Component)authorLabel, 0, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("East", (Component)authorLabel, authorLabel.getPreferredSize().width, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)authorLabel, 23, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)authorLabel, 42, "North", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)authorLabel);
            descriptionSpring.putConstraint("West", (Component)authorValue, 5, "East", (Component)authorLabel);
            descriptionSpring.putConstraint("East", (Component)authorValue, 0, "East", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)authorValue, 23, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)authorValue, 42, "North", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)authorValue);
            descriptionSpring.putConstraint("West", (Component)this.description, 0, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("East", (Component)this.description, -100, "East", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)this.description, 46, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.description, 85, "North", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.description);
            descriptionSpring.putConstraint("West", (Component)this.downloadLabel, 0, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("East", (Component)this.downloadLabel, this.downloadLabel.getPreferredSize().width, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)this.downloadLabel, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.downloadLabel, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.downloadLabel);
            descriptionSpring.putConstraint("West", (Component)downloadValue, 5, "East", (Component)this.downloadLabel);
            descriptionSpring.putConstraint("East", (Component)downloadValue, downloadValue.getPreferredSize().width + 5, "East", (Component)this.downloadLabel);
            descriptionSpring.putConstraint("North", (Component)downloadValue, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)downloadValue, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)downloadValue);
            descriptionSpring.putConstraint("West", (Component)this.updateLabel, 30, "East", (Component)downloadValue);
            descriptionSpring.putConstraint("East", (Component)this.updateLabel, 30 + this.updateLabel.getPreferredSize().width, "East", (Component)downloadValue);
            descriptionSpring.putConstraint("North", (Component)this.updateLabel, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.updateLabel, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.updateLabel);
            descriptionSpring.putConstraint("West", (Component)updateValue, 5, "East", (Component)this.updateLabel);
            descriptionSpring.putConstraint("East", (Component)updateValue, updateValue.getPreferredSize().width + 5, "East", (Component)this.updateLabel);
            descriptionSpring.putConstraint("North", (Component)updateValue, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)updateValue, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)updateValue);
            descriptionSpring.putConstraint("West", (Component)gameVersionLabel, 30, "East", (Component)updateValue);
            descriptionSpring.putConstraint("East", (Component)gameVersionLabel, 30 + gameVersionLabel.getPreferredSize().width, "East", (Component)updateValue);
            descriptionSpring.putConstraint("North", (Component)gameVersionLabel, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)gameVersionLabel, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)gameVersionLabel);
            descriptionSpring.putConstraint("West", (Component)this.gameVersion, 5, "East", (Component)gameVersionLabel);
            descriptionSpring.putConstraint("East", (Component)this.gameVersion, this.gameVersion.getPreferredSize().width + 5, "East", (Component)gameVersionLabel);
            descriptionSpring.putConstraint("North", (Component)this.gameVersion, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.gameVersion, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.gameVersion);
            ExtendedPanel pictureCategories = new ExtendedPanel();
            int count = 0;
            for (CategoryDTO c : entity.getCategories()) {
                try {
                    Icon icon = ImageCache.getNativeIcon((String)("category/" + c.getName() + ".png"));
                    ++count;
                    final JLabel label = new JLabel(icon);
                    label.setHorizontalAlignment(0);
                    label.setAlignmentY(0.5f);
                    pictureCategories.add((Component)label);
                    final ModpackCategoryPopupMenu popupMenu = new ModpackCategoryPopupMenu(c, label);
                    label.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            popupMenu.show(label, e.getX() + 15, e.getY() + 15);
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            popupMenu.setVisible(false);
                        }
                    });
                }
                catch (Throwable e) {
                    U.log("problem with category " + c.getName());
                }
            }
            pictureCategories.setLayout(new GridLayout(1, count, 0, 10));
            this.descriptionLayout.putConstraint("West", (Component)pictureCategories, -200, "East", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)pictureCategories, -25 - (5 - count) * 35, "East", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)pictureCategories, 24, "North", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)pictureCategories, 50, "North", (Component)this);
            this.add(pictureCategories);
            this.descriptionLayout.putConstraint("West", (Component)this.statusStarButton, -38, "East", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)this.statusStarButton, -25, "East", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)this.statusStarButton, -35, "South", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)this.statusStarButton, -22, "South", (Component)this);
            this.add(this.statusStarButton);
        }

        private String getStringDownloadingCount(Long i) {
            String res = "";
            if (i < 1000L) {
                return i.toString();
            }
            res = i < 1000000L ? i / 1000L + " " + Localizable.get("modpack.thousand") : i / 1000000L + " " + Localizable.get("modpack.million");
            if (Objects.nonNull(TLauncher.getInstance().getConfiguration().getLocale()) && "en".equals(TLauncher.getInstance().getConfiguration().getLocale().getLanguage())) {
                res = res.replace(" ", "");
            }
            return res;
        }
    }

    public static class ImagePanel
    extends JLayeredPane {
        private GameRightButton gameRightButton;
        private static final ConcurrentLinkedDeque<List<String>> images = new ConcurrentLinkedDeque();
        private final GameEntityDTO entity;
        private final JLabel label;

        public ImagePanel(GameEntityDTO entity) {
            this.entity = entity;
            this.setOpaque(true);
            this.label = new JLabel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    this.initPicture(g);
                }
            };
            this.label.setOpaque(true);
            this.add((Component)this.label, 1);
            this.label.setBounds(0, 0, 111, 111);
        }

        public void addMoapckActButton(GameRightButton actButton) {
            this.gameRightButton = actButton;
            this.add((Component)actButton, 0);
            actButton.setBounds(10, 80, 90, 23);
        }

        public void initPicture(Graphics g) {
            if (this.entity.getPicture() != null) {
                try {
                    List<String> picture = ModpackUtil.getPictureURL(this.entity.getPicture(), "logo");
                    Optional<String> op = picture.stream().filter(ImageCache::imageInCache).findFirst();
                    if (!op.isPresent()) {
                        images.push(picture);
                        if (images.size() == 1) {
                            this.loadImages();
                        }
                    } else {
                        BufferedImage image = ImageCache.loadImage(picture, (boolean)false);
                        if (image != null) {
                            g.drawImage(image, 0, 0, null);
                        }
                    }
                }
                catch (Exception e) {
                    U.log(e);
                }
            }
        }

        private void loadImages() {
            CompletableFuture.runAsync(() -> {
                try {
                    HashSet<List<String>> set = new HashSet<List<String>>();
                    Thread.sleep(100L);
                    int size = images.size() > 3 ? 3 : images.size();
                    for (int i = 0; i < size; ++i) {
                        set.add(images.pop());
                    }
                    images.clear();
                    ArrayList<CompletableFuture<Void>> c = new ArrayList<CompletableFuture<Void>>();
                    for (List list : set) {
                        c.add(CompletableFuture.runAsync(() -> {
                            try {
                                ImageCache.loadImage((List)list, (boolean)false);
                            }
                            catch (Throwable e) {
                                U.log(e);
                            }
                        }));
                    }
                    try {
                        CompletableFuture.allOf(c.toArray(new CompletableFuture[0])).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        U.log("problem with pictures", e);
                    }
                    if (this.gameRightButton != null) {
                        this.gameRightButton.updateRow();
                    }
                    this.label.repaint();
                }
                catch (Exception e) {
                    U.log(e);
                }
            }, singleDownloadExecutor);
        }
    }
}

