/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.editor.EditorField;
import org.tlauncher.tlauncher.ui.settings.HandlerSettings;
import org.tlauncher.tlauncher.ui.settings.SettingsHandlerInterface;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;

public abstract class PageSettings
extends ExtendedPanel
implements SettingsHandlerInterface {
    private static final long serialVersionUID = 971905170736637142L;
    private final List<HandlerSettings> settingsList = new ArrayList<HandlerSettings>();
    protected final Configuration global;
    protected TLauncher tlauncher = TLauncher.getInstance();

    public PageSettings() {
        this.global = this.tlauncher.getConfiguration();
    }

    @Override
    public boolean validateSettings() {
        for (HandlerSettings handler : this.settingsList) {
            if (handler.getEditorField().isValueValid()) continue;
            EditorField editorField = handler.getEditorField();
            ((JComponent)((Object)editorField)).setBackground(Color.PINK);
            return false;
        }
        return true;
    }

    @Override
    public void setValues() {
        for (HandlerSettings handler : this.settingsList) {
            String newValue;
            String key = handler.getKey();
            String oldValue = this.global.get(key);
            if (StringUtils.equals((CharSequence)oldValue, (CharSequence)(newValue = handler.getEditorField().getSettingsValue()))) continue;
            this.global.set(key, (Object)newValue);
            handler.onChange(oldValue, newValue);
        }
    }

    @Override
    public void setDefaultSettings() {
        for (HandlerSettings handler : this.settingsList) {
            handler.getEditorField().setSettingsValue(this.global.getDefault(handler.getKey()));
        }
    }

    public void addHandler(HandlerSettings handler) {
        this.addFocus((Component)((Object)handler.getEditorField()), new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                e.getComponent().setBackground(Color.white);
            }
        });
        this.settingsList.add(handler);
    }

    private void addFocus(Component comp, FocusListener focus) {
        comp.addFocusListener(focus);
        if (comp instanceof Container) {
            for (Component curComp : ((Container)comp).getComponents()) {
                this.addFocus(curComp, focus);
            }
        }
    }

    @Override
    public void init() {
        for (HandlerSettings handler : this.settingsList) {
            handler.getEditorField().setSettingsValue(this.global.get(handler.getKey()));
        }
    }
}

