/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.tlauncher.exceptions.CheckedFunction;
import org.tlauncher.tlauncher.configuration.enums.ConnectionQuality;
import org.tlauncher.tlauncher.rmo.Bootstrapper;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.Reflect;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.async.ExtendedThread;

public class U {
    public static final String PROGRAM_PACKAGE = "org.tlauncher";
    public static final int CONNECTION_TIMEOUT = 30000;
    public static final PatternLayout LOG_LAYOUT = new PatternLayout("%m%n");
    private static final int ST_TOTAL = 100;
    private static final int ST_PROGRAM = 10;
    public static String FLUSH_MESSAGE = "flush now";
    private static Logger logField;
    private static FileAppender appender;
    private static ConsoleAppender console;

    private U() {
    }

    public static void log(Object ... what) {
        U.hlog(null, what);
    }

    public static void plog(Object ... what) {
        U.hlog(null, what);
    }

    private static void hlog(String prefix, Object[] append) {
        if (Objects.nonNull(logField)) {
            logField.info(U.toLog(prefix, append));
        } else {
            System.out.println(U.toLog(prefix, append));
        }
    }

    private static String toLog(String prefix, Object ... append) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (prefix != null) {
            b.append(prefix);
            first = false;
        }
        if (append != null) {
            for (Object e : append) {
                if (e != null) {
                    if (e.getClass().isArray()) {
                        if (!first) {
                            b.append(" ");
                        }
                        if (e instanceof Object[]) {
                            b.append(U.toLog((Object[])e));
                            continue;
                        }
                        b.append(U.arrayToLog(e));
                        continue;
                    }
                    if (e instanceof Throwable) {
                        if (!first) {
                            b.append("\n");
                        }
                        b.append(U.stackTrace((Throwable)e));
                        b.append("\n");
                        continue;
                    }
                    if (e instanceof File) {
                        if (!first) {
                            b.append(" ");
                        }
                        File file = (File)e;
                        String absPath = file.getAbsolutePath();
                        b.append(absPath);
                        if (file.isDirectory() && !absPath.endsWith(File.separator)) {
                            b.append(File.separator);
                        }
                    } else if (e instanceof Iterator) {
                        Iterator i = (Iterator)e;
                        while (i.hasNext()) {
                            b.append(" ");
                            b.append(U.toLog(i.next()));
                        }
                    } else if (e instanceof Enumeration) {
                        Enumeration en = (Enumeration)e;
                        while (en.hasMoreElements()) {
                            b.append(" ");
                            b.append(U.toLog(en.nextElement()));
                        }
                    } else {
                        if (!first) {
                            b.append(" ");
                        }
                        b.append(e);
                    }
                } else {
                    if (!first) {
                        b.append(" ");
                    }
                    b.append("null");
                }
                if (!first) continue;
                first = false;
            }
        } else {
            b.append("null");
        }
        return b.toString();
    }

    public static String toLog(Object ... append) {
        return U.toLog(null, append);
    }

    private static String arrayToLog(Object e) {
        if (!e.getClass().isArray()) {
            throw new IllegalArgumentException("Given object is not an array!");
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (e instanceof Object[]) {
            for (Object i : (Object[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof int[]) {
            for (int i : (int[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof boolean[]) {
            for (boolean i : (boolean[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof long[]) {
            for (long i : (long[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof float[]) {
            for (float i : (float[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof double[]) {
            for (double i : (double[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof byte[]) {
            for (byte i : (byte[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof short[]) {
            for (short i : (short[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof char[]) {
            for (char i : (char[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        }
        if (b.length() == 0) {
            throw new UnknownError("Unknown array type given.");
        }
        return b.toString();
    }

    public static void setLoadingStep(Bootstrapper.LoadingStep step) {
        if (step == null) {
            throw new NullPointerException();
        }
        U.plog("[Loading]", step.toString());
    }

    public static boolean ok(int d) {
        return new Random(System.currentTimeMillis()).nextInt(d) == 0;
    }

    public static double getAverage(double[] d) {
        double a = 0.0;
        int k = 0;
        for (double curd : d) {
            if (curd == 0.0) continue;
            a += curd;
            ++k;
        }
        if (k == 0) {
            return 0.0;
        }
        return a / (double)k;
    }

    public static double getAverage(double[] d, int max) {
        double a = 0.0;
        int k = 0;
        for (double curd : d) {
            a += curd;
            if (++k == max) break;
        }
        if (k == 0) {
            return 0.0;
        }
        return a / (double)k;
    }

    public static double getSum(double[] d) {
        double a = 0.0;
        for (double curd : d) {
            a += curd;
        }
        return a;
    }

    public static int getMaxMultiply(int i, int max) {
        if (i <= max) {
            return 1;
        }
        for (int x = max; x > 1; --x) {
            if (i % x != 0) continue;
            return x;
        }
        return (int)Math.ceil(i / max);
    }

    private static String stackTrace(Throwable e) {
        StringBuilder trace = U.rawStackTrace(e);
        ExtendedThread currentAsExtended = U.getAs(Thread.currentThread(), ExtendedThread.class);
        if (currentAsExtended != null) {
            trace.append("\nThread called by: ").append((CharSequence)U.rawStackTrace(currentAsExtended.getCaller()));
        }
        return trace.toString();
    }

    private static StringBuilder rawStackTrace(Throwable e) {
        Throwable cause;
        if (e == null) {
            return null;
        }
        StackTraceElement[] elems = e.getStackTrace();
        int programElements = 0;
        int totalElements = 0;
        StringBuilder builder = new StringBuilder();
        builder.append(e.toString());
        for (StackTraceElement elem : elems) {
            ++totalElements;
            String description = elem.toString();
            if (description.startsWith(PROGRAM_PACKAGE)) {
                ++programElements;
            }
            builder.append("\nat ").append(description);
            if (totalElements != 100 && programElements != 10) continue;
            int remain = elems.length - totalElements;
            if (remain == 0) break;
            builder.append("\n... and ").append(remain).append(" more");
            break;
        }
        if ((cause = e.getCause()) != null) {
            builder.append("\nCaused by: ").append((CharSequence)U.rawStackTrace(cause));
        }
        return builder;
    }

    public static long getUsingSpace() {
        return U.getTotalSpace() - U.getFreeSpace();
    }

    public static long getFreeSpace() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public static long getTotalSpace() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public static String memoryStatus() {
        return U.getUsingSpace() + " / " + U.getTotalSpace() + " MB";
    }

    public static void gc() {
        U.log("Starting garbage collector: " + U.memoryStatus());
        System.gc();
        U.log("Garbage collector completed: " + U.memoryStatus());
    }

    public static void sleepFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static URL makeURL(String p) {
        try {
            return new URL(p);
        }
        catch (Exception e) {
            U.log("Cannot make URL from string: " + p + ".", e);
            return null;
        }
    }

    public static URI makeURI(URL url) {
        try {
            return url.toURI();
        }
        catch (Exception e) {
            U.log("Cannot make URI from URL: " + url + ".", e);
            return null;
        }
    }

    public static URI makeURI(String p) {
        return U.makeURI(U.makeURL(p));
    }

    private static int fitInterval(int val, int min, int max) {
        if (val > max) {
            return max;
        }
        if (val < min) {
            return min;
        }
        return val;
    }

    public static long m() {
        return System.currentTimeMillis();
    }

    public static long n() {
        return System.nanoTime();
    }

    public static int getReadTimeout() {
        return U.getConnectionTimeout();
    }

    public static int getConnectionTimeout() {
        TLauncher t = TLauncher.getInstance();
        if (t == null) {
            return 30000;
        }
        ConnectionQuality quality = t.getConfiguration().getConnectionQuality();
        if (quality == null) {
            return 30000;
        }
        return quality.getTimeout();
    }

    public static Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public static <K, E> LinkedHashMap<K, E> sortMap(Map<K, E> map, K[] sortedKeys) {
        if (map == null) {
            return null;
        }
        if (sortedKeys == null) {
            throw new NullPointerException("Keys cannot be NULL!");
        }
        LinkedHashMap<K, E> result = new LinkedHashMap<K, E>();
        block0: for (K key : sortedKeys) {
            for (Map.Entry<K, E> entry : map.entrySet()) {
                K entryKey = entry.getKey();
                E value = entry.getValue();
                if (key == null && entryKey == null) {
                    result.put(null, value);
                    continue block0;
                }
                if (key == null || !key.equals(entryKey)) continue;
                result.put(key, value);
                continue block0;
            }
        }
        return result;
    }

    public static Color shiftColor(Color color, int bits) {
        if (color == null) {
            return null;
        }
        if (bits == 0) {
            return color;
        }
        int newRed = U.fitInterval(color.getRed() + bits, 0, 255);
        int newGreen = U.fitInterval(color.getGreen() + bits, 0, 255);
        int newBlue = U.fitInterval(color.getBlue() + bits, 0, 255);
        return new Color(newRed, newGreen, newBlue, color.getAlpha());
    }

    public static Color shiftAlpha(Color color, int bits) {
        if (color == null) {
            return null;
        }
        if (bits == 0) {
            return color;
        }
        int newAlpha = U.fitInterval(color.getAlpha() + bits, 0, 255);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), newAlpha);
    }

    @Deprecated
    public static <T> T getAs(Object o, Class<T> classOfT) {
        return Reflect.cast(o, classOfT);
    }

    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    public static void close(Closeable c) {
        try {
            c.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static <T> int find(T obj, T[] array) {
        if (obj == null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (!obj.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static void initializeLoggerU(File minecraftFolder, String type) {
        if (minecraftFolder == null) {
            minecraftFolder = MinecraftUtil.getSystemRelatedDirectory("tlauncher");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM_dd_yyyy_HH_mm_ss");
        String separator = System.getProperty("file.separator");
        File path = new File(minecraftFolder, separator + "logs" + separator + "tlauncher" + separator + type + "_" + formatter.format(new Date()) + ".log");
        appender = new FileAppender(){

            @Override
            protected boolean shouldFlush(LoggingEvent event) {
                if (!(event.getMessage() instanceof String)) {
                    return false;
                }
                return FLUSH_MESSAGE.equalsIgnoreCase((String)event.getMessage());
            }
        };
        appender.setName("fileAppender");
        appender.setLayout(LOG_LAYOUT);
        appender.setFile(path.getAbsolutePath());
        appender.setThreshold(Level.INFO);
        appender.activateOptions();
        appender.setBufferedIO(true);
        appender.setEncoding(TlauncherUtil.LOG_CHARSET);
        Logger.getRootLogger().addAppender(appender);
        logField = Logger.getLogger("main");
        console = new ConsoleAppender();
        console.setName("console");
        console.setLayout(new PatternLayout("%m%n"));
        console.setThreshold(Level.INFO);
        console.activateOptions();
        console.setEncoding(TlauncherUtil.LOG_CHARSET);
        Logger.getRootLogger().addAppender(console);
        Logger.getRootLogger().setLevel(Level.INFO);
        if ("tlauncher".equalsIgnoreCase(type)) {
            try {
                Files.walk(Paths.get(minecraftFolder.getAbsolutePath(), "logs"), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> U.uncheckCall(() -> {
                    BasicFileAttributes b = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime t = b.creationTime();
                    return DateUtils.addDays((Date)new Date(), (int)-20).after(new Date(t.toMillis()));
                })).forEach(p -> FileUtil.deleteFile(p.toFile()));
            }
            catch (Throwable e) {
                U.log(e);
            }
        }
    }

    public static void debug(Object ... ob) {
        if (!TLauncher.DEBUG) {
            return;
        }
        U.plog("[DEBUG] ----- ", ob);
    }

    public static URI fixInvallidLink(String link) {
        try {
            if (link.contains("|")) {
                U.debug("U", "replace |");
                return new URI(link.replace("|", "%7C"));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            if (link.contains("|")) {
                U.debug("U", "replace |");
                link = link.replace("|", "%7C");
            }
            if (link.contains("?")) {
                return new URI(link.substring(0, link.indexOf("?")));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public static <T> void classNameLog(Class<T> cl, Object message) {
        U.log("[" + cl.getSimpleName() + "] ", message);
    }

    public static String readFileLog() {
        logField.info(FLUSH_MESSAGE);
        try {
            return FileUtil.readFile(new File(appender.getFile()), TlauncherUtil.LOG_CHARSET);
        }
        catch (IOException e) {
            logField.warn("can't read log file", e);
            return "can't read log file";
        }
    }

    public static void removeConsoleAppender() {
        Logger.getRootLogger().removeAppender(console);
    }

    static <T, R> Function<T, R> wrap(CheckedFunction<T, R> checkedFunction) {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> T uncheckCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

