/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.advertising;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Http;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.skin.domain.AdvertisingDTO;
import org.tlauncher.skin.domain.responce.AdvertisingResponseDTO;
import org.tlauncher.tlauncher.entity.profile.ClientProfile;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.util.U;
import org.tlauncher.util.advertising.AdvertisingStatusObserver;

public class AdvertisingStatusObservable
implements Runnable {
    private final ClientProfile clientProfile;
    private final ProfileManager profileManager;
    private List<AdvertisingStatusObserver> listeners = new ArrayList<AdvertisingStatusObserver>();

    @Override
    public void run() {
        this.log("started to get ad information");
        AdvertisingDTO dto = new AdvertisingDTO();
        try {
            String url = TLauncher.getInnerSettings().get("skin.server.advertising");
            for (Account acc : this.clientProfile.getAccounts().values()) {
                if (acc.getType() != Account.AccountType.TLAUNCHER) continue;
                U.debug(acc);
                JsonObject send = new JsonObject();
                send.add("clientToken", new JsonPrimitive(this.clientProfile.getClientToken().toString()));
                send.add("accessToken", new JsonPrimitive(acc.getAccessToken() == null ? "null" : acc.getAccessToken()));
                String res = Http.performPost(new URL(url), send.toString(), "application/json");
                AdvertisingResponseDTO advertisingResponseDTO = new Gson().fromJson(res, AdvertisingResponseDTO.class);
                if (StringUtils.isNotBlank((CharSequence)advertisingResponseDTO.getError())) {
                    if (!"Invalid token.".equals(advertisingResponseDTO.getErrorMessage())) continue;
                    SwingUtilities.invokeLater(() -> {
                        Alert.showWarning("", Localizable.getByKeys("token.not.valid", "account.config", "crash.opengl.help"));
                        try {
                            this.profileManager.remove(acc);
                        }
                        catch (IOException e) {
                            U.log(e);
                        }
                        U.log("removed not valid token");
                        this.log(advertisingResponseDTO.getError() + " " + advertisingResponseDTO.getErrorMessage());
                    });
                    continue;
                }
                acc.setAccessToken(advertisingResponseDTO.getAccessToken());
                if (!advertisingResponseDTO.getUser().isAccountStatus()) continue;
                acc.setPremiumAccount(true);
                dto = advertisingResponseDTO.getAdvertising();
                break;
            }
        }
        catch (JsonSyntaxException | IOException e) {
            this.log(e);
        }
        this.log("finished to get add information");
        this.notifyObserver(dto);
    }

    public void addListeners(AdvertisingStatusObserver advertisingStatusListerner) {
        this.listeners.add(advertisingStatusListerner);
    }

    public void removeListener(AdvertisingStatusObserver advertisingStatusListerner) {
        this.listeners.remove(advertisingStatusListerner);
    }

    public void notifyObserver(AdvertisingDTO advertisingDTO) {
        for (AdvertisingStatusObserver advertisingStatusObserver : this.listeners) {
            advertisingStatusObserver.advertisingReceived(advertisingDTO);
        }
    }

    private void log(Object o) {
        U.log("[AdvertisingStatusObserver] ", o);
    }

    public AdvertisingStatusObservable(ClientProfile clientProfile, ProfileManager profileManager) {
        this.clientProfile = clientProfile;
        this.profileManager = profileManager;
    }

    public ClientProfile getClientProfile() {
        return this.clientProfile;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public List<AdvertisingStatusObserver> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<AdvertisingStatusObserver> listeners) {
        this.listeners = listeners;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvertisingStatusObservable)) {
            return false;
        }
        AdvertisingStatusObservable other = (AdvertisingStatusObservable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClientProfile this$clientProfile = this.getClientProfile();
        ClientProfile other$clientProfile = other.getClientProfile();
        if (this$clientProfile == null ? other$clientProfile != null : !((Object)this$clientProfile).equals(other$clientProfile)) {
            return false;
        }
        ProfileManager this$profileManager = this.getProfileManager();
        ProfileManager other$profileManager = other.getProfileManager();
        if (this$profileManager == null ? other$profileManager != null : !this$profileManager.equals(other$profileManager)) {
            return false;
        }
        List<AdvertisingStatusObserver> this$listeners = this.getListeners();
        List<AdvertisingStatusObserver> other$listeners = other.getListeners();
        return !(this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdvertisingStatusObservable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClientProfile $clientProfile = this.getClientProfile();
        result = result * 59 + ($clientProfile == null ? 43 : ((Object)$clientProfile).hashCode());
        ProfileManager $profileManager = this.getProfileManager();
        result = result * 59 + ($profileManager == null ? 43 : $profileManager.hashCode());
        List<AdvertisingStatusObserver> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        return result;
    }

    public String toString() {
        return "AdvertisingStatusObservable(clientProfile=" + this.getClientProfile() + ", profileManager=" + this.getProfileManager() + ", listeners=" + this.getListeners() + ")";
    }
}

