/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.versions.json.PatternTypeAdapter;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.tlauncher.rmo.Bootstrapper;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.U;

public class DownloadUtil {
    private static final Gson gson;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 15000;

    public static <T> T loadObjectByKey(String key, Class<T> cl) throws IOException {
        String result = DownloadUtil.readTextByKey(key, "", true);
        return gson.fromJson(result, cl);
    }

    public static <T> T loadByRepository(Repo repo, Class<T> cl) throws IOException {
        return gson.fromJson(repo.getUrl(), cl);
    }

    public static <T> T loadByRepository(Repo repository, Type type) throws IOException {
        return gson.fromJson(repository.getUrl(), type);
    }

    public static <T> T loadObjectByKey(String key, Type type, boolean flag) throws IOException {
        return gson.fromJson(DownloadUtil.readTextByKey(key, "", flag), type);
    }

    public static String readTextByKey(String key, String postfix, boolean innerConfig) throws IOException {
        List<String> urls = innerConfig ? Arrays.asList(TLauncher.getInnerSettings().get(key).split(",")) : Arrays.asList(Bootstrapper.innerConfig.get(key).split(","));
        IOException error = null;
        for (String url : urls) {
            DownloadUtil.log("request to " + url);
            try {
                return Http.performGet(new URL(url + postfix), 5000, 15000);
            }
            catch (IOException ex) {
                error = ex;
            }
        }
        throw new IOException("couldn't download ", error);
    }

    private static void log(String line) {
        U.log("[GsonUtil] ", line);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Pattern.class), new PatternTypeAdapter());
        builder.setPrettyPrinting();
        gson = builder.create();
    }
}

