/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.gson.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.tlauncher.tlauncher.updater.client.Banner;
import org.tlauncher.tlauncher.updater.client.Offer;
import org.tlauncher.tlauncher.updater.client.Update;
import org.tlauncher.util.U;

public class UpdateDeserializer
implements JsonDeserializer<Update> {
    @Override
    public Update deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        try {
            return this.deserialize0(json, context);
        }
        catch (Exception e) {
            U.log("Cannot parse update:", e);
            return new Update();
        }
    }

    private Update deserialize0(JsonElement json, JsonDeserializationContext context) {
        List exeLinks;
        List jarLinks;
        JsonObject object = json.getAsJsonObject();
        Update update = new Update();
        update.setVersion(object.get("version").getAsDouble());
        update.setMandatory(object.get("mandatory").getAsBoolean());
        update.setRequiredAtLeastFor(object.has("requiredAtLeastFor") ? object.get("requiredAtLeastFor").getAsDouble() : 0.0);
        Map description = (Map)context.deserialize(object.get("description"), new TypeToken<Map<String, String>>(){}.getType());
        if (description != null) {
            update.setDescription(description);
        }
        if ((jarLinks = (List)context.deserialize(object.get("jarLinks"), new TypeToken<List<String>>(){}.getType())) != null) {
            update.setJarLinks(jarLinks);
        }
        if ((exeLinks = (List)context.deserialize(object.get("exeLinks"), new TypeToken<List<String>>(){}.getType())) != null) {
            update.setExeLinks(exeLinks);
        }
        update.setUpdaterView(object.get("updaterView").getAsInt());
        update.setOfferDelay(object.get("offerDelay").getAsInt());
        update.setOfferEmptyCheckboxDelay(object.get("offerEmptyCheckboxDelay").getAsInt());
        update.setUpdaterLaterInstall(object.get("updaterLaterInstall").getAsBoolean());
        Map banners = (Map)context.deserialize(object.get("banners"), new TypeToken<Map<String, List<Banner>>>(){}.getType());
        banners.values().forEach(Collections::shuffle);
        update.setBanners(banners);
        List offers = (List)context.deserialize(object.get("offers"), new TypeToken<List<Offer>>(){}.getType());
        Collections.shuffle(offers);
        update.setOffers(offers);
        update.setRootAccessExe((List)context.deserialize(object.get("rootAccessExe"), new TypeToken<List<String>>(){}.getType()));
        if (Objects.nonNull(object.get("aboveMandatoryVersion"))) {
            update.setAboveMandatoryVersion(object.get("aboveMandatoryVersion").getAsDouble());
        }
        if (Objects.nonNull(object.get("mandatoryUpdatedVersions"))) {
            update.setMandatoryUpdatedVersions((Set)context.deserialize(object.get("mandatoryUpdatedVersions"), new TypeToken<Set<Double>>(){}.getType()));
        }
        return update;
    }
}

